/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLEvent
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLEvent(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getProcessModel().getEventSet().createEvent(StringUtilities.decodeAttributeValue(string), 0);
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        int n;
        Event event = (Event)super.recreateObject(element, design, bl);
        String string = element.getAttribute("synonym");
        if (string != null) {
            event.setSynonym(StringUtilities.decodeAttributeValue(string));
        }
        Map map = this.getProperties(element, "attributes");
        try {
            n = Integer.parseInt((String)map.get("type"));
            event.setEventType(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        event.setText((String)map.get("eventtext"));
        try {
            n = Integer.parseInt((String)map.get("frequency"));
            event.setFrequency(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        event.setOnDay(Boolean.valueOf((String)map.get("onday")));
        event.setDayOfWeek((String)map.get("dayofweek"));
        try {
            int n2 = Integer.parseInt((String)map.get("dayofmonth"));
            event.setDayOfMonth(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        event.setMonths((String)map.get("months"));
        try {
            int n3 = Integer.parseInt((String)map.get("quarter"));
            event.setQuarter(n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n4 = Integer.parseInt((String)map.get("year"));
            event.setYear(n4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        event.setFiscal(Boolean.valueOf((String)map.get("fiscal")));
        try {
            int n5 = Integer.parseInt((String)map.get("timeswhenrun"));
            event.setTimesWhenRun(n5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        event.setAtTime(Boolean.valueOf((String)map.get("attime")));
        try {
            int n6 = Integer.parseInt((String)map.get("hour"));
            event.setHour(n6);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n7 = Integer.parseInt((String)map.get("minute"));
            event.setMinute(n7);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n8 = Integer.parseInt((String)map.get("timefreq"));
            event.setTimeFreq(n8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(event.getObjectID())).append(".dmd");
        event.setFilePath(stringBuffer.toString());
        return event;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            if (this.isOldDesign()) {
                stringBuffer.append(string).append('/').append("processmodel").append('/');
            } else {
                stringBuffer.append(string).append('/').append("pm").append('/');
            }
        }
        stringBuffer.append(this.getConfiguration().get("eventPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == Event.class;
    }
}

