/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLDataFlowDesign
extends AbstractXMLReader {
    private boolean xmlFromDB = false;
    private static Logger LOGGER = new Logger(RXMLDataFlowDesign.class);
    private Map map = new TreeMap();

    public RXMLDataFlowDesign(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public Object recreateObject(Document document, Design design, boolean bl) {
        return null;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        int n;
        String string;
        Object object;
        Object object2;
        Object object32;
        this.xmlFromDB = this.getPersistenceManager().isXML_FromDataBase();
        Element element = document.getDocumentElement();
        String string2 = element.getAttribute("id");
        if (!"".equalsIgnoreCase(string2)) {
            designPart.setObjectID(StringUtilities.decodeAttributeValue(string2));
        }
        this.map.clear();
        NodeList nodeList = RXMLDataFlowDesign.getFirstChildByTagName(element, "ref").getElementsByTagName("objectid");
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            object32 = (Element)nodeList.item(i);
            object2 = object32.getAttribute("role");
            object = object32.getAttribute("type");
            string = object32.getAttribute("oid");
            boolean bl2 = "contains".equalsIgnoreCase((String)object2) && bl;
            DesignObject designObject = null;
            designObject = !this.xmlFromDB ? (DesignObject)this.getPersistenceManager().read((Object)string, designPart.getDesign(), bl2) : designPart.getDesign().getDesignObject(string);
            if (designObject != null) {
                String string3;
                if ("Process".equalsIgnoreCase((String)object) && (string3 = object32.getAttribute("process_number")) != null && !"".equals(string3)) {
                    this.map.put(new Integer(string3), designObject);
                }
                designObject.setTemporaryWriteable(true);
                if (!designObject.belongsToDesign(designPart.getDesign())) {
                    designObject.setReadOnly(true);
                }
                this.readGraphicalInfo((Element)object32, designObject);
                designObject.setTemporaryWriteable(false);
                continue;
            }
            LOGGER.error("RXMLDataFlowDesign: Read object returns null (objectID: " + string);
        }
        for (Object object32 : this.map.keySet()) {
            object2 = this.map.get(object32);
            if (!(object2 instanceof Process) || !((DataFlowDesign)(object = (DataFlowDesign)((DesignObject)object2).getDesignPart())).getProcessOrderList().remove(object2)) continue;
            ((DataFlowDesign)object).getProcessOrderList().add((Integer)object32 - 1, object2);
        }
        object32 = this.getProperties(element, "documents");
        object2 = object32.keySet().toArray();
        for (n = 0; n < ((Object[])object2).length; ++n) {
            string = (String)object32.get(object2[n]);
            DesignObject designObject = designPart.getDesign().getDesignObject(string);
            if (designObject == null) continue;
            designPart.addDocument((BIDocument)designObject);
        }
        object32 = this.getProperties(element, "parties");
        object2 = object32.keySet().toArray();
        for (n = 0; n < ((Object[])object2).length; ++n) {
            string = (String)object32.get(object2[n]);
            DesignObject designObject = designPart.getDesign().getDesignObject(string);
            if (designObject == null) continue;
            designPart.addResponsibleParty((BIResponsibleParty)designObject);
        }
        this.readSynonymsForGlobals(element, (DataFlowDesign)designPart);
        this.readFlows(element, (DataFlowDesign)designPart);
        this.readDisplayProperties(element, designPart.getMainView());
        designPart.getMainView().getWorkSpace().updateSettings();
        this.readDiagramViews(element, designPart);
        designPart.setLoaded(true);
        designPart.setDirty(false);
        if (designPart.getMainView() != null) {
            designPart.getMainView().setDirty(false);
        }
        return designPart;
    }

    @Override
    protected Map getProperties(Element element, String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        Element element2 = RXMLDataFlowDesign.getFirstChildByTagName(element, string);
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("parameter");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                treeMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
            }
        }
        return treeMap;
    }

    private void readFlows(Element element, DataFlowDesign dataFlowDesign) {
        Element element2;
        ApplicationView.log(Messages.getString("RXMLDataFlowDesign.ReadFlows"));
        DesignPartView designPartView = dataFlowDesign.getMainView();
        if (dataFlowDesign.getAppView() != null && (element2 = RXMLDataFlowDesign.getFirstChildByTagName(element, "view_flows")) != null) {
            NodeList nodeList = element2.getElementsByTagName("objectid");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                String string;
                Object object3;
                Object object4;
                Element element3;
                Object object5;
                Object object6;
                Element element4 = (Element)nodeList.item(i);
                String string2 = element4.getAttribute("oid");
                Flow flow = (Flow)dataFlowDesign.getFlowSet().getObjectByID(string2);
                String string3 = element4.getAttribute("viewid_source");
                String string4 = element4.getAttribute("viewid_target");
                if (!string3.equals("null") && flow.getSourceProcessObject() != null && ((ArrayList)(object6 = flow.getSourceProcessObject().getViewsForDPV(designPartView))).size() == 1) {
                    object5 = (TopView)((ArrayList)object6).get(0);
                    flow.setSourceTV((AbstractDataFlowTV)object5);
                }
                if (!string4.equals("null") && flow.getTargetProcessObject() != null && ((ArrayList)(object6 = flow.getTargetProcessObject().getViewsForDPV(designPartView))).size() == 1) {
                    object5 = (TopView)((ArrayList)object6).get(0);
                    flow.setTargetTV((AbstractDataFlowTV)object5);
                }
                object6 = RXMLDataFlowDesign.getFirstChildByTagName(element4, "points");
                object5 = object6.getElementsByTagName("point");
                int n2 = object5.getLength();
                TVFlow tVFlow = (TVFlow)flow.getTopView();
                for (int j = 0; j < n2; ++j) {
                    element3 = (Element)object5.item(j);
                    object4 = element3.getAttribute("x_coordinate");
                    object3 = element3.getAttribute("y_coordinate");
                    tVFlow.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble((String)object4), Double.parseDouble((String)object3)));
                }
                Element element5 = RXMLDataFlowDesign.getFirstChildByTagName(element4, "labels");
                if (element5 != null && (element3 = RXMLDataFlowDesign.getFirstChildByTagName(element5, "main_label")) != null) {
                    object4 = element3.getAttribute("x_coordinate");
                    object3 = element3.getAttribute("y_coordinate");
                    String string5 = element3.getAttribute("width");
                    string = element3.getAttribute("height");
                    if (string5 == null || "".equalsIgnoreCase(string5)) {
                        string5 = "-1";
                    }
                    if (string == null || "".equalsIgnoreCase(string)) {
                        string = "-1";
                    }
                    tVFlow.setLabelBounds(new Rectangle((int)Double.parseDouble((String)object4), (int)Double.parseDouble((String)object3), (int)Double.parseDouble(string5), (int)Double.parseDouble(string)));
                    object2 = tVFlow.getTempCenterLabel();
                    if (object2 != null) {
                        this.readColorInfo(element3, (DesignObject)object2);
                        this.readFontsInfo(element3, (DesignObject)object2);
                    }
                }
                if ((element3 = RXMLDataFlowDesign.getFirstChildByTagName(element4, "graphical")) == null) continue;
                object4 = element3.getElementsByTagName("parameter");
                object3 = new HashMap();
                int n3 = object4.getLength();
                for (int j = 0; j < n3; ++j) {
                    object2 = (Element)object4.item(j);
                    object3.put(object2.getAttribute("name"), object2.getAttribute("value"));
                }
                string = (String)object3.get("use_default_color");
                boolean bl = true;
                if (string != null) {
                    bl = Boolean.valueOf(string);
                }
                tVFlow.setUseDefaultColor(bl);
                if (bl) continue;
                String string6 = (String)object3.get("color");
                if (string6 != null && !"null".equalsIgnoreCase(string6)) {
                    object = new Color(Integer.parseInt(string6));
                    tVFlow.setBackgroundColor((Color)object);
                }
                if ((object = (String)object3.get("width")) == null || "null".equalsIgnoreCase((String)object)) continue;
                int n4 = Integer.parseInt((String)object);
                tVFlow.setLineWidth(n4);
            }
        }
    }

    private void readSynonymsForGlobals(Element element, DataFlowDesign dataFlowDesign) {
        Element element2;
        ApplicationView.log(Messages.getString("RXMLDataFlowDesign.ReadSynonymsForGlobalPMObjects"));
        DPVProcess dPVProcess = (DPVProcess)dataFlowDesign.getMainView();
        if (dataFlowDesign.getAppView() != null && (element2 = RXMLDataFlowDesign.getFirstChildByTagName(element, "synonyms_for_globals")) != null) {
            NodeList nodeList = element2.getElementsByTagName("objectid");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string = element3.getAttribute("oid");
                String string2 = element3.getAttribute("type");
                AbstractProcessObject abstractProcessObject = null;
                if ("ExtAgent".equalsIgnoreCase(string2)) {
                    abstractProcessObject = (AbstractProcessObject)dataFlowDesign.getExternalAgentSet().getObjectByID(string);
                } else if ("InfoStore".equalsIgnoreCase(string2)) {
                    abstractProcessObject = (AbstractProcessObject)dataFlowDesign.getInfoStoreSet().getObjectByID(string);
                } else if ("Process".equalsIgnoreCase(string2)) {
                    abstractProcessObject = (AbstractProcessObject)dataFlowDesign.getDesign().getDesignObject(string);
                }
                if (abstractProcessObject == null || dPVProcess == null) continue;
                TopView topView = abstractProcessObject.getFirstViewForDPV(dPVProcess);
                if (topView == null) {
                    topView = dPVProcess.createViewSynonim(abstractProcessObject);
                }
                this.readGraphicalInfo(element3, abstractProcessObject, topView);
            }
        }
    }

    public void readGraphicalInfo(Element element, DesignObject designObject) {
        if (designObject == null || designObject.getDesign() == null) {
            LOGGER.error("readGraphicalInfo: DesignObject = null or design = null");
            return;
        }
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            NodeList nodeList = element.getElementsByTagName("graphical");
            HashMap<String, String> hashMap = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                hashMap = new HashMap<String, String>();
                NodeList nodeList2 = element2.getElementsByTagName("parameter");
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    hashMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
                }
                applicationView.setGraphicalPropsFor(designObject, hashMap);
            }
        }
    }

    public void readGraphicalInfo(Element element, DesignObject designObject, TopView topView) {
        if (designObject == null || designObject.getDesign() == null) {
            LOGGER.error("readGraphicalInfo: DesignObject = null or design = null");
            return;
        }
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            NodeList nodeList = element.getElementsByTagName("graphical");
            HashMap<String, String> hashMap = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                hashMap = new HashMap<String, String>();
                NodeList nodeList2 = element2.getElementsByTagName("parameter");
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    hashMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
                }
                applicationView.setGraphicalPropsFor(topView, hashMap);
            }
        }
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append('/');
            if (this.isOldDesign()) {
                stringBuffer.append("processmodel/dataflows");
            } else {
                stringBuffer.append("pm/dflows");
            }
            return stringBuffer.toString();
        }
        return "pm/dflows";
    }
}

