/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLRollupLink
extends AbstractWXMLDesignObject
implements MDConstants {
    private RollupLink rollupLink = null;

    public WXMLRollupLink(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof RollupLink;
        if (bl) {
            this.rollupLink = (RollupLink)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.rollupLink != null) {
            String string = this.rollupLink.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.rollupLink.getDesignPart().getObjectID())).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("rolluplinkPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof RollupLink) {
            RollupLink rollupLink = (RollupLink)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("description", String.valueOf(rollupLink.getDescription()));
            treeMap.put("childlevel", String.valueOf(rollupLink.getChildLevel() != null ? StringUtilities.encodeAttributeValue(rollupLink.getChildLevel().getObjectID()) : "null"));
            treeMap.put("parentlevel", String.valueOf(rollupLink.getParentLevel() != null ? StringUtilities.encodeAttributeValue(rollupLink.getParentLevel().getObjectID()) : "null"));
            treeMap.put("roleplaying", String.valueOf(rollupLink.isRolePlaying()));
            treeMap.put("sparse_dimension", String.valueOf(rollupLink.isSparseDimension()));
            treeMap.put("default_aggr_operator", String.valueOf(rollupLink.getDefaultAggregationOperator()));
            if (rollupLink.getFactEntity() != null) {
                treeMap.put("factentity", StringUtilities.encodeAttributeValue(rollupLink.getFactEntity().getObjectID()));
            } else {
                treeMap.put("factentity", "null");
            }
            this.appendProperties(element, "attributes", treeMap);
            this.appendObjects(element, rollupLink.getChildToParentAttributes().toArray(), "attributes_list");
        }
    }
}

