/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLRaggedHLink
extends AbstractWXMLDesignObject
implements MDConstants {
    private RaggedHLink raggedHLink = null;

    public WXMLRaggedHLink(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof RaggedHLink;
        if (bl) {
            this.raggedHLink = (RaggedHLink)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.raggedHLink != null) {
            String string = this.raggedHLink.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.raggedHLink.getDesignPart().getObjectID())).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("raggedhlinkPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof RaggedHLink) {
            RaggedHLink raggedHLink = (RaggedHLink)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("description", String.valueOf(raggedHLink.getDescription()));
            treeMap.put("childlevel", String.valueOf(raggedHLink.getChildLevel() != null ? StringUtilities.encodeAttributeValue(raggedHLink.getChildLevel().getObjectID()) : "null"));
            treeMap.put("parentlevel", String.valueOf(raggedHLink.getParentLevel() != null ? StringUtilities.encodeAttributeValue(raggedHLink.getParentLevel().getObjectID()) : "null"));
            this.appendProperties(element, "attributes", treeMap);
            this.appendObjects(element, raggedHLink.getChildToParentAttributes().toArray(), "attributes_list");
        }
    }
}

