/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.multidimensional.DPVCompactMultidimentional;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import oracle.dbtools.crest.swingui.multidimensional.TVRaggedHLink;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WXMLMultidimensionalDesign
extends AbstractXMLWriter {
    private MultidimensionalDesign design = null;

    public WXMLMultidimensionalDesign(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof MultidimensionalDesign;
    }

    @Override
    public Document writeDocument(Object object) {
        this.design = (MultidimensionalDesign)object;
        if (this.design.getAppView().isSelectedForSave(object)) {
            Document document = this.createDocument("design");
            Element element = document.getDocumentElement();
            element.setAttribute("id", StringUtilities.encodeAttributeValue(this.design.getObjectID()));
            Element element2 = document.createElement("ref");
            element.appendChild(element2);
            Element element3 = document.createElement("view_links");
            element.appendChild(element3);
            Element element4 = document.createElement("compact_diagram");
            element.appendChild(element4);
            Collection collection = this.design.getStorableDesignObjects();
            Iterator iterator = collection.iterator();
            DesignObject designObject = null;
            while (iterator.hasNext()) {
                designObject = (DesignObject)iterator.next();
                this.handleDesignObject(element2, designObject);
            }
            this.handleLinks(this.design, element3);
            this.handleRHLinks(this.design, element3);
            this.handleCompactDiagram(this.design, element4);
            this.appendDocumentsInfo(document, element, this.design);
            this.appendPartiesInfo(document, element, this.design);
            this.appendDisplayProperties(element, this.design.getMainView());
            this.appendDiagramViews(document, element, this.design);
            this.design.setDirty(false);
            return document;
        }
        return null;
    }

    private void appendDocumentsInfo(Document document, Element element, MultidimensionalDesign multidimensionalDesign) {
        this.appendObjects(element, multidimensionalDesign.getDocuments().toArray(), "documents");
    }

    private void appendPartiesInfo(Document document, Element element, MultidimensionalDesign multidimensionalDesign) {
        this.appendObjects(element, multidimensionalDesign.getResponsibleParties().toArray(), "parties");
    }

    protected void appendObjects(Element element, Object[] objectArray, String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObject designObject = (DesignObject)objectArray[i];
            treeMap.put(String.valueOf(i + 1), StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        }
        this.appendProperties(element, string, treeMap);
    }

    @Override
    protected void appendProperties(Element element, String string, Map map) {
        Element element2 = element.getOwnerDocument().createElement(string);
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            String string3 = (String)map.get(string2);
            if (string2.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element element3 = element.getOwnerDocument().createElement("parameter");
            element2.appendChild(element3);
            this.appendProperty(element3, string2, string3);
        }
        element.appendChild(element2);
    }

    private void handleDesignObject(Element element, DesignObject designObject) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            if (this.getPersistenceManager().isCheckDirty()) {
                if (designObject.isDirty()) {
                    this.getPersistenceManager().write(designObject);
                }
            } else {
                this.getPersistenceManager().write(designObject);
            }
        }
        this.appendReferencedObjectElement(element, designObject);
    }

    private void appendReferencedObjectElement(Element element, DesignObject designObject) {
        if (designObject instanceof Note && designObject.getFirstViewForDPV(this.design.getMainView()) == null) {
            return;
        }
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", designObject.belongsToDesign() ? "contains" : "uses");
        element2.setAttribute("type", designObject.getObjectTypeName());
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        this.appendGraphicalInfo(element2, designObject);
        element.appendChild(element2);
    }

    public void appendGraphicalInfo(Element element, DesignObject designObject) {
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            Element element2 = element.getOwnerDocument().createElement("graphical");
            Map map = applicationView.getGraphicalPropsFor(designObject);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Element element3 = element.getOwnerDocument().createElement("parameter");
                element2.appendChild(element3);
                String string = (String)iterator.next();
                element3.setAttribute("name", string);
                element3.setAttribute("value", (String)map.get(string));
            }
            element.appendChild(element2);
        }
    }

    public void handleLinks(MultidimensionalDesign multidimensionalDesign, Element element) {
        if (multidimensionalDesign.getAppView() != null) {
            DesignPartView designPartView = multidimensionalDesign.getMainView();
            Iterator iterator = multidimensionalDesign.getLinkSet().iterator();
            while (iterator.hasNext()) {
                Link link = (Link)iterator.next();
                if (link.getSourceTV(designPartView) == null && link.getTargetTV(designPartView) == null) continue;
                this.appendLinkObjectElement(multidimensionalDesign, element, link);
            }
        }
    }

    private void appendLinkObjectElement(MultidimensionalDesign multidimensionalDesign, Element element, Link link) {
        Object object;
        Object object2;
        Document document = element.getOwnerDocument();
        DesignPartView designPartView = multidimensionalDesign.getMainView();
        TVLink tVLink = (TVLink)link.getViewFor(designPartView);
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", "represents");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(link.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(link.getObjectID()));
        element2.setAttribute("viewid_source", link.getSourceTV(designPartView) != null ? link.getSourceTV(designPartView).getViewID() : "null");
        element2.setAttribute("viewid_target", link.getTargetTV(designPartView) != null ? link.getTargetTV(designPartView).getViewID() : "null");
        Element element3 = document.createElement("points");
        if (tVLink != null) {
            object2 = (EdgeView)((DefaultEdge)tVLink.getCellView().getCell()).getCellView();
            object = ((EdgeView)object2).getPoints();
            for (int i = 0; i < object.size(); ++i) {
                Object e = object.get(i);
                Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                if (point2D == null) continue;
                Element element4 = document.createElement("point");
                element4.setAttribute("x_coordinate", Double.toString(point2D.getX()));
                element4.setAttribute("y_coordinate", Double.toString(point2D.getY()));
                element3.appendChild(element4);
            }
        }
        element2.appendChild(element3);
        if (link.getRollupLink() != null && link.getRollupLink().isRolePlaying() && (object2 = (EdgeView)tVLink.getCellView()) != null) {
            object = document.createElement("labels");
            Element element5 = document.createElement("main_label");
            element5.setAttribute("x_coordinate", Double.toString(tVLink.getLabelBounds().getX()));
            element5.setAttribute("y_coordinate", Double.toString(tVLink.getLabelBounds().getY()));
            element5.setAttribute("width", Double.toString(tVLink.getLabelBounds().getWidth()));
            element5.setAttribute("height", Double.toString(tVLink.getLabelBounds().getHeight()));
            object.appendChild(element5);
            element2.appendChild((Node)object);
        }
        if (tVLink != null) {
            object2 = document.createElement("graphical");
            object = element2.getOwnerDocument().createElement("parameter");
            object2.appendChild((Node)object);
            object.setAttribute("name", "use_default_color");
            object.setAttribute("value", Boolean.toString(tVLink.useDefaultColor()));
            if (!tVLink.useDefaultColor()) {
                object = element2.getOwnerDocument().createElement("parameter");
                object2.appendChild((Node)object);
                object.setAttribute("name", "color");
                object.setAttribute("value", tVLink.getBackgroundColor() != null ? Integer.toString(tVLink.getBackgroundColor().getRGB()) : "null");
                object = element2.getOwnerDocument().createElement("parameter");
                object2.appendChild((Node)object);
                object.setAttribute("name", "width");
                object.setAttribute("value", Integer.toString(tVLink.getLineWidth()));
            }
            element2.appendChild((Node)object2);
        }
        element.appendChild(element2);
    }

    public void handleRHLinks(MultidimensionalDesign multidimensionalDesign, Element element) {
        if (multidimensionalDesign.getAppView() != null) {
            Iterator iterator = multidimensionalDesign.getRaggedHLinkSet().iterator();
            while (iterator.hasNext()) {
                RaggedHLink raggedHLink = (RaggedHLink)iterator.next();
                if (raggedHLink.getChildLevel().getTopView() == null || raggedHLink.getParentLevel().getTopView() == null) continue;
                this.appendRHLinkObjectElement(multidimensionalDesign, element, raggedHLink);
            }
        }
    }

    private void appendRHLinkObjectElement(MultidimensionalDesign multidimensionalDesign, Element element, RaggedHLink raggedHLink) {
        Object object;
        Object object2;
        Document document = element.getOwnerDocument();
        TVRaggedHLink tVRaggedHLink = (TVRaggedHLink)raggedHLink.getTopView();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", "represents");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(raggedHLink.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(raggedHLink.getObjectID()));
        element2.setAttribute("viewid_source", raggedHLink.getSourceTV() != null ? raggedHLink.getSourceTV().getViewID() : "null");
        element2.setAttribute("viewid_target", raggedHLink.getTargetTV() != null ? raggedHLink.getTargetTV().getViewID() : "null");
        Element element3 = document.createElement("points");
        if (tVRaggedHLink != null) {
            object2 = (EdgeView)((DefaultEdge)tVRaggedHLink.getCellView().getCell()).getCellView();
            object = ((EdgeView)object2).getPoints();
            for (int i = 0; i < object.size(); ++i) {
                Object e = object.get(i);
                Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                if (point2D == null) continue;
                Element element4 = document.createElement("point");
                element4.setAttribute("x_coordinate", Double.toString(point2D.getX()));
                element4.setAttribute("y_coordinate", Double.toString(point2D.getY()));
                element3.appendChild(element4);
            }
        }
        element2.appendChild(element3);
        if (tVRaggedHLink != null) {
            object2 = document.createElement("graphical");
            object = element2.getOwnerDocument().createElement("parameter");
            object2.appendChild((Node)object);
            object.setAttribute("name", "use_default_color");
            object.setAttribute("value", Boolean.toString(tVRaggedHLink.useDefaultColor()));
            if (!tVRaggedHLink.useDefaultColor()) {
                object = element2.getOwnerDocument().createElement("parameter");
                object2.appendChild((Node)object);
                object.setAttribute("name", "color");
                object.setAttribute("value", tVRaggedHLink.getBackgroundColor() != null ? Integer.toString(tVRaggedHLink.getBackgroundColor().getRGB()) : "null");
                object = element2.getOwnerDocument().createElement("parameter");
                object2.appendChild((Node)object);
                object.setAttribute("name", "width");
                object.setAttribute("value", Integer.toString(tVRaggedHLink.getLineWidth()));
            }
            element2.appendChild((Node)object2);
        }
        element.appendChild(element2);
    }

    @Override
    public String getFilenameFor(Object object) {
        MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)object;
        return StringUtilities.encodeAttributeValue(multidimensionalDesign.getObjectID());
    }

    @Override
    public String getRelativePath() {
        if (this.design != null && this.design.getAppView() != null) {
            String string = this.design.getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('/').append(string).append('/').append("multidimensional");
            return stringBuffer.toString();
        }
        return "multidimensional";
    }

    public void handleCompactDiagram(MultidimensionalDesign multidimensionalDesign, Element element) {
        if (multidimensionalDesign.getAppView() != null) {
            AbstractMDObject abstractMDObject;
            DesignPartViewPlaceHolder designPartViewPlaceHolder = multidimensionalDesign.getCompactDiagramPlaceHolder();
            DPVCompactMultidimentional dPVCompactMultidimentional = multidimensionalDesign.getCompactDiagram();
            element.setAttribute("name", dPVCompactMultidimentional.getName());
            element.setAttribute("id", dPVCompactMultidimentional.getDPVId());
            element.setAttribute("generator", dPVCompactMultidimentional.getGeneratorId());
            element.setAttribute("visible", designPartViewPlaceHolder.getVisible() ? "true" : "false");
            element.setAttribute("comment", StringUtilities.encodeAttributeValue(designPartViewPlaceHolder.getComment()));
            element.setAttribute("notes", StringUtilities.encodeAttributeValue(designPartViewPlaceHolder.getNotes()));
            this.addCubesInDPV(multidimensionalDesign, element, dPVCompactMultidimentional);
            this.addDimensionsInDPV(multidimensionalDesign, element, dPVCompactMultidimentional);
            this.addLevelsInDPV(multidimensionalDesign, element, dPVCompactMultidimentional);
            this.addNotesInDPV(multidimensionalDesign, element, dPVCompactMultidimentional);
            Iterator iterator = multidimensionalDesign.getLinkSet().iterator();
            while (iterator.hasNext()) {
                abstractMDObject = (Link)iterator.next();
                this.appendSubViewLinkInfo(element, dPVCompactMultidimentional, (Link)abstractMDObject);
            }
            iterator = multidimensionalDesign.getRaggedHLinkSet().iterator();
            while (iterator.hasNext()) {
                abstractMDObject = (RaggedHLink)iterator.next();
                this.appendSubViewRaggedHLinkInfo(element, dPVCompactMultidimentional, (RaggedHLink)abstractMDObject);
            }
            this.appendDisplayProperties(element, dPVCompactMultidimentional);
        }
    }

    private void appendSubViewLinkInfo(Element element, DesignPartView designPartView, Link link) {
        block8: {
            try {
                Object object;
                Object object2;
                Document document = element.getOwnerDocument();
                TVLink tVLink = (TVLink)link.getViewFor(designPartView);
                if (tVLink == null || link.getSourceTV(designPartView) == null || link.getTargetTV(designPartView) == null) break block8;
                Element element2 = document.createElement("objectid");
                element2.setAttribute("role", "represents");
                element2.setAttribute("type", StringUtilities.encodeAttributeValue(link.getObjectTypeName()));
                element2.setAttribute("oid", StringUtilities.encodeAttributeValue(link.getObjectID()));
                element2.setAttribute("viewid_source", link.getSourceTV(designPartView) != null ? link.getSourceTV(designPartView).getViewID() : "null");
                element2.setAttribute("viewid_target", link.getTargetTV(designPartView) != null ? link.getTargetTV(designPartView).getViewID() : "null");
                Element element3 = document.createElement("points");
                if (tVLink != null) {
                    if (tVLink.getCellView() != null) {
                        object2 = (EdgeView)((DefaultEdge)tVLink.getCellView().getCell()).getCellView();
                        object = ((EdgeView)object2).getPoints();
                        for (int i = 0; i < object.size(); ++i) {
                            Object e = object.get(i);
                            Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                            if (point2D == null) continue;
                            Element element4 = document.createElement("point");
                            element4.setAttribute("x_coordinate", Double.toString(point2D.getX()));
                            element4.setAttribute("y_coordinate", Double.toString(point2D.getY()));
                            element3.appendChild(element4);
                        }
                    } else {
                        object2 = tVLink.getEdgePoints();
                        for (int i = 0; i < object2.size(); ++i) {
                            Object e = object2.get(i);
                            Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                            if (point2D == null) continue;
                            Element element5 = document.createElement("point");
                            element5.setAttribute("x_coordinate", Double.toString(point2D.getX()));
                            element5.setAttribute("y_coordinate", Double.toString(point2D.getY()));
                            element3.appendChild(element5);
                        }
                    }
                }
                element2.appendChild(element3);
                if (link.getRollupLink() != null && link.getRollupLink().isRolePlaying() && (object2 = (EdgeView)tVLink.getCellView()) != null) {
                    object = document.createElement("labels");
                    Element element6 = document.createElement("main_label");
                    element6.setAttribute("x_coordinate", Double.toString(tVLink.getLabelBounds().getX()));
                    element6.setAttribute("y_coordinate", Double.toString(tVLink.getLabelBounds().getY()));
                    element6.setAttribute("width", Double.toString(tVLink.getLabelBounds().getWidth()));
                    element6.setAttribute("height", Double.toString(tVLink.getLabelBounds().getHeight()));
                    object.appendChild(element6);
                    element2.appendChild((Node)object);
                }
                element.appendChild(element2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void appendSubViewRaggedHLinkInfo(Element element, DesignPartView designPartView, RaggedHLink raggedHLink) {
        block7: {
            try {
                Document document = element.getOwnerDocument();
                TVRaggedHLink tVRaggedHLink = (TVRaggedHLink)raggedHLink.getViewFor(designPartView);
                if (tVRaggedHLink == null || raggedHLink.getSourceTV(designPartView) == null || raggedHLink.getTargetTV(designPartView) == null) break block7;
                Element element2 = document.createElement("objectid");
                element2.setAttribute("role", "represents");
                element2.setAttribute("type", StringUtilities.encodeAttributeValue(raggedHLink.getObjectTypeName()));
                element2.setAttribute("oid", StringUtilities.encodeAttributeValue(raggedHLink.getObjectID()));
                element2.setAttribute("viewid_source", raggedHLink.getSourceTV(designPartView) != null ? raggedHLink.getSourceTV(designPartView).getViewID() : "null");
                element2.setAttribute("viewid_target", raggedHLink.getTargetTV(designPartView) != null ? raggedHLink.getTargetTV(designPartView).getViewID() : "null");
                Element element3 = document.createElement("points");
                if (tVRaggedHLink != null) {
                    if (tVRaggedHLink.getCellView() != null) {
                        EdgeView edgeView = (EdgeView)((DefaultEdge)tVRaggedHLink.getCellView().getCell()).getCellView();
                        List list = edgeView.getPoints();
                        for (int i = 0; i < list.size(); ++i) {
                            Object e = list.get(i);
                            Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                            if (point2D == null) continue;
                            Element element4 = document.createElement("point");
                            element4.setAttribute("x_coordinate", Double.toString(point2D.getX()));
                            element4.setAttribute("y_coordinate", Double.toString(point2D.getY()));
                            element3.appendChild(element4);
                        }
                    } else {
                        List list = tVRaggedHLink.getEdgePoints();
                        for (int i = 0; i < list.size(); ++i) {
                            Object e = list.get(i);
                            Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                            if (point2D == null) continue;
                            Element element5 = document.createElement("point");
                            element5.setAttribute("x_coordinate", Double.toString(point2D.getX()));
                            element5.setAttribute("y_coordinate", Double.toString(point2D.getY()));
                            element3.appendChild(element5);
                        }
                    }
                }
                element2.appendChild(element3);
                element.appendChild(element2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addCubesInDPV(MultidimensionalDesign multidimensionalDesign, Element element, DPVCompactMultidimentional dPVCompactMultidimentional) {
        Iterator iterator = multidimensionalDesign.getCubeSet().iterator();
        while (iterator.hasNext()) {
            Cube cube = (Cube)iterator.next();
            for (TopView topView : cube.getViewsForDPV(dPVCompactMultidimentional)) {
                this.appendReferencedObjectReprElement(element, topView);
            }
        }
    }

    private void addDimensionsInDPV(MultidimensionalDesign multidimensionalDesign, Element element, DPVCompactMultidimentional dPVCompactMultidimentional) {
        Iterator iterator = multidimensionalDesign.getDimensionSet().iterator();
        while (iterator.hasNext()) {
            Dimension dimension = (Dimension)iterator.next();
            for (TopView topView : dimension.getViewsForDPV(dPVCompactMultidimentional)) {
                this.appendReferencedObjectReprElement(element, topView);
            }
        }
    }

    private void addLevelsInDPV(MultidimensionalDesign multidimensionalDesign, Element element, DPVCompactMultidimentional dPVCompactMultidimentional) {
        Iterator iterator = multidimensionalDesign.getLevelSet().iterator();
        while (iterator.hasNext()) {
            Level level = (Level)iterator.next();
            for (TopView topView : level.getViewsForDPV(dPVCompactMultidimentional)) {
                this.appendReferencedObjectReprElement(element, topView);
            }
        }
    }

    private void appendReferencedObjectReprElement(Element element, TopView topView) {
        Document document = element.getOwnerDocument();
        DesignObject designObject = topView.getModel();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", "represents");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        element2.setAttribute("viewid", topView.getViewID());
        element2.setAttribute("tv_generator_id", topView.getGeneratorID());
        this.appendGraphicalInfo(element2, topView);
        element.appendChild(element2);
    }

    public void appendGraphicalInfo(Element element, TopView topView) {
        DesignObject designObject = topView.getModel();
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            Element element2 = element.getOwnerDocument().createElement("graphical");
            Map map = applicationView.getGraphicalPropsFor(topView);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Element element3 = element.getOwnerDocument().createElement("parameter");
                element2.appendChild(element3);
                String string = (String)iterator.next();
                element3.setAttribute("name", string);
                element3.setAttribute("value", (String)map.get(string));
            }
            element.appendChild(element2);
        }
    }

    private void addNotesInDPV(MultidimensionalDesign multidimensionalDesign, Element element, DPVCompactMultidimentional dPVCompactMultidimentional) {
        Iterator iterator = multidimensionalDesign.getNoteSet().iterator();
        while (iterator.hasNext()) {
            Note note = (Note)iterator.next();
            TopView topView = note.getFirstViewForDPV(dPVCompactMultidimentional);
            if (topView == null) continue;
            this.appendReferencedObjectReprElement(element, topView);
        }
    }
}

