/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolder;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLMeasureFolder
extends AbstractWXMLDesignObject
implements MDConstants {
    private MeasureFolder measureFolder = null;

    public WXMLMeasureFolder(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof MeasureFolder;
        if (bl) {
            this.measureFolder = (MeasureFolder)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.measureFolder != null) {
            String string = this.measureFolder.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.measureFolder.getDesignPart().getObjectID())).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("measureFolderPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof MeasureFolder) {
            MeasureFolder measureFolder = (MeasureFolder)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("description", String.valueOf(measureFolder.getDescription()));
            if (measureFolder.getParentFolder() != null) {
                treeMap.put("parent_folder", StringUtilities.encodeAttributeValue(String.valueOf(measureFolder.getParentFolder().getObjectID())));
            } else {
                treeMap.put("parent_folder", String.valueOf(measureFolder.getParentFolder()));
            }
            this.appendProperties(element, "attributes", treeMap);
            Element element2 = element.getOwnerDocument().createElement("measure_wrappers");
            this.appendMeasureWrappers(element2, measureFolder);
            element.appendChild(element2);
            Element element3 = element.getOwnerDocument().createElement("measures");
            this.appendMeasures(element3, measureFolder);
            element.appendChild(element3);
        }
    }

    private void appendMeasureWrappers(Element element, MeasureFolder measureFolder) {
        for (MeasureFolder.MFElement mFElement : measureFolder.getOnlyMeasureWrapper()) {
            Element element2 = element.getOwnerDocument().createElement("measure_wrapper");
            Slice.MeasureWrapper measureWrapper = (Slice.MeasureWrapper)mFElement.getMeasure();
            element2.setAttribute("measure_id", StringUtilities.encodeAttributeValue(measureWrapper.getMeasure().getObjectID()));
            element2.setAttribute("mfelement_parent_id", StringUtilities.encodeAttributeValue(mFElement.getParent().getObjectID()));
            if (measureWrapper.getAggrFunction() != null) {
                element2.setAttribute("aggr_function_id", StringUtilities.encodeAttributeValue(measureWrapper.getAggrFunction().getObjectID()));
            }
            this.appendSummaryLevels(element2, measureWrapper);
            element.appendChild(element2);
        }
    }

    private void appendMeasures(Element element, MeasureFolder measureFolder) {
        for (MeasureFolder.MFElement mFElement : measureFolder.getOnlyMeasures()) {
            Element element2 = element.getOwnerDocument().createElement("measure");
            Measure measure = (Measure)mFElement.getMeasure();
            element2.setAttribute("measure_id", StringUtilities.encodeAttributeValue(measure.getObjectID()));
            element2.setAttribute("mfelement_parent_id", StringUtilities.encodeAttributeValue(mFElement.getParent().getObjectID()));
            element.appendChild(element2);
        }
    }

    private void appendSummaryLevels(Element element, Slice.MeasureWrapper measureWrapper) {
        for (Level level : measureWrapper.levels) {
            Element element2 = element.getOwnerDocument().createElement("summary_level");
            element2.setAttribute("level_id", StringUtilities.encodeAttributeValue(level.getObjectID()));
            element.appendChild(element2);
        }
    }
}

