/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLLink
extends AbstractWXMLDesignObject
implements MDConstants {
    private Link link = null;

    public WXMLLink(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl;
        boolean bl2 = bl = Link.class == object.getClass();
        if (bl) {
            this.link = (Link)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.link != null) {
            String string = this.link.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.link.getDesignPart().getObjectID())).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("linkPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof Link) {
            Link link = (Link)designObject;
            this.appendConnectionInfo(element, link.getSourceConnection(), "source");
            this.appendConnectionInfo(element, link.getTargetConnection(), "target");
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("rolluplink", String.valueOf(link.getRollupLink() != null ? StringUtilities.encodeAttributeValue(link.getRollupLink().getObjectID()) : "null"));
            this.appendProperties(element, "attributes", treeMap);
        }
    }

    private void appendConnectionInfo(Element element, Link.Connection connection, String string) {
        Element element2 = element.getOwnerDocument().createElement("connection");
        element.appendChild(element2);
        element2.setAttribute("endpoint", string);
        element2.setAttribute("mdobject", connection.getMDObject() != null ? StringUtilities.encodeAttributeValue(connection.getMDObject().getObjectID()) : "null");
    }
}

