/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Iterator;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLLevel
extends AbstractWXMLDesignObject
implements MDConstants {
    private Level level = null;

    public WXMLLevel(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof Level;
        if (bl) {
            this.level = (Level)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.level != null) {
            String string = this.level.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.level.getDesignPart().getObjectID())).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("levelPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof Level) {
            Level level = (Level)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("description", String.valueOf(level.getDescription()));
            treeMap.put("entity", String.valueOf(level.getLevelEntity() != null ? StringUtilities.encodeAttributeValue(level.getLevelEntity().getObjectID()) : "null"));
            treeMap.put("selectioncriteria", String.valueOf(level.getSelectionCriteria()));
            treeMap.put("selectioncriteriades", String.valueOf(level.getSelectionCriteriaDescription()));
            treeMap.put("valuebased", String.valueOf(level.isValueBasedHierarchy()));
            treeMap.put("rootident", String.valueOf(level.getRootIdentification()));
            treeMap.put("identvalue", String.valueOf(level.getIdentificationValue()));
            if (level.getDefaultAttribute() != null) {
                treeMap.put("default_attribute", StringUtilities.encodeAttributeValue(level.getDefaultAttribute().getObjectID()));
            }
            Level.OraAWAttributes oraAWAttributes = level.getOraAWAttributes();
            if (oraAWAttributes.shortDesc != null) {
                treeMap.put("aw_short_description", StringUtilities.encodeAttributeValue(oraAWAttributes.shortDesc.getObjectID()));
            }
            if (oraAWAttributes.longDesc != null) {
                treeMap.put("aw_long_description", StringUtilities.encodeAttributeValue(oraAWAttributes.longDesc.getObjectID()));
            }
            if (oraAWAttributes.timeEnd != null) {
                treeMap.put("aw_time_end", StringUtilities.encodeAttributeValue(oraAWAttributes.timeEnd.getObjectID()));
            }
            if (oraAWAttributes.timeSpan != null) {
                treeMap.put("aw_time_span", StringUtilities.encodeAttributeValue(oraAWAttributes.timeSpan.getObjectID()));
            }
            treeMap.put("name_column", String.valueOf(level.getNameColumn() != null ? StringUtilities.encodeAttributeValue(level.getNameColumn().getObjectID()) : "null"));
            treeMap.put("value_column", String.valueOf(level.getValueColumn() != null ? StringUtilities.encodeAttributeValue(level.getValueColumn().getObjectID()) : "null"));
            this.appendProperties(element, "attributes", treeMap);
            this.appendObjects(element, level.getLevelKey().toArray(), "levelkey");
            this.appendObjects(element, level.getParentKey().toArray(), "parentkey");
            this.appendCalculatedAttributes(element, level);
            Element element2 = element.getOwnerDocument().createElement("contained");
            element.appendChild(element2);
            for (SlowChangingAttribute slowChangingAttribute : level.getSlowChangingAttributes()) {
                this.appendSlowChangingAttributeInfo(element2, slowChangingAttribute);
            }
        }
    }

    private void appendSlowChangingAttributeInfo(Element element, SlowChangingAttribute slowChangingAttribute) {
        Element element2 = element.getOwnerDocument().createElement("slowchangingattribute");
        Element element3 = element.getOwnerDocument().createElement("parameter");
        element2.appendChild(element3);
        this.appendProperty(element3, "attributeid", StringUtilities.encodeAttributeValue(slowChangingAttribute.getAttribute().getObjectID()));
        element3 = element.getOwnerDocument().createElement("parameter");
        element2.appendChild(element3);
        this.appendProperty(element3, "type", slowChangingAttribute.getType());
        element3 = element.getOwnerDocument().createElement("parameter");
        element2.appendChild(element3);
        this.appendProperty(element3, "classification", slowChangingAttribute.getClassification());
        element3 = element.getOwnerDocument().createElement("parameter");
        element2.appendChild(element3);
        this.appendProperty(element3, "name", slowChangingAttribute.getName());
        element3 = element.getOwnerDocument().createElement("parameter");
        element2.appendChild(element3);
        this.appendProperty(element3, "indexed", String.valueOf(slowChangingAttribute.isIndexed()));
        Iterator iterator = slowChangingAttribute.getHistoryAttributes().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(StringUtilities.encodeAttributeValue(((DesignObject)iterator.next()).getObjectID()));
        }
        element3 = element.getOwnerDocument().createElement("parameter");
        element2.appendChild(element3);
        this.appendProperty(element3, "historyattributes", stringBuffer.toString());
        element.appendChild(element2);
    }

    private void appendCalculatedAttributes(Element element, Level level) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("calculated_attributes");
        for (CalculatedAttribute calculatedAttribute : level.getCalculatedAttributes()) {
            Element element3 = document.createElement("contained");
            element3.setAttribute("oid", StringUtilities.encodeAttributeValue(calculatedAttribute.getObjectID()));
            if (calculatedAttribute.getName() != null && !"".equalsIgnoreCase(calculatedAttribute.getName())) {
                element3.setAttribute("name", StringUtilities.encodeAttributeValue(calculatedAttribute.getName()));
            }
            if (calculatedAttribute.getFunction() != null && !"".equalsIgnoreCase(calculatedAttribute.getFunction())) {
                element3.setAttribute("ca_expression", StringUtilities.encodeAttributeValue(calculatedAttribute.getFunction()));
            }
            element2.appendChild(element3);
        }
        element.appendChild(element2);
    }
}

