/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLDimension
extends AbstractWXMLDesignObject
implements MDConstants {
    private Dimension dimension = null;

    public WXMLDimension(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof Dimension;
        if (bl) {
            this.dimension = (Dimension)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dimension != null) {
            String string = this.dimension.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.dimension.getDesignPart().getObjectID())).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("dimensionPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof Dimension) {
            Dimension dimension = (Dimension)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("description", String.valueOf(dimension.getDescription()));
            treeMap.put("timedimension", String.valueOf(dimension.isTimeDimension()));
            treeMap.put("use_natural_keys", String.valueOf(dimension.isUseNaturalKeys()));
            this.appendProperties(element, "attributes", treeMap);
            this.appendClacMembers(element, dimension);
        }
    }

    private void appendClacMembers(Element element, Dimension dimension) {
        Element element2 = element.getOwnerDocument().createElement("calculated_members");
        for (Dimension.PermanentCalcMember permanentCalcMember : dimension.getPermanentCalcMembers()) {
            Element element3 = element.getOwnerDocument().createElement("calculated_member");
            if (permanentCalcMember.getName() != null && !"".equalsIgnoreCase(permanentCalcMember.getName())) {
                element3.setAttribute("name", StringUtilities.encodeAttributeValue(permanentCalcMember.getName()));
            }
            if (permanentCalcMember.getExpression() != null && !"".equalsIgnoreCase(permanentCalcMember.getExpression())) {
                element3.setAttribute("expression", StringUtilities.encodeAttributeValue(permanentCalcMember.getExpression()));
            }
            element2.appendChild(element3);
        }
        element.appendChild(element2);
    }
}

