/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLCube
extends AbstractWXMLDesignObject
implements MDConstants {
    private Cube cube = null;

    public WXMLCube(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof Cube;
        if (bl) {
            this.cube = (Cube)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cube != null) {
            String string = this.cube.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.cube.getDesignPart().getObjectID())).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("cubePath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof Cube) {
            Cube cube = (Cube)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("description", String.valueOf(cube.getDescription()));
            treeMap.put("virtual", String.valueOf(cube.isVirtual()));
            treeMap.put("global_composites", String.valueOf(cube.isUseGlobalComposites()));
            treeMap.put("compressed_composites", String.valueOf(cube.isCompressedComposites()));
            treeMap.put("partitioned", String.valueOf(cube.isPartitioned()));
            if (cube.getPartDimension() != null) {
                treeMap.put("part_dimension", StringUtilities.encodeAttributeValue(String.valueOf(cube.getPartDimension().getObjectID())));
            }
            if (cube.getPartHierarchy() != null) {
                treeMap.put("part_hierarchy", StringUtilities.encodeAttributeValue(String.valueOf(cube.getPartHierarchy().getObjectID())));
            }
            if (cube.getPartLevel() != null) {
                treeMap.put("part_level", StringUtilities.encodeAttributeValue(String.valueOf(cube.getPartLevel().getObjectID())));
            }
            treeMap.put("partdescription", String.valueOf(cube.getPartitioningDescription()));
            treeMap.put("fullcubemat", String.valueOf(cube.getFullCubeMaterialization() != null ? StringUtilities.encodeAttributeValue(cube.getFullCubeMaterialization().getObjectID()) : "null"));
            this.appendProperties(element, "attributes", treeMap);
            this.appendObjects(element, cube.getDimensions().toArray(), "dimensions");
            this.appendObjects(element, cube.getMeasures().toArray(), "measures");
            this.appendObjects(element, cube.getPrecalculatedSlices().toArray(), "slices");
            this.appendObjects(element, cube.getFactEntities().toArray(), "fact_entities");
            this.appendObjects(element, cube.getJoins().toArray(), "fact_joins");
        }
    }
}

