/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteria;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLSelectionCriteria
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLSelectionCriteria(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getMultidimensionalDesign().getSelectionCriteriaSet().createSC(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        String string;
        Object object;
        SelectionCriteria selectionCriteria = (SelectionCriteria)super.recreateObject(element, design, bl);
        Map map = this.getProperties(element, "attributes");
        selectionCriteria.setSelectionCriteria((String)map.get("selectioncriteria"));
        selectionCriteria.setDescription((String)map.get("description"));
        String string2 = (String)map.get("entity");
        if (!"null".equalsIgnoreCase(string2) && (object = (Entity)selectionCriteria.getDesign().getLogicalDesign().getEntitySet().getObjectByID(string2)) != null) {
            selectionCriteria.setEntity((Entity)object);
        }
        selectionCriteria.setPartition((String)map.get("partition"));
        object = (String)map.get("measure_id");
        if (!"null".equalsIgnoreCase((String)object)) {
            selectionCriteria.setMeasureID((String)object);
        }
        if (!"null".equalsIgnoreCase(string = (String)map.get("aggr_function_id"))) {
            selectionCriteria.setFuncID(string);
        }
        selectionCriteria.setPartition((String)map.get("partition"));
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(selectionCriteria.getObjectID())).append(".dmd");
        selectionCriteria.setFilePath(stringBuffer.toString());
        return selectionCriteria;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            stringBuffer.append(string).append('/').append("multidimensional").append('/').append(string2).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("selcriteriaPath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == SelectionCriteria.class;
    }
}

