/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.datatypes;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.datatypes.DTConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLDistinctType
extends AbstractWXMLDesignObject
implements DTConstants {
    private DistinctType distinctType = null;

    public WXMLDistinctType(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof DistinctType;
        if (bl) {
            this.distinctType = (DistinctType)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.distinctType != null) {
            String string = this.distinctType.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("datatypes").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("distincttypePath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof DistinctType) {
            DistinctType distinctType = (DistinctType)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("LogicalType", String.valueOf(distinctType.getLogicalDataType() != null ? StringUtilities.encodeAttributeValue(distinctType.getLogicalDataType().getObjectID()) : "null"));
            treeMap.put("size", distinctType.getSize());
            treeMap.put("Scale", String.valueOf(distinctType.getScale()));
            treeMap.put("Precision", String.valueOf(distinctType.getPrecision()));
            this.appendProperties(element, "attributes", treeMap);
        }
    }
}

