/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.datatypes;

import java.util.Map;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.datatypes.DTConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLStructuredType
extends AbstractRXMLDesignObject
implements DTConstants {
    public RXMLStructuredType(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        boolean bl = Boolean.valueOf(element.getAttribute("visible"));
        return design.getDataTypesDesign().getStructuredTypeSet().createStructuredType(StringUtilities.decodeAttributeValue(string), bl);
    }

    @Override
    public Object recreateObject(Document document, Design design, boolean bl) {
        try {
            DesignObject designObject;
            Element element;
            int n;
            int n2;
            NodeList nodeList;
            Element element2 = RXMLStructuredType.getFirstChildByTagName(document.getDocumentElement(), "object");
            StructuredType structuredType = (StructuredType)this.recreateObject(element2, design, bl);
            if (RXMLStructuredType.getFirstChildByTagName(document.getDocumentElement(), "contained") != null) {
                nodeList = RXMLStructuredType.getFirstChildByTagName(document.getDocumentElement(), "contained").getElementsByTagName("object");
                n2 = nodeList.getLength();
                for (n = 0; n < n2; ++n) {
                    element = (Element)nodeList.item(n);
                    designObject = this.instantiateTypeElement(element.getAttribute("id"), design, structuredType, element);
                    this.readElementInfo(element, (TypeElement)designObject, bl, design, structuredType);
                }
            }
            if (RXMLStructuredType.getFirstChildByTagName(document.getDocumentElement(), "methods") != null) {
                nodeList = RXMLStructuredType.getFirstChildByTagName(document.getDocumentElement(), "methods").getElementsByTagName("object");
                n2 = nodeList.getLength();
                for (n = 0; n < n2; ++n) {
                    element = (Element)nodeList.item(n);
                    designObject = this.instantiateMethod(element.getAttribute("id"), design, structuredType, element);
                    this.readMethodInfo(element, (Method)designObject, bl, design, structuredType);
                }
            }
            return structuredType;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Object object;
        StructuredType structuredType = (StructuredType)super.recreateObject(element, design, bl);
        Map map = this.getProperties(element, "attributes");
        boolean bl2 = Boolean.valueOf(element.getAttribute("visible"));
        structuredType.setVisible(bl2);
        String string = StringUtilities.decodeAttributeValue((String)map.get("parent_type"));
        if (!"null".equalsIgnoreCase(string)) {
            object = (StructuredType)structuredType.getDesign().getDesignObject(string);
            if (object != null) {
                structuredType.setParentType((StructuredType)object, false);
            } else {
                structuredType.setParentTypeID(string);
            }
        }
        structuredType.setFinal(Boolean.valueOf((String)map.get("final")));
        structuredType.setInstantiable(Boolean.valueOf((String)map.get("instantiable")));
        structuredType.setPredefined(Boolean.valueOf((String)map.get("predefined")));
        object = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            ((StringBuffer)object).append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        ((StringBuffer)object).append(this.getRelativePath()).append('/').append(structuredType.getObjectID()).append(".dmd");
        structuredType.setFilePath(((StringBuffer)object).toString());
        return structuredType;
    }

    private TypeElement instantiateTypeElement(String string, Design design, StructuredType structuredType, Element element) {
        TypeElement typeElement = new TypeElement(structuredType.getDesignPart(), structuredType);
        typeElement.setObjectID(string);
        typeElement.setDesign(structuredType.getDesign());
        structuredType.add(typeElement);
        return typeElement;
    }

    private Method instantiateMethod(String string, Design design, StructuredType structuredType, Element element) {
        Method method = new Method(structuredType.getDesignPart(), structuredType);
        method.setObjectID(StringUtilities.decodeAttributeValue(string));
        method.setDesign(structuredType.getDesign());
        structuredType.addMethod(method);
        return method;
    }

    private void readElementInfo(Element element, TypeElement typeElement, boolean bl, Design design, DesignObject designObject) {
        this.readBasicObjectInfo(element, typeElement, bl);
        Map map = this.getProperties(element, "attributes");
        typeElement.setReference(Boolean.valueOf((String)map.get("reference")));
        String string = StringUtilities.decodeAttributeValue((String)map.get("typeid"));
        if (!"null".equalsIgnoreCase(string)) {
            DesignObject designObject2 = designObject.getDesign().getDesignObject(string);
            if (designObject2 != null) {
                typeElement.setType(designObject2);
            } else {
                typeElement.setTypeID(string);
            }
        }
        try {
            typeElement.setSize((String)map.get("size"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            typeElement.setScale(Integer.parseInt((String)map.get("Scale")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            typeElement.setPrecision(Integer.parseInt((String)map.get("Precision")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        boolean bl2 = Boolean.valueOf((String)map.get("mandatory"));
        typeElement.setMandatory(bl2);
    }

    private void readMethodInfo(Element element, Method method, boolean bl, Design design, DesignObject designObject) {
        Object object;
        Object object2;
        this.readBasicObjectInfo(element, method, bl);
        Map map = this.getProperties(element, "attributes");
        method.setConstructor(Boolean.valueOf((String)map.get("constructor")));
        String string = (String)map.get("overrided_method");
        if (!"null".equalsIgnoreCase(string) && (object2 = designObject.getDesign().getDesignObject(string)) != null) {
            method.setOverridedMethod((Method)object2);
        }
        method.setBody((String)map.get("body"));
        object2 = element.getElementsByTagName("methodparam");
        for (int i = 0; i < object2.getLength(); ++i) {
            object = (Element)object2.item(i);
            MethodParam methodParam = new MethodParam(method.getDesignPart());
            methodParam.setDesign(method.getDesign());
            this.readParamInfo((Element)object, method, methodParam);
            method.addParameter(methodParam);
        }
        Element element2 = RXMLStructuredType.getFirstChildByTagName(element, "return_value");
        if (element2 != null) {
            object = new MethodParam(method.getDesignPart());
            ((ModelObject)object).setDesign(method.getDesign());
            this.readParamInfo(element2, method, (MethodParam)object);
            method.setReturnValue((MethodParam)object);
        }
    }

    private void readParamInfo(Element element, Method method, MethodParam methodParam) {
        Object object;
        Map map = this.getProperties(element, "attributes");
        methodParam.setName((String)map.get("name"));
        String string = StringUtilities.decodeAttributeValue((String)map.get("typeid"));
        if (!"null".equalsIgnoreCase(string)) {
            object = methodParam.getDesign().getDesignObject(string);
            if (object != null) {
                methodParam.setType((DesignObject)object);
            } else {
                methodParam.setTypeID(string);
            }
        }
        if ((object = (String)map.get("id")) != null) {
            methodParam.setObjectID((String)object);
        }
        try {
            methodParam.setSize((String)map.get("size"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            methodParam.setScale(Integer.parseInt((String)map.get("Scale")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            methodParam.setPrecision(Integer.parseInt((String)map.get("Precision")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        methodParam.setReference(Boolean.valueOf((String)map.get("reference")));
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("datatypes").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("structuredtypePath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == StructuredType.class;
    }
}

