/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.datatypes;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DTRelation;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.persistence.xml.RXMLSubview;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.TVDTRelation;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLDataTypesDesign
extends AbstractXMLReader {
    private static Logger LOGGER;
    private static float NFS;
    private float loadedVersion = NFS;
    private boolean xmlFromDB = false;

    public RXMLDataTypesDesign(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public Object recreateObject(Document document, Design design, boolean bl) {
        return null;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        int n;
        String string;
        Object[] objectArray;
        this.loadedVersion = designPart.getDesign().getLoadedVersion();
        this.xmlFromDB = this.getPersistenceManager().isXML_FromDataBase();
        Element element = document.getDocumentElement();
        String string2 = element.getAttribute("id");
        if (!"".equalsIgnoreCase(string2)) {
            designPart.setObjectID(StringUtilities.decodeAttributeValue(string2));
        }
        DesignPartView designPartView = null;
        if (this.loadedVersion < NFS) {
            designPartView = designPart.getMainView();
            int n2 = designPartView.getTabbedPane().indexOfComponent(designPartView);
            if (n2 < 0) {
                designPartView.getTabbedPane().setName(designPartView.getName());
                designPartView.getTabbedPane().add(designPartView);
            }
            this.readDisplayProperties(element, designPartView);
            designPartView.getWorkSpace().updateSettings();
        }
        NodeList nodeList = RXMLDataTypesDesign.getFirstChildByTagName(element, "ref").getElementsByTagName("objectid");
        int n3 = nodeList.getLength();
        for (int i = 0; i < n3; ++i) {
            objectArray = (Object[])nodeList.item(i);
            String string3 = objectArray.getAttribute("role");
            string = objectArray.getAttribute("oid");
            boolean bl2 = "contains".equalsIgnoreCase(string3) && bl;
            DesignObject designObject = null;
            designObject = !this.xmlFromDB ? (DesignObject)this.getPersistenceManager().read((Object)string, designPart.getDesign(), bl2) : designPart.getDesign().getDesignObject(string);
            if (designObject != null) {
                designObject.setTemporaryWriteable(true);
                if (!designObject.belongsToDesign(designPart.getDesign())) {
                    designObject.setReadOnly(true);
                }
                if (this.loadedVersion < NFS) {
                    this.readGraphicalInfo((Element)objectArray, designObject);
                }
                designObject.setTemporaryWriteable(false);
                continue;
            }
            LOGGER.error("RXMLDataTypesDesign: Read object returns null (objectID: " + string);
        }
        Map map = this.getProperties(element, "documents");
        objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map.get(objectArray[n]);
            DesignObject designObject = designPart.getDesign().getDesignObject(string);
            if (designObject == null) continue;
            designPart.addDocument((BIDocument)designObject);
        }
        map = this.getProperties(element, "parties");
        objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map.get(objectArray[n]);
            DesignObject designObject = designPart.getDesign().getDesignObject(string);
            if (designObject == null) continue;
            designPart.addResponsibleParty((BIResponsibleParty)designObject);
        }
        if (this.loadedVersion < NFS) {
            this.readRelations(element, (DataTypesDesign)designPart);
            this.readDTSubViews(element, (DataTypesDesign)designPart);
            n = designPartView.getTabbedPane().indexOfComponent(designPartView);
            if (n < 0) {
                designPartView.getTabbedPane().setName(designPartView.getName());
                designPartView.getTabbedPane().add(designPartView);
            }
            this.readSubordinateDisplays(element, designPartView);
            designPartView.getTabbedPane().setSelectedComponent(designPartView);
            this.readDiagramViews(element, designPart);
        } else if (!this.xmlFromDB) {
            RXMLSubview rXMLSubview = this.getPersistenceManager().getDesignPartViewReader();
            rXMLSubview.readExtSubViews(element, designPart);
        }
        designPart.setLoaded(true);
        return designPart;
    }

    @Override
    protected Map getProperties(Element element, String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        Element element2 = RXMLDataTypesDesign.getFirstChildByTagName(element, string);
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("parameter");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                treeMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
            }
        }
        return treeMap;
    }

    private void readRelations(Element element, DataTypesDesign dataTypesDesign) {
        ApplicationView.log(Messages.getString("RXMLDataTypesDesign.ReadDatatypeRelations"));
        Element element2 = RXMLDataTypesDesign.getFirstChildByTagName(element, "view_relations");
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("objectid");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                Object object3;
                Element element3;
                Object object4;
                Object object5;
                Object object6;
                String string;
                Element element4 = (Element)nodeList.item(i);
                String string2 = StringUtilities.decodeAttributeValue(element4.getAttribute("oid"));
                String string3 = StringUtilities.decodeAttributeValue(element4.getAttribute("type"));
                DTRelation dTRelation = string3.equalsIgnoreCase("DTInheritance") ? dataTypesDesign.createDTInheritance() : dataTypesDesign.createDTReference();
                if (dTRelation == null) continue;
                if (dTRelation instanceof DTReference) {
                    string = element4.getAttribute("stelement");
                    if (!string.equals("null") && (object6 = (TypeElement)dataTypesDesign.getTypeElementSet().getObjectByID(string)) != null) {
                        ((DTReference)dTRelation).setTypeElement((TypeElement)object6);
                        ((TypeElement)object6).setReferenceRelation((DTReference)dTRelation);
                    }
                } else if (dTRelation instanceof DTInheritance && !(string = StringUtilities.decodeAttributeValue(element4.getAttribute("viewid_target"))).equals("null") && (object6 = (StructuredType)dataTypesDesign.getDesign().getDesignObject(string)) != null) {
                    ((StructuredType)object6).setInheritanceRelation((DTInheritance)dTRelation);
                }
                string = StringUtilities.decodeAttributeValue(element4.getAttribute("viewid_source"));
                object6 = StringUtilities.decodeAttributeValue(element4.getAttribute("viewid_target"));
                if (!string.equals("null") && !((String)object6).equals("null")) {
                    object5 = (AbstractDTObject)dataTypesDesign.getDesign().getDesignObject(string);
                    object4 = (AbstractDTObject)dataTypesDesign.getDesign().getDesignObject((String)object6);
                    if (object5 != null && object4 != null) {
                        dTRelation.setSourceDTObject((AbstractDTObject)object5);
                        dTRelation.setTargetDTObject((AbstractDTObject)object4);
                    }
                }
                dTRelation.setObjectID(StringUtilities.decodeAttributeValue(string2));
                dataTypesDesign.getDesign().addDesignObject(dTRelation);
                object5 = RXMLDataTypesDesign.getFirstChildByTagName(element4, "points");
                object4 = object5.getElementsByTagName("point");
                int n2 = object4.getLength();
                TVDTRelation tVDTRelation = (TVDTRelation)dTRelation.getTopView();
                if (tVDTRelation == null) continue;
                for (int j = 0; j < n2; ++j) {
                    element3 = (Element)object4.item(j);
                    object3 = element3.getAttribute("x_coordinate");
                    object2 = element3.getAttribute("y_coordinate");
                    tVDTRelation.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble((String)object3), Double.parseDouble((String)object2)));
                }
                Element element5 = RXMLDataTypesDesign.getFirstChildByTagName(element4, "labels");
                if (element5 == null || (element3 = RXMLDataTypesDesign.getFirstChildByTagName(element5, "main_label")) != null) {
                    // empty if block
                }
                if ((element3 = RXMLDataTypesDesign.getFirstChildByTagName(element4, "graphical")) == null) continue;
                object3 = element3.getElementsByTagName("parameter");
                object2 = new HashMap();
                int n3 = object3.getLength();
                for (int j = 0; j < n3; ++j) {
                    Element element6 = (Element)object3.item(j);
                    object2.put(element6.getAttribute("name"), element6.getAttribute("value"));
                }
                String string4 = (String)object2.get("use_default_color");
                boolean bl = true;
                if (string4 != null) {
                    bl = Boolean.valueOf(string4);
                }
                tVDTRelation.setUseDefaultColor(bl);
                if (bl) continue;
                String string5 = (String)object2.get("color");
                if (string5 != null && !"null".equalsIgnoreCase(string5)) {
                    object = new Color(Integer.parseInt(string5));
                    tVDTRelation.setBackgroundColor((Color)object);
                }
                if ((object = (String)object2.get("width")) == null || "null".equalsIgnoreCase((String)object)) continue;
                int n4 = Integer.parseInt((String)object);
                tVDTRelation.setLineWidth(n4);
            }
        }
    }

    private void readDTSubViews(Element element, DataTypesDesign dataTypesDesign) {
        ApplicationView.log(Messages.getString("RXMLDataTypesDesign.ReadDataTypesSubViews"));
        if (dataTypesDesign.getAppView() != null) {
            StructuredTypeSet structuredTypeSet = dataTypesDesign.getStructuredTypeSet();
            Element element2 = RXMLDataTypesDesign.getFirstChildByTagName(element, "datatype_sub_views_collection");
            if (element2 != null) {
                NodeList nodeList = element2.getElementsByTagName("datatype_sub_view");
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    Element element3 = (Element)nodeList.item(i);
                    String string = element3.getAttribute("subview_name");
                    String string2 = element3.getAttribute("id");
                    String string3 = element3.getAttribute("generator");
                    DesignPartView designPartView = dataTypesDesign.createDesignPartSubView();
                    designPartView.setName(StringUtilities.decodeAttributeValue(string));
                    designPartView.setVisible(false);
                    if (string2 != null && !"".equalsIgnoreCase(string2) && !"null".equalsIgnoreCase(string2)) {
                        designPartView.setDPVId(string2);
                    }
                    if (string3 != null && !"".equalsIgnoreCase(string3) && !"null".equalsIgnoreCase(string3)) {
                        designPartView.setGeneratorId(string3);
                    }
                    String string4 = element3.getAttribute("visible");
                    NodeList nodeList2 = element3.getElementsByTagName("objectid");
                    int n2 = nodeList2.getLength();
                    for (int j = 0; j < n2; ++j) {
                        String string5;
                        String string6;
                        Element element4;
                        int n3;
                        TVDTRelation tVDTRelation;
                        int n4;
                        NodeList nodeList3;
                        Object object2;
                        String string7;
                        Object object3;
                        DesignObject designObject;
                        object = (Element)nodeList2.item(j);
                        if (object.getParentNode() != element3) continue;
                        String string8 = object.getAttribute("type");
                        String string9 = object.getAttribute("oid");
                        if (string8.equalsIgnoreCase("StructuredType")) {
                            designObject = (StructuredType)structuredTypeSet.getObjectByID(string9);
                            object3 = (TVStructuredType)((TVStructuredType)((AbstractDTObject)designObject).getTopView()).createViewSynonim(designPartView);
                            string7 = object.getAttribute("viewid");
                            object2 = object.getAttribute("tv_generator_id");
                            ((TopView)object3).setViewID(string7);
                            if (object2 != null && !"".equalsIgnoreCase((String)object2) && !"null".equalsIgnoreCase((String)object2)) {
                                ((TopView)object3).setGeneratorID((String)object2);
                            }
                            this.readGraphicalInfo((Element)object, (TopView)object3);
                        }
                        if (string8.equalsIgnoreCase("Note")) {
                            designObject = (Note)this.getPersistenceManager().read((Object)string9, dataTypesDesign.getDesign(), true);
                            object3 = (TVNote)((TVNote)((MultiShapedDesignObject)designObject).getTopView()).createViewSynonim(designPartView);
                            ((TVNote)((MultiShapedDesignObject)designObject).getTopView()).remove(false);
                            string7 = object.getAttribute("viewid");
                            ((TopView)object3).setViewID(string7);
                            this.readGraphicalInfo((Element)object, (TopView)object3);
                        }
                        if (string8.equalsIgnoreCase("DTReference") && (designObject = (DTReference)dataTypesDesign.getDTReferenceSet().getObjectByID(string9)) != null) {
                            object3 = StringUtilities.decodeAttributeValue(object.getAttribute("viewid_source"));
                            string7 = StringUtilities.decodeAttributeValue(object.getAttribute("viewid_target"));
                            if (!((String)object3).equals("null")) {
                                ((DTRelation)designObject).setSourceTV((TVStructuredType)((DTRelation)designObject).getSourceDTObject().getTopViewByID(designPartView, (String)object3));
                            }
                            if (!string7.equals("null")) {
                                ((DTRelation)designObject).setTargetTV((TVStructuredType)((DTRelation)designObject).getTargetDTObject().getTopViewByID(designPartView, string7));
                            }
                            if ((object2 = RXMLDataTypesDesign.getFirstChildByTagName((Element)object, "points")) != null) {
                                nodeList3 = object2.getElementsByTagName("point");
                                n4 = nodeList3.getLength();
                                tVDTRelation = (TVDTRelation)((DTRelation)designObject).getViewFor(designPartView);
                                if (tVDTRelation != null) {
                                    for (n3 = 0; n3 < n4; ++n3) {
                                        element4 = (Element)nodeList3.item(n3);
                                        string6 = element4.getAttribute("x_coordinate");
                                        string5 = element4.getAttribute("y_coordinate");
                                        tVDTRelation.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(string6), Double.parseDouble(string5)));
                                    }
                                }
                            }
                        }
                        if (!string8.equalsIgnoreCase("DTInheritance") || (designObject = (DTInheritance)dataTypesDesign.getDTInheritanceSet().getObjectByID(string9)) == null) continue;
                        object3 = StringUtilities.decodeAttributeValue(object.getAttribute("viewid_source"));
                        string7 = StringUtilities.decodeAttributeValue(object.getAttribute("viewid_target"));
                        if (!((String)object3).equals("null")) {
                            ((DTRelation)designObject).setSourceTV((TVStructuredType)((DTRelation)designObject).getSourceDTObject().getTopViewByID(designPartView, (String)object3));
                        }
                        if (!string7.equals("null")) {
                            ((DTRelation)designObject).setTargetTV((TVStructuredType)((DTRelation)designObject).getTargetDTObject().getTopViewByID(designPartView, string7));
                        }
                        if ((object2 = RXMLDataTypesDesign.getFirstChildByTagName((Element)object, "points")) == null) continue;
                        nodeList3 = object2.getElementsByTagName("point");
                        n4 = nodeList3.getLength();
                        tVDTRelation = (TVDTRelation)((DTRelation)designObject).getViewFor(designPartView);
                        if (tVDTRelation == null) continue;
                        for (n3 = 0; n3 < n4; ++n3) {
                            element4 = (Element)nodeList3.item(n3);
                            string6 = element4.getAttribute("x_coordinate");
                            string5 = element4.getAttribute("y_coordinate");
                            tVDTRelation.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(string6), Double.parseDouble(string5)));
                        }
                    }
                    designPartView.setMustBeVisible(string4.equalsIgnoreCase("true"));
                    String string10 = element3.getAttribute("comment");
                    ((DesignPartViewPlaceHolder)designPartView.getPlaceHolder()).setComment(StringUtilities.decodeAttributeValue(string10));
                    object = element3.getAttribute("notes");
                    ((DesignPartViewPlaceHolder)designPartView.getPlaceHolder()).setNotes(StringUtilities.decodeAttributeValue((String)object));
                    designPartView.getTabbedPane().setName(designPartView.getName());
                    this.readSubordinateDisplays(element3, designPartView);
                    designPartView.getTabbedPane().setSelectedComponent(designPartView);
                    designPartView.setDirty(false);
                }
            }
        }
    }

    public void readGraphicalInfo(Element element, TopView topView) {
        DesignObject designObject = topView.getModel();
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            NodeList nodeList = element.getElementsByTagName("graphical");
            HashMap<String, String> hashMap = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                hashMap = new HashMap<String, String>();
                NodeList nodeList2 = element2.getElementsByTagName("parameter");
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    hashMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
                }
                applicationView.setGraphicalPropsFor(topView, hashMap);
            }
        }
    }

    public void readGraphicalInfo(Element element, DesignObject designObject) {
        if (designObject == null || designObject.getDesign() == null) {
            LOGGER.error("readGraphicalInfo: DesignObject = null or design = null");
            return;
        }
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            NodeList nodeList = element.getElementsByTagName("graphical");
            HashMap<String, String> hashMap = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                hashMap = new HashMap<String, String>();
                NodeList nodeList2 = element2.getElementsByTagName("parameter");
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    hashMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
                }
                applicationView.setGraphicalPropsFor(designObject, hashMap);
            }
        }
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append('/').append("datatypes");
            return stringBuffer.toString();
        }
        return "datatypes";
    }

    static {
        NFS = 2.4f;
        LOGGER = new Logger(RXMLDataTypesDesign.class);
    }
}

