/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.datatypes;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.datatypes.DTConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLCollectionType
extends AbstractRXMLDesignObject
implements DTConstants {
    public RXMLCollectionType(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getDataTypesDesign().getCollectionTypeSet().createCollectionType(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        CollectionType collectionType = (CollectionType)super.recreateObject(element, design, bl);
        Map map = this.getProperties(element, "attributes");
        String string = (String)map.get("collection_type");
        if (!"null".equalsIgnoreCase(string)) {
            collectionType.setType(string);
        }
        collectionType.setMaxElement(Integer.parseInt((String)map.get("max_element")));
        String string2 = StringUtilities.decodeAttributeValue((String)map.get("datatype"));
        DesignObject designObject = collectionType.getDesign().getDesignObject(string2);
        if (designObject != null) {
            collectionType.addElementType(designObject);
            collectionType.getElementType().setReference(Boolean.valueOf((String)map.get("reference")));
        } else {
            collectionType.setDataTypeID(string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(collectionType.getObjectID())).append(".dmd");
        collectionType.setFilePath(stringBuffer.toString());
        return collectionType;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("datatypes").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("collectiontypePath"));
        return stringBuffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == CollectionType.class;
    }
}

