/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.TreeMap;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLUrl
extends AbstractWXMLDesignObject
implements BIConstants {
    private BIResourceLocator url = null;

    public WXMLUrl(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof BIResourceLocator;
        if (bl) {
            this.url = (BIResourceLocator)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.url != null) {
            String string = this.url.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("businessinfo").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("urlPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof BIResourceLocator) {
            BIResourceLocator bIResourceLocator = (BIResourceLocator)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("url", StringUtilities.encodeAttributeValue(String.valueOf(bIResourceLocator.getUrl())));
            this.appendProperties(element, "attributes", treeMap);
        }
    }
}

