/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.TreeMap;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLLocation
extends AbstractWXMLDesignObject
implements BIConstants {
    private BILocation location = null;

    public WXMLLocation(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof BILocation;
        if (bl) {
            this.location = (BILocation)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.location != null) {
            String string = this.location.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("businessinfo").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("locationPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof BILocation) {
            BILocation bILocation = (BILocation)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("type", StringUtilities.encodeAttributeValue(String.valueOf(bILocation.getLocationType())));
            treeMap.put("address", StringUtilities.encodeAttributeValue(String.valueOf(bILocation.getAddress())));
            treeMap.put("city", StringUtilities.encodeAttributeValue(String.valueOf(bILocation.getCity())));
            treeMap.put("postcode", StringUtilities.encodeAttributeValue(String.valueOf(bILocation.getPostCode())));
            treeMap.put("area", StringUtilities.encodeAttributeValue(String.valueOf(bILocation.getArea())));
            treeMap.put("country", StringUtilities.encodeAttributeValue(String.valueOf(bILocation.getCountry())));
            this.appendProperties(element, "attributes", treeMap);
        }
    }
}

