/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.TreeMap;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLEmail
extends AbstractWXMLDesignObject
implements BIConstants {
    private BIEmail email = null;

    public WXMLEmail(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof BIEmail;
        if (bl) {
            this.email = (BIEmail)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.email != null) {
            String string = this.email.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("businessinfo").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("emailPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof BIEmail) {
            BIEmail bIEmail = (BIEmail)designObject;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("address", String.valueOf(StringUtilities.encodeAttributeValue(bIEmail.getEmailAddress())));
            treeMap.put("type", String.valueOf(StringUtilities.encodeAttributeValue(bIEmail.getType())));
            this.appendProperties(element, "attributes", treeMap);
        }
    }
}

