/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLHandler;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.WXMLTypes;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLTypesFile
extends AbstractXMLWriter {
    public static final DocumentBuilder DOCUMENT_BUILDER;
    private static final Logger LOGGER;
    private WXMLTypes delegate;
    private boolean isSystem;

    public WXMLTypesFile(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
        this.delegate = new WXMLTypes(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            return list.size() > 0 && list.get(0) instanceof LogicalDatatype;
        }
        return false;
    }

    @Override
    public Document writeDocument(Object object) {
        Object object2;
        if (object instanceof List && (object2 = (List)object).size() > 0 && object2.get(0) instanceof LogicalDatatype) {
            return this.writeTypesToDocument((List)object2);
        }
        object2 = this.createDocument("logtypes");
        return object2;
    }

    public Document writeTypesToDocument(List list) {
        Document document = this.createDocument("logtypes");
        Element element = document.getDocumentElement();
        this.addTypesToElement(element, list);
        return document;
    }

    public Document writeTypesToDocument(LogicalDatatypeSet logicalDatatypeSet) {
        ArrayList arrayList = new ArrayList();
        logicalDatatypeSet.addAllElementsTo(arrayList);
        return this.writeTypesToDocument(arrayList);
    }

    public void addTypesToElement(Element element, List list) {
        for (LogicalDatatype logicalDatatype : list) {
            this.delegate.appendTypeInfo(element, logicalDatatype);
        }
        this.appendNativeToLogicalMappings(element);
        this.appendUD_NativeDBTypes(element);
    }

    private void appendNativeToLogicalMappings(Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("native_to_logical_mappings");
        RDBMSType[] rDBMSTypeArray = this.getPersistenceManager().getAppView().getCurrentDesign().getDefaultRDBMSTypeSet().toTypeArray();
        for (int i = 0; i < rDBMSTypeArray.length; ++i) {
            RDBMSType rDBMSType = rDBMSTypeArray[i];
            Map map = MappingDatatypeNameLogicalDataType.getMappingsForRDBMSType(rDBMSType);
            if (map == null) continue;
            Element element3 = document.createElement("mappings_for_RDBMS_type");
            element3.setAttribute("rdbms_type", WXMLTypesFile.encodeAttributeValue(rDBMSType.getLongName()));
            for (String string : map.keySet()) {
                LogicalDatatype logicalDatatype = (LogicalDatatype)map.get(string);
                if (logicalDatatype == null || "UNKNOWN".equalsIgnoreCase(logicalDatatype.getName())) continue;
                Element element4 = document.createElement("mapping");
                element4.setAttribute("native_type", WXMLTypesFile.encodeAttributeValue(string));
                element4.setAttribute("logicaltype", StringUtilities.encodeAttributeValue(WXMLTypesFile.encodeAttributeValue(logicalDatatype.getName())));
                element4.setAttribute("log_type_id", StringUtilities.encodeAttributeValue(WXMLTypesFile.encodeAttributeValue(logicalDatatype.getObjectID())));
                element3.appendChild(element4);
            }
            element2.appendChild(element3);
        }
        element.appendChild(element2);
    }

    private void appendUD_NativeDBTypes(Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("ud_native_db_types");
        Map map = StandardDatatypeNames.getUd_nativeMap();
        for (RDBMSType rDBMSType : map.keySet()) {
            Map map2 = (Map)map.get(rDBMSType);
            if (map2.size() <= 0) continue;
            Element element3 = document.createElement("ud_native_for_db_type");
            element3.setAttribute("rdbms_type", WXMLTypesFile.encodeAttributeValue(rDBMSType.getLongName()));
            for (NativeDBType nativeDBType : map2.values()) {
                Element element4 = document.createElement("ud_db_type");
                element4.setAttribute("native_type", WXMLTypesFile.encodeAttributeValue(nativeDBType.getName()));
                LogicalDatatype logicalDatatype = nativeDBType.getLogicalDatatype();
                if (logicalDatatype != null) {
                    element4.setAttribute("logicaltype", StringUtilities.encodeAttributeValue(WXMLTypesFile.encodeAttributeValue(logicalDatatype.getName())));
                    element4.setAttribute("log_type_id", StringUtilities.encodeAttributeValue(WXMLTypesFile.encodeAttributeValue(logicalDatatype.getObjectID())));
                }
                if (nativeDBType.isHasSize()) {
                    element4.setAttribute("has_size", String.valueOf(true));
                } else if (nativeDBType.isHasPrecision()) {
                    element4.setAttribute("has_precision", String.valueOf(true));
                    if (nativeDBType.isHasScale()) {
                        element4.setAttribute("has_scale", String.valueOf(true));
                    }
                }
                if (!"".equals(nativeDBType.getTypeKind())) {
                    element4.setAttribute("ud_native_kind", nativeDBType.getTypeKind());
                }
                element3.appendChild(element4);
            }
            element2.appendChild(element3);
        }
        element.appendChild(element2);
    }

    @Override
    protected Document createDocument(String string) {
        Document document = null;
        try {
            document = DOCUMENT_BUILDER.newDocument();
            Element element = document.getDocumentElement();
            element = document.createElement(string);
            document.appendChild(element);
        }
        catch (Exception exception) {
            LOGGER.error("problem creating document. WXMLTypesFile.createDocument(): ", exception);
        }
        return document;
    }

    @Override
    public String getFilenameFor(Object object) {
        String string = null;
        if (object instanceof List) {
            List list = (List)object;
            string = ((LogicalDatatype)list.get(0)).getFileName();
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public String getRelativePath(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            this.isSystem = "types".equalsIgnoreCase(((LogicalDatatype)list.get(0)).getFileName());
        } else if (object instanceof String) {
            this.isSystem = "types".equalsIgnoreCase(String.valueOf(object));
        }
        return this.getRelativePath();
    }

    @Override
    public String getRelativePath() {
        if (!this.isSystem) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append(this.getConfiguration().get("logtypePath"));
            return stringBuffer.toString();
        }
        return this.getConfiguration().get("typesPath");
    }

    static {
        LOGGER = new Logger(AbstractXMLHandler.class);
        DocumentBuilder documentBuilder = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error("Can not instantiate XML parser in WXMLTypesFile (DOCUMENT_BUILDER) " + parserConfigurationException);
        }
        DOCUMENT_BUILDER = documentBuilder;
    }
}

