/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.Collection;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLTable
extends AbstractWXMLDesignObject {
    Table table = null;

    public WXMLTable(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof Table;
        if (bl) {
            this.table = (Table)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.table != null) {
            String string = this.table.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("rel").append('/').append(this.table.getDesignPart().getPathIDString()).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("tablePath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendContainedObjectInfo(Element element, ContainedObject containedObject) {
        Column column = (Column)containedObject;
        this.appendDataTypeInfo(element, column);
        String string = column.getAbbreviation();
        if (string != null) {
            this.appendAbbreviation(element, string);
        }
        this.appendReferenceInfo(element, column.isReference());
        this.appendLogicalTypeInfo(element, column.getLogicalDatatype());
        this.appendUseDomainInfo(element, column.getUse());
        this.appendSourceTypeInfo(element, column.getSourceType());
        this.appendComputedInfo(element, column.isComputed());
        this.appendFormulaDescInfo(element, column.getFormulaDesc());
        this.appendSubtypeSubstitutionInfo(element, column.isAllowSubtypeSubstitution());
        this.appendRestrictedSubstitutionInfo(element, column);
        this.appendScopeInfo(element, column);
        this.appendSecurityInfo(element, column);
        this.appendUIDefaultsInfo(element, column);
        this.appendAutoIncrementInfo(element, column);
        if (column.isFKColumn()) {
            this.appendIsPreviousColumnInfo(element, column);
            Collection collection = column.getRefColAndAssocIDs();
            Iterator iterator = collection.iterator();
            Element element2 = element.getOwnerDocument().createElement("associations");
            while (iterator.hasNext()) {
                Element element3 = element.getOwnerDocument().createElement("associated");
                Column.FKColRefNode fKColRefNode = (Column.FKColRefNode)iterator.next();
                element3.setAttribute("tableid", fKColRefNode.remoteTableId);
                element3.setAttribute("indexid", fKColRefNode.remoteKeyId);
                element3.setAttribute("references", fKColRefNode.refColumnId);
                element3.setAttribute("fkassid", fKColRefNode.fkAssocId);
                element2.appendChild(element3);
            }
            element.appendChild(element2);
            element.setAttribute("beforeDrop", StringUtilities.encodeAttributeValue(this.table.getBeforeDrop()));
        }
    }

    @Override
    protected void appendReferenceInfo(Element element, boolean bl) {
        Element element2 = element.getOwnerDocument().createElement("reference");
        element2.setAttribute("value", String.valueOf(bl));
        element.appendChild(element2);
    }

    protected void appendLogicalTypeInfo(Element element, LogicalDatatype logicalDatatype) {
        if (logicalDatatype != null) {
            Element element2 = element.getOwnerDocument().createElement("logicaltype");
            element2.setAttribute("dttype", StringUtilities.encodeAttributeValue(logicalDatatype.getName()));
            element2.setAttribute("oid", StringUtilities.encodeAttributeValue(logicalDatatype.getObjectID()));
            element.appendChild(element2);
        }
    }

    protected void appendUseDomainInfo(Element element, short s) {
        Element element2 = element.getOwnerDocument().createElement("use");
        if (s == 0) {
            element2.setAttribute("value", "domain");
        } else if (s == 1) {
            element2.setAttribute("value", "logical type");
        } else if (s == 2) {
            element2.setAttribute("value", "distinct type");
        } else if (s == 3) {
            element2.setAttribute("value", "structured type");
        } else if (s == 4) {
            element2.setAttribute("value", "collection type");
        }
        element.appendChild(element2);
    }

    private void appendSourceTypeInfo(Element element, String string) {
        Element element2 = element.getOwnerDocument().createElement("sourcetype");
        element2.setAttribute("sort", string);
        element.appendChild(element2);
    }

    protected void appendComputedInfo(Element element, boolean bl) {
        Element element2 = element.getOwnerDocument().createElement("computed");
        element2.setAttribute("value", String.valueOf(bl));
        element.appendChild(element2);
    }

    private void appendFormulaDescInfo(Element element, String string) {
        Element element2 = element.getOwnerDocument().createElement("formula");
        element2.setAttribute("desc", StringUtilities.encodeAttributeValue(string));
        element.appendChild(element2);
    }

    private void appendAbbreviation(Element element, String string) {
        Element element2 = element.getOwnerDocument().createElement("abbreviation");
        element2.setTextContent(StringUtilities.encodeAttributeValue(string));
        element.appendChild(element2);
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof Table) {
            Table table = (Table)designObject;
            element.setAttribute("entitytype", table.getTypeID());
            String string = table.getScope();
            if (string != null && !"".equalsIgnoreCase(string)) {
                element.setAttribute("scope", StringUtilities.encodeAttributeValue(string));
            }
            element.setAttribute("splittedTableID", table.getSplittedTableID());
            if (table.getBasedOnStructuredType() != null) {
                element.setAttribute("structuredType", StringUtilities.encodeAttributeValue(table.getBasedOnStructuredType().getObjectID()));
            }
            element.setAttribute("allow_type_substitution", String.valueOf(table.isAllowTypeSubstitution()));
            this.appendTableLevelConstraints(element, table);
            element.setAttribute("minVolumes", new Integer(table.getMinVolumes()).toString());
            element.setAttribute("expectedVolumes", new Integer(table.getExpectedVolumes()).toString());
            element.setAttribute("maxVolumes", new Integer(table.getMaxVolumes()).toString());
            element.setAttribute("growthPercent", new Integer(table.getGrowthPercent()).toString());
            element.setAttribute("growthType", table.getGrowthType());
            element.setAttribute("normalForm", table.getNormalForm());
            element.setAttribute("adequatelyNormalized", table.getAdequatelyNormalized());
            String string2 = table.getAbbreviation();
            if (string2 != null) {
                element.setAttribute("abbreviation", StringUtilities.encodeAttributeValue(string2));
            }
            this.appendScriptInfo(element, "include_in_ddl", table.getShouldGenerateScript() ? VALUE_TRUE : VALUE_FALSE);
            this.appendScriptInfo(element, "beforeDrop", table.getBeforeDrop());
            this.appendScriptInfo(element, "beforeCreate", table.getBeforeCreate());
            this.appendScriptInfo(element, "beforeAlter", table.getBeforeAlter());
            this.appendScriptInfo(element, "afterCreate", table.getAfterCreate());
            this.appendScriptInfo(element, "afterAlter", table.getAfterAlter());
            this.appendScriptInfo(element, "endOfScript", table.getEndOfScript());
            this.appendSpatialTableInfo(element, table);
            element.setAttribute("oid_is_pk", String.valueOf(table.isOidIsPK()));
            this.appendObjects(element, table.getOidPKColumns().toArray(), "oid_pk_columns");
            this.appendColumnGroups(element, table);
        }
    }

    private void appendSpatialTableInfo(Element element, Table table) {
        Element element2 = element.getOwnerDocument().createElement("spatial_table");
        Element element3 = null;
        element2.setAttribute("value", String.valueOf(table.isSpatialTable()));
        Iterator iterator = table.getSpatialDefinitions().iterator();
        while (iterator.hasNext()) {
            Element element4 = element2.getOwnerDocument().createElement("spatial_definition");
            SpatialColumnDefObject spatialColumnDefObject = (SpatialColumnDefObject)iterator.next();
            String string = spatialColumnDefObject.getName();
            if (string != null && !"".equalsIgnoreCase(string)) {
                element4.setAttribute("name", StringUtilities.encodeAttributeValue(string));
            }
            if (spatialColumnDefObject.getSpatialColumn() != null) {
                element3 = element4.getOwnerDocument().createElement("spatial_column");
                element3.setAttribute("id", StringUtilities.encodeAttributeValue(spatialColumnDefObject.getSpatialColumn().getObjectID()));
                element4.appendChild(element3);
            }
            if (spatialColumnDefObject.isFunction()) {
                element3 = element4.getOwnerDocument().createElement("spatial_function");
                element3.setAttribute("value", String.valueOf(spatialColumnDefObject.isFunction()));
                element4.appendChild(element3);
                element3 = element4.getOwnerDocument().createElement("spatial_func_expression");
                element3.setAttribute("value", spatialColumnDefObject.getFuncExpression());
                element4.appendChild(element3);
            }
            element3 = element4.getOwnerDocument().createElement("spatial_srid");
            String string2 = spatialColumnDefObject.getSystemID();
            if (string2 != null && !"".equalsIgnoreCase(string2)) {
                element3.setAttribute("value", StringUtilities.encodeAttributeValue(string2));
            }
            element4.appendChild(element3);
            if (spatialColumnDefObject.getSpatialIndex() != null) {
                Index index = spatialColumnDefObject.getSpatialIndex();
                element3 = element4.getOwnerDocument().createElement("spatial_index");
                element3.setAttribute("id", StringUtilities.encodeAttributeValue(index.getObjectID()));
                element3.setAttribute("layer_gtype", index.getLayerType());
                element3.setAttribute("geodetic", index.getGeodetic());
                element3.setAttribute("sdo_indx_dims", String.valueOf(index.getDimensionsNumber()));
                element4.appendChild(element3);
            }
            element3 = element4.getOwnerDocument().createElement("spatial_table_dimensions");
            for (SpatialColumnDefObject.TableDimension tableDimension : spatialColumnDefObject.getTableDimensions()) {
                String string3;
                String string4;
                String string5;
                Element element5 = element3.getOwnerDocument().createElement("spatial_table_dimension");
                String string6 = tableDimension.getName();
                if (string != null && !"".equalsIgnoreCase(string6)) {
                    element5.setAttribute("name", StringUtilities.encodeAttributeValue(string6));
                }
                if ((string5 = tableDimension.getLowBoundary()) != null && !"".equalsIgnoreCase(string5)) {
                    element5.setAttribute("low_boundary", StringUtilities.encodeAttributeValue(string5));
                }
                if ((string4 = tableDimension.getUpperBoundary()) != null && !"".equalsIgnoreCase(string4)) {
                    element5.setAttribute("upper_boundary", StringUtilities.encodeAttributeValue(string4));
                }
                if ((string3 = tableDimension.getTolerance()) != null && !"".equalsIgnoreCase(string3)) {
                    element5.setAttribute("tolerance", StringUtilities.encodeAttributeValue(string3));
                }
                element3.appendChild(element5);
            }
            element4.appendChild(element3);
            element2.appendChild(element4);
        }
        element.appendChild(element2);
    }

    public void appendIsPreviousColumnInfo(Element element, Column column) {
        Element element2 = element.getOwnerDocument().createElement("is_previous_column");
        element2.setAttribute("value", column.isPreviousColumn() ? VALUE_TRUE : VALUE_FALSE);
        element.appendChild(element2);
    }

    private void appendTableLevelConstraints(Element element, Table table) {
        for (TableLevelConstraint tableLevelConstraint : table.getCheckConstraints()) {
            String string;
            Element element2 = element.getOwnerDocument().createElement("tableconstraint");
            element2.setAttribute("oid", String.valueOf(tableLevelConstraint.getID()));
            String string2 = tableLevelConstraint.getName();
            if (string2 != null && !"".equalsIgnoreCase(string2)) {
                element2.setAttribute("name", StringUtilities.encodeAttributeValue(tableLevelConstraint.getName()));
            }
            if ((string = tableLevelConstraint.getRule()) != null && !"".equalsIgnoreCase(string)) {
                element2.setAttribute("rule", StringUtilities.encodeAttributeValue(string));
            }
            element.appendChild(element2);
        }
    }

    @Override
    protected void appendKeyObjectInfo(Element element, KeyObject keyObject) {
        Index index;
        String string;
        if (keyObject instanceof Index && !keyObject.isFK() && (string = (index = (Index)keyObject).getIdOfRecoveredIntegrityIndex()) != null) {
            element.setAttribute("id_of_recovered_integrity_index", string);
        }
    }

    protected void appendSecurityInfo(Element element, Column column) {
        Element element2 = element.getOwnerDocument().createElement("security");
        this.setAttributeIfNotEmpty(element2, "containsPII", column.isContainsPII());
        this.setAttributeIfNotEmpty(element2, "containsSensitiveInformation", column.isContainsSensitiveInformation());
        this.setAttributeIfNotEmpty(element2, "maskData", column.isMaskData());
        element.appendChild(element2);
    }

    protected void appendAutoIncrementInfo(Element element, Column column) {
        Element element2 = element.getOwnerDocument().createElement("auto_increment");
        this.setAttributeIfNotEmpty(element2, "auto_increment_column", column.isAutoIncrementColumn());
        this.setAttributeIfNotEmpty(element2, "identity_column", column.isIdentityColumn());
        this.setAttributeIfNotEmpty(element2, "generate_always", column.isAutoIncrementGenerateAlways());
        this.setAttributeIfNotEmpty(element2, "start_with", column.getAutoIncrementStartWith());
        this.setAttributeIfNotEmpty(element2, "increment_by", column.getAutoIncrementIncrementBy());
        this.setAttributeIfNotEmpty(element2, "min_value", column.getAutoIncrementMinValue());
        this.setAttributeIfNotEmpty(element2, "max_value", column.getAutoIncrementMaxValue());
        this.setAttributeIfNotEmpty(element2, "cycle", column.isAutoIncrementCycle());
        this.setAttributeIfNotEmpty(element2, "disable_cache", column.isAutoIncrementDisableCache());
        this.setAttributeIfNotEmpty(element2, "cache", column.getAutoIncrementCache());
        this.setAttributeIfNotEmpty(element2, "order", column.isAutoIncrementOrder());
        this.setAttributeIfNotEmpty(element2, "sequence_name", column.getAutoIncrementSequenceName());
        this.setAttributeIfNotEmpty(element2, "trigger_name", column.getAutoIncrementTriggerName());
        this.setAttributeIfNotEmpty(element2, "generate_trigger", column.isAutoIncrementGenerateTrigger());
        element.appendChild(element2);
    }

    protected void setAttributeIfNotEmpty(Element element, String string, Object object) {
        if (object != null) {
            element.setAttribute(string, String.valueOf(object));
        }
    }

    protected void setAttributeIfNotEmpty(Element element, String string, String string2) {
        if (StringUtilities.isNotEmpty(string2)) {
            element.setAttribute(string, string2);
        }
    }

    private void appendColumnGroups(Element element, Table table) {
        Element element2 = null;
        Iterator iterator = table.getColumnGroupsSet().iterator();
        while (iterator.hasNext()) {
            element2 = element.getOwnerDocument().createElement("column_group");
            Table.ColumnGroup columnGroup = (Table.ColumnGroup)iterator.next();
            element2.setAttribute("name", StringUtilities.encodeAttributeValue(columnGroup.getName()));
            element2.setAttribute("objectid", columnGroup.getObjectID());
            element2.setAttribute("note", columnGroup.getNote());
            for (String string : columnGroup.getColumns()) {
                Element element3 = element.getOwnerDocument().createElement("cg_column");
                element3.setAttribute("objectid", string);
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
    }

    protected void appendUIDefaultsInfo(Element element, Column column) {
        Element element2 = element.getOwnerDocument().createElement("ui_defaults");
        this.setAttributeIfNotEmpty(element2, "label", StringUtilities.encodeAttributeValue(column.getDefaultLabel()));
        this.setAttributeIfNotEmpty(element2, "formatMask", StringUtilities.encodeAttributeValue(column.getDefaultFormatMask()));
        this.setAttributeIfNotEmpty(element2, "formDisplayWidth", column.getDefaultFormDisplayWidth());
        this.setAttributeIfNotEmpty(element2, "formMaximumWidth", column.getDefaultFormMaximumWidth());
        this.setAttributeIfNotEmpty(element2, "formHeight", column.getDefaultFormHeight());
        this.setAttributeIfNotEmpty(element2, "helpText", StringUtilities.encodeAttributeValue(column.getDefaultHelpText()));
        this.setAttributeIfNotEmpty(element2, "readOnly", String.valueOf(column.isDefaultReadOnly()));
        this.setAttributeIfNotEmpty(element2, "displayedOnReports", String.valueOf(column.isDefaultDisplayedOnReports()));
        this.setAttributeIfNotEmpty(element2, "displayedOnForms", String.valueOf(column.isDefaultDisplayedOnForms()));
        this.setAttributeIfNotEmpty(element2, "displayAs", column.getDefaultDisplayAs());
        element.appendChild(element2);
    }
}

