/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.WXMLSubview;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.swingui.relational.TVFKArc;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WXMLRelationalDesign
extends AbstractXMLWriter {
    private RelationalDesign design = null;
    private static float NFS = 2.4f;
    private float version = NFS;

    public WXMLRelationalDesign(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof RelationalDesign;
    }

    @Override
    public Document writeDocument(Object object) {
        this.design = (RelationalDesign)object;
        if (this.design.getAppView().isSelectedForSave(object)) {
            this.version = this.design.getDesign().getVersion();
            Design design = this.design.getDesign();
            Document document = this.createDocument("design");
            Element element = document.getDocumentElement();
            element.setAttribute("id", StringUtilities.encodeAttributeValue(this.design.getObjectID()));
            Attr attr = document.createAttribute("defaultRDBMSSite");
            attr.setValue(StringUtilities.encodeAttributeValue(this.design.getSelectedRDBMSSite().getObjectID()));
            element.setAttributeNode(attr);
            Element element2 = document.createElement("ref");
            element.appendChild(element2);
            Element element3 = null;
            Element element4 = null;
            Element element5 = null;
            if (this.version < NFS) {
                element3 = document.createElement("view_synonyms");
                element.appendChild(element3);
                element4 = document.createElement("view_fkeys");
                element.appendChild(element4);
                element5 = document.createElement("physical_sub_views_collection");
                element.appendChild(element5);
            }
            Element element6 = document.createElement("type_substitutions");
            element.appendChild(element6);
            Element element7 = document.createElement("marked_generate_for_indexes");
            element.appendChild(element7);
            Collection collection = this.design.getStorableDesignObjects();
            Iterator iterator = collection.iterator();
            DesignObject designObject = null;
            while (iterator.hasNext()) {
                designObject = (DesignObject)iterator.next();
                if (!design.shouldExport(designObject)) continue;
                this.handleDesignObject(element2, designObject);
            }
            if (this.version < NFS) {
                this.handleTVSynonyms(this.design, element3);
                this.handleFKeys(this.design, element4);
            }
            this.handleTypeSubstitutions(this.design, element6);
            if (this.version < NFS) {
                this.appendSubordinateDisplays(element, this.design.getMainView());
                this.handlePhysSubViews(this.design, element5);
                this.appendDiagramViews(document, element, this.design);
            } else {
                WXMLSubview wXMLSubview = this.getPersistenceManager().getDesignPartViewWriter();
                wXMLSubview.appendExtSubViews(element, this.design);
            }
            this.handleMarkGenerateForIndexesAndFKeys(this.design, element7);
            this.appendDocumentsInfo(document, element, this.design);
            this.appendPartiesInfo(document, element, this.design);
            this.appendNamingOptions(document, element, this.design);
            this.design.setDirty(false);
            return document;
        }
        return null;
    }

    private void appendDocumentsInfo(Document document, Element element, RelationalDesign relationalDesign) {
        this.appendObjects(element, relationalDesign.getDocuments().toArray(), "documents");
    }

    private void appendPartiesInfo(Document document, Element element, RelationalDesign relationalDesign) {
        this.appendObjects(element, relationalDesign.getResponsibleParties().toArray(), "parties");
    }

    protected void appendObjects(Element element, Object[] objectArray, String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObject designObject = (DesignObject)objectArray[i];
            treeMap.put(String.valueOf(i + 1), StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        }
        this.appendProperties(element, string, treeMap);
    }

    @Override
    protected void appendProperties(Element element, String string, Map map) {
        Element element2 = element.getOwnerDocument().createElement(string);
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            String string3 = (String)map.get(string2);
            if (string2.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element element3 = element.getOwnerDocument().createElement("parameter");
            element2.appendChild(element3);
            this.appendProperty(element3, string2, string3);
        }
        element.appendChild(element2);
    }

    public void handleTVSynonyms(RelationalDesign relationalDesign, Element element) {
        if (relationalDesign.getAppView() != null) {
            ContainerObject containerObject;
            DesignPartView designPartView = relationalDesign.getMainView();
            Iterator iterator = relationalDesign.getTableSet().iterator();
            while (iterator.hasNext()) {
                containerObject = (Table)iterator.next();
                if (!relationalDesign.getDesign().shouldExport(containerObject)) continue;
                for (TopView topView : containerObject.getViewSynonims(designPartView)) {
                    this.appendReferencedObjectReprElement(element, topView);
                }
            }
            iterator = relationalDesign.getTableViewSet().iterator();
            while (iterator.hasNext()) {
                containerObject = (TableView)iterator.next();
                if (!relationalDesign.getDesign().shouldExport(containerObject)) continue;
                for (TopView topView : containerObject.getViewSynonims(designPartView)) {
                    this.appendReferencedObjectReprElement(element, topView);
                }
            }
        }
    }

    private void appendReferencedObjectReprElement(Element element, TopView topView) {
        Document document = element.getOwnerDocument();
        DesignObject designObject = topView.getModel();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", "represents");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        element2.setAttribute("viewid", topView.getViewID());
        element2.setAttribute("tv_generator_id", topView.getGeneratorID());
        this.appendGraphicalInfo(element2, topView);
        element.appendChild(element2);
    }

    public void appendGraphicalInfo(Element element, TopView topView) {
        DesignObject designObject = topView.getModel();
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            Element element2 = element.getOwnerDocument().createElement("graphical");
            Map map = applicationView.getGraphicalPropsFor(topView);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Element element3 = element.getOwnerDocument().createElement("parameter");
                element2.appendChild(element3);
                String string = (String)iterator.next();
                element3.setAttribute("name", string);
                element3.setAttribute("value", (String)map.get(string));
            }
            element.appendChild(element2);
        }
    }

    private void handleDesignObject(Element element, DesignObject designObject) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            boolean bl = this.getPersistenceManager().isCheckDirty() ? designObject.isDirty() : true;
            if (bl) {
                this.getPersistenceManager().write(designObject);
            }
        }
        this.appendReferencedObjectElement(element, designObject);
    }

    private void appendReferencedObjectElement(Element element, DesignObject designObject) {
        if (designObject instanceof Note && designObject.getFirstViewForDPV(this.design.getMainView()) == null) {
            return;
        }
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", designObject.belongsToDesign() ? "contains" : "uses");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        element2.setAttribute("marked_generate", String.valueOf(designObject.isMarkedGenerate()));
        if (this.version < NFS) {
            this.appendGraphicalInfo(element2, designObject);
        }
        element.appendChild(element2);
    }

    public void appendGraphicalInfo(Element element, DesignObject designObject) {
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            Element element2 = element.getOwnerDocument().createElement("graphical");
            Map map = applicationView.getGraphicalPropsFor(designObject);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Element element3 = element.getOwnerDocument().createElement("parameter");
                element2.appendChild(element3);
                String string = (String)iterator.next();
                element3.setAttribute("name", string);
                element3.setAttribute("value", (String)map.get(string));
            }
            element.appendChild(element2);
        }
    }

    @Override
    public String getFilenameFor(Object object) {
        RelationalDesign relationalDesign = (RelationalDesign)object;
        return relationalDesign.getPathIDString();
    }

    @Override
    public String getRelativePath() {
        if (this.design != null && this.design.getAppView() != null) {
            String string = this.design.getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('/').append(string).append('/').append("rel");
            return stringBuffer.toString();
        }
        return "rel";
    }

    public static String getRelativePath(RelationalDesign relationalDesign) {
        if (relationalDesign != null && relationalDesign.getAppView() != null) {
            String string = relationalDesign.getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('/').append(string).append('/');
            if (relationalDesign.getDesign().getLoadedVersion() < 3.2f) {
                stringBuffer.append("relational");
            } else {
                stringBuffer.append("rel");
            }
            return stringBuffer.toString();
        }
        return "rel";
    }

    public void handleFKeys(RelationalDesign relationalDesign, Element element) {
        if (relationalDesign.getAppView() != null) {
            DesignPartView designPartView = relationalDesign.getMainView();
            Iterator iterator = relationalDesign.getFKIndexAssociationSet().iterator();
            while (iterator.hasNext()) {
                FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
                if (fKIndexAssociation.isBackupFK()) continue;
                TVTable tVTable = fKIndexAssociation.getSourceTV(designPartView);
                TVTable tVTable2 = fKIndexAssociation.getTargetTV(designPartView);
                if (tVTable == null || tVTable2 == null || !relationalDesign.getDesign().shouldExport(tVTable.getModel()) || !relationalDesign.getDesign().shouldExport(tVTable2.getModel())) continue;
                this.appendFKObjectElement(relationalDesign, element, fKIndexAssociation);
            }
        }
    }

    public void handleTypeSubstitutions(RelationalDesign relationalDesign, Element element) {
        if (relationalDesign.getAppView() != null) {
            DesignPartView designPartView = relationalDesign.getMainView();
            Iterator iterator = relationalDesign.getTypeSubstitutionSet().iterator();
            while (iterator.hasNext()) {
                TypeSubstitution typeSubstitution = (TypeSubstitution)iterator.next();
                ContainerView containerView = typeSubstitution.getChildCV(designPartView);
                ContainerView containerView2 = typeSubstitution.getParentCV(designPartView);
                if (containerView == null || containerView2 == null || !relationalDesign.getDesign().shouldExport(containerView.getModel()) || !relationalDesign.getDesign().shouldExport(containerView2.getModel())) continue;
                this.appendTypeSbstElement(relationalDesign, element, typeSubstitution);
            }
        }
    }

    private void appendFKObjectElement(RelationalDesign relationalDesign, Element element, FKIndexAssociation fKIndexAssociation) {
        Object object;
        Object object2;
        int n;
        Object object3;
        Document document = element.getOwnerDocument();
        DesignPartView designPartView = relationalDesign.getMainView();
        TVFKRelation tVFKRelation = (TVFKRelation)fKIndexAssociation.getViewFor(designPartView);
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", "represents");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(fKIndexAssociation.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(fKIndexAssociation.getObjectID()));
        element2.setAttribute("viewid_source", fKIndexAssociation.getSourceTV(designPartView) != null ? fKIndexAssociation.getSourceTV(designPartView).getViewID() : "null");
        element2.setAttribute("viewid_target", fKIndexAssociation.getTargetTV(designPartView) != null ? fKIndexAssociation.getTargetTV(designPartView).getViewID() : "null");
        Element element3 = document.createElement("points");
        if (tVFKRelation != null && tVFKRelation.getEdge() != null && tVFKRelation.getEdge().getCellView() != null) {
            object3 = ((EdgeView)tVFKRelation.getEdge().getCellView()).getPoints();
            for (n = 0; n < object3.size(); ++n) {
                object2 = object3.get(n);
                object = object2 instanceof PortView ? ((PortView)object2).getPoint() : (Point2D)object2;
                if (object == null) continue;
                Element element4 = document.createElement("point");
                element4.setAttribute("x_coordinate", Double.toString(((Point2D)object).getX()));
                element4.setAttribute("y_coordinate", Double.toString(((Point2D)object).getY()));
                element3.appendChild(element4);
            }
        } else if (tVFKRelation != null) {
            object3 = tVFKRelation.getEdgePoints();
            for (n = 0; n < object3.size(); ++n) {
                object2 = object3.get(n);
                object = object2 instanceof PortView ? ((PortView)object2).getPoint() : (Point2D)object2;
                if (object == null) continue;
                Element element5 = document.createElement("point");
                element5.setAttribute("x_coordinate", Double.toString(((Point2D)object).getX()));
                element5.setAttribute("y_coordinate", Double.toString(((Point2D)object).getY()));
                element3.appendChild(element5);
            }
        }
        element2.appendChild(element3);
        if (tVFKRelation != null) {
            object3 = (EdgeView)tVFKRelation.getCellView();
            if (object3 != null) {
                Element element6 = document.createElement("labels");
                object2 = document.createElement("main_label");
                object2.setAttribute("x_coordinate", Double.toString(tVFKRelation.getLabelBounds().getX()));
                object2.setAttribute("y_coordinate", Double.toString(tVFKRelation.getLabelBounds().getY()));
                object2.setAttribute("width", Double.toString(tVFKRelation.getLabelBounds().getWidth()));
                object2.setAttribute("height", Double.toString(tVFKRelation.getLabelBounds().getHeight()));
                element6.appendChild((Node)object2);
                object = tVFKRelation.getLabel(1);
                if (object != null) {
                    this.appendDesignObjectColor((Element)object2, (DesignObject)object);
                    this.appendDesignObjectFonts((Element)object2, (DesignObject)object);
                }
                element2.appendChild(element6);
            }
            Element element7 = document.createElement("graphical");
            object2 = element2.getOwnerDocument().createElement("parameter");
            element7.appendChild((Node)object2);
            object2.setAttribute("name", "use_default_color");
            object2.setAttribute("value", Boolean.toString(tVFKRelation.useDefaultColor()));
            if (!tVFKRelation.useDefaultColor()) {
                object2 = element2.getOwnerDocument().createElement("parameter");
                element7.appendChild((Node)object2);
                object2.setAttribute("name", "color");
                object2.setAttribute("value", tVFKRelation.getBackgroundColor() != null ? Integer.toString(tVFKRelation.getBackgroundColor().getRGB()) : "null");
                object2 = element2.getOwnerDocument().createElement("parameter");
                element7.appendChild((Node)object2);
                object2.setAttribute("name", "width");
                object2.setAttribute("value", Integer.toString(tVFKRelation.getLineWidth()));
            }
            element2.appendChild(element7);
        }
        element.appendChild(element2);
    }

    private void handleMarkGenerateForIndexesAndFKeys(RelationalDesign relationalDesign, Element element) {
        Iterator iterator = relationalDesign.getGlobalIndexSet().iterator();
        while (iterator.hasNext()) {
            Index index = (Index)iterator.next();
            this.appendIndexMarkGenerate(element, index);
        }
    }

    private void appendIndexMarkGenerate(Element element, Index index) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(index.getObjectID()));
        if (index.isFK()) {
            FKIndexAssociation fKIndexAssociation = index.getFKAssociation();
            if (fKIndexAssociation != null) {
                element2.setAttribute("marked_generate", String.valueOf(fKIndexAssociation.isMarkedGenerate()));
            }
        } else {
            element2.setAttribute("marked_generate", String.valueOf(index.isMarkedGenerate()));
        }
        element.appendChild(element2);
    }

    private void appendTypeSbstElement(RelationalDesign relationalDesign, Element element, TypeSubstitution typeSubstitution) {
        Object object;
        Object object2;
        Document document = element.getOwnerDocument();
        DesignPartView designPartView = relationalDesign.getMainView();
        TVTypeSubstitution tVTypeSubstitution = (TVTypeSubstitution)typeSubstitution.getViewFor(designPartView);
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", "represents");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(typeSubstitution.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(typeSubstitution.getObjectID()));
        if (typeSubstitution.getChildContainerObject() != null) {
            element2.setAttribute("child_id", StringUtilities.encodeAttributeValue(typeSubstitution.getChildContainerObject().getObjectID()));
        } else {
            element2.setAttribute("child_id", "null");
        }
        if (typeSubstitution.getParentContainerObject() != null) {
            element2.setAttribute("parent_id", StringUtilities.encodeAttributeValue(typeSubstitution.getParentContainerObject().getObjectID()));
        } else {
            element2.setAttribute("parent_id", "null");
        }
        element2.setAttribute("view_id_child", typeSubstitution.getChildCV(designPartView) != null ? typeSubstitution.getChildCV(designPartView).getViewID() : "null");
        element2.setAttribute("view_id_parent", typeSubstitution.getParentCV(designPartView) != null ? typeSubstitution.getParentCV(designPartView).getViewID() : "null");
        Element element3 = document.createElement("points");
        if (tVTypeSubstitution != null) {
            object2 = (EdgeView)((DefaultEdge)tVTypeSubstitution.getCellView().getCell()).getCellView();
            object = ((EdgeView)object2).getPoints();
            for (int i = 0; i < object.size(); ++i) {
                Object e = object.get(i);
                Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                if (point2D == null) continue;
                Element element4 = document.createElement("point");
                element4.setAttribute("x_coordinate", Double.toString(point2D.getX()));
                element4.setAttribute("y_coordinate", Double.toString(point2D.getY()));
                element3.appendChild(element4);
            }
        }
        element2.appendChild(element3);
        if (tVTypeSubstitution != null) {
            object2 = document.createElement("graphical");
            object = element2.getOwnerDocument().createElement("parameter");
            object2.appendChild((Node)object);
            object.setAttribute("name", "use_default_color");
            object.setAttribute("value", Boolean.toString(tVTypeSubstitution.useDefaultColor()));
            if (!tVTypeSubstitution.useDefaultColor()) {
                object = element2.getOwnerDocument().createElement("parameter");
                object2.appendChild((Node)object);
                object.setAttribute("name", "color");
                object.setAttribute("value", tVTypeSubstitution.getBackgroundColor() != null ? Integer.toString(tVTypeSubstitution.getBackgroundColor().getRGB()) : "null");
                object = element2.getOwnerDocument().createElement("parameter");
                object2.appendChild((Node)object);
                object.setAttribute("name", "width");
                object.setAttribute("value", Integer.toString(tVTypeSubstitution.getLineWidth()));
            }
            element2.appendChild((Node)object2);
        }
        element.appendChild(element2);
    }

    public void handlePhysSubViews(RelationalDesign relationalDesign, Element element) {
        if (relationalDesign.getAppView() != null) {
            Document document = element.getOwnerDocument();
            SubViewObjectSet subViewObjectSet = relationalDesign.getPhysicalDesignSubviews();
            Iterator iterator = subViewObjectSet.iterator();
            while (iterator.hasNext()) {
                DesignObject designObject;
                DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
                DPVRelationalSubView dPVRelationalSubView = (DPVRelationalSubView)designPartViewPlaceHolder.getDesignPartView();
                if (!relationalDesign.getDesign().shouldExportDPV(dPVRelationalSubView)) continue;
                Element element2 = document.createElement("physical_sub_view");
                element2.setAttribute("subview_name", StringUtilities.encodeAttributeValue(dPVRelationalSubView.getName()));
                element2.setAttribute("id", dPVRelationalSubView.getDPVId());
                element2.setAttribute("generator", dPVRelationalSubView.getGeneratorId());
                element2.setAttribute("visible", designPartViewPlaceHolder.getVisible() ? "true" : "false");
                element2.setAttribute("comment", StringUtilities.encodeAttributeValue(designPartViewPlaceHolder.getComment()));
                element2.setAttribute("notes", StringUtilities.encodeAttributeValue(designPartViewPlaceHolder.getNotes()));
                element.appendChild(element2);
                this.addTablesInDPV(relationalDesign, element2, dPVRelationalSubView);
                this.addTableViewsInDPV(relationalDesign, element2, dPVRelationalSubView);
                this.addNotesInDPV(relationalDesign, element2, dPVRelationalSubView);
                this.addDiagramViewsInDPV(relationalDesign, element2, dPVRelationalSubView);
                Iterator iterator2 = relationalDesign.getFKIndexAssociationSet().iterator();
                while (iterator2.hasNext()) {
                    designObject = (FKIndexAssociation)iterator2.next();
                    this.appendSubViewInfoFK(element2, dPVRelationalSubView, (FKIndexAssociation)designObject);
                }
                iterator2 = relationalDesign.getTypeSubstitutionSet().iterator();
                while (iterator2.hasNext()) {
                    designObject = (TypeSubstitution)iterator2.next();
                    this.appendSubViewInfoTypeSubst(element2, dPVRelationalSubView, (TypeSubstitution)designObject);
                }
                this.addArcViewsInDPV(relationalDesign, element2, dPVRelationalSubView);
                this.appendSubordinateDisplays(element2, dPVRelationalSubView);
            }
        }
    }

    private void addArcViewsInDPV(RelationalDesign relationalDesign, Element element, DPVRelationalSubView dPVRelationalSubView) {
        CellView[] cellViewArray = dPVRelationalSubView.getWorkSpace().getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            TopView topView = ((DefaultDiagramCell)cellViewArray[i].getCell()).getTopView();
            if (topView.isConnection() || !(cellViewArray[i].getCell() instanceof DefaultDiagramCell) || !(topView instanceof TVFKArc)) continue;
            this.appendReferencedObjectReprElement(element, topView);
        }
    }

    private void addTablesInDPV(RelationalDesign relationalDesign, Element element, DPVRelationalSubView dPVRelationalSubView) {
        Iterator iterator = relationalDesign.getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            for (TopView topView : table.getViewsForDPV(dPVRelationalSubView)) {
                this.appendReferencedObjectReprElement(element, topView);
            }
        }
    }

    private void addNotesInDPV(RelationalDesign relationalDesign, Element element, DPVRelationalSubView dPVRelationalSubView) {
        Iterator iterator = relationalDesign.getNoteSet().iterator();
        while (iterator.hasNext()) {
            Note note = (Note)iterator.next();
            TopView topView = note.getFirstViewForDPV(dPVRelationalSubView);
            if (topView == null) continue;
            this.appendReferencedObjectReprElement(element, topView);
        }
    }

    private void addDiagramViewsInDPV(RelationalDesign relationalDesign, Element element, DPVRelationalSubView dPVRelationalSubView) {
        Iterator iterator = relationalDesign.getDiagramViewSet().iterator();
        while (iterator.hasNext()) {
            DiagramView diagramView = (DiagramView)iterator.next();
            TopView topView = diagramView.getFirstViewForDPV(dPVRelationalSubView);
            if (topView == null) continue;
            this.appendDiagramViewInfo(element.getOwnerDocument(), element, diagramView, topView);
        }
    }

    private void addTableViewsInDPV(RelationalDesign relationalDesign, Element element, DPVRelationalSubView dPVRelationalSubView) {
        Iterator iterator = relationalDesign.getTableViewSet().iterator();
        while (iterator.hasNext()) {
            TableView tableView = (TableView)iterator.next();
            for (TopView topView : tableView.getViewsForDPV(dPVRelationalSubView)) {
                this.appendReferencedObjectReprElement(element, topView);
            }
        }
    }

    private void appendSubViewInfoFK(Element element, DesignPartView designPartView, FKIndexAssociation fKIndexAssociation) {
        Document document = element.getOwnerDocument();
        TVFKRelation tVFKRelation = (TVFKRelation)fKIndexAssociation.getViewFor(designPartView);
        if (tVFKRelation != null) {
            Object object;
            Object object2;
            Object object3;
            Element element2 = document.createElement("objectid");
            element2.setAttribute("role", "represents");
            element2.setAttribute("type", StringUtilities.encodeAttributeValue(fKIndexAssociation.getObjectTypeName()));
            element2.setAttribute("oid", StringUtilities.encodeAttributeValue(fKIndexAssociation.getObjectID()));
            element2.setAttribute("viewid_source", fKIndexAssociation.getSourceTV(designPartView) != null ? fKIndexAssociation.getSourceTV(designPartView).getViewID() : "null");
            element2.setAttribute("viewid_target", fKIndexAssociation.getTargetTV(designPartView) != null ? fKIndexAssociation.getTargetTV(designPartView).getViewID() : "null");
            Element element3 = document.createElement("points");
            if (tVFKRelation != null) {
                if (tVFKRelation.getCellView() != null) {
                    object3 = (EdgeView)((DefaultEdge)tVFKRelation.getCellView().getCell()).getCellView();
                    object2 = ((EdgeView)object3).getPoints();
                    for (int i = 0; i < object2.size(); ++i) {
                        object = object2.get(i);
                        Object object4 = object instanceof PortView ? ((PortView)object).getPoint() : object;
                        if (object4 == null) continue;
                        Element element4 = document.createElement("point");
                        element4.setAttribute("x_coordinate", Double.toString(((Point2D)object4).getX()));
                        element4.setAttribute("y_coordinate", Double.toString(((Point2D)object4).getY()));
                        element3.appendChild(element4);
                    }
                } else {
                    object3 = tVFKRelation.getEdgePoints();
                    for (int i = 0; i < object3.size(); ++i) {
                        Object e = object3.get(i);
                        object = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                        if (object == null) continue;
                        Element element5 = document.createElement("point");
                        element5.setAttribute("x_coordinate", Double.toString(((Point2D)object).getX()));
                        element5.setAttribute("y_coordinate", Double.toString(((Point2D)object).getY()));
                        element3.appendChild(element5);
                    }
                }
            }
            element2.appendChild(element3);
            object3 = (EdgeView)tVFKRelation.getCellView();
            if (object3 != null) {
                object2 = document.createElement("labels");
                Element element6 = document.createElement("main_label");
                element6.setAttribute("x_coordinate", Double.toString(tVFKRelation.getLabelBounds().getX()));
                element6.setAttribute("y_coordinate", Double.toString(tVFKRelation.getLabelBounds().getY()));
                element6.setAttribute("width", Double.toString(tVFKRelation.getLabelBounds().getWidth()));
                element6.setAttribute("height", Double.toString(tVFKRelation.getLabelBounds().getHeight()));
                object2.appendChild(element6);
                object = tVFKRelation.getLabel(1);
                if (object != null) {
                    this.appendDesignObjectColor(element6, (DesignObject)object);
                    this.appendDesignObjectFonts(element6, (DesignObject)object);
                }
                element2.appendChild((Node)object2);
            }
            element.appendChild(element2);
        }
    }

    private void appendSubViewInfoTypeSubst(Element element, DesignPartView designPartView, TypeSubstitution typeSubstitution) {
        Document document = element.getOwnerDocument();
        TVTypeSubstitution tVTypeSubstitution = (TVTypeSubstitution)typeSubstitution.getViewFor(designPartView);
        if (tVTypeSubstitution != null) {
            Element element2 = document.createElement("objectid");
            element2.setAttribute("role", "represents");
            element2.setAttribute("type", StringUtilities.encodeAttributeValue(typeSubstitution.getObjectTypeName()));
            element2.setAttribute("oid", StringUtilities.encodeAttributeValue(typeSubstitution.getObjectID()));
            element2.setAttribute("view_id_child", typeSubstitution.getChildCV(designPartView) != null ? typeSubstitution.getChildCV(designPartView).getViewID() : "null");
            element2.setAttribute("view_id_parent", typeSubstitution.getParentCV(designPartView) != null ? typeSubstitution.getParentCV(designPartView).getViewID() : "null");
            Element element3 = document.createElement("points");
            if (tVTypeSubstitution != null) {
                if (tVTypeSubstitution.getCellView() != null) {
                    EdgeView edgeView = (EdgeView)((DefaultEdge)tVTypeSubstitution.getCellView().getCell()).getCellView();
                    List list = edgeView.getPoints();
                    for (int i = 0; i < list.size(); ++i) {
                        Object e = list.get(i);
                        Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                        if (point2D == null) continue;
                        Element element4 = document.createElement("point");
                        element4.setAttribute("x_coordinate", Double.toString(point2D.getX()));
                        element4.setAttribute("y_coordinate", Double.toString(point2D.getY()));
                        element3.appendChild(element4);
                    }
                } else {
                    List list = tVTypeSubstitution.getEdgePoints();
                    for (int i = 0; i < list.size(); ++i) {
                        Object e = list.get(i);
                        Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                        if (point2D == null) continue;
                        Element element5 = document.createElement("point");
                        element5.setAttribute("x_coordinate", Double.toString(point2D.getX()));
                        element5.setAttribute("y_coordinate", Double.toString(point2D.getY()));
                        element3.appendChild(element5);
                    }
                }
            }
            element2.appendChild(element3);
            element.appendChild(element2);
        }
    }
}

