/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WXMLRelation
extends AbstractWXMLDesignObject {
    Relation relation = null;

    public WXMLRelation(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl;
        boolean bl2 = bl = object.getClass() == Relation.class;
        if (bl) {
            this.relation = (Relation)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.relation != null) {
            String string = this.relation.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("logical").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("relationPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof Relation) {
            Relation relation = (Relation)designObject;
            this.appendConnectionInfo(element, relation.getSourceConnection(), "source");
            this.appendConnectionInfo(element, relation.getTargetConnection(), "target");
            Element element2 = element.getOwnerDocument().createElement("dominant_role");
            Text text = element.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(relation.getDominantRole().getObjectID()));
            element2.appendChild(text);
            element.appendChild(element2);
            Element element3 = element.getOwnerDocument().createElement("identifying");
            Text text2 = relation.isIdentifying() ? element.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(VALUE_TRUE)) : element.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(VALUE_FALSE));
            element3.appendChild(text2);
            element.appendChild(element3);
        }
    }

    private void appendConnectionInfo(Element element, Relation.Connection connection, String string) {
        Element element2 = element.getOwnerDocument().createElement("connection");
        element.appendChild(element2);
        element2.setAttribute("endpoint", string);
        element2.setAttribute("card", connection.getCardinality().toString());
        element2.setAttribute("entity", StringUtilities.encodeAttributeValue(connection.getEntity().getObjectID()));
        element2.setAttribute("allownull", String.valueOf(connection.isOptional()));
    }
}

