/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.WXMLSubview;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.logical.TVArc;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WXMLLogicalDesign
extends AbstractXMLWriter {
    private LogicalDesign design = null;
    private static float NFS = 2.4f;
    private float version = NFS;

    public WXMLLogicalDesign(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof LogicalDesign;
    }

    @Override
    public Document writeDocument(Object object) {
        this.design = (LogicalDesign)object;
        if (this.design.getAppView().isSelectedForSave(object)) {
            this.version = this.design.getDesign().getVersion();
            Design design = this.design.getDesign();
            Document document = this.createDocument("design");
            Element element = document.getDocumentElement();
            element.setAttribute("id", StringUtilities.encodeAttributeValue(this.design.getObjectID()));
            Element element2 = document.createElement("ref");
            element.appendChild(element2);
            Element element3 = null;
            Element element4 = null;
            Element element5 = null;
            if (this.version < NFS) {
                element3 = document.createElement("view_synonyms");
                element.appendChild(element3);
                element4 = document.createElement("view_relations");
                element.appendChild(element4);
                element5 = document.createElement("logical_sub_views_collection");
                element.appendChild(element5);
            }
            Element element6 = document.createElement("type_substitutions");
            element.appendChild(element6);
            Collection collection = this.design.getStorableDesignObjects();
            Iterator iterator = collection.iterator();
            DesignObject designObject = null;
            while (iterator.hasNext()) {
                designObject = (DesignObject)iterator.next();
                if (!design.shouldExport(designObject)) continue;
                this.handleDesignObject(element2, designObject);
            }
            if (this.version < NFS) {
                this.handleTVSynonyms(this.design, element3);
                this.handleRelations(this.design, element4);
            }
            this.handleTypeSubstitutions(this.design, element6);
            if (this.version < NFS) {
                this.appendSubordinateDisplays(element, this.design.getMainView());
                this.handleLogicalSubViews(this.design, element5);
                this.appendDiagramViews(document, element, this.design);
            } else {
                WXMLSubview wXMLSubview = this.getPersistenceManager().getDesignPartViewWriter();
                wXMLSubview.appendExtSubViews(element, this.design);
            }
            this.appendDocumentsInfo(document, element, this.design);
            this.appendPartiesInfo(document, element, this.design);
            this.appendNamingOptions(document, element, this.design);
            this.design.setDirty(false);
            return document;
        }
        return null;
    }

    private void appendDocumentsInfo(Document document, Element element, LogicalDesign logicalDesign) {
        this.appendObjects(element, logicalDesign.getDocuments().toArray(), "documents");
    }

    private void appendPartiesInfo(Document document, Element element, LogicalDesign logicalDesign) {
        this.appendObjects(element, logicalDesign.getResponsibleParties().toArray(), "parties");
    }

    protected void appendObjects(Element element, Object[] objectArray, String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObject designObject = (DesignObject)objectArray[i];
            treeMap.put(String.valueOf(i + 1), StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        }
        this.appendProperties(element, string, treeMap);
    }

    @Override
    protected void appendProperties(Element element, String string, Map map) {
        Element element2 = element.getOwnerDocument().createElement(string);
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            String string3 = (String)map.get(string2);
            if (string2.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element element3 = element.getOwnerDocument().createElement("parameter");
            element2.appendChild(element3);
            this.appendProperty(element3, string2, string3);
        }
        element.appendChild(element2);
    }

    private void handleDesignObject(Element element, DesignObject designObject) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            boolean bl = this.getPersistenceManager().isCheckDirty() ? designObject.isDirty() : true;
            if (bl) {
                this.getPersistenceManager().write(designObject);
            }
        }
        this.appendReferencedObjectElement(element, designObject);
    }

    private void appendReferencedObjectElement(Element element, DesignObject designObject) {
        if (designObject instanceof Note && designObject.getFirstViewForDPV(this.design.getMainView()) == null) {
            return;
        }
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", designObject.belongsToDesign() ? "contains" : "uses");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        if (this.version < NFS) {
            this.appendGraphicalInfo(element2, designObject);
        }
        element.appendChild(element2);
    }

    public void appendGraphicalInfo(Element element, DesignObject designObject) {
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            Element element2 = element.getOwnerDocument().createElement("graphical");
            Map map = applicationView.getGraphicalPropsFor(designObject);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Element element3 = element.getOwnerDocument().createElement("parameter");
                element2.appendChild(element3);
                String string = (String)iterator.next();
                element3.setAttribute("name", string);
                element3.setAttribute("value", (String)map.get(string));
            }
            element.appendChild(element2);
        }
    }

    @Override
    public String getFilenameFor(Object object) {
        LogicalDesign logicalDesign = (LogicalDesign)object;
        return logicalDesign.getName();
    }

    @Override
    public String getRelativePath() {
        if (this.design != null && this.design.getAppView() != null) {
            String string = this.design.getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append('/').append("logical");
            return stringBuffer.toString();
        }
        return "logical";
    }

    public void handleTVSynonyms(LogicalDesign logicalDesign, Element element) {
        if (this.design.getAppView() != null) {
            ContainerObject containerObject;
            DesignPartView designPartView = logicalDesign.getMainView();
            Iterator iterator = logicalDesign.getEntitySet().iterator();
            while (iterator.hasNext()) {
                containerObject = (Entity)iterator.next();
                if (!logicalDesign.getDesign().shouldExport(containerObject)) continue;
                for (TopView topView : containerObject.getViewSynonims(designPartView)) {
                    this.appendReferencedObjectReprElement(element, topView);
                }
            }
            iterator = logicalDesign.getEntityViewSet().iterator();
            while (iterator.hasNext()) {
                containerObject = (EntityView)iterator.next();
                if (!logicalDesign.getDesign().shouldExport(containerObject)) continue;
                for (TopView topView : containerObject.getViewSynonims(designPartView)) {
                    this.appendReferencedObjectReprElement(element, topView);
                }
            }
        }
    }

    private void appendReferencedObjectReprElement(Element element, TopView topView) {
        Document document = element.getOwnerDocument();
        DesignObject designObject = topView.getModel();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", "represents");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        element2.setAttribute("viewid", topView.getViewID());
        element2.setAttribute("tv_generator_id", topView.getGeneratorID());
        this.appendGraphicalInfo(element2, topView);
        element.appendChild(element2);
    }

    public void appendGraphicalInfo(Element element, TopView topView) {
        DesignObject designObject = topView.getModel();
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            Element element2 = element.getOwnerDocument().createElement("graphical");
            Map map = applicationView.getGraphicalPropsFor(topView);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Element element3 = element.getOwnerDocument().createElement("parameter");
                element2.appendChild(element3);
                String string = (String)iterator.next();
                element3.setAttribute("name", string);
                element3.setAttribute("value", (String)map.get(string));
            }
            element.appendChild(element2);
        }
    }

    public void handleRelations(LogicalDesign logicalDesign, Element element) {
        if (logicalDesign.getAppView() != null) {
            Relation relation;
            Iterator iterator = logicalDesign.getRelationSet().iterator();
            while (iterator.hasNext()) {
                relation = (Relation)iterator.next();
                if (!logicalDesign.getDesign().shouldExport(relation)) continue;
                this.appendRelationObjectElement(logicalDesign, element, relation);
            }
            iterator = logicalDesign.getInheritanceRelationSet().iterator();
            while (iterator.hasNext()) {
                relation = (Relation)iterator.next();
                if (!logicalDesign.getDesign().shouldExport(relation.getSourceObject()) || !logicalDesign.getDesign().shouldExport(relation.getTargetObject())) continue;
                this.appendRelationObjectElement(logicalDesign, element, relation);
            }
        }
    }

    private void appendRelationObjectElement(LogicalDesign logicalDesign, Element element, Relation relation) {
        Object object;
        Object object2;
        int n;
        Object object3;
        Document document = element.getOwnerDocument();
        DesignPartView designPartView = logicalDesign.getMainView();
        TVRelation tVRelation = (TVRelation)relation.getTopView();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", "represents");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(relation.getObjectTypeName()));
        element2.setAttribute("oid", relation.getObjectID());
        element2.setAttribute("viewid_source", relation.getSourceTV(designPartView) != null ? relation.getSourceTV(designPartView).getViewID() : "null");
        element2.setAttribute("viewid_target", relation.getTargetTV(designPartView) != null ? relation.getTargetTV(designPartView).getViewID() : "null");
        Element element3 = document.createElement("points");
        if (tVRelation != null && tVRelation.getEdge() != null && tVRelation.getEdge().getCellView() != null) {
            object3 = ((EdgeView)tVRelation.getEdge().getCellView()).getPoints();
            for (n = 0; n < object3.size(); ++n) {
                object2 = object3.get(n);
                object = object2 instanceof PortView ? ((PortView)object2).getPoint() : (Point2D)object2;
                if (object == null) continue;
                Element element4 = document.createElement("point");
                element4.setAttribute("x_coordinate", Double.toString(((Point2D)object).getX()));
                element4.setAttribute("y_coordinate", Double.toString(((Point2D)object).getY()));
                element3.appendChild(element4);
            }
        } else if (tVRelation != null) {
            object3 = tVRelation.getEdgePoints();
            for (n = 0; n < object3.size(); ++n) {
                object2 = object3.get(n);
                object = object2 instanceof PortView ? ((PortView)object2).getPoint() : (Point2D)object2;
                if (object == null) continue;
                Element element5 = document.createElement("point");
                element5.setAttribute("x_coordinate", Double.toString(((Point2D)object).getX()));
                element5.setAttribute("y_coordinate", Double.toString(((Point2D)object).getY()));
                element3.appendChild(element5);
            }
        }
        element2.appendChild(element3);
        if (tVRelation != null) {
            object3 = tVRelation.getEdgeView();
            if (object3 != null) {
                Element element6 = document.createElement("labels");
                object2 = document.createElement("source");
                object2.setAttribute("x_coordinate", Double.toString(tVRelation.getSourceLabelBounds().getX()));
                object2.setAttribute("y_coordinate", Double.toString(tVRelation.getSourceLabelBounds().getY()));
                object2.setAttribute("width", Double.toString(tVRelation.getSourceLabelBounds().getWidth()));
                object2.setAttribute("height", Double.toString(tVRelation.getSourceLabelBounds().getHeight()));
                element6.appendChild((Node)object2);
                object = tVRelation.getLabel(0);
                if (object != null) {
                    this.appendDesignObjectColor((Element)object2, (DesignObject)object);
                    this.appendDesignObjectFonts((Element)object2, (DesignObject)object);
                }
                object2 = document.createElement("target");
                object2.setAttribute("x_coordinate", Double.toString(tVRelation.getTargetLabelBounds().getX()));
                object2.setAttribute("y_coordinate", Double.toString(tVRelation.getTargetLabelBounds().getY()));
                object2.setAttribute("width", Double.toString(tVRelation.getTargetLabelBounds().getWidth()));
                object2.setAttribute("height", Double.toString(tVRelation.getTargetLabelBounds().getHeight()));
                element6.appendChild((Node)object2);
                object = tVRelation.getLabel(2);
                if (object != null) {
                    this.appendDesignObjectColor((Element)object2, (DesignObject)object);
                    this.appendDesignObjectFonts((Element)object2, (DesignObject)object);
                }
                element2.appendChild(element6);
            }
            Element element7 = document.createElement("graphical");
            object2 = element2.getOwnerDocument().createElement("parameter");
            element7.appendChild((Node)object2);
            object2.setAttribute("name", "use_default_color");
            object2.setAttribute("value", Boolean.toString(tVRelation.useDefaultColor()));
            if (!tVRelation.useDefaultColor()) {
                object2 = element2.getOwnerDocument().createElement("parameter");
                element7.appendChild((Node)object2);
                object2.setAttribute("name", "color");
                object2.setAttribute("value", tVRelation.getBackgroundColor() != null ? Integer.toString(tVRelation.getBackgroundColor().getRGB()) : "null");
                object2 = element2.getOwnerDocument().createElement("parameter");
                element7.appendChild((Node)object2);
                object2.setAttribute("name", "width");
                object2.setAttribute("value", Integer.toString(tVRelation.getLineWidth()));
            }
            element2.appendChild(element7);
        }
        element.appendChild(element2);
    }

    public void handleLogicalSubViews(LogicalDesign logicalDesign, Element element) {
        if (logicalDesign.getAppView() != null) {
            Document document = element.getOwnerDocument();
            SubViewObjectSet subViewObjectSet = logicalDesign.getLogicalDesignSubviews();
            Iterator iterator = subViewObjectSet.iterator();
            while (iterator.hasNext()) {
                DesignObject designObject;
                DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
                DPVLogicalSubView dPVLogicalSubView = (DPVLogicalSubView)designPartViewPlaceHolder.getDesignPartView();
                if (!logicalDesign.getDesign().shouldExportDPV(dPVLogicalSubView)) continue;
                Element element2 = document.createElement("logical_sub_view");
                element2.setAttribute("subview_name", StringUtilities.encodeAttributeValue(dPVLogicalSubView.getName()));
                element2.setAttribute("id", dPVLogicalSubView.getDPVId());
                element2.setAttribute("generator", dPVLogicalSubView.getGeneratorId());
                element2.setAttribute("visible", designPartViewPlaceHolder.getVisible() ? "true" : "false");
                element2.setAttribute("comment", StringUtilities.encodeAttributeValue(designPartViewPlaceHolder.getComment()));
                element2.setAttribute("notes", StringUtilities.encodeAttributeValue(designPartViewPlaceHolder.getNotes()));
                element.appendChild(element2);
                this.addEntitiesInDPV(logicalDesign, element2, dPVLogicalSubView);
                this.addEntitiyViewsInDPV(logicalDesign, element2, dPVLogicalSubView);
                this.addNotesInDPV(logicalDesign, element2, dPVLogicalSubView);
                this.addDiagramViewsInDPV(logicalDesign, element2, dPVLogicalSubView);
                Iterator iterator2 = logicalDesign.getRelationSet().iterator();
                while (iterator2.hasNext()) {
                    designObject = (Relation)iterator2.next();
                    this.appendSubViewInfoRelation(element2, dPVLogicalSubView, (Relation)designObject);
                }
                iterator2 = logicalDesign.getInheritanceRelationSet().iterator();
                while (iterator2.hasNext()) {
                    designObject = (Relation)iterator2.next();
                    this.appendSubViewInfoRelation(element2, dPVLogicalSubView, (Relation)designObject);
                }
                iterator2 = logicalDesign.getTypeSubstitutionSet().iterator();
                while (iterator2.hasNext()) {
                    designObject = (TypeSubstitution)iterator2.next();
                    this.appendSubViewInfoTypeSubst(element2, dPVLogicalSubView, (TypeSubstitution)designObject);
                }
                this.addArcViewsInDPV(logicalDesign, element2, dPVLogicalSubView);
                this.appendSubordinateDisplays(element2, dPVLogicalSubView);
            }
        }
    }

    private void addEntitiesInDPV(LogicalDesign logicalDesign, Element element, DPVLogicalSubView dPVLogicalSubView) {
        Iterator iterator = logicalDesign.getEntitySet().iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            for (TopView topView : entity.getViewsForDPV(dPVLogicalSubView)) {
                this.appendReferencedObjectReprElement(element, topView);
            }
        }
    }

    private void addEntitiyViewsInDPV(LogicalDesign logicalDesign, Element element, DPVLogicalSubView dPVLogicalSubView) {
        Iterator iterator = logicalDesign.getEntityViewSet().iterator();
        while (iterator.hasNext()) {
            EntityView entityView = (EntityView)iterator.next();
            for (TopView topView : entityView.getViewsForDPV(dPVLogicalSubView)) {
                this.appendReferencedObjectReprElement(element, topView);
            }
        }
    }

    private void addNotesInDPV(LogicalDesign logicalDesign, Element element, DPVLogicalSubView dPVLogicalSubView) {
        Iterator iterator = logicalDesign.getNoteSet().iterator();
        while (iterator.hasNext()) {
            Note note = (Note)iterator.next();
            TopView topView = note.getFirstViewForDPV(dPVLogicalSubView);
            if (topView == null) continue;
            this.appendReferencedObjectReprElement(element, topView);
        }
    }

    private void addDiagramViewsInDPV(LogicalDesign logicalDesign, Element element, DPVLogicalSubView dPVLogicalSubView) {
        Iterator iterator = logicalDesign.getDiagramViewSet().iterator();
        while (iterator.hasNext()) {
            DiagramView diagramView = (DiagramView)iterator.next();
            TopView topView = diagramView.getFirstViewForDPV(dPVLogicalSubView);
            if (topView == null) continue;
            this.appendDiagramViewInfo(element.getOwnerDocument(), element, diagramView, topView);
        }
    }

    private void addArcViewsInDPV(LogicalDesign logicalDesign, Element element, DPVLogicalSubView dPVLogicalSubView) {
        CellView[] cellViewArray = dPVLogicalSubView.getWorkSpace().getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            TopView topView = ((DefaultDiagramCell)cellViewArray[i].getCell()).getTopView();
            if (topView.isConnection() || !(cellViewArray[i].getCell() instanceof DefaultDiagramCell) || !(topView instanceof TVArc)) continue;
            this.appendReferencedObjectReprElement(element, topView);
        }
    }

    private void appendSubViewInfoRelation(Element element, DesignPartView designPartView, Relation relation) {
        block13: {
            try {
                Object object;
                Element element2;
                Object object2;
                Document document = element.getOwnerDocument();
                TVRelation tVRelation = (TVRelation)relation.getViewFor(designPartView);
                if (tVRelation == null || relation.getSourceTV(designPartView) == null || relation.getTargetTV(designPartView) == null) break block13;
                Element element3 = document.createElement("objectid");
                element3.setAttribute("role", "represents");
                element3.setAttribute("type", StringUtilities.encodeAttributeValue(relation.getObjectTypeName()));
                element3.setAttribute("oid", StringUtilities.encodeAttributeValue(relation.getObjectID()));
                element3.setAttribute("viewid_source", relation.getSourceTV(designPartView) != null ? relation.getSourceTV(designPartView).getViewID() : "null");
                element3.setAttribute("viewid_target", relation.getTargetTV(designPartView) != null ? relation.getTargetTV(designPartView).getViewID() : "null");
                Element element4 = document.createElement("points");
                if (tVRelation != null) {
                    int n;
                    if (tVRelation.getEdge() != null && tVRelation.getEdge().getCellView() != null) {
                        object2 = ((EdgeView)tVRelation.getEdge().getCellView()).getPoints();
                        for (n = 0; n < object2.size(); ++n) {
                            element2 = object2.get(n);
                            object = element2 instanceof PortView ? ((PortView)((Object)element2)).getPoint() : (Point2D)((Object)element2);
                            if (object == null) continue;
                            Element element5 = document.createElement("point");
                            element5.setAttribute("x_coordinate", Double.toString(((Point2D)object).getX()));
                            element5.setAttribute("y_coordinate", Double.toString(((Point2D)object).getY()));
                            element4.appendChild(element5);
                        }
                    } else if (tVRelation.getCellView() != null) {
                        object2 = ((EdgeView)tVRelation.getCellView()).getPoints();
                        for (n = 0; n < object2.size(); ++n) {
                            element2 = object2.get(n);
                            object = element2 instanceof PortView ? ((PortView)((Object)element2)).getPoint() : (Point2D)((Object)element2);
                            if (object == null) continue;
                            Element element6 = document.createElement("point");
                            element6.setAttribute("x_coordinate", Double.toString(((Point2D)object).getX()));
                            element6.setAttribute("y_coordinate", Double.toString(((Point2D)object).getY()));
                            element4.appendChild(element6);
                        }
                    } else {
                        object2 = tVRelation.getEdgePoints();
                        for (n = 0; n < object2.size(); ++n) {
                            element2 = object2.get(n);
                            object = element2 instanceof PortView ? ((PortView)((Object)element2)).getPoint() : (Point2D)((Object)element2);
                            if (object == null) continue;
                            Element element7 = document.createElement("point");
                            element7.setAttribute("x_coordinate", Double.toString(((Point2D)object).getX()));
                            element7.setAttribute("y_coordinate", Double.toString(((Point2D)object).getY()));
                            element4.appendChild(element7);
                        }
                    }
                }
                element3.appendChild(element4);
                object2 = tVRelation.getEdgeView();
                if (object2 != null) {
                    Element element8 = document.createElement("labels");
                    element2 = document.createElement("source");
                    element2.setAttribute("x_coordinate", Double.toString(tVRelation.getSourceLabelBounds().getX()));
                    element2.setAttribute("y_coordinate", Double.toString(tVRelation.getSourceLabelBounds().getY()));
                    element2.setAttribute("width", Double.toString(tVRelation.getSourceLabelBounds().getWidth()));
                    element2.setAttribute("height", Double.toString(tVRelation.getSourceLabelBounds().getHeight()));
                    element8.appendChild(element2);
                    object = tVRelation.getLabel(0);
                    if (object != null) {
                        this.appendDesignObjectColor(element2, (DesignObject)object);
                        this.appendDesignObjectFonts(element2, (DesignObject)object);
                    }
                    element2 = document.createElement("target");
                    element2.setAttribute("x_coordinate", Double.toString(tVRelation.getTargetLabelBounds().getX()));
                    element2.setAttribute("y_coordinate", Double.toString(tVRelation.getTargetLabelBounds().getY()));
                    element2.setAttribute("width", Double.toString(tVRelation.getTargetLabelBounds().getWidth()));
                    element2.setAttribute("height", Double.toString(tVRelation.getTargetLabelBounds().getHeight()));
                    element8.appendChild(element2);
                    object = tVRelation.getLabel(2);
                    if (object != null) {
                        this.appendDesignObjectColor(element2, (DesignObject)object);
                        this.appendDesignObjectFonts(element2, (DesignObject)object);
                    }
                    element3.appendChild(element8);
                }
                element.appendChild(element3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void handleTypeSubstitutions(LogicalDesign logicalDesign, Element element) {
        if (logicalDesign.getAppView() != null) {
            DesignPartView designPartView = logicalDesign.getMainView();
            Iterator iterator = logicalDesign.getTypeSubstitutionSet().iterator();
            while (iterator.hasNext()) {
                TypeSubstitution typeSubstitution = (TypeSubstitution)iterator.next();
                ContainerView containerView = typeSubstitution.getChildCV(designPartView);
                ContainerView containerView2 = typeSubstitution.getParentCV(designPartView);
                if (containerView == null || containerView2 == null || !logicalDesign.getDesign().shouldExport(containerView.getModel()) || !logicalDesign.getDesign().shouldExport(containerView2.getModel())) continue;
                this.appendTypeSbstElement(logicalDesign, element, typeSubstitution);
            }
        }
    }

    private void appendTypeSbstElement(LogicalDesign logicalDesign, Element element, TypeSubstitution typeSubstitution) {
        Object object;
        Object object2;
        Document document = element.getOwnerDocument();
        DesignPartView designPartView = logicalDesign.getMainView();
        TVTypeSubstitution tVTypeSubstitution = (TVTypeSubstitution)typeSubstitution.getViewFor(designPartView);
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", "represents");
        element2.setAttribute("type", typeSubstitution.getObjectTypeName());
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(typeSubstitution.getObjectID()));
        if (typeSubstitution.getChildContainerObject() != null) {
            element2.setAttribute("child_id", StringUtilities.encodeAttributeValue(typeSubstitution.getChildContainerObject().getObjectID()));
        } else {
            element2.setAttribute("child_id", "null");
        }
        if (typeSubstitution.getParentContainerObject() != null) {
            element2.setAttribute("parent_id", StringUtilities.encodeAttributeValue(typeSubstitution.getParentContainerObject().getObjectID()));
        } else {
            element2.setAttribute("parent_id", "null");
        }
        element2.setAttribute("view_id_child", typeSubstitution.getChildCV(designPartView) != null ? typeSubstitution.getChildCV(designPartView).getViewID() : "null");
        element2.setAttribute("view_id_parent", typeSubstitution.getParentCV(designPartView) != null ? typeSubstitution.getParentCV(designPartView).getViewID() : "null");
        Element element3 = document.createElement("points");
        if (tVTypeSubstitution != null) {
            object2 = (EdgeView)((DefaultEdge)tVTypeSubstitution.getCellView().getCell()).getCellView();
            object = ((EdgeView)object2).getPoints();
            for (int i = 0; i < object.size(); ++i) {
                Object e = object.get(i);
                Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                Element element4 = document.createElement("point");
                element4.setAttribute("x_coordinate", Double.toString(point2D.getX()));
                element4.setAttribute("y_coordinate", Double.toString(point2D.getY()));
                element3.appendChild(element4);
            }
        }
        element2.appendChild(element3);
        if (tVTypeSubstitution != null) {
            object2 = document.createElement("graphical");
            object = element2.getOwnerDocument().createElement("parameter");
            object2.appendChild((Node)object);
            object.setAttribute("name", "use_default_color");
            object.setAttribute("value", Boolean.toString(tVTypeSubstitution.useDefaultColor()));
            if (!tVTypeSubstitution.useDefaultColor()) {
                object = element2.getOwnerDocument().createElement("parameter");
                object2.appendChild((Node)object);
                object.setAttribute("name", "color");
                object.setAttribute("value", tVTypeSubstitution.getBackgroundColor() != null ? Integer.toString(tVTypeSubstitution.getBackgroundColor().getRGB()) : "null");
                object = element2.getOwnerDocument().createElement("parameter");
                object2.appendChild((Node)object);
                object.setAttribute("name", "width");
                object.setAttribute("value", Integer.toString(tVTypeSubstitution.getLineWidth()));
            }
            element2.appendChild((Node)object2);
        }
        element.appendChild(element2);
    }

    private void appendSubViewInfoTypeSubst(Element element, DesignPartView designPartView, TypeSubstitution typeSubstitution) {
        Document document = element.getOwnerDocument();
        TVTypeSubstitution tVTypeSubstitution = (TVTypeSubstitution)typeSubstitution.getViewFor(designPartView);
        if (tVTypeSubstitution != null) {
            Element element2 = document.createElement("objectid");
            element2.setAttribute("role", "represents");
            element2.setAttribute("type", StringUtilities.encodeAttributeValue(typeSubstitution.getObjectTypeName()));
            element2.setAttribute("oid", StringUtilities.encodeAttributeValue(typeSubstitution.getObjectID()));
            element2.setAttribute("view_id_child", typeSubstitution.getChildCV(designPartView) != null ? typeSubstitution.getChildCV(designPartView).getViewID() : "null");
            element2.setAttribute("view_id_parent", typeSubstitution.getParentCV(designPartView) != null ? typeSubstitution.getParentCV(designPartView).getViewID() : "null");
            Element element3 = document.createElement("points");
            if (tVTypeSubstitution != null) {
                if (tVTypeSubstitution.getCellView() != null) {
                    EdgeView edgeView = (EdgeView)((DefaultEdge)tVTypeSubstitution.getCellView().getCell()).getCellView();
                    List list = edgeView.getPoints();
                    for (int i = 0; i < list.size(); ++i) {
                        Object e = list.get(i);
                        Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                        Element element4 = document.createElement("point");
                        element4.setAttribute("x_coordinate", Double.toString(point2D.getX()));
                        element4.setAttribute("y_coordinate", Double.toString(point2D.getY()));
                        element3.appendChild(element4);
                    }
                } else {
                    List list = tVTypeSubstitution.getEdgePoints();
                    for (int i = 0; i < list.size(); ++i) {
                        Point2D point2D = (Point2D)list.get(i);
                        Element element5 = document.createElement("point");
                        element5.setAttribute("x_coordinate", Double.toString(point2D.getX()));
                        element5.setAttribute("y_coordinate", Double.toString(point2D.getY()));
                        element3.appendChild(element5);
                    }
                }
            }
            element2.appendChild(element3);
            element.appendChild(element2);
        }
    }
}

