/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLFKArc
extends AbstractWXMLDesignObject {
    private FKArc arc = null;

    public WXMLFKArc(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof FKArc;
        if (bl) {
            this.arc = (FKArc)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.arc != null) {
            String string = this.arc.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("rel").append('/').append(this.arc.getDesignPart().getPathIDString()).append('/');
        }
        stringBuffer.append(this.getConfiguration().get("arcPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof FKArc) {
            FKArc fKArc = (FKArc)designObject;
            element.setAttribute("table", StringUtilities.encodeAttributeValue(fKArc.getTable().getObjectID()));
            element.setAttribute("mandatory", String.valueOf(fKArc.isMandatory()));
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            int n = 0;
            for (FKIndexAssociation fKIndexAssociation : fKArc.getFkeys()) {
                treeMap.put("fkey_" + ++n, StringUtilities.encodeAttributeValue(fKIndexAssociation.getObjectID()));
            }
            this.appendProperties(element, "fkeys", treeMap);
        }
    }
}

