/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.List;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WXMLEntityView
extends AbstractWXMLDesignObject {
    EntityView view = null;

    public WXMLEntityView(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof EntityView;
        if (bl) {
            this.view = (EntityView)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.view != null) {
            String string = this.view.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("logical").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("tableViewPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof EntityView) {
            String string;
            Object object2;
            EntityView entityView = (EntityView)designObject;
            Document document = element.getOwnerDocument();
            element.setAttribute("viewtype", entityView.getViewType());
            if (entityView.getBasedOnStructuredType() != null) {
                element.setAttribute("structuredType", StringUtilities.encodeAttributeValue(entityView.getBasedOnStructuredType().getObjectID()));
            }
            element.setAttribute("allow_type_substitution", String.valueOf(entityView.isAllowTypeSubstitution()));
            Element element2 = document.createElement("containers");
            element.appendChild(element2);
            for (Object object2 : entityView.getUsedContainers()) {
                this.appendContainerInfo(document, element2, StringUtilities.encodeAttributeValue(((AbstractView.ContainerHolder)object2).getContainer().getObjectID()), ((AbstractView.ContainerHolder)object2).getAlias());
            }
            object2 = "" + entityView.getUserDefined();
            Element element3 = document.createElement("userDefined");
            Text text = document.createTextNode(StringUtilities.encodeAttributeValue((String)object2));
            element3.appendChild(text);
            element.appendChild(element3);
            String string2 = entityView.getUserDefinedSQL();
            if (string2 != null) {
                element3 = document.createElement("userDefinedSQL");
                text = document.createTextNode(StringUtilities.encodeAttributeValue(string2));
                element3.appendChild(text);
                element.appendChild(element3);
            }
            if ((string = entityView.getWhere()) != null) {
                element3 = document.createElement("where");
                text = document.createTextNode(StringUtilities.encodeAttributeValue(string));
                element3.appendChild(text);
                element.appendChild(element3);
            }
            element3 = document.createElement("groupby");
            this.appendGroupBy(element, element3, entityView.getGroupByList());
            String string3 = entityView.getHaving();
            if (string3 != null) {
                element3 = document.createElement("having");
                text = document.createTextNode(StringUtilities.encodeAttributeValue(string3));
                element3.appendChild(text);
                element.appendChild(element3);
            }
            Element element4 = document.createElement("orderby");
            element.appendChild(element4);
            for (ContainedObject containedObject : entityView.getOrderByList()) {
                String string4 = entityView.getSortOrder(StringUtilities.encodeAttributeValue(containedObject.getObjectID()));
                if (string4 == "") {
                    string4 = "ASC";
                }
                if (((AttributeView)containedObject).getEntity() != null) {
                    this.appendOrderByInfo(document, element4, StringUtilities.encodeAttributeValue(containedObject.getObjectID()), StringUtilities.encodeAttributeValue(containedObject.getName()), StringUtilities.encodeAttributeValue(((AttributeView)containedObject).getEntity().getObjectID()), string4);
                    continue;
                }
                if (((AttributeView)containedObject).getView() != null) {
                    this.appendOrderByInfo(document, element4, StringUtilities.encodeAttributeValue(containedObject.getObjectID()), StringUtilities.encodeAttributeValue(containedObject.getName()), StringUtilities.encodeAttributeValue(((AttributeView)containedObject).getView().getObjectID()), string4);
                    continue;
                }
                this.appendOrderByInfo(document, element4, StringUtilities.encodeAttributeValue(containedObject.getObjectID()), StringUtilities.encodeAttributeValue(containedObject.getName()), StringUtilities.encodeAttributeValue(((AttributeView)containedObject).getContainer().getObjectID()), string4);
            }
        }
    }

    protected final Element appendOrderByInfo(Document document, Element element, String string, String string2, String string3, String string4) {
        Element element2 = document.createElement("columnview");
        element2.setAttribute("objectid", StringUtilities.encodeAttributeValue(string));
        element2.setAttribute("name", StringUtilities.encodeAttributeValue(string2));
        element2.setAttribute("cid", StringUtilities.encodeAttributeValue(string3));
        element2.setAttribute("sortorder", string4);
        element.appendChild(element2);
        return element2;
    }

    protected final Element appendContainerInfo(Document document, Element element, String string, String string2) {
        Element element2 = document.createElement("container");
        element2.setAttribute("alias", StringUtilities.encodeAttributeValue(string2));
        element2.setAttribute("cid", StringUtilities.encodeAttributeValue(string));
        element.appendChild(element2);
        return element2;
    }

    @Override
    protected void appendContainedObjectInfo(Element element, ContainedObject containedObject) {
        String string;
        String string2;
        String string3;
        Text text;
        Element element2;
        AttributeView attributeView = (AttributeView)containedObject;
        Document document = element.getOwnerDocument();
        element.setAttribute("tableid", StringUtilities.encodeAttributeValue(attributeView.getContainer().getObjectID()));
        element.setAttribute("reference", String.valueOf(attributeView.isReference()));
        element.setAttribute("dttype", attributeView.getStructuredType() != null ? StringUtilities.encodeAttributeValue(attributeView.getStructuredType().getObjectID()) : "");
        this.appendScopeInfo(element, attributeView);
        String string4 = attributeView.getAlias();
        if (string4 != null) {
            element2 = document.createElement("alias");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string4));
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if ((string3 = attributeView.getEntityAlias()) != null) {
            element2 = document.createElement("tableAlias");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string3));
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if (attributeView.getReferencedAttribute() != null && (string2 = attributeView.getReferencedAttribute().getObjectID()) != null) {
            element2 = document.createElement("refcolumn");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string2));
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if (attributeView.getEntity() != null && (string2 = attributeView.getEntity().getObjectID()) != null) {
            element2 = document.createElement("table");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string2));
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if (attributeView.getView() != null && (string2 = attributeView.getView().getObjectID()) != null) {
            element2 = document.createElement("view");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string2));
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if ((string2 = attributeView.getExpression()) != null) {
            element2 = document.createElement("expression");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string2));
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if ((string = attributeView.getDataType()) != null) {
            element2 = document.createElement("datatype");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string));
            element2.appendChild(text);
            element.appendChild(element2);
        }
    }

    private void appendGroupBy(Element element, Element element2, List list) {
        if (list.size() > 0) {
            for (AttributeView attributeView : list) {
                if (attributeView == null) continue;
                Element element3 = element.getOwnerDocument().createElement("cv_id");
                element3.setAttribute("value", StringUtilities.encodeAttributeValue(attributeView.getObjectID()));
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
    }
}

