/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.List;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.WXMLDomain;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLDomainFile
extends AbstractXMLWriter {
    private WXMLDomain delegate;
    private boolean isSystem;

    public WXMLDomainFile(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
        this.delegate = new WXMLDomain(xMLPersistenceManager);
    }

    @Override
    public String getRelativePath(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            this.isSystem = "defaultdomains".equalsIgnoreCase(((Domain)list.get(0)).getFileName());
        } else if (object instanceof String) {
            this.isSystem = "defaultdomains".equalsIgnoreCase(String.valueOf(object));
        }
        return this.getRelativePath();
    }

    @Override
    public String getRelativePath() {
        if (!this.isSystem) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append(this.getConfiguration().get("domainPath"));
            return stringBuffer.toString();
        }
        return this.getConfiguration().get("typesPath");
    }

    @Override
    public boolean canWrite(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            return list.size() > 0 && list.get(0) instanceof Domain;
        }
        return false;
    }

    @Override
    public Document writeDocument(Object object) {
        Document document = this.createDocument("domain");
        Element element = document.getDocumentElement();
        List list = (List)object;
        for (Domain domain : list) {
            if ("Unknown".equalsIgnoreCase(domain.getName())) continue;
            this.delegate.appendDomainInfo(element, domain);
        }
        return document;
    }

    @Override
    public String getFilenameFor(Object object) {
        String string = null;
        if (object instanceof List) {
            List list = (List)object;
            string = ((Domain)list.get(0)).getFileName();
        } else {
            string = null;
        }
        return string;
    }
}

