/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WXMLDomain
extends AbstractWXMLDesignObject {
    public WXMLDomain(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    public void appendDomainInfo(Element element, Domain domain) {
        Document document = element.getOwnerDocument();
        this.appendDesignObjectInfo(document, element, domain);
    }

    @Override
    public String getDocumentAsString(Object object) {
        Document document = this.createDocument("domain");
        Element element = document.getDocumentElement();
        Domain domain = (Domain)object;
        this.appendDomainInfo(element, domain);
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.prettyPrint(document, stringBuffer);
        return string;
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof Domain) {
            Domain domain = (Domain)designObject;
            LogicalDatatype logicalDatatype = domain.getLogicalDatatype();
            Element element2 = element.getOwnerDocument().createElement("logicaltype");
            element2.setAttribute("oid", StringUtilities.encodeAttributeValue(logicalDatatype.getObjectID()));
            element2.setAttribute("name", StringUtilities.encodeAttributeValue(logicalDatatype.getName()));
            this.appendAVT(element, domain);
            this.appendDataTypeParameters(element, domain);
            if (domain.getCheck() != null) {
                this.appendConstraint(element, domain.getCheck());
            }
            if (domain.getValueList() != null) {
                this.appendConstraint(element, domain.getValueList());
            }
            element.setAttribute("synonym", StringUtilities.encodeAttributeValue(domain.getSynonym()));
            element.setAttribute("dimension", StringUtilities.encodeAttributeValue(domain.getDimension()));
            element.setAttribute("file", domain.getFileName());
            element.appendChild(element2);
        }
    }

    protected void appendDataTypeParameters(Element element, Domain domain) {
        Iterator iterator = domain.getDataTypeParameterNames();
        if (iterator.hasNext()) {
            Element element2 = element.getOwnerDocument().createElement("parameters");
            this.appendComment(element2, "Default values for named parameters, passed on to logical datatypes");
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = domain.getDataTypeParameter(string);
                if (string2 == null || "".equals(string2)) continue;
                Element element3 = element.getOwnerDocument().createElement("parameter");
                element2.appendChild(element3);
                element3.setAttribute("name", string);
                element3.setAttribute("value", StringUtilities.encodeAttributeValue(string2));
            }
            element.appendChild(element2);
        }
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof Domain;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getPersistenceManager().getAppView().getDesignName();
        stringBuffer.append(string).append('/').append(this.getConfiguration().get("domainPath"));
        return stringBuffer.toString();
    }

    @Override
    public String getFilenameFor(Object object) {
        return ((Domain)object).getFileName();
    }

    @Override
    public Document writeDocument(Object object) {
        return null;
    }

    @Override
    protected void appendConstraint(Element element, Constraint constraint) {
        Element element2 = this.createElement(element, "constraint");
        element2.setAttribute("type", WXMLDomain.encodeAttributeValue(constraint.getType()));
        this.appendConstraintInfo(element2, constraint);
        if (constraint instanceof ConstraintEnumeration) {
            this.appendConstraintEnumeration(element2, (ConstraintEnumeration)constraint);
        }
    }

    private void appendConstraintEnumeration(Element element, ConstraintEnumeration constraintEnumeration) {
        Element element2 = element.getOwnerDocument().createElement("properties");
        Iterator iterator = constraintEnumeration.getPropertyNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = constraintEnumeration.getProperty(string);
            if (string.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element element3 = element.getOwnerDocument().createElement("parameter");
            element2.appendChild(element3);
            this.appendProperty(element3, string, string2);
            String string3 = "";
            if (constraintEnumeration.getValuesDescriptionMap().containsKey(string2)) {
                string3 = (String)constraintEnumeration.getValuesDescriptionMap().get(string2);
            }
            element3.setAttribute("desc", WXMLDomain.encodeAttributeValue(string3));
        }
        element.appendChild(element2);
    }

    @Override
    protected void appendConstraintInfo(Element element, Constraint constraint) {
    }

    protected void appendAVT(Element element, Domain domain) {
        element.setAttribute("avt_sort_order", String.valueOf(domain.getAVTSortOrder()));
        Set set = domain.getAVTs();
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                AVT aVT = (AVT)iterator.next();
                Element element2 = this.createElement(element, "avt");
                Element element3 = element2.getOwnerDocument().createElement("beginvalue");
                Text text = element2.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(aVT.getBeginValue()));
                element3.appendChild(text);
                element2.appendChild(element3);
                element3 = element2.getOwnerDocument().createElement("endvalue");
                text = element2.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(aVT.getEndValue()));
                element3.appendChild(text);
                element2.appendChild(element3);
                element3 = element2.getOwnerDocument().createElement("description");
                text = element2.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(aVT.getDescription()));
                element3.appendChild(text);
                element2.appendChild(element3);
            }
        } else {
            Element element4 = this.createElement(element, "avt");
            Element element5 = element4.getOwnerDocument().createElement("beginvalue");
            Text text = element4.getOwnerDocument().createTextNode("");
            element5.appendChild(text);
            element4.appendChild(element5);
            element5 = element4.getOwnerDocument().createElement("endvalue");
            text = element4.getOwnerDocument().createTextNode("");
            element5.appendChild(text);
            element4.appendChild(element5);
            element5 = element4.getOwnerDocument().createElement("description");
            text = element4.getOwnerDocument().createTextNode("");
            element5.appendChild(text);
            element4.appendChild(element5);
        }
    }
}

