/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WXMLDesign
extends AbstractXMLWriter {
    public WXMLDesign(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof Design;
    }

    @Override
    public String getRelativePath() {
        return "";
    }

    @Override
    public Document writeDocument(Object object) {
        Design design = (Design)object;
        Document document = this.createDocument("model");
        Element element = document.getDocumentElement();
        this.appendVersion(document, element, design);
        this.appendDesignProperties(document, element, design);
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            this.appendChangeRequestsInfo(document, element, design);
        }
        this.appendDesignInfo(document, element, design.getDataTypesDesign());
        this.appendDesignInfo(document, element, design.getLogicalDesign());
        this.appendRelationalDesignsInfo(document, element, design);
        this.appendMultidimensionalDesignsInfo(document, element, design);
        this.appendProcessModelInfo(document, element, design.getProcessModel());
        this.appendDesignInfo(document, element, design.getBusinessInfoDesign());
        Element element2 = document.createElement("domains");
        element.appendChild(element2);
        Collection collection = design.getStorableDesignObjects();
        HashMap hashMap = new HashMap();
        if (design.isSaveDefaultDomains()) {
            hashMap.put("defaultdomains", new ArrayList());
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = collection.iterator();
        DesignObject designObject = null;
        while (iterator.hasNext()) {
            designObject = (DesignObject)iterator.next();
            this.handleDesignObject(element2, designObject, hashMap, hashSet);
        }
        this.handleDomainFiles(hashMap);
        hashSet.clear();
        hashMap.clear();
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            this.getPersistenceManager().write(design.getRDBMSSiteSet());
        }
        design.setDirty(false);
        return document;
    }

    private void appendDesignProperties(Document document, Element element, Design design) {
        String string;
        Text text;
        Element element2;
        Element element3 = document.createElement("object");
        String string2 = design.getComment();
        if (string2 != null) {
            element2 = document.createElement("comment");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string2));
            element2.appendChild(text);
            element3.appendChild(element2);
        }
        if ((string = design.getNotes()) != null) {
            element2 = document.createElement("notes");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string));
            element2.appendChild(text);
            element3.appendChild(element2);
        }
        this.appendChange(element3, design.getCreation(), "created");
        this.appendChange(element3, design.getChange(), "changed");
        element.appendChild(element3);
    }

    private void appendVersion(Document document, Element element, Design design) {
        Element element2 = document.createElement("version");
        element2.setAttribute("version", String.valueOf(design.getVersion()));
        element2.setAttribute("design_id", design.getDesignID());
        element.appendChild(element2);
    }

    private void appendChangeRequestsInfo(Document document, Element element, Design design) {
        Element element2 = document.createElement("changerequests");
        Iterator iterator = design.getChangeRequestSet().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append(StringUtilities.encodeAttributeValue(((DesignObject)iterator.next()).getObjectID()));
        }
        element2.setAttribute("id", stringBuffer.toString());
        element.appendChild(element2);
    }

    private void appendDesignInfo(Document document, Element element, DesignPart designPart) {
        if (!designPart.isNewModel() || designPart.getAppView().isSelectedForSave(designPart)) {
            Element element2 = document.createElement("design");
            element2.setAttribute("type", StringUtilities.encodeAttributeValue(designPart.getObjectTypeName()));
            element2.setAttribute("id", StringUtilities.encodeAttributeValue(designPart.getObjectID()));
            element2.setAttribute("path_id", StringUtilities.encodeAttributeValue(designPart.getPathIDString()));
            if (designPart.getMainView() != null) {
                element2.setAttribute("main_view_id", designPart.getMainView().getDPVId());
            } else {
                element2.setAttribute("main_view_id", "null");
            }
            element2.setAttribute("should_be_open", StringUtilities.encodeAttributeValue(String.valueOf(designPart.isLoaded())));
            if (designPart instanceof LogicalDesign) {
                if (((LogicalDesign)designPart).isSubviewToNewDesign()) {
                    element2.setAttribute("is_visible", String.valueOf(true));
                } else {
                    element2.setAttribute("is_visible", String.valueOf(designPart.isMainViewVisible()));
                }
            } else if (designPart instanceof RelationalDesign) {
                if (((RelationalDesign)designPart).isSubviewToNewDesign()) {
                    element2.setAttribute("is_visible", String.valueOf(true));
                } else {
                    element2.setAttribute("is_visible", String.valueOf(designPart.isMainViewVisible()));
                }
            } else {
                element2.setAttribute("is_visible", String.valueOf(designPart.isMainViewVisible()));
            }
            if (designPart instanceof DataFlowDesign) {
                element2.setAttribute("top_level_dfd_design", String.valueOf(((DataFlowDesign)designPart).isTopLevel()));
            }
            Element element3 = document.createElement("name");
            element3.appendChild(document.createTextNode(StringUtilities.encodeAttributeValue(designPart.getName())));
            element2.appendChild(element3);
            Element element4 = document.createElement("comment");
            element4.appendChild(document.createTextNode(StringUtilities.encodeAttributeValue(designPart.getComment())));
            element2.appendChild(element4);
            element.appendChild(element2);
            Element element5 = document.createElement("notes");
            element5.appendChild(document.createTextNode(StringUtilities.encodeAttributeValue(designPart.getNotes())));
            element2.appendChild(element5);
            element.appendChild(element2);
        }
    }

    private void appendRelationalDesignsInfo(Document document, Element element, Design design) {
        Iterator iterator = design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!design.shouldExportFull(relationalDesign) && !design.shouldExportPartial(relationalDesign)) continue;
            this.appendDesignInfo(document, element, relationalDesign);
        }
    }

    private void appendMultidimensionalDesignsInfo(Document document, Element element, Design design) {
        Iterator iterator = design.getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)iterator.next();
            if (!design.shouldExportFull(multidimensionalDesign) && !design.shouldExportPartial(multidimensionalDesign)) continue;
            this.appendDesignInfo(document, element, multidimensionalDesign);
        }
    }

    private void appendProcessModelInfo(Document document, Element element, ProcessModel processModel) {
        Element element2 = document.createElement("design");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(processModel.getObjectTypeName()));
        element2.setAttribute("id", StringUtilities.encodeAttributeValue(processModel.getObjectID()));
        Element element3 = document.createElement("name");
        element3.appendChild(document.createTextNode(StringUtilities.encodeAttributeValue(processModel.getName())));
        element2.appendChild(element3);
        Element element4 = document.createElement("comment");
        element4.appendChild(document.createTextNode(StringUtilities.encodeAttributeValue(processModel.getComment())));
        element2.appendChild(element4);
        element.appendChild(element2);
        Element element5 = document.createElement("notes");
        element5.appendChild(document.createTextNode(StringUtilities.encodeAttributeValue(processModel.getNotes())));
        element2.appendChild(element5);
        element.appendChild(element2);
        this.appendDataFlowDesignsInfo(document, element, processModel);
    }

    private void appendDataFlowDesignsInfo(Document document, Element element, ProcessModel processModel) {
        Iterator iterator = processModel.getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
            this.appendDesignInfo(document, element, dataFlowDesign);
        }
    }

    private void handleDesignObject(Element element, DesignObject designObject, Map map, Set set) {
        if (designObject instanceof Domain) {
            String string = ((Domain)designObject).getFileName();
            ArrayList<DesignObject> arrayList = null;
            if (map.containsKey(string)) {
                arrayList = (ArrayList<DesignObject>)map.get(string);
                arrayList.add(designObject);
            } else if (!set.contains(string)) {
                if (designObject.belongsToDesign()) {
                    arrayList = new ArrayList<DesignObject>();
                    arrayList.add(designObject);
                    map.put(string, arrayList);
                    this.appendDomainFileNameNode(element, string, true);
                } else {
                    set.add(string);
                    this.appendDomainFileNameNode(element, string, false);
                }
            }
        }
    }

    private void handleDomainFiles(Map map) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            for (String string : map.keySet()) {
                List list = (List)map.get(string);
                this.getPersistenceManager().write(list);
            }
        }
    }

    private void appendDomainFileNameNode(Element element, String string, boolean bl) {
        Element element2 = element.getOwnerDocument().createElement("domain");
        element2.setAttribute("name", StringUtilities.encodeAttributeValue(string));
        element2.setAttribute("role", bl ? "contains" : "uses");
        element.appendChild(element2);
    }

    @Override
    public String getFilenameFor(Object object) {
        Design design = (Design)object;
        return new StringBuffer(design.getFileName()).append(".dmd").toString();
    }

    protected void appendImportedDesigns(Element element, Design design) {
        String[] stringArray = design.getImportedDesignNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Element element2 = this.createElement(element, "imports");
            element2.setAttribute("design", StringUtilities.encodeAttributeValue(stringArray[i]));
        }
    }

    private void createProperty(Document document, Element element, EngPropertyHolder engPropertyHolder) {
        Element element2 = document.createElement("property");
        element2.setAttribute("name", StringUtilities.encodeAttributeValue(engPropertyHolder.getName()));
        element2.setAttribute("selected", String.valueOf(engPropertyHolder.isSelected()));
        element.appendChild(element2);
    }
}

