/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WXMLChangeRequest
extends AbstractWXMLDesignObject {
    private ChangeRequest request = null;

    public WXMLChangeRequest(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof ChangeRequest;
        if (bl) {
            this.request = (ChangeRequest)object;
        }
        return bl;
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof ChangeRequest) {
            ChangeRequest changeRequest = (ChangeRequest)designObject;
            Document document = element.getOwnerDocument();
            Element element2 = document.createElement("reason");
            Text text = null;
            if (changeRequest.getReason() != null && !"".equalsIgnoreCase(changeRequest.getReason())) {
                text = document.createTextNode("" + StringUtilities.encodeAttributeValue(changeRequest.getReason()));
                element2.appendChild(text);
                element.appendChild(element2);
            }
            element2 = document.createElement("status");
            text = document.createTextNode(changeRequest.getStatus());
            element2.appendChild(text);
            element.appendChild(element2);
            element2 = document.createElement("completed");
            text = changeRequest.isCompleted() ? document.createTextNode(VALUE_TRUE) : document.createTextNode(VALUE_FALSE);
            element2.appendChild(text);
            element.appendChild(element2);
            element2 = document.createElement("requestDate");
            text = document.createTextNode(changeRequest.getRequestDate());
            element2.appendChild(text);
            element.appendChild(element2);
            element2 = document.createElement("completionDate");
            text = document.createTextNode(changeRequest.getCompletionDate());
            element2.appendChild(text);
            element.appendChild(element2);
            element2 = document.createElement("implNote");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(changeRequest.getImplDescription()));
            element2.appendChild(text);
            element.appendChild(element2);
        }
    }

    @Override
    public String getRelativePath() {
        if (this.request != null) {
            String string = this.request.getDesign().getName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append('/').append("changerequest");
            return stringBuffer.toString();
        }
        return "changerequest";
    }
}

