/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLArc
extends AbstractWXMLDesignObject {
    private Arc arc = null;

    public WXMLArc(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean bl = object instanceof Arc;
        if (bl) {
            this.arc = (Arc)object;
        }
        return bl;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.arc != null) {
            String string = this.arc.getDesignPart().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("logical").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("arcPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element element, DesignObject designObject) {
        if (designObject instanceof Arc) {
            Arc arc = (Arc)designObject;
            element.setAttribute("entity", StringUtilities.encodeAttributeValue(arc.getEntity().getObjectID()));
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            int n = 0;
            for (Relation relation : arc.getRelations()) {
                treeMap.put("relation_" + ++n, StringUtilities.encodeAttributeValue(relation.getObjectID()));
            }
            this.appendProperties(element, "relations", treeMap);
        }
    }
}

