/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLRelation
extends AbstractRXMLDesignObject {
    public RXMLRelation(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/').append("logical").append('/');
        }
        stringBuffer.append(this.getConfiguration().get("relationPath"));
        return stringBuffer.toString();
    }

    @Override
    public String getIdStartSequence() {
        return MDPreferences.getDefaultInstance().get("relation id prefix");
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        return design.getLogicalDesign().recreateRelation(StringUtilities.decodeAttributeValue(string));
    }

    @Override
    protected void readObjectInfo(Element element, ModelIDObject modelIDObject, boolean bl) {
        if (modelIDObject instanceof Relation) {
            Object object;
            Object object2;
            Design design = modelIDObject.getDesign();
            Relation relation = (Relation)modelIDObject;
            Element element2 = RXMLRelation.getFirstChildByTagName(element, "dominant_role");
            if (element2 != null && element2.getFirstChild() != null) {
                object2 = element2.getFirstChild().getNodeValue();
                object = (Entity)design.getDesignObject((String)object2);
                relation.setDominantRole((Entity)object);
            }
            if ((object2 = RXMLRelation.getFirstChildByTagName(element, "identifying")) != null && object2.getFirstChild() != null) {
                object = object2.getFirstChild().getNodeValue();
                relation.setIdentifying(((String)object).equals(VALUE_TRUE));
            }
            object = element.getElementsByTagName("connection");
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)object.item(i);
                String string = element3.getAttribute("entity");
                String string2 = element3.getAttribute("card");
                String string3 = element3.getAttribute("allownull");
                boolean bl2 = true;
                if (string3 != null && string3.equalsIgnoreCase("false")) {
                    bl2 = false;
                }
                Entity entity = (Entity)design.getDesignObject(string);
                if ("source".equals(element3.getAttribute("endpoint"))) {
                    relation.setCardinality(0, string2);
                    relation.setOptionalSource(bl2);
                    relation.setSourceEntity(entity);
                    continue;
                }
                if (!"target".equals(element3.getAttribute("endpoint"))) continue;
                relation.setCardinality(1, string2);
                relation.setOptionalTarget(bl2);
                relation.setTargetEntity(entity);
            }
            if (relation.getSourceEntity() == null || relation.getTargetEntity() == null) {
                relation.remove();
            }
        }
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        Relation relation = (Relation)super.recreateObject(element, design, bl);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(relation.getObjectID())).append(".dmd");
        relation.setFilePath(stringBuffer.toString());
        return relation;
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == Relation.class;
    }
}

