/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.persistence.xml.RXMLSubview;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.reference.CompositeReference;
import oracle.dbtools.crest.model.reference.ModelIDObjectReference;
import oracle.dbtools.crest.model.reference.Reference;
import oracle.dbtools.crest.model.reference.ReferenceSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLLogicalDesign
extends AbstractXMLReader {
    private boolean xmlFromDB = false;
    private static Logger LOGGER;
    private static float NFS;
    private float loadedVersion = NFS;

    public RXMLLogicalDesign(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        int n;
        String string;
        Object[] objectArray;
        this.loadedVersion = designPart.getDesign().getLoadedVersion();
        this.xmlFromDB = this.getPersistenceManager().isXML_FromDataBase();
        Element element = document.getDocumentElement();
        String string2 = element.getAttribute("id");
        if (!"".equalsIgnoreCase(string2)) {
            designPart.setObjectID(StringUtilities.decodeAttributeValue(string2));
        }
        DesignPartView designPartView = null;
        if (this.loadedVersion < NFS) {
            designPartView = designPart.getMainView();
            int n2 = designPartView.getTabbedPane().indexOfComponent(designPartView);
            if (n2 < 0) {
                designPartView.getTabbedPane().setName(designPartView.getName());
                designPartView.getTabbedPane().add(designPartView);
            }
            this.readDisplayProperties(element, designPartView);
            designPartView.getWorkSpace().updateSettings();
        }
        NodeList nodeList = RXMLLogicalDesign.getFirstChildByTagName(element, "ref").getElementsByTagName("objectid");
        int n3 = nodeList.getLength();
        for (int i = 0; i < n3; ++i) {
            objectArray = (Object[])nodeList.item(i);
            String string3 = objectArray.getAttribute("role");
            string = objectArray.getAttribute("oid");
            boolean bl2 = "contains".equalsIgnoreCase(string3) && bl;
            DesignObject designObject = null;
            designObject = !this.xmlFromDB ? (DesignObject)this.getPersistenceManager().read((Object)string, designPart.getDesign(), bl2) : designPart.getDesign().getDesignObject(string);
            if (designObject != null) {
                designObject.setTemporaryWriteable(true);
                if (!designObject.belongsToDesign(designPart.getDesign())) {
                    designObject.setReadOnly(true);
                }
                if (this.loadedVersion < NFS) {
                    this.readGraphicalInfo((Element)objectArray, designObject);
                }
                designObject.setTemporaryWriteable(false);
                continue;
            }
            LOGGER.error("Read object returns null");
        }
        Map map = this.getProperties(element, "documents");
        objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map.get(objectArray[n]);
            DesignObject designObject = designPart.getDesign().getDesignObject(string);
            if (designObject == null) continue;
            designPart.addDocument((BIDocument)designObject);
        }
        map = this.getProperties(element, "parties");
        objectArray = map.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)map.get(objectArray[n]);
            DesignObject designObject = designPart.getDesign().getDesignObject(string);
            if (designObject == null) continue;
            designPart.addResponsibleParty((BIResponsibleParty)designObject);
        }
        this.getPersistenceManager().runTasks();
        if (this.loadedVersion < NFS) {
            this.readViewSynonyms(element, (LogicalDesign)designPart);
            this.readRelationToSynonyms(element, (LogicalDesign)designPart);
        }
        this.readTypeSubstitutions(element, (LogicalDesign)designPart);
        if (this.loadedVersion < NFS) {
            this.readSubordinateDisplays(element, designPartView);
            designPartView.getTabbedPane().setSelectedComponent(designPartView);
            this.readLogicalSubViews(element, (LogicalDesign)designPart);
            this.readDiagramViews(element, designPart);
        } else if (!this.xmlFromDB) {
            RXMLSubview rXMLSubview = this.getPersistenceManager().getDesignPartViewReader();
            rXMLSubview.readExtSubViews(element, designPart);
        }
        this.resetRelations((LogicalDesign)designPart);
        this.readNamingOptions(element, designPart);
        this.updateKeysElements((LogicalDesign)designPart);
        designPart.setLoaded(true);
        return designPart;
    }

    private void resetRelations(LogicalDesign logicalDesign) {
        Iterator iterator = logicalDesign.getRelationSet().iterator();
        while (iterator.hasNext()) {
            Relation relation = (Relation)iterator.next();
            relation.setCardinality(0, relation.getCardinality(0));
        }
    }

    @Override
    protected Map getProperties(Element element, String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        Element element2 = RXMLLogicalDesign.getFirstChildByTagName(element, string);
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("parameter");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                treeMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
            }
        }
        return treeMap;
    }

    protected DesignObject instantiateDesignObject(String string, Design design) {
        return design.getBusinessInfoDesign().getDocumentSet().createDocument(StringUtilities.decodeAttributeValue(string));
    }

    private void readLogicalSubViews(Element element, LogicalDesign logicalDesign) {
        ApplicationView.log(Messages.getString("RXMLLogicalDesign.ReadLogicalSubViews"));
        if (logicalDesign.getAppView() != null) {
            EntitySet entitySet = logicalDesign.getEntitySet();
            Element element2 = RXMLLogicalDesign.getFirstChildByTagName(element, "logical_sub_views_collection");
            if (element2 != null) {
                NodeList nodeList = element2.getElementsByTagName("logical_sub_view");
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    String string;
                    Element element3 = (Element)nodeList.item(i);
                    String string2 = element3.getAttribute("subview_name");
                    String string3 = element3.getAttribute("id");
                    String string4 = element3.getAttribute("generator");
                    DesignPartView designPartView = logicalDesign.createDesignPartSubView();
                    this.readDisplayProperties(element3, designPartView);
                    designPartView.setName(StringUtilities.decodeAttributeValue(string2));
                    designPartView.setVisible(false);
                    if (string3 != null && !"".equalsIgnoreCase(string3) && !"null".equalsIgnoreCase(string3)) {
                        designPartView.setDPVId(string3);
                    }
                    if (string4 != null && !"".equalsIgnoreCase(string4) && !"null".equalsIgnoreCase(string4)) {
                        designPartView.setGeneratorId(string4);
                    }
                    String string5 = element3.getAttribute("visible");
                    NodeList nodeList2 = element3.getElementsByTagName("objectid");
                    int n2 = nodeList2.getLength();
                    for (int j = 0; j < n2; ++j) {
                        String string6;
                        String string7;
                        Object object8;
                        int n3;
                        int n4;
                        Element element4 = (Element)nodeList2.item(j);
                        if (element4.getParentNode() != element3) continue;
                        string = element4.getAttribute("type");
                        object7 = element4.getAttribute("oid");
                        if (string.equalsIgnoreCase("Entity")) {
                            object6 = (Entity)entitySet.getObjectByID((String)object7);
                            object5 = (TVEntity)designPartView.createTopViewFor((DesignObject)object6);
                            object4 = element4.getAttribute("viewid");
                            object3 = element4.getAttribute("tv_generator_id");
                            ((TopView)object5).setViewID((String)object4);
                            if (object3 != null && !"".equalsIgnoreCase((String)object3) && !"null".equalsIgnoreCase((String)object3)) {
                                ((TopView)object5).setGeneratorID((String)object3);
                            }
                            this.readGraphicalInfo(element4, (TopView)object5);
                        }
                        if (string.equalsIgnoreCase("VIEW") && (object6 = (EntityView)logicalDesign.getDesign().getDesignObject((String)object7)) != null) {
                            object5 = designPartView.createTopViewFor((DesignObject)object6);
                            object4 = element4.getAttribute("viewid");
                            object3 = element4.getAttribute("tv_generator_id");
                            ((TopView)object5).setViewID((String)object4);
                            if (object3 != null && !"".equalsIgnoreCase((String)object3) && !"null".equalsIgnoreCase((String)object3)) {
                                ((TopView)object5).setGeneratorID((String)object3);
                            }
                            this.readGraphicalInfo(element4, (TopView)object5);
                        }
                        if (string.equalsIgnoreCase("Arc") && (object6 = (Arc)logicalDesign.getDesign().getDesignObject((String)object7)) != null) {
                            object5 = designPartView.createTopViewFor((DesignObject)object6);
                            object4 = element4.getAttribute("viewid");
                            object3 = element4.getAttribute("tv_generator_id");
                            ((TopView)object5).setViewID((String)object4);
                            if (object3 != null && !"".equalsIgnoreCase((String)object3) && !"null".equalsIgnoreCase((String)object3)) {
                                ((TopView)object5).setGeneratorID((String)object3);
                            }
                            this.readGraphicalInfo(element4, (TopView)object5);
                        }
                        if (string.equalsIgnoreCase("Note")) {
                            object6 = (Note)this.getPersistenceManager().read(object7, logicalDesign.getDesign(), true);
                            object5 = (TVNote)designPartView.createTopViewFor((DesignObject)object6);
                            object4 = (TVNote)((MultiShapedDesignObject)object6).getFirstViewForDPV(designPartView.getDesignPart().getMainView());
                            if (object4 != null) {
                                ((ContainerView)object4).remove(false);
                            }
                            object3 = element4.getAttribute("viewid");
                            ((TopView)object5).setViewID((String)object3);
                            this.readGraphicalInfo(element4, (TopView)object5);
                        }
                        if (string.equalsIgnoreCase("Relation") || string.equalsIgnoreCase("Hierarchy relation")) {
                            if (string.equalsIgnoreCase("Relation")) {
                                object6 = (Relation)logicalDesign.getRelationSet().getObjectByID((String)object7);
                            } else {
                                object6 = (Relation)logicalDesign.getInheritanceRelationSet().getObjectByID((String)object7);
                                if (object6 != null) {
                                    // empty if block
                                }
                            }
                            if (object6 != null) {
                                object5 = element4.getAttribute("viewid_source");
                                object4 = element4.getAttribute("viewid_target");
                                if (!((String)object5).equals("null")) {
                                    ((Relation)object6).setSourceTV((TVEntity)((Relation)object6).getSourceEntity().getTopViewByID(designPartView, (String)object5));
                                }
                                if (!((String)object4).equals("null") && ((Relation)object6).getTargetEntity() != null) {
                                    ((Relation)object6).setTargetTV((TVEntity)((Relation)object6).getTargetEntity().getTopViewByID(designPartView, (String)object4));
                                }
                                if ((object3 = RXMLLogicalDesign.getFirstChildByTagName(element4, "points")) != null) {
                                    object2 = object3.getElementsByTagName("point");
                                    n4 = object2.getLength();
                                    object = (TVRelation)((Relation)object6).getViewFor(designPartView);
                                    if (object != null) {
                                        for (n3 = 0; n3 < n4; ++n3) {
                                            object8 = (Element)object2.item(n3);
                                            string7 = object8.getAttribute("x_coordinate");
                                            string6 = object8.getAttribute("y_coordinate");
                                            ((TVConnector)object).getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(string7), Double.parseDouble(string6)));
                                        }
                                    }
                                }
                                if ((object2 = RXMLLogicalDesign.getFirstChildByTagName(element4, "labels")) != null) {
                                    Label label;
                                    TVRelation tVRelation = (TVRelation)((Relation)object6).getViewFor(designPartView);
                                    object = RXMLLogicalDesign.getFirstChildByTagName((Element)object2, "source");
                                    if (object != null) {
                                        String string8 = object.getAttribute("x_coordinate");
                                        object8 = object.getAttribute("y_coordinate");
                                        string7 = object.getAttribute("width");
                                        string6 = object.getAttribute("height");
                                        if (string7 == null || "".equalsIgnoreCase(string7)) {
                                            string7 = "-1";
                                        }
                                        if (string6 == null || "".equalsIgnoreCase(string6)) {
                                            string6 = "-1";
                                        }
                                        if (string8 != null && object8 != null) {
                                            tVRelation.setSourceLabelBounds(new Rectangle((int)Double.parseDouble(string8), (int)Double.parseDouble((String)object8), (int)Double.parseDouble(string7), (int)Double.parseDouble(string6)));
                                        }
                                        if ((label = tVRelation.getTempSourceLabel()) != null) {
                                            this.readColorInfo((Element)object, label);
                                            this.readFontsInfo((Element)object, label);
                                        }
                                    }
                                    if ((object = RXMLLogicalDesign.getFirstChildByTagName((Element)object2, "target")) != null) {
                                        String string9 = object.getAttribute("x_coordinate");
                                        object8 = object.getAttribute("y_coordinate");
                                        string7 = object.getAttribute("width");
                                        string6 = object.getAttribute("height");
                                        if (string7 == null || "".equalsIgnoreCase(string7)) {
                                            string7 = "-1";
                                        }
                                        if (string6 == null || "".equalsIgnoreCase(string6)) {
                                            string6 = "-1";
                                        }
                                        if (string9 != null && object8 != null) {
                                            tVRelation.setTargetLabelBounds(new Rectangle((int)Double.parseDouble(string9), (int)Double.parseDouble((String)object8), (int)Double.parseDouble(string7), (int)Double.parseDouble(string6)));
                                        }
                                        if ((label = tVRelation.getTempTargetLabel()) != null) {
                                            this.readColorInfo((Element)object, label);
                                            this.readFontsInfo((Element)object, label);
                                        }
                                    }
                                }
                            }
                        }
                        if (!string.equalsIgnoreCase("TypeSubstitution")) continue;
                        object6 = (TypeSubstitution)logicalDesign.getTypeSubstitutionSet().getObjectByID((String)object7);
                        object5 = element4.getAttribute("view_id_child");
                        object4 = element4.getAttribute("view_id_parent");
                        if (!((String)object5).equals("null")) {
                            ((TypeSubstitution)object6).setChildCV((ContainerView)((TypeSubstitution)object6).getChildContainerObject().getTopViewByID(designPartView, (String)object5));
                        }
                        if (!((String)object4).equals("null")) {
                            ((TypeSubstitution)object6).setParentCV((ContainerView)((TypeSubstitution)object6).getParentContainerObject().getTopViewByID(designPartView, (String)object4));
                        }
                        if ((object3 = RXMLLogicalDesign.getFirstChildByTagName(element4, "points")) == null) continue;
                        object2 = object3.getElementsByTagName("point");
                        n4 = object2.getLength();
                        object = (TVTypeSubstitution)((TypeSubstitution)object6).getViewFor(designPartView);
                        for (n3 = 0; n3 < n4; ++n3) {
                            object8 = (Element)object2.item(n3);
                            string7 = object8.getAttribute("x_coordinate");
                            string6 = object8.getAttribute("y_coordinate");
                            ((TVConnector)object).getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(string7), Double.parseDouble(string6)));
                        }
                    }
                    NodeList nodeList3 = element3.getElementsByTagName("diagram_view");
                    int n5 = nodeList3.getLength();
                    for (int j = 0; j < n5; ++j) {
                        object7 = (Element)nodeList3.item(j);
                        object6 = object7.getAttribute("objectid");
                        object5 = object7.getAttribute("dpv_id");
                        object4 = object7.getAttribute("dpv_name");
                        object3 = object7.getAttribute("composite");
                        object2 = logicalDesign.recreateDiagramView((String)object6);
                        ((DiagramView)object2).setDpvID((String)object5);
                        ((DiagramView)object2).setDpvName((String)object4);
                        ((DiagramView)object2).setCompositeView(Boolean.valueOf((String)object3));
                        logicalDesign.getDesign().addDiagramView((DiagramView)object2);
                        TVDiagramView tVDiagramView = (TVDiagramView)designPartView.createTopViewFor((DesignObject)object2);
                        logicalDesign.getMainView().removeViewFor((DesignObject)object2);
                        object = ((MultiShapedDesignObject)object2).getFirstViewForDPV(logicalDesign.getMainView());
                        if (object != null) {
                            ((MultiShapedDesignObject)object2).removeTopView((TopView)object, true);
                        }
                        this.readGraphicalInfo((Element)object7, tVDiagramView);
                    }
                    designPartView.setMustBeVisible(string5.equalsIgnoreCase("true"));
                    string = element3.getAttribute("comment");
                    ((DesignPartViewPlaceHolder)designPartView.getPlaceHolder()).setComment(StringUtilities.decodeAttributeValue(string));
                    object7 = element3.getAttribute("notes");
                    ((DesignPartViewPlaceHolder)designPartView.getPlaceHolder()).setNotes(StringUtilities.decodeAttributeValue((String)object7));
                    designPartView.getTabbedPane().setName(designPartView.getName());
                    designPartView.getWorkSpace().updateSettings();
                    this.readSubordinateDisplays(element3, designPartView);
                    designPartView.getTabbedPane().setSelectedComponent(designPartView);
                }
            }
        }
    }

    private void readViewSynonyms(Element element, LogicalDesign logicalDesign) {
        ApplicationView.log(Messages.getString("RXMLLogicalDesign.ReadViewsSynonyms"));
        if (logicalDesign.getAppView() != null) {
            DesignPartView designPartView = logicalDesign.getMainView();
            Element element2 = RXMLLogicalDesign.getFirstChildByTagName(element, "view_synonyms");
            if (element2 != null) {
                NodeList nodeList = element2.getElementsByTagName("objectid");
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Element element3 = (Element)nodeList.item(i);
                    String string = element3.getAttribute("oid");
                    String string2 = element3.getAttribute("viewid");
                    String string3 = element3.getAttribute("tv_generator_id");
                    String string4 = element3.getAttribute("type");
                    if (!string4.equalsIgnoreCase("Entity")) continue;
                    DesignObject designObject = logicalDesign.getEntitySet().getObjectByID(string);
                    TVEntity tVEntity = (TVEntity)designObject.getTopView().createViewSynonim(designPartView);
                    tVEntity.setViewID(string2);
                    if (string3 != null && !"".equalsIgnoreCase(string3) && !"null".equalsIgnoreCase(string3)) {
                        tVEntity.setGeneratorID(string3);
                    }
                    this.readGraphicalInfo(element3, tVEntity);
                }
            }
        }
    }

    public void readGraphicalInfo(Element element, TopView topView) {
        DesignObject designObject = topView.getModel();
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            NodeList nodeList = element.getElementsByTagName("graphical");
            HashMap<String, String> hashMap = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                hashMap = new HashMap<String, String>();
                NodeList nodeList2 = element2.getElementsByTagName("parameter");
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    hashMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
                }
                applicationView.setGraphicalPropsFor(topView, hashMap);
            }
        }
    }

    private void readRelationToSynonyms(Element element, LogicalDesign logicalDesign) {
        ApplicationView.log(Messages.getString("RXMLLogicalDesign.ReadRelationsToSynonyms"));
        DesignPartView designPartView = logicalDesign.getMainView();
        Element element2 = RXMLLogicalDesign.getFirstChildByTagName(element, "view_relations");
        if (element2 != null) {
            NodeList nodeList = element2.getElementsByTagName("objectid");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                String string;
                Object object3;
                Object object4;
                Element element3;
                Element element4 = (Element)nodeList.item(i);
                String string2 = element4.getAttribute("oid");
                String string3 = element4.getAttribute("type");
                Relation relation = string3.equalsIgnoreCase("Relation") ? (Relation)logicalDesign.getRelationSet().getObjectByID(string2) : (Relation)logicalDesign.getInheritanceRelationSet().getObjectByID(string2);
                if (relation == null || relation.getTargetEntity() == null) continue;
                String string4 = element4.getAttribute("viewid_source");
                String string5 = element4.getAttribute("viewid_target");
                if (!string4.equals("null")) {
                    relation.setSourceTV((TVEntity)relation.getSourceEntity().getTopViewByID(designPartView, string4));
                }
                if (!string5.equals("null")) {
                    relation.setTargetTV((TVEntity)relation.getTargetEntity().getTopViewByID(designPartView, string5));
                }
                Element element5 = RXMLLogicalDesign.getFirstChildByTagName(element4, "points");
                NodeList nodeList2 = element5.getElementsByTagName("point");
                int n2 = nodeList2.getLength();
                TVRelation tVRelation = (TVRelation)relation.getTopView();
                for (int j = 0; j < n2; ++j) {
                    element3 = (Element)nodeList2.item(j);
                    object4 = element3.getAttribute("x_coordinate");
                    object3 = element3.getAttribute("y_coordinate");
                    tVRelation.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble((String)object4), Double.parseDouble((String)object3)));
                }
                Element element6 = RXMLLogicalDesign.getFirstChildByTagName(element4, "labels");
                if (element6 != null) {
                    String string6;
                    element3 = RXMLLogicalDesign.getFirstChildByTagName(element6, "source");
                    if (element3 != null) {
                        object4 = element3.getAttribute("x_coordinate");
                        object3 = element3.getAttribute("y_coordinate");
                        string6 = element3.getAttribute("width");
                        string = element3.getAttribute("height");
                        if (string6 == null || "".equalsIgnoreCase(string6)) {
                            string6 = "-1";
                        }
                        if (string == null || "".equalsIgnoreCase(string)) {
                            string = "-1";
                        }
                        if (object4 != null && object3 != null) {
                            tVRelation.setSourceLabelBounds(new Rectangle((int)Double.parseDouble((String)object4), (int)Double.parseDouble((String)object3), (int)Double.parseDouble(string6), (int)Double.parseDouble(string)));
                        }
                        if ((object2 = tVRelation.getTempSourceLabel()) != null) {
                            this.readColorInfo(element3, (DesignObject)object2);
                            this.readFontsInfo(element3, (DesignObject)object2);
                        }
                    }
                    if ((element3 = RXMLLogicalDesign.getFirstChildByTagName(element6, "target")) != null) {
                        object4 = element3.getAttribute("x_coordinate");
                        object3 = element3.getAttribute("y_coordinate");
                        string6 = element3.getAttribute("width");
                        string = element3.getAttribute("height");
                        if (string6 == null || "".equalsIgnoreCase(string6)) {
                            string6 = "-1";
                        }
                        if (string == null || "".equalsIgnoreCase(string)) {
                            string = "-1";
                        }
                        if (object4 != null && object3 != null) {
                            tVRelation.setTargetLabelBounds(new Rectangle((int)Double.parseDouble((String)object4), (int)Double.parseDouble((String)object3), (int)Double.parseDouble(string6), (int)Double.parseDouble(string)));
                        }
                        if ((object2 = tVRelation.getTempTargetLabel()) != null) {
                            this.readColorInfo(element3, (DesignObject)object2);
                            this.readFontsInfo(element3, (DesignObject)object2);
                        }
                    }
                }
                if ((element3 = RXMLLogicalDesign.getFirstChildByTagName(element4, "graphical")) == null) continue;
                object4 = element3.getElementsByTagName("parameter");
                object3 = new HashMap();
                int n3 = object4.getLength();
                for (int j = 0; j < n3; ++j) {
                    object2 = (Element)object4.item(j);
                    object3.put(object2.getAttribute("name"), object2.getAttribute("value"));
                }
                string = (String)object3.get("use_default_color");
                boolean bl = true;
                if (string != null) {
                    bl = Boolean.valueOf(string);
                }
                tVRelation.setUseDefaultColor(bl);
                if (bl) continue;
                String string7 = (String)object3.get("color");
                if (string7 != null && !"null".equalsIgnoreCase(string7)) {
                    object = new Color(Integer.parseInt(string7));
                    tVRelation.setBackgroundColor((Color)object);
                }
                if ((object = (String)object3.get("width")) == null || "null".equalsIgnoreCase((String)object)) continue;
                int n4 = Integer.parseInt((String)object);
                tVRelation.setLineWidth(n4);
            }
        }
    }

    public void readGraphicalInfo(Element element, DesignObject designObject) {
        if (designObject == null || designObject.getDesign() == null) {
            LOGGER.error("readGraphicalInfo: DesignObject = null or design = null");
            return;
        }
        ApplicationView applicationView = designObject.getDesign().getAppView();
        if (applicationView != null) {
            NodeList nodeList = element.getElementsByTagName("graphical");
            HashMap<String, String> hashMap = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                hashMap = new HashMap<String, String>();
                NodeList nodeList2 = element2.getElementsByTagName("parameter");
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    hashMap.put(element3.getAttribute("name"), element3.getAttribute("value"));
                }
                applicationView.setGraphicalPropsFor(designObject, hashMap);
            }
        }
    }

    protected void readAtomicReference(Element element, ModelIDObjectReference modelIDObjectReference, Map map) {
        if (VALUE_TRUE.equals(element.getAttribute("disabled"))) {
            modelIDObjectReference.setNullified(true);
        } else {
            String string = element.getAttribute("references");
            modelIDObjectReference.setObjectId(StringUtilities.decodeAttributeValue(string));
        }
    }

    protected void readCompositeReference(Element element, CompositeReference compositeReference, ReferenceSet referenceSet, Map map) {
        NodeList nodeList = element.getElementsByTagName("ref");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("oid");
            Reference reference = referenceSet.getReferenceByIdString(string);
            if (reference == null) continue;
            compositeReference.add(reference);
            String string2 = element2.getAttribute("main");
            if (!VALUE_TRUE.equals(string2)) continue;
            compositeReference.setMainReference(reference);
        }
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append('/').append("logical");
            return stringBuffer.toString();
        }
        return "logical";
    }

    @Override
    public Object recreateObject(Document document, Design design, boolean bl) {
        return null;
    }

    private void readTypeSubstitutions(Element element, LogicalDesign logicalDesign) {
        ApplicationView.log(Messages.getString("RXMLLogicalDesign.ReadTypeSubstitutions"));
        if (logicalDesign.getAppView() != null) {
            DesignPartView designPartView = logicalDesign.getMainView();
            Element element2 = RXMLLogicalDesign.getFirstChildByTagName(element, "type_substitutions");
            if (element2 != null) {
                NodeList nodeList = element2.getElementsByTagName("objectid");
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    Object object2;
                    Object object3;
                    Element element3 = (Element)nodeList.item(i);
                    String string = element3.getAttribute("oid");
                    String string2 = element3.getAttribute("child_id");
                    ContainerObject containerObject = null;
                    ContainerObject containerObject2 = null;
                    if (string2 == null) {
                        string2 = "null";
                    } else {
                        containerObject2 = (ContainerObject)logicalDesign.getDesign().getDesignObject(string2);
                    }
                    String string3 = element3.getAttribute("parent_id");
                    if (string3 == null) {
                        string3 = "null";
                    } else {
                        containerObject = (ContainerObject)logicalDesign.getDesign().getDesignObject(string3);
                    }
                    if (containerObject == null || containerObject2 == null) continue;
                    TypeSubstitution typeSubstitution = (TypeSubstitution)logicalDesign.getDesign().getDesignObject(string);
                    if (typeSubstitution == null) {
                        typeSubstitution = logicalDesign.createTypeSubstitution(string);
                    }
                    String string4 = element3.getAttribute("view_id_child");
                    String string5 = element3.getAttribute("view_id_parent");
                    if (!string4.equals("null")) {
                        typeSubstitution.setChildCV((ContainerView)containerObject2.getTopViewByID(designPartView, string4));
                    }
                    if (!string5.equals("null")) {
                        typeSubstitution.setParentCV((ContainerView)containerObject.getTopViewByID(designPartView, string4));
                    }
                    Element element4 = RXMLLogicalDesign.getFirstChildByTagName(element3, "points");
                    NodeList nodeList2 = element4.getElementsByTagName("point");
                    int n2 = nodeList2.getLength();
                    TVTypeSubstitution tVTypeSubstitution = (TVTypeSubstitution)typeSubstitution.getTopView();
                    for (int j = 0; j < n2; ++j) {
                        object3 = (Element)nodeList2.item(j);
                        object2 = object3.getAttribute("x_coordinate");
                        String string6 = object3.getAttribute("y_coordinate");
                        tVTypeSubstitution.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble((String)object2), Double.parseDouble(string6)));
                    }
                    Element element5 = RXMLLogicalDesign.getFirstChildByTagName(element3, "graphical");
                    if (element5 == null) continue;
                    object3 = element5.getElementsByTagName("parameter");
                    object2 = new HashMap();
                    int n3 = object3.getLength();
                    for (int j = 0; j < n3; ++j) {
                        Element element6 = (Element)object3.item(j);
                        object2.put(element6.getAttribute("name"), element6.getAttribute("value"));
                    }
                    String string7 = (String)object2.get("use_default_color");
                    boolean bl = true;
                    if (string7 != null) {
                        bl = Boolean.valueOf(string7);
                    }
                    tVTypeSubstitution.setUseDefaultColor(bl);
                    if (bl) continue;
                    String string8 = (String)object2.get("color");
                    if (string8 != null && !"null".equalsIgnoreCase(string8)) {
                        object = new Color(Integer.parseInt(string8));
                        tVTypeSubstitution.setBackgroundColor((Color)object);
                    }
                    if ((object = (String)object2.get("width")) == null || "null".equalsIgnoreCase((String)object)) continue;
                    int n4 = Integer.parseInt((String)object);
                    tVTypeSubstitution.setLineWidth(n4);
                }
            }
        }
    }

    private void updateKeysElements(LogicalDesign logicalDesign) {
        Iterator iterator = logicalDesign.getGlobalCandidateKeySet().iterator();
        while (iterator.hasNext()) {
            CandidateKey candidateKey = (CandidateKey)iterator.next();
            candidateKey.updateContainedObjects();
        }
    }

    static {
        NFS = 2.4f;
        LOGGER = new Logger(RXMLLogicalDesign.class);
    }
}

