/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLForeignKey
extends AbstractRXMLDesignObject {
    public RXMLForeignKey(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        FKIndexAssociation fKIndexAssociation = new FKIndexAssociation(design.getRelationalDesign());
        fKIndexAssociation.setObjectID(StringUtilities.decodeAttributeValue(string));
        return fKIndexAssociation;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            stringBuffer.append(string).append('/');
            if (this.isOldDesign()) {
                String string2 = this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getObjectID();
                stringBuffer.append("relational").append('/').append(StringUtilities.decodeAttributeValue(string2)).append('/');
            } else {
                String string3 = this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getPathIDString();
                stringBuffer.append("rel").append('/').append(string3).append('/');
            }
        }
        stringBuffer.append(this.getConfiguration().get("fkeyPath"));
        return stringBuffer.toString();
    }

    @Override
    protected void readObjectInfo(Element element, ModelIDObject modelIDObject, boolean bl) {
        if (modelIDObject instanceof FKIndexAssociation) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)modelIDObject;
            String string = element.getAttribute("tableid");
            String string2 = element.getAttribute("reftableid");
            String string3 = element.getAttribute("references");
            String string4 = element.getAttribute("localindexid");
            String string5 = element.getAttribute("delrule");
            String string6 = element.getAttribute("mandatory");
            String string7 = element.getAttribute("transferable");
            Table table = (Table)modelIDObject.getDesign().getDesignObject(string);
            Table table2 = (Table)modelIDObject.getDesign().getDesignObject(string2);
            if (table != null && table2 != null) {
                Index index = (Index)table2.getKeyObject(string3);
                table.recreateFK(fKIndexAssociation, index, string4, string5);
                if (string6 != null && "true".equalsIgnoreCase(string6)) {
                    fKIndexAssociation.setMandatory(true);
                } else if ("".equals(string6)) {
                    fKIndexAssociation.resetMandatoryUsingColumns();
                } else {
                    fKIndexAssociation.setMandatory(false);
                }
                if (string7 != null && ("true".equalsIgnoreCase(string7) || "".equals(string7))) {
                    fKIndexAssociation.setTransferable(true);
                } else {
                    fKIndexAssociation.setTransferable(false);
                }
                fKIndexAssociation.resetEdgeParams();
            }
        }
    }

    @Override
    public Object recreateObject(Element element, Design design, boolean bl) {
        FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)super.recreateObject(element, design, bl);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(fKIndexAssociation.getObjectID())).append(".dmd");
        fKIndexAssociation.setFilePath(stringBuffer.toString());
        return fKIndexAssociation;
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == FKIndexAssociation.class;
    }
}

