/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.persistence.xml.RXMLRDBMSSiteSet;
import oracle.dbtools.crest.model.persistence.xml.XMLConstants;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RXMLDefaultRDBMSSiteSet
implements XMLConstants {
    private static final Logger LOGGER = new Logger(RXMLRDBMSSiteSet.class);

    public Object readDefaultRDBMSSites(String string, Design design) {
        return this.readDefaultRDBMSSites(string, design, new RDBMSSiteSet(design));
    }

    public Object readDefaultRDBMSSites(String string, Design design, RDBMSSiteSet rDBMSSiteSet) {
        File file = new File(string);
        try {
            if (file.exists()) {
                RDBMSTypeSet rDBMSTypeSet;
                FileInputStream fileInputStream = new FileInputStream(file);
                InputSource inputSource = new InputSource(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputSource);
                if (design != null) {
                    rDBMSTypeSet = design.getDefaultRDBMSTypeSet();
                } else {
                    rDBMSTypeSet = new RDBMSTypeSet();
                    LOGGER.error("recreateObject(...): RDBMSTypeSet NOT from model, Design or Model was null");
                }
                Element element = document.getDocumentElement();
                NodeList nodeList = element.getElementsByTagName("site");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    RDBMSSite rDBMSSite = this.recreateSite((Element)nodeList.item(i), rDBMSSiteSet, rDBMSTypeSet);
                    if (rDBMSSite == null) continue;
                    hashMap.put(rDBMSSite.getObjectID(), rDBMSSite.getName());
                }
                Object[] objectArray = rDBMSSiteSet.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    RDBMSSite rDBMSSite = (RDBMSSite)objectArray[i];
                    if (rDBMSSite.isDesignLevel() || hashMap.get(rDBMSSite.getObjectID()) != null) continue;
                    rDBMSSiteSet.remove(rDBMSSite);
                }
                return rDBMSSiteSet;
            }
        }
        catch (Exception exception) {
            LOGGER.error(exception);
        }
        return rDBMSSiteSet;
    }

    private void removeUnexistingSites(RDBMSSiteSet rDBMSSiteSet, Set<String> set) {
        HashSet<RDBMSSite> hashSet = new HashSet<RDBMSSite>();
        Collection collection = rDBMSSiteSet.getValueSet();
        for (RDBMSSite rDBMSSite : collection) {
            if (set.contains(rDBMSSite.getObjectID())) continue;
            hashSet.add(rDBMSSite);
        }
        if (!hashSet.isEmpty()) {
            rDBMSSiteSet.removeAll(hashSet);
        }
    }

    public RDBMSSite recreateSite(Element element, RDBMSSiteSet rDBMSSiteSet, RDBMSTypeSet rDBMSTypeSet) {
        String string = this.getEncoded(element, "name");
        String string2 = element.getAttribute("type");
        String string3 = this.getEncoded(element, "oid");
        String string4 = element.getAttribute("pathid");
        RDBMSSite rDBMSSite = rDBMSSiteSet.getByObjectID(string3);
        if (rDBMSSite != null) {
            rDBMSSite.setName(string);
            rDBMSSite.setIsDefault(true);
            rDBMSSite.setDesignLevel(false);
            return rDBMSSite;
        }
        rDBMSSite = rDBMSSiteSet.createSite(string, rDBMSSiteSet.getDesign());
        rDBMSSite.setIsDefault(true);
        rDBMSSite.setDesignLevel(false);
        int n = 8;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        RDBMSType rDBMSType = rDBMSTypeSet.get(n);
        rDBMSSite.setType(rDBMSType);
        rDBMSSite.setObjectID(string3);
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 > 0) {
            rDBMSSite.setPathID(n2);
            rDBMSSiteSet.updateMaxIndex(n2);
        } else {
            rDBMSSite.setPathID(rDBMSSiteSet.nextIndex());
        }
        if (rDBMSType == null) {
            LOGGER.error("Unknown RDBMS type: " + n);
        }
        return rDBMSSite;
    }

    private String getEncoded(Element element, String string) {
        return StringUtilities.decodeAttributeValue(element.getAttribute(string));
    }
}

