/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RXMLChangeRequest
extends AbstractRXMLDesignObject {
    public RXMLChangeRequest(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    protected DesignObject instantiateDesignObject(String string, Design design, Element element) {
        ChangeRequest changeRequest = new ChangeRequest(design.getLogicalDesign());
        changeRequest.setObjectID(StringUtilities.decodeAttributeValue(string));
        changeRequest.setDesign(design);
        design.getChangeRequestSet().add(changeRequest);
        design.addDesignObject(changeRequest);
        return changeRequest;
    }

    @Override
    public Object recreateDesign(Document document, DesignPart designPart, boolean bl) {
        return null;
    }

    @Override
    protected void readObjectInfo(Element element, ModelIDObject modelIDObject, boolean bl) {
        if (modelIDObject instanceof ChangeRequest) {
            String string;
            Node node;
            ChangeRequest changeRequest = (ChangeRequest)modelIDObject;
            Element element2 = RXMLChangeRequest.getFirstChildByTagName(element, "reason");
            if (element2 != null && (node = element2.getFirstChild()) != null && (string = node.getNodeValue()) != null) {
                changeRequest.setReason(StringUtilities.decodeAttributeValue(string));
            }
            if ((element2 = RXMLChangeRequest.getFirstChildByTagName(element, "status")) != null && (node = element2.getFirstChild()) != null && (string = node.getNodeValue()) != null) {
                changeRequest.setStatus(string);
            }
            if ((element2 = RXMLChangeRequest.getFirstChildByTagName(element, "completed")) != null && (node = element2.getFirstChild()) != null && (string = node.getNodeValue()) != null) {
                changeRequest.setCompleted(Boolean.valueOf(string));
            }
            if ((element2 = RXMLChangeRequest.getFirstChildByTagName(element, "requestDate")) != null && (node = element2.getFirstChild()) != null && (string = node.getNodeValue()) != null) {
                changeRequest.setRequestDate(string);
            }
            if ((element2 = RXMLChangeRequest.getFirstChildByTagName(element, "completionDate")) != null && (node = element2.getFirstChild()) != null && (string = node.getNodeValue()) != null) {
                changeRequest.setCompletionDate(string);
            }
            if ((element2 = RXMLChangeRequest.getFirstChildByTagName(element, "implNote")) != null && (node = element2.getFirstChild()) != null && (string = node.getNodeValue()) != null) {
                changeRequest.setImplDescription(string);
            }
        }
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String string = this.getPersistenceManager().getAppView().getDesignName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append('/').append("changerequest");
            return stringBuffer.toString();
        }
        return "changerequest";
    }

    @Override
    public boolean isReaderForClass(Class clazz) {
        return clazz == ChangeRequest.class;
    }
}

