/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.ObjectChange;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DLDomains;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.RLDomains;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLHandler;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class AbstractXMLWriter
extends AbstractXMLHandler {
    private AbstractXMLWriter successor;
    private static final Logger LOGGER = new Logger(AbstractXMLWriter.class);

    public AbstractXMLWriter(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    @Override
    public abstract boolean canWrite(Object var1);

    @Override
    public final boolean canRead(String string) {
        return false;
    }

    public boolean write(Object object) {
        try {
            Document document = this.writeDocument(object);
            if (document != null) {
                this.getPersistenceManager().storeDocument(document, this.getRelativePath(object), this.getFilenameFor(object), this);
                if (this.getPersistenceManager().getAppView().getCurrentOperation() != 5) {
                    ModelIDObject modelIDObject;
                    if (object instanceof ModelIDObject && (modelIDObject = (ModelIDObject)object).getFilePath() == null) {
                        String string = this.getPersistenceManager().getDesignLocation() + "/" + this.getRelativePath(object) + "/" + this.getFilenameFor(object) + ".xml";
                        modelIDObject.setFilePath(string);
                    }
                    if (object instanceof ModelIDObject) {
                        ((ModelIDObject)object).setDirty(false);
                    }
                }
            }
            return true;
        }
        catch (Exception exception) {
            this.getPersistenceManager().setSaveFailed(true);
            exception.printStackTrace();
            LOGGER.error("Unable to save object: " + object, exception);
            return false;
        }
    }

    public String getDocumentAsString(Object object) {
        Document document = this.writeDocument(object);
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.prettyPrint(document, stringBuffer);
        return string;
    }

    public Document getDocument(Object object) {
        Document document = this.writeDocument(object);
        return document;
    }

    public final boolean handleWrite(Object object) {
        AbstractXMLWriter abstractXMLWriter = this.getWriterFor(object);
        if (abstractXMLWriter != null) {
            return abstractXMLWriter.write(object);
        }
        return false;
    }

    public AbstractXMLWriter getWriterFor(Object object) {
        if (object instanceof RLDomains || object instanceof DLDomains) {
            return null;
        }
        if (this.canWrite(object)) {
            return this;
        }
        AbstractXMLWriter abstractXMLWriter = this.getSuccessor();
        if (abstractXMLWriter != null) {
            return abstractXMLWriter.getWriterFor(object);
        }
        LOGGER.error("No writer for: " + object.getClass());
        return null;
    }

    public abstract Document writeDocument(Object var1);

    public abstract String getFilenameFor(Object var1);

    public void setSuccessor(AbstractXMLWriter abstractXMLWriter) {
        this.successor = abstractXMLWriter;
    }

    public AbstractXMLWriter getSuccessor() {
        return this.successor;
    }

    public AbstractXMLWriter getLast() {
        if (this.getSuccessor() == null) {
            return this;
        }
        return this.getSuccessor().getLast();
    }

    protected Element createElement(Element element, String string) {
        Element element2 = element.getOwnerDocument().createElement(string);
        element.appendChild(element2);
        return element2;
    }

    protected Element createParameterElement(Element element, String string, String string2) {
        Element element2 = this.createElement(element, "parameter");
        element2.setAttribute("name", string);
        element2.setAttribute("value", string2);
        return element2;
    }

    protected void appendTextNode(Element element, String string) {
        Text text = element.getOwnerDocument().createTextNode(string);
        element.appendChild(text);
    }

    protected void appendMainDisplay(Element element, DesignPartView designPartView) {
        if (designPartView.isMasterDPV()) {
            this.appendDisplay(element, designPartView);
        }
    }

    protected void appendSubordinateDisplays(Element element, DesignPartView designPartView) {
        if (designPartView.isMasterDPV()) {
            Document document = element.getOwnerDocument();
            Element element2 = document.createElement("subordinate_displays");
            for (DesignPartView designPartView2 : designPartView.getSubordinateViews()) {
                this.appendDisplay(element2, designPartView2);
            }
            element.appendChild(element2);
        }
    }

    protected void appendDisplay(Element element, DesignPartView designPartView) {
        TopView topView;
        int n;
        Document document = element.getOwnerDocument();
        Element element2 = designPartView.isMasterDPV() ? document.createElement("main_display") : document.createElement("subordinate_display");
        element2.setAttribute("name", StringUtilities.encodeAttributeValue(designPartView.getName()));
        element2.setAttribute("objectid", designPartView.getDPVId());
        this.appendDisplayProperties(element2, designPartView);
        Object[] objectArray = designPartView.getTopviewsList().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            topView = (TopView)objectArray[n];
            if (topView.isConnection() || !(topView instanceof ContainerView)) continue;
            this.appendObjectReprElement(element2, topView);
        }
        for (n = 0; n < objectArray.length; ++n) {
            topView = (TopView)objectArray[n];
            if (!topView.isConnection() || !topView.isConnection() || !(topView.getModel() instanceof ConnectionInterface) || !(topView instanceof TVConnector)) continue;
            this.appendConnectorInfo(element2, (TVConnector)topView);
        }
        this.addDiagramViewsInDPV(designPartView.getDesignPart(), element2, designPartView);
        ModelIDObject modelIDObject = designPartView.isMasterDPV() ? designPartView.getDesignPart() : designPartView.getPlaceHolder();
        if (modelIDObject != null) {
            element2.setAttribute("comment", StringUtilities.encodeAttributeValue(modelIDObject.getComment()));
            element2.setAttribute("notes", StringUtilities.encodeAttributeValue(modelIDObject.getNotes()));
            this.appendChange(element2, modelIDObject.getCreation(), "created");
            this.appendChange(element2, modelIDObject.getChange(), "changed");
        }
        element.appendChild(element2);
    }

    private void appendObjectReprElement(Element element, TopView topView) {
        Document document = element.getOwnerDocument();
        DesignObject designObject = topView.getModel();
        Element element2 = document.createElement("objectid");
        element2.setAttribute("role", "represents");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        element2.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        element2.setAttribute("viewid", StringUtilities.encodeAttributeValue(topView.getViewID()));
        element2.setAttribute("tv_generator_id", StringUtilities.encodeAttributeValue(topView.getGeneratorID()));
        element2.setAttribute("viewnumber", String.valueOf(topView.getViewNumber()));
        this.appendGraphInfo(element2, topView);
        element.appendChild(element2);
    }

    private void appendGraphInfo(Element element, TopView topView) {
        ApplicationView applicationView = topView.getApplicationView();
        if (applicationView != null) {
            Element element2 = element.getOwnerDocument().createElement("graphical");
            Map map = applicationView.getGraphicalPropsFor(topView);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Element element3 = element.getOwnerDocument().createElement("parameter");
                element2.appendChild(element3);
                String string = (String)iterator.next();
                element3.setAttribute("name", string);
                element3.setAttribute("value", (String)map.get(string));
            }
            element.appendChild(element2);
        }
    }

    private void appendConnectorInfo(Element element, TVConnector tVConnector) {
        block15: {
            try {
                Object object;
                Object object2;
                int n;
                Object object3;
                Object object4;
                Document document = element.getOwnerDocument();
                ConnectionInterface connectionInterface = (ConnectionInterface)((Object)tVConnector.getModel());
                DesignPartView designPartView = tVConnector.getDesignPartView();
                if (tVConnector == null || connectionInterface.getSourceTopView(designPartView) == null || connectionInterface.getTargetTopView(designPartView) == null) break block15;
                Element element2 = document.createElement("objectid");
                element2.setAttribute("role", "represents");
                element2.setAttribute("type", StringUtilities.encodeAttributeValue(((DesignObject)((Object)connectionInterface)).getObjectTypeName()));
                element2.setAttribute("oid", StringUtilities.encodeAttributeValue(((DesignObject)((Object)connectionInterface)).getObjectID()));
                DesignObject designObject = connectionInterface.getSourceObject();
                DesignObject designObject2 = connectionInterface.getTargetObject();
                if (designObject != null) {
                    element2.setAttribute("source", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
                }
                if (designObject2 != null) {
                    element2.setAttribute("target", StringUtilities.encodeAttributeValue(designObject2.getObjectID()));
                }
                if (connectionInterface instanceof DTReference && (object4 = ((DTReference)connectionInterface).getTypeElement()) != null) {
                    element2.setAttribute("stelement", StringUtilities.encodeAttributeValue(((ModelIDObject)object4).getObjectID()));
                }
                element2.setAttribute("viewid_source", connectionInterface.getSourceTopView(designPartView) != null ? connectionInterface.getSourceTopView(designPartView).getViewID() : "null");
                element2.setAttribute("viewid_target", connectionInterface.getTargetTopView(designPartView) != null ? connectionInterface.getTargetTopView(designPartView).getViewID() : "null");
                object4 = document.createElement("points");
                if (tVConnector != null && tVConnector.getEdge() != null && tVConnector.getEdge().getCellView() != null) {
                    object3 = ((EdgeView)tVConnector.getEdge().getCellView()).getPoints();
                    for (n = 0; n < object3.size(); ++n) {
                        object2 = object3.get(n);
                        object = object2 instanceof PortView ? ((PortView)object2).getPoint() : (Point2D)object2;
                        if (object == null) continue;
                        Element element3 = document.createElement("point");
                        element3.setAttribute("x_coordinate", Double.toString(((Point2D)object).getX()));
                        element3.setAttribute("y_coordinate", Double.toString(((Point2D)object).getY()));
                        object4.appendChild(element3);
                    }
                } else if (tVConnector != null) {
                    object3 = tVConnector.getEdgePoints();
                    for (n = 0; n < object3.size(); ++n) {
                        object2 = object3.get(n);
                        object = object2 instanceof PortView ? ((PortView)object2).getPoint() : (Point2D)object2;
                        if (object == null) continue;
                        Element element4 = document.createElement("point");
                        element4.setAttribute("x_coordinate", Double.toString(((Point2D)object).getX()));
                        element4.setAttribute("y_coordinate", Double.toString(((Point2D)object).getY()));
                        object4.appendChild(element4);
                    }
                }
                element2.appendChild((Node)object4);
                object3 = tVConnector.getEdgeView();
                if (object3 != null) {
                    Element element5 = document.createElement("labels");
                    object2 = document.createElement("source");
                    object2.setAttribute("x_coordinate", Double.toString(tVConnector.getSourceLabelBounds().getX()));
                    object2.setAttribute("y_coordinate", Double.toString(tVConnector.getSourceLabelBounds().getY()));
                    object2.setAttribute("width", Double.toString(tVConnector.getSourceLabelBounds().getWidth()));
                    object2.setAttribute("height", Double.toString(tVConnector.getSourceLabelBounds().getHeight()));
                    element5.appendChild((Node)object2);
                    object = tVConnector.getLabel(0);
                    if (object != null) {
                        this.appendDesignObjectColor((Element)object2, (DesignObject)object);
                        this.appendDesignObjectFonts((Element)object2, (DesignObject)object);
                    }
                    object2 = document.createElement("target");
                    object2.setAttribute("x_coordinate", Double.toString(tVConnector.getTargetLabelBounds().getX()));
                    object2.setAttribute("y_coordinate", Double.toString(tVConnector.getTargetLabelBounds().getY()));
                    object2.setAttribute("width", Double.toString(tVConnector.getTargetLabelBounds().getWidth()));
                    object2.setAttribute("height", Double.toString(tVConnector.getTargetLabelBounds().getHeight()));
                    element5.appendChild((Node)object2);
                    object = tVConnector.getLabel(2);
                    if (object != null) {
                        this.appendDesignObjectColor((Element)object2, (DesignObject)object);
                        this.appendDesignObjectFonts((Element)object2, (DesignObject)object);
                    }
                    object2 = document.createElement("main_label");
                    object2.setAttribute("x_coordinate", Double.toString(tVConnector.getLabelBounds().getX()));
                    object2.setAttribute("y_coordinate", Double.toString(tVConnector.getLabelBounds().getY()));
                    object2.setAttribute("width", Double.toString(tVConnector.getLabelBounds().getWidth()));
                    object2.setAttribute("height", Double.toString(tVConnector.getLabelBounds().getHeight()));
                    element5.appendChild((Node)object2);
                    object = tVConnector.getLabel(1);
                    if (object != null) {
                        this.appendDesignObjectColor((Element)object2, (DesignObject)object);
                        this.appendDesignObjectFonts((Element)object2, (DesignObject)object);
                    }
                    element2.appendChild(element5);
                    Element element6 = document.createElement("graphical");
                    Element element7 = element2.getOwnerDocument().createElement("parameter");
                    element6.appendChild(element7);
                    element7.setAttribute("name", "use_default_color");
                    element7.setAttribute("value", Boolean.toString(tVConnector.useDefaultColor()));
                    if (!tVConnector.useDefaultColor()) {
                        element7 = element2.getOwnerDocument().createElement("parameter");
                        element6.appendChild(element7);
                        element7.setAttribute("name", "color");
                        element7.setAttribute("value", tVConnector.getBackgroundColor() != null ? Integer.toString(tVConnector.getBackgroundColor().getRGB()) : "null");
                        element7 = element2.getOwnerDocument().createElement("parameter");
                        element6.appendChild(element7);
                        element7.setAttribute("name", "width");
                        element7.setAttribute("value", Integer.toString(tVConnector.getLineWidth()));
                    }
                    element2.appendChild(element6);
                }
                element.appendChild(element2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void appendDisplayProperties(Element element, DesignPartView designPartView) {
        element.setAttribute("notation", Integer.toString(designPartView.getNotation()));
        element.setAttribute("show_all_details", Boolean.toString(designPartView.showAllDetails()));
        element.setAttribute("show_names_only", Boolean.toString(designPartView.isShowNamesOnly()));
        element.setAttribute("show_elements", Boolean.toString(designPartView.showElements()));
        element.setAttribute("show_datatype", Boolean.toString(designPartView.showDatatype()));
        element.setAttribute("show_keys", Boolean.toString(designPartView.showKeys()));
        element.setAttribute("auto_route", Boolean.toString(designPartView.isAutoRoute()));
        element.setAttribute("box_in_box", Boolean.toString(designPartView.isBoxInBox()));
    }

    protected void appendSubViews(Element element, DesignPart designPart) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("sub_views_collection");
        Iterator iterator = designPart.getDesignSubviews().iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            this.appendSubView(element2, designPartViewPlaceHolder, designPartViewPlaceHolder.getDesignPartView());
        }
        element.appendChild(element2);
    }

    protected void appendSubView(Element element, DesignPartViewPlaceHolder designPartViewPlaceHolder, DesignPartView designPartView) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("sub_view");
        element2.setAttribute("subview_name", StringUtilities.encodeAttributeValue(designPartView.getName()));
        element2.setAttribute("id", designPartView.getDPVId());
        element2.setAttribute("generator", designPartView.getGeneratorId());
        if (designPartViewPlaceHolder != null) {
            element2.setAttribute("visible", designPartViewPlaceHolder.getVisible() ? "true" : "false");
            element2.setAttribute("comment", StringUtilities.encodeAttributeValue(designPartViewPlaceHolder.getComment()));
            element2.setAttribute("notes", StringUtilities.encodeAttributeValue(designPartViewPlaceHolder.getNotes()));
        }
        String string = "sub_view";
        if (designPartView == designPartView.getDesignPart().getMainView()) {
            string = "main_view";
        }
        element2.setAttribute("sv_type", string);
        element2.setAttribute("generator", designPartView.getGeneratorId());
        element2.setAttribute("rep_oid", designPartView.getRepositoryOID());
        element2.setAttribute("rep_ovid", designPartView.getRepositoryOVID());
        element2.setAttribute("is_checkedout", String.valueOf(designPartView.isCheckedOut()));
        element2.setAttribute("checkedout_by", designPartView.getCheckedOutBy());
        if (designPartViewPlaceHolder != null) {
            this.appendChange(element2, designPartViewPlaceHolder.getCreation(), "created");
            this.appendChange(element2, designPartViewPlaceHolder.getChange(), "changed");
        }
        this.appendMainDisplay(element2, designPartView);
        this.appendSubordinateDisplays(element2, designPartView);
        element.appendChild(element2);
    }

    protected void appendDiagramViews(Document document, Element element, DesignPart designPart) {
        Element element2 = document.createElement("diagram_views");
        Design design = designPart.getDesign();
        Iterator iterator = designPart.getDiagramViewSet().iterator();
        while (iterator.hasNext()) {
            DesignPartView designPartView;
            DiagramView diagramView = (DiagramView)iterator.next();
            TopView topView = diagramView.getFirstViewForDPV(designPart.getMainView());
            if (topView == null || (designPartView = diagramView.getDesignPartView()) == null) continue;
            DesignPart designPart2 = designPartView.getDesignPart();
            if (design.shouldExportFull(designPart2)) {
                this.appendDiagramViewInfo(document, element2, diagramView);
                continue;
            }
            if (designPartView == designPart2.getMainView()) {
                if (!design.shouldExportPartial(designPart2)) continue;
                this.appendDiagramViewInfo(document, element2, diagramView);
                continue;
            }
            if (!design.shouldExportDPV(designPartView)) continue;
            this.appendDiagramViewInfo(document, element2, diagramView);
        }
        element.appendChild(element2);
    }

    private void addDiagramViewsInDPV(DesignPart designPart, Element element, DesignPartView designPartView) {
        Iterator iterator = designPart.getDiagramViewSet().iterator();
        while (iterator.hasNext()) {
            DiagramView diagramView = (DiagramView)iterator.next();
            TopView topView = diagramView.getFirstViewForDPV(designPartView);
            if (topView == null || topView.getCellView() == null) continue;
            this.appendDiagramViewInfo(element.getOwnerDocument(), element, diagramView, topView);
        }
    }

    protected void appendDiagramViewInfo(Document document, Element element, DiagramView diagramView) {
        this.appendDiagramViewInfo(document, element, diagramView, null);
    }

    protected void appendDiagramViewInfo(Document document, Element element, DiagramView diagramView, TopView topView) {
        Element element2 = document.createElement("diagram_view");
        element2.setAttribute("objectid", diagramView.getObjectID());
        element2.setAttribute("dpv_id", diagramView.getDpvID());
        element2.setAttribute("dpv_name", diagramView.getDpvName());
        element2.setAttribute("composite", String.valueOf(diagramView.isCompositeView()));
        if (topView != null) {
            this.appendGraphInfo(element2, topView);
        } else {
            TopView topView2 = diagramView.getTopView();
            if (topView2 != null) {
                this.appendGraphInfo(element2, topView2);
            }
        }
        element.appendChild(element2);
    }

    protected void appendNamingOptions(Document document, Element element, DesignPart designPart) {
        Element element2 = document.createElement("naming_options");
        for (NamingOptionsHolder namingOptionsHolder : designPart.getNamingOptionsHolderList()) {
            this.appendNamingOptionsInfo(document, element2, namingOptionsHolder);
        }
        element.appendChild(element2);
    }

    protected void appendNamingOptionsInfo(Document document, Element element, NamingOptionsHolder namingOptionsHolder) {
        Element element2 = document.createElement("naming_option");
        element2.setAttribute("class_name", namingOptionsHolder.getClassName().getName());
        element2.setAttribute("max_name_length", String.valueOf(namingOptionsHolder.getMaxNameLength()));
        element2.setAttribute("case_type", StringUtilities.encodeAttributeValue(String.valueOf(namingOptionsHolder.getCaseType())));
        element2.setAttribute("valid_characters", namingOptionsHolder.getValidChars());
        element2.setAttribute("all_valid", Boolean.toString(namingOptionsHolder.getIsValid()));
        element.appendChild(element2);
    }

    protected void appendDesignObjectColor(Element element, DesignObject designObject) {
        element.setAttribute("use_default_color", StringUtilities.encodeAttributeValue(String.valueOf(designObject.useDefaultColor())));
        element.setAttribute("background_color", designObject.getBackgroundColor() != null ? Integer.toString(designObject.getBackgroundColor().getRGB()) : "null");
        element.setAttribute("foreground_color", designObject.getForegroundColor() != null ? Integer.toString(designObject.getForegroundColor().getRGB()) : "null");
    }

    protected void appendDesignObjectFonts(Element element, DesignObject designObject) {
        if (designObject instanceof EditableFonts) {
            EditableFonts editableFonts = (EditableFonts)((Object)designObject);
            Element element2 = this.createElement(element, "fonts");
            for (FontObject fontObject : editableFonts.getEditableFonts()) {
                this.appendFontObjectInfo(element2, fontObject);
            }
        }
    }

    private void appendFontObjectInfo(Element element, FontObject fontObject) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("fo_type", fontObject.getType());
        treeMap.put("font_name", fontObject.getFont().getName());
        treeMap.put("font_style", String.valueOf(fontObject.getFont().getStyle()));
        treeMap.put("font_size", String.valueOf(fontObject.getFont().getSize()));
        treeMap.put("font_color", String.valueOf(fontObject.getColor().getRGB()));
        this.appendProperties(element, "font_object", treeMap);
    }

    protected void appendChange(Element element, ObjectChange objectChange, String string) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("alter");
        element2.setAttribute("type", StringUtilities.encodeAttributeValue(string));
        Element element3 = document.createElement("user");
        Text text = document.createTextNode(objectChange.getUser().getName());
        element3.appendChild(text);
        element2.appendChild(element3);
        element3 = document.createElement("timestamp");
        text = document.createTextNode(objectChange.getTimeString("UTC"));
        element3.appendChild(text);
        element2.appendChild(element3);
        element.appendChild(element2);
    }
}

