/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class AbstractWXMLModelIDObject
extends AbstractXMLWriter {
    public AbstractWXMLModelIDObject(XMLPersistenceManager xMLPersistenceManager) {
        super(xMLPersistenceManager);
    }

    protected Element appendObjectInfo(Document document, Element element, DesignObject designObject) {
        return this.appendObjectInfo(document, element, designObject, designObject.getObjectTypeName());
    }

    protected Element appendObjectInfo(Document document, Element element, ModelIDObject modelIDObject, String string) {
        String string2;
        modelIDObject.setPersisted(true);
        Element element2 = document.createElement("object");
        element2.setAttribute("type", string);
        element2.setAttribute("id", modelIDObject.getObjectID());
        element2.setAttribute("rep_oid", modelIDObject.getRepositoryOID());
        element2.setAttribute("rep_ovid", modelIDObject.getRepositoryOVID());
        element2.setAttribute("is_checkedout", String.valueOf(modelIDObject.isCheckedOut()));
        element2.setAttribute("checkedout_by", modelIDObject.getCheckedOutBy());
        if (!modelIDObject.hasOwnerDesignName() && modelIDObject.isWriteable()) {
            modelIDObject.setOwnerDesign();
        }
        Element element3 = document.createElement("name");
        Text text = document.createTextNode(StringUtilities.encodeAttributeValue(modelIDObject.getName()));
        element3.appendChild(text);
        element2.appendChild(element3);
        String string3 = modelIDObject.getComment();
        if (string3 != null) {
            element3 = document.createElement("comment");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string3));
            element3.appendChild(text);
            element2.appendChild(element3);
        }
        if ((string2 = modelIDObject.getNotes()) != null) {
            element3 = document.createElement("notes");
            text = document.createTextNode(StringUtilities.encodeAttributeValue(string2));
            element3.appendChild(text);
            element2.appendChild(element3);
        }
        this.appendChange(element2, modelIDObject.getCreation(), "created");
        this.appendChange(element2, modelIDObject.getChange(), "changed");
        String string4 = modelIDObject.getGeneratorID();
        if (!ModelIDObject.USER_GENERATED.equalsIgnoreCase(string4)) {
            element3 = document.createElement("generator");
            text = document.createTextNode(string4);
            element3.appendChild(text);
            element2.appendChild(element3);
        }
        element.appendChild(element2);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            stringBuffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        stringBuffer.append(this.getRelativePath()).append('/').append(modelIDObject.getObjectID()).append(".dmd");
        modelIDObject.setFilePath(stringBuffer.toString());
        return element2;
    }
}

