/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db.oracle;

import java.io.StringReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.DLDomains;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.RLDomains;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolder;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteria;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.RecordStructure;
import oracle.dbtools.crest.model.design.process.Role;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationFlow;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.persistence.ObjectTypes;
import oracle.dbtools.crest.model.persistence.PersistenceManager;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.db.oracle.CheckInOutManager;
import oracle.dbtools.crest.model.persistence.db.oracle.ReadManager;
import oracle.dbtools.crest.model.persistence.db.oracle.RepositoryFactory;
import oracle.dbtools.crest.model.persistence.db.oracle.WriteManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLHandler;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.RXMLDesign;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.editor.NewRepositoryDesignDialog;
import oracle.dbtools.crest.util.DBLoginDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.jdbc.OracleDriver;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class OracleRepositoryManager
extends AbstractRepositoryManager {
    private Map tableNames = new TreeMap();
    public static String T_TABLES = "DMR_TABLES";
    public static String T_PACKAGES = "DMR_PACKAGES";
    public static String T_PACKAGE_MEMBERS = "DMR_PACKAGE_MEMBERS";
    public static String T_REPOSITORY = "REPOSITORY";
    public static String T_VIEWS = "DMR_VIEWS";
    public static String T_ENTITIES = "DMR_ENTITIES";
    public static String T_RELATIONS = "DMR_RELATIONS";
    public static String T_HRELATIONS = "DMR_HRELATIONS";
    public static String T_ENTVIEWS = "DMR_ENTVIEWS";
    public static String T_FKEYS = "DMR_FKEYS";
    public static String T_ARC = "DMR_ARCS";
    public static String T_FKARC = "DMR_FKARCS";
    public static String T_USERS = "DMR_USERS";
    public static String T_OBJECT_REGISTER = "OBJECT_REGISTER";
    public static String T_LOGICAL_DATATYPES = "DMR_LOGICAL_DATATYPES";
    public static String T_RDBMS_SITES = "DMR_RDBMS_SITES";
    public static String T_DOMAINS = "DMR_DOMAINS";
    public static String T_XMAPPING = "DMR_MAPPINGS";
    public static String T_PHYSMODELS = "DMR_PHYSMODELS";
    public static String T_PHYSMODELS_MEMBERS = "DMR_PHYSMODELS_MEMBERS";
    public static String T_PM_OBJECT_REGISTER = "PM_OBJECT_REGISTER";
    public static String T_STRUCTURED_TYPES = "DMR_STRUCTUREDTYPES";
    public static String T_COLLECTION_TYPES = "DMR_COLLECTIONTYPES";
    public static String T_DISTINCT_TYPES = "DMR_DISTINCTTYPES";
    public static String T_PHYSICAL_OBJECTS = "DMR_PHYSICAL_OBJECTS";
    public static String T_SELECTION_CRITERIA = "DMR_SelectionCriterias";
    public static String T_LEVEL = "DMR_Levels";
    public static String T_ROLLUP_LINK = "DMR_RollupLinks";
    public static String T_RAGGED_HLINK = "DMR_RaggedHLinks";
    public static String T_DIMENSION = "DMR_Dimensions";
    public static String T_MEASURE = "DMR_Measures";
    public static String T_SLICE = "DMR_Slices";
    public static String T_FACT_ENTITIES_JOIN = "DMR_FactEntitiesJoins";
    public static String T_CUBE = "DMR_Cubes";
    public static String T_LINK = "DMR_Links";
    public static String T_HIERARCHY = "DMR_Hierarchies";
    public static String T_MEASURE_FOLDER = "DMR_MeasureFolders";
    public static String T_SQLACCESSTOAW = "DMR_SQLAccessToAWs";
    public static String T_RECORD_STRUCTURE = "DMR_RecordStructures";
    public static String T_EXTERNAL_DATA = "DMR_ExternalDatas";
    public static String T_EVENT = "DMR_Events";
    public static String T_INFO_STRUCTURE = "DMR_InfoStructures";
    public static String T_INFO_STORE = "DMR_InfoStores";
    public static String T_ROLE = "DMR_Roles";
    public static String T_TRANSFORMATION_PACKAGE = "DMR_TransformationPackages";
    public static String T_PROCESS = "DMR_Processes";
    public static String T_EXTERNAL_AGENT = "DMR_ExternalAgents";
    public static String T_FLOW = "DMR_Flows";
    public static String T_TRANSFORMATION = "DMR_Transformations";
    public static String T_TRANSFORMATION_FLOW = "DMR_TransformationFlows";
    public static String T_BI_EMAILS = "DMR_BIEmails".toUpperCase();
    public static String T_BI_LOCATIONS = "DMR_BILocations".toUpperCase();
    public static String T_BI_PHONES = "DMR_BIPhones".toUpperCase();
    public static String T_BI_RESOURCE_LOCATORS = "DMR_BIResourceLocators".toUpperCase();
    public static String T_BI_CONTACTS = "DMR_BIContacts".toUpperCase();
    public static String T_BI_RESPONSIBLE_PARTYS = "DMR_BIResponsibleParties".toUpperCase();
    public static String T_BI_DOCUMENTS = "DMR_BIDocuments".toUpperCase();
    public static String T_NOTES = "DMR_Notes".toUpperCase();
    public static String T_CHANGE_REQUESTS = "DMR_ChangeRequests".toUpperCase();
    public static String T_DL_SETTINGS = "DMR_DL_Settings".toUpperCase();
    private RepositoryFactory repositoryFactory;
    private CheckInOutManager checkInOutManager;
    private ReadManager readManager;
    private WriteManager writeManager;
    private String lastError = "";
    private static final Logger LOGGER = new Logger(OracleRepositoryManager.class);

    public OracleRepositoryManager(Design design) {
        super(design);
        this.initTableNames();
    }

    public OracleRepositoryManager(String string, String string2, String string3, Design design) {
        super(string, string2, string3, design);
        this.initTableNames();
    }

    private void initTableNames() {
        this.tableNames.put(ObjectTypes.TABLE, T_TABLES);
        this.tableNames.put(ObjectTypes.LOGICAL_MODEL, T_PACKAGES);
        this.tableNames.put(ObjectTypes.RELATIONAL_MODEL, T_PACKAGES);
        this.tableNames.put(ObjectTypes.REL_VIEW, T_VIEWS);
        this.tableNames.put(ObjectTypes.DESIGN, T_PACKAGES);
        this.tableNames.put(ObjectTypes.ENTITY, T_ENTITIES);
        this.tableNames.put(ObjectTypes.ENTVIEW, T_ENTVIEWS);
        this.tableNames.put(ObjectTypes.RELATION, T_RELATIONS);
        this.tableNames.put(ObjectTypes.HRELATION.toUpperCase(), T_HRELATIONS);
        this.tableNames.put(ObjectTypes.ARC, T_ARC);
        this.tableNames.put(ObjectTypes.FKARC, T_FKARC);
        this.tableNames.put(ObjectTypes.SUBVIEW, T_PACKAGES);
        this.tableNames.put(ObjectTypes.MAINVIEW, T_PACKAGES);
        this.tableNames.put(ObjectTypes.FKEY, T_FKEYS);
        this.tableNames.put(ObjectTypes.XMAPPING, T_XMAPPING);
        this.tableNames.put(ObjectTypes.FKINDEXASSOCIATION, T_FKEYS);
        this.tableNames.put(ObjectTypes.LOGICAL_DATATYPES, T_LOGICAL_DATATYPES);
        this.tableNames.put(ObjectTypes.RDBMS_SITES, T_RDBMS_SITES);
        this.tableNames.put(ObjectTypes.DOMAIN, T_DOMAINS);
        this.tableNames.put(ObjectTypes.PHYSOBJECT, T_PHYSICAL_OBJECTS);
        this.tableNames.put(ObjectTypes.STORAGEOBJECT, T_PHYSICAL_OBJECTS);
        this.tableNames.put(ObjectTypes.PHYSMODEL, T_PHYSMODELS);
        this.tableNames.put(ObjectTypes.STRUCTUREDTYPE, T_STRUCTURED_TYPES);
        this.tableNames.put(ObjectTypes.COLLECTIONTYPE, T_COLLECTION_TYPES);
        this.tableNames.put(ObjectTypes.DISTINCTTYPE, T_DISTINCT_TYPES);
        this.tableNames.put(ObjectTypes.SELECTION_CRITERIA, T_SELECTION_CRITERIA);
        this.tableNames.put(ObjectTypes.LEVEL, T_LEVEL);
        this.tableNames.put(ObjectTypes.ROLLUP_LINK, T_ROLLUP_LINK);
        this.tableNames.put(ObjectTypes.RAGGED_HLINK, T_RAGGED_HLINK);
        this.tableNames.put(ObjectTypes.DIMENSION, T_DIMENSION);
        this.tableNames.put(ObjectTypes.MEASURE, T_MEASURE);
        this.tableNames.put(ObjectTypes.SLICE, T_SLICE);
        this.tableNames.put(ObjectTypes.FACT_ENTITIES_JOIN, T_FACT_ENTITIES_JOIN);
        this.tableNames.put(ObjectTypes.CUBE, T_CUBE);
        this.tableNames.put(ObjectTypes.LINK, T_LINK);
        this.tableNames.put(ObjectTypes.HIERARCHY, T_HIERARCHY);
        this.tableNames.put(ObjectTypes.MEASURE_FOLDER, T_MEASURE_FOLDER);
        this.tableNames.put(ObjectTypes.SQLACCESSTOAW, T_SQLACCESSTOAW);
        this.tableNames.put(ObjectTypes.RECORD_STRUCTURE, T_RECORD_STRUCTURE);
        this.tableNames.put(ObjectTypes.EXTERNAL_DATA, T_EXTERNAL_DATA);
        this.tableNames.put(ObjectTypes.EVENT, T_EVENT);
        this.tableNames.put(ObjectTypes.INFO_STRUCTURE, T_INFO_STRUCTURE);
        this.tableNames.put(ObjectTypes.INFO_STORE, T_INFO_STORE);
        this.tableNames.put(ObjectTypes.ROLE, T_ROLE);
        this.tableNames.put(ObjectTypes.TRANSFORMATION_PACKAGE, T_PACKAGES);
        this.tableNames.put(ObjectTypes.PROCESS, T_PROCESS);
        this.tableNames.put(ObjectTypes.EXTERNAL_AGENT, T_EXTERNAL_AGENT);
        this.tableNames.put(ObjectTypes.FLOW, T_FLOW);
        this.tableNames.put(ObjectTypes.TRANSFORMATION, T_TRANSFORMATION);
        this.tableNames.put(ObjectTypes.TRANSFORMATION_FLOW, T_TRANSFORMATION_FLOW);
        this.tableNames.put(ObjectTypes.BI_EMAIL, T_BI_EMAILS);
        this.tableNames.put(ObjectTypes.BI_LOCATION, T_BI_LOCATIONS);
        this.tableNames.put(ObjectTypes.BI_PHONE, T_BI_PHONES);
        this.tableNames.put(ObjectTypes.BI_RESOURCE_LOCATOR, T_BI_RESOURCE_LOCATORS);
        this.tableNames.put(ObjectTypes.BI_CONTACT, T_BI_CONTACTS);
        this.tableNames.put(ObjectTypes.BI_RESPONSIBLE_PARTY, T_BI_RESPONSIBLE_PARTYS);
        this.tableNames.put(ObjectTypes.BI_DOCUMENT, T_BI_DOCUMENTS);
        this.tableNames.put(ObjectTypes.NOTE, T_NOTES);
        this.tableNames.put(ObjectTypes.CHANGE_REQUEST, T_CHANGE_REQUESTS);
    }

    @Override
    public boolean canUpgradeRepository() {
        return false;
    }

    @Override
    public void connect() {
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            boolean bl = true;
            String string = this.user;
            String string2 = this.password;
            if (string == null || "".equalsIgnoreCase(string) || this.password == null || "".equalsIgnoreCase(this.password)) {
                DBLoginDialog dBLoginDialog = new DBLoginDialog();
                if (dBLoginDialog.showDialog(string)) {
                    string = dBLoginDialog.getUserName();
                    this.password = dBLoginDialog.getPassword();
                } else {
                    bl = false;
                }
            }
            if (bl) {
                this.connection = DriverManager.getConnection(this.connectionURL, string, string2);
            }
        }
        catch (SQLException sQLException) {
            String string;
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = sQLException.getMessage()) == null || "".equalsIgnoreCase(string)) {
                string = "Error occured while connecting to repository.";
            }
            MessageDialogs.showErrorMessage(string);
        }
    }

    @Override
    protected void readRepositoryDetails() {
        super.readRepositoryDetails();
    }

    @Override
    public void dropRepository() {
        this.getRepositoryFactory().dropRepository(this.getConnection());
    }

    @Override
    public void upgradeRepository() {
        this.getRepositoryFactory().upgradeRepository(this.getConnection());
    }

    private AbstractXMLWriter getXMLWriter(Object object) {
        if (object instanceof Domain) {
            return this.getDesign().getAppView().getPersistenceManager().getDomainWriter();
        }
        if (object instanceof StorageObject) {
            StorageDesign storageDesign = ((StorageObject)object).getStorageDesign();
            AbstractXMLWriter abstractXMLWriter = this.getDesign().getAppView().getPersistenceManager().getWriterFor(storageDesign);
            if (abstractXMLWriter != null) {
                return abstractXMLWriter.getWriterFor(object);
            }
        }
        return this.getDesign().getAppView().getPersistenceManager().getWriterFor(object);
    }

    public String getXML(Object object) {
        AbstractXMLWriter abstractXMLWriter;
        if (object instanceof DesignPartView && (abstractXMLWriter = this.getDesign().getAppView().getPersistenceManager().getDesignPartViewWriter()) != null) {
            return abstractXMLWriter.getDocumentAsString(object);
        }
        if (object instanceof LogicalDatatypeSet && (abstractXMLWriter = this.getDesign().getAppView().getPersistenceManager().getLogicalTypesWriter()) != null) {
            return abstractXMLWriter.getDocumentAsString(((LogicalDatatypeSet)object).getLogicalDataTypes());
        }
        if (object instanceof RDBMSSiteSet && (abstractXMLWriter = this.getDesign().getAppView().getPersistenceManager().getRDBMSWriter()) != null) {
            return abstractXMLWriter.getDocumentAsString(object);
        }
        abstractXMLWriter = this.getXMLWriter(object);
        if (abstractXMLWriter != null) {
            return abstractXMLWriter.getDocumentAsString(object);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDesign(Design design) {
        if (this.isConnected()) {
            try {
                ProgressDialog progressDialog = new ProgressDialog(design.getAppView(), "", 0, 100);
                try {
                    RepositoryObject repositoryObject;
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    this.getDesign().getAppView().getPersistenceManager().setReadMode(PersistenceManager.READ_MODE_DATABASE);
                    if (!design.isLoadFromDB()) {
                        AbstractRepositoryManager.INITIAL_WRITE_TODB = true;
                    }
                    TimeLog.log();
                    progressDialog.setNote("Saving Repository Level Domains...");
                    progressDialog.setProgress(5);
                    progressDialog.setNote("Saving Design...");
                    progressDialog.setProgress(10);
                    boolean bl = false;
                    if (design.getRepositoryOID() == null) {
                        bl = true;
                        object4 = design.getName();
                        object3 = design.getComment();
                        try {
                            object2 = new NewRepositoryDesignDialog(design.getAppView(), (String)object4);
                            ((NewRepositoryDesignDialog)object2).showDialog();
                            object = ((NewRepositoryDesignDialog)object2).getName();
                            String string = ((NewRepositoryDesignDialog)object2).getDescription();
                            design.setName((String)object);
                            design.setComment(string);
                            this.getWriteManager().writePackageRecord(design.getObjectTypeName(), design);
                        }
                        finally {
                            design.setName((String)object4);
                            design.setComment((String)object3);
                        }
                    }
                    this.writeDLDomains(design);
                    object4 = this.writeChangeRequests(design);
                    object3 = new ArrayList(object4);
                    object2 = design.getStorableDesignParts();
                    object = object2.iterator();
                    int n = 20;
                    while (object.hasNext()) {
                        repositoryObject = (DesignPart)object.next();
                        progressDialog.setNote("Saving Model: " + ((ModelObject)((Object)repositoryObject)).getName());
                        progressDialog.setProgress(n);
                        if (bl || design.isCheckedOutByMe()) {
                            if (((ModelIDObject)repositoryObject).getRepositoryOID() == null) {
                                object3.add(repositoryObject);
                            }
                            this.writeDesignPart((DesignPart)repositoryObject);
                        }
                        n += 10;
                    }
                    progressDialog.setNote("Saving Finishing...");
                    progressDialog.setProgress(n);
                    repositoryObject = design.getExtendedMap();
                    this.getWriteManager().writeXMap((ExtendedMap)repositoryObject);
                    List list = design.getDesignPartsToDeleteFromRepository();
                    if (bl) {
                        object2.add(repositoryObject);
                        object2.addAll(object4);
                        this.getWriteManager().writePackageMembers(design.getRepositoryOID(), design.getRepositoryOVID(), (List)object2);
                    } else {
                        if (object3.size() > 0) {
                            this.getWriteManager().writePackageMembers(design.getRepositoryOID(), design.getRepositoryOVID(), (List)object3);
                        }
                        if (design.isCheckedOutByMe()) {
                            this.getWriteManager().removeDeleted(list, design.getRepositoryOVID(), false);
                        }
                    }
                    if (!bl && design.isDirty() && design.isCheckedOutByMe()) {
                        this.getWriteManager().updatePackageRecord(design.getObjectTypeName(), design);
                    }
                    this.writeDesignLevelSettings(design);
                    design.createDP_RepositoryMap();
                    design.setDirty(false);
                    design.setLoadFromDB(true);
                }
                finally {
                    progressDialog.close();
                    this.getDesign().getAppView().getPersistenceManager().setReadMode(PersistenceManager.READ_MODE_FILESYTEM);
                    AbstractRepositoryManager.INITIAL_WRITE_TODB = false;
                    TimeLog.log();
                }
            }
            catch (SQLException sQLException) {
                this.lastError = sQLException.toString();
                LOGGER.error("OracleRepositoryManager.checkInObject():\n" + this.lastError + "\n", sQLException);
            }
        }
    }

    public void writeLogicalDatatypes(Design design) {
        LogicalDatatypeSet logicalDatatypeSet = design.getLogicalDatatypeSet();
        if (logicalDatatypeSet.getRepositoryOID() == null) {
            this.initPackageObject(logicalDatatypeSet);
        }
        this.getWriteManager().writeRepSet(logicalDatatypeSet);
    }

    public void writeRDBMSSites(Design design) {
        RDBMSSiteSet rDBMSSiteSet = design.getRDBMSSiteSet();
        rDBMSSiteSet.setSaveDefaults(true);
        if (rDBMSSiteSet.getRepositoryOID() == null) {
            this.initPackageObject(rDBMSSiteSet);
        }
        this.getWriteManager().writeRepSet(rDBMSSiteSet);
    }

    public void writeRLDomains(Design design) {
        RLDomains rLDomains = design.getRLDomains();
        boolean bl = true;
        if (rLDomains.getRepositoryOID() == null) {
            bl = this.initDomainObject(rLDomains);
        }
        if (bl) {
            this.getWriteManager().writeDomains(rLDomains);
        }
    }

    private void writeDLDomains(Design design) {
        DLDomains dLDomains = design.getDLDomains();
        boolean bl = true;
        if (dLDomains.getRepositoryOID() == null) {
            bl = this.initDLDomains(dLDomains);
        }
        if (bl) {
            this.getWriteManager().writeDomains(dLDomains);
        }
    }

    private List writeChangeRequests(Design design) throws SQLException {
        return this.getWriteManager().writeChangeRequests(design);
    }

    public String getTableName(Object object) {
        if (object instanceof DesignPart || object instanceof DesignPartView || object instanceof LogicalDatatypeSet || object instanceof RDBMSSiteSet) {
            return T_PACKAGES;
        }
        if (object instanceof StorageDesign) {
            return T_PHYSMODELS;
        }
        String string = "";
        string = object instanceof String ? ((String)object).toUpperCase() : ObjectTypes.getObjectType(object);
        String string2 = (String)this.tableNames.get(string);
        if (string2 == null) {
            return ObjectTypes.UNKNOWN;
        }
        return string2;
    }

    public String getObjectType(Object object) {
        if (object instanceof DesignPartView) {
            DesignPartView designPartView = (DesignPartView)object;
            if (designPartView.getDesignPart().getMainView() == designPartView) {
                return "MainView";
            }
            return "SubView";
        }
        if (object instanceof ExtendedMap) {
            return "ExtendedMap";
        }
        if (object instanceof XtdMapping) {
            return ObjectTypes.getObjectType(object);
        }
        if (object instanceof ModelIDObject) {
            return ((ModelIDObject)object).getObjectTypeName();
        }
        if (object instanceof DLDomains) {
            return "DLDomains";
        }
        if (object instanceof LogicalDatatypeSet) {
            return "LogicalDatatypeSet";
        }
        if (object instanceof RDBMSSiteSet) {
            return "RDBMSSiteSet";
        }
        return "undefined";
    }

    public static Document getDocument(String string) {
        try {
            StringReader stringReader = new StringReader(string);
            InputSource inputSource = new InputSource(stringReader);
            Document document = AbstractXMLHandler.DOCUMENT_BUILDER.parse(inputSource);
            stringReader.close();
            return document;
        }
        catch (Exception exception) {
            Design.openFailed();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDesign(Design design, String string, String string2) {
        System.out.println("Load from DB start " + System.currentTimeMillis());
        ProgressDialog progressDialog = null;
        try {
            ApplicationView.loading = true;
            ApplicationView.canLogging = false;
            ApplicationView applicationView = design.getAppView();
            design.setLoadedVersion(2.4f);
            this.getReadManager().readUserRights(design);
            RelationalDesign relationalDesign = design.getRelationalDesign();
            relationalDesign.setMainViewVisible(false);
            design.getLogicalDesign().setLoaded(false);
            design.getLogicalDesign().setMainViewVisible(false);
            design.getBusinessInfoDesign().setLoaded(false);
            design.getDataTypesDesign().setLoaded(false);
            design.getDataTypesDesign().getMainView();
            relationalDesign.setLoaded(false);
            progressDialog = new ProgressDialog(applicationView, "", 0, 100);
            progressDialog.setNote("Open Design: \"" + design.getName() + '\"');
            progressDialog.setProgress(5);
            this.getDesign().getAppView().getPersistenceManager().setReadMode(PersistenceManager.READ_MODE_DATABASE);
            design.setRepositoryOID(string);
            design.setRepositoryOVID(string2);
            String string3 = this.getUser();
            String string4 = this.getCheckoutByUser(design);
            if (string4 != null) {
                design.setCheckedOutBy(string4);
                design.setCheckedOut(true);
                if (string3 != null && string3.equalsIgnoreCase(string4)) {
                    design.setCheckedOutByMe(true);
                }
            }
            Document document = this.getReadManager().getDesignDoc(string2);
            RXMLDesign rXMLDesign = this.getDesign().getAppView().getPersistenceManager().getDesignReader();
            if (document != null) {
                rXMLDesign.readVersion(document, design);
            }
            this.readDLDomains(design);
            this.getReadManager().readChangerequests(design);
            this.getReadManager().readDesignParts(design, string, string2, progressDialog);
            if (design.getAppView().getSettings().isLoadDLSettingsOnOpen()) {
                this.getReadManager().readDLSettings(design);
            }
            if (document != null) {
                rXMLDesign.recreateObject(document, design, progressDialog);
            }
            progressDialog.setNote("Show Models...");
            progressDialog.setProgress(98);
            if (design.getLogicalDesign().isVisible()) {
                design.getLogicalDesign().setMainViewVisible(true);
            }
            design.showLogicalSubViews();
            design.showAllRelationalDesigns();
            design.showDataTypesDesign();
            design.showAllMultidimensionalDesigns();
            design.showAllDataFlowDesigns();
            design.showAllTransformationTask();
            if (design.getRelationalDesign().getTableSet().size() > 0 && design.getRelationalDesign().getMainView().isVisible()) {
                applicationView.setCurrentDPV(design.getRelationalDesign().getMainView());
            } else if (design.getLogicalDesign().getEntitySet().size() > 0 && design.getLogicalDesign().getMainView().isVisible()) {
                applicationView.setCurrentDPV(design.getLogicalDesign().getMainView());
            }
            design.getRelationalDesign().setDirty(false);
            design.getLogicalDesign().setDirty(false);
            design.setDirty(false);
            design.setLoadFromDB(true);
            design.setDlSettings(design.getAppView().getSettings().getDesignLevelSettings());
            design.createDP_RepositoryMap();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        finally {
            ApplicationView.loading = false;
            ApplicationView.canLogging = true;
            this.getDesign().getAppView().getPersistenceManager().setReadMode(PersistenceManager.READ_MODE_FILESYTEM);
            design.getAppView().clearTree();
            if (progressDialog != null) {
                progressDialog.close();
            }
            System.out.println("Load from DB end " + System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initDomainObject(RepositoryObject repositoryObject) {
        boolean bl = true;
        Connection connection = this.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                String string = "select oid, ovid from " + T_PACKAGES + " where type = '" + repositoryObject.getName() + "'";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string);
                if (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    repositoryObject.setRepositoryOID(string2);
                    repositoryObject.setRepositoryOVID(string3);
                } else {
                    this.getWriteManager().writePackageRecord(repositoryObject.getName(), repositoryObject);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initPackageObject(RepositoryObject repositoryObject) {
        boolean bl = true;
        Connection connection = this.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                String string = repositoryObject.getName();
                String string2 = "select m.type, m.oid, m.ovid, r.check_out_version, r.checkout_by, m.xml_content from " + T_PACKAGES + " m, " + T_OBJECT_REGISTER + " r where m.type = '" + string + "' and m.oid = r.oid and r.last_version = m.ovid and (r.check_out_version is null or  r.check_out_version is not null and r.checkout_by <> user)";
                string2 = string2 + " union all " + "select m.type, m.oid, m.ovid, r.check_out_version, r.checkout_by, m.xml_content from " + T_PACKAGES + " m, " + T_OBJECT_REGISTER + " r where m.type = '" + string + "' and m.oid = r.oid and r.check_out_version = m.ovid and r.check_out_version is not null and r.checkout_by = user";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string2);
                if (resultSet.next()) {
                    String string3 = resultSet.getString(2);
                    String string4 = resultSet.getString(3);
                    repositoryObject.setRepositoryOID(string3);
                    repositoryObject.setRepositoryOVID(string4);
                } else {
                    bl = false;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initDLDomains(DLDomains dLDomains) {
        boolean bl = true;
        Connection connection = this.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                String string = "select oid, ovid from " + T_PACKAGES + " where type = '" + dLDomains.getType() + "'";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string);
                if (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    dLDomains.setRepositoryOID(string2);
                    dLDomains.setRepositoryOVID(string3);
                } else {
                    ArrayList<DLDomains> arrayList = new ArrayList<DLDomains>();
                    arrayList.add(dLDomains);
                    this.getWriteManager().writePackageRecord(dLDomains.getType(), dLDomains);
                    this.getWriteManager().writePackageMembers(dLDomains.getDesign().getRepositoryOID(), dLDomains.getDesign().getRepositoryOVID(), arrayList);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        return bl;
    }

    public void readLogicalDatatypes(Design design) throws SQLException {
        LogicalDatatypeSet logicalDatatypeSet = design.getLogicalDatatypeSet();
        boolean bl = true;
        if (logicalDatatypeSet.getRepositoryOID() == null) {
            bl = this.initPackageObject(logicalDatatypeSet);
        }
        if (bl) {
            this.getReadManager().readRepSet(logicalDatatypeSet);
        }
    }

    public void readRDBMSSites(Design design) throws SQLException {
        RDBMSSiteSet rDBMSSiteSet = design.getRDBMSSiteSet();
        boolean bl = true;
        if (rDBMSSiteSet.getRepositoryOID() == null) {
            bl = this.initPackageObject(rDBMSSiteSet);
        }
        if (bl) {
            rDBMSSiteSet.setLoadFromRepository(true);
            this.getReadManager().readRepSet(rDBMSSiteSet);
        }
    }

    public void readRLDomains(Design design) throws SQLException {
        RLDomains rLDomains = design.getRLDomains();
        boolean bl = true;
        if (rLDomains.getRepositoryOID() == null) {
            bl = this.initPackageObject(rLDomains);
        }
        if (bl) {
            this.getReadManager().readDomains(design, rLDomains);
        }
    }

    private void readDLDomains(Design design) throws SQLException {
        DLDomains dLDomains = design.getDLDomains();
        boolean bl = true;
        if (dLDomains.getRepositoryOID() == null) {
            bl = this.initDLDomains(dLDomains);
        }
        if (bl) {
            this.getReadManager().readDomains(design, dLDomains);
        }
    }

    public AbstractXMLReader getXMReader(String string) {
        Class clazz = this.getClassforType(string);
        if (clazz != null) {
            AbstractXMLReader abstractXMLReader = this.getDesign().getAppView().getPersistenceManager().getReaderForClass(clazz);
            return abstractXMLReader;
        }
        return null;
    }

    private Class getClassforType(String string) {
        if (string.equalsIgnoreCase("Table")) {
            return Table.class;
        }
        if (string.equalsIgnoreCase("FKIndexAssociation")) {
            return FKIndexAssociation.class;
        }
        if (string.equalsIgnoreCase("View")) {
            return TableView.class;
        }
        if (string.equalsIgnoreCase("Relation")) {
            return Relation.class;
        }
        if (string.equalsIgnoreCase("Hierarchy relation")) {
            return InheritanceRelation.class;
        }
        if (string.equalsIgnoreCase("Entity")) {
            return Entity.class;
        }
        if (string.equalsIgnoreCase("EntityView")) {
            return EntityView.class;
        }
        if (string.equalsIgnoreCase("Arc")) {
            return Arc.class;
        }
        if (string.equalsIgnoreCase("FKArc")) {
            return FKArc.class;
        }
        if (string.equalsIgnoreCase(ObjectTypes.XMAPPING)) {
            return XtdMapping.class;
        }
        if (string.equalsIgnoreCase("SubView") || string.equalsIgnoreCase("MainView")) {
            return DesignPartView.class;
        }
        if (string.equalsIgnoreCase("LogicalDatatypeSet")) {
            return LogicalDatatypeSet.class;
        }
        if (string.equalsIgnoreCase("RDBMSSiteSet")) {
            return RDBMSSiteSet.class;
        }
        if (string.equalsIgnoreCase("Domain")) {
            return Domain.class;
        }
        if (string.equalsIgnoreCase("StorageObject")) {
            return StorageObject.class;
        }
        if (string.equalsIgnoreCase("CollectionType")) {
            return CollectionType.class;
        }
        if (string.equalsIgnoreCase("StructuredType")) {
            return StructuredType.class;
        }
        if (string.equalsIgnoreCase("DistinctType")) {
            return DistinctType.class;
        }
        if (string.equalsIgnoreCase("SelectionCriteria")) {
            return SelectionCriteria.class;
        }
        if (string.equalsIgnoreCase("Level")) {
            return Level.class;
        }
        if (string.equalsIgnoreCase("RollupLink")) {
            return RollupLink.class;
        }
        if (string.equalsIgnoreCase("RaggedHLink")) {
            return RaggedHLink.class;
        }
        if (string.equalsIgnoreCase("Dimension")) {
            return Dimension.class;
        }
        if (string.equalsIgnoreCase("Measure")) {
            return Measure.class;
        }
        if (string.equalsIgnoreCase("Slice")) {
            return Slice.class;
        }
        if (string.equalsIgnoreCase("FactEntitiesJoin")) {
            return FactEntitiesJoin.class;
        }
        if (string.equalsIgnoreCase("Cube")) {
            return Cube.class;
        }
        if (string.equalsIgnoreCase("Link")) {
            return Link.class;
        }
        if (string.equalsIgnoreCase("Hierarchy")) {
            return Hierarchy.class;
        }
        if (string.equalsIgnoreCase("MeasureFolder")) {
            return MeasureFolder.class;
        }
        if (string.equalsIgnoreCase("SQLAccessToAW")) {
            return SQLAccessToAW.class;
        }
        if (string.equalsIgnoreCase("RecordStructure")) {
            return RecordStructure.class;
        }
        if (string.equalsIgnoreCase("ExternalData")) {
            return ExternalData.class;
        }
        if (string.equalsIgnoreCase("Event")) {
            return Event.class;
        }
        if (string.equalsIgnoreCase("InfoStructure")) {
            return InfoStructure.class;
        }
        if (string.equalsIgnoreCase("InfoStore")) {
            return InfoStore.class;
        }
        if (string.equalsIgnoreCase("Role")) {
            return Role.class;
        }
        if (string.equalsIgnoreCase("TransformationPackage")) {
            return TransformationPackage.class;
        }
        if (string.equalsIgnoreCase("Process")) {
            return Process.class;
        }
        if (string.equalsIgnoreCase("ExtAgent")) {
            return ExternalAgent.class;
        }
        if (string.equalsIgnoreCase(Flow.TYPE_NAME)) {
            return Flow.class;
        }
        if (string.equalsIgnoreCase("Transformation")) {
            return Transformation.class;
        }
        if (string.equalsIgnoreCase(TransformationFlow.TYPE_NAME)) {
            return TransformationFlow.class;
        }
        if (string.equalsIgnoreCase("Email")) {
            return BIEmail.class;
        }
        if (string.equalsIgnoreCase("Location")) {
            return BILocation.class;
        }
        if (string.equalsIgnoreCase("Phone")) {
            return BIPhone.class;
        }
        if (string.equalsIgnoreCase("ResLocator")) {
            return BIResourceLocator.class;
        }
        if (string.equalsIgnoreCase("Contact")) {
            return BIContact.class;
        }
        if (string.equalsIgnoreCase("ResponsibleParty")) {
            return BIResponsibleParty.class;
        }
        if (string.equalsIgnoreCase("Document")) {
            return BIDocument.class;
        }
        if (string.equalsIgnoreCase("Note")) {
            return Note.class;
        }
        if (string.equalsIgnoreCase("ChangeRequest")) {
            return ChangeRequest.class;
        }
        return null;
    }

    @Override
    public List getDesigns(boolean bl) {
        return this.getReadManager().getDesigns(bl);
    }

    @Override
    public RepositoryFactory getRepositoryFactory() {
        if (this.repositoryFactory == null) {
            this.repositoryFactory = new RepositoryFactory(this);
        }
        return this.repositoryFactory;
    }

    public CheckInOutManager getCheckInOutManager() {
        if (this.checkInOutManager == null) {
            this.checkInOutManager = new CheckInOutManager(this);
        }
        return this.checkInOutManager;
    }

    @Override
    public boolean checkOutObject(RepositoryObject repositoryObject) {
        try {
            return this.getCheckInOutManager().checkOutObject(repositoryObject);
        }
        catch (SQLException sQLException) {
            this.lastError = sQLException.toString();
            LOGGER.error("OracleRepositoryManager.checkOutObject():\n" + this.lastError + "\n", sQLException);
            return false;
        }
    }

    public boolean checkInObject(ModelIDObject modelIDObject) {
        try {
            return this.getCheckInOutManager().checkInObject(modelIDObject);
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public ReadManager getReadManager() {
        if (this.readManager == null) {
            this.readManager = new ReadManager(this);
        }
        return this.readManager;
    }

    public WriteManager getWriteManager() {
        if (this.writeManager == null) {
            this.writeManager = new WriteManager(this);
        }
        return this.writeManager;
    }

    @Override
    public void writeDesignPart(DesignPart designPart) {
        this.getWriteManager().writeDesignPart(designPart);
    }

    @Override
    public void writeObject(RepositoryObject repositoryObject) {
        if (repositoryObject instanceof Design) {
            this.writeDesign((Design)repositoryObject);
        } else {
            this.getWriteManager().writeObject(repositoryObject);
        }
    }

    @Override
    public void writeObjects(List list, String string) throws SQLException {
        this.getWriteManager().writeObjects(list, string);
    }

    @Override
    public boolean checkInObject(RepositoryObject repositoryObject) {
        try {
            return this.getCheckInOutManager().checkInObject(repositoryObject);
        }
        catch (SQLException sQLException) {
            this.lastError = sQLException.toString();
            LOGGER.error("OracleRepositoryManager.checkInObject():\n" + this.lastError + "\n", sQLException);
            return false;
        }
    }

    @Override
    public String getCheckoutByUser(RepositoryObject repositoryObject) throws SQLException {
        return this.getCheckInOutManager().getCheckoutByUser(repositoryObject);
    }

    @Override
    public void readPhysicalModel(StorageDesign storageDesign) {
        try {
            this.getReadManager().readPhysicalModel(storageDesign);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void writeDesignLevelSettings(Design design) {
        String string = design.getAppView().getSettings().getDesignLevelSettings();
        this.getWriteManager().writeDLSettings(design, string);
    }

    public boolean readDLSettings(Design design) {
        boolean bl = false;
        try {
            bl = this.getReadManager().readDLSettings(design);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return bl;
    }
}

