/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.db.oracle.AbstractDBWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.OracleRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.oracle.WriteManager;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.JDBCUtils;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.BLOB;

public class DB_XMappingWriter
extends AbstractDBWriter {
    public DB_XMappingWriter(OracleRepositoryManager oracleRepositoryManager) {
        super(oracleRepositoryManager);
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof XtdMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeObjectToDB(Object object) throws SQLException {
        String string = this.repositoryManager.getXML(object);
        String string2 = "null";
        if (object instanceof ConnectionInterface) {
            OraclePreparedStatement oraclePreparedStatement = null;
            PreparedStatement preparedStatement = null;
            try {
                String string3;
                DesignObject designObject = (DesignObject)object;
                string2 = designObject.getName();
                Connection connection = this.getConnection();
                String string4 = this.getTableName(object);
                boolean bl = false;
                String string5 = designObject.getRepositoryOID();
                if (string5 == null) {
                    string5 = new GUID().toString();
                    bl = true;
                }
                if ((string3 = designObject.getRepositoryOVID()) == null) {
                    string3 = new GUID().toString();
                }
                ConnectionInterface connectionInterface = (ConnectionInterface)object;
                String string6 = connectionInterface.getSourceObject().getRepositoryOID();
                String string7 = connectionInterface.getTargetObject().getRepositoryOID();
                BLOB bLOB = DB_XMappingWriter.getBLOB(string, connection);
                if (bl) {
                    String string8 = "insert into " + string4 + " ( name, OID, OVID,source,target, created_by,date_created,v_sequence,xml_content) values ('" + string2 + "' ,'" + string5 + "', '" + string3 + "','" + string6 + "','" + string7 + "', user, sysdate,1,? )";
                    oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string8);
                    oraclePreparedStatement.setObject(1, (Object)bLOB);
                    int n = oraclePreparedStatement.executeUpdate();
                    if (n == 1) {
                        this.assignRepositoryIDs(designObject, string5, string3);
                        WriteManager.registerObject(string5, string3, connection, false);
                    }
                } else {
                    String string9 = "update " + string4 + " set name = ?, changed_by = user, date_changed = sysdate, xml_content = ? " + " where ovid = ?";
                    preparedStatement = connection.prepareStatement(string9);
                    preparedStatement.setString(1, designObject.getName());
                    preparedStatement.setObject(2, bLOB);
                    preparedStatement.setString(3, string3);
                    preparedStatement.executeUpdate();
                }
                this.clearDirtyFlag(designObject);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(oraclePreparedStatement);
                JDBCUtils.close(preparedStatement);
                throw throwable;
            }
            JDBCUtils.close((Statement)oraclePreparedStatement);
            JDBCUtils.close(preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObjectsToDB(List list) throws SQLException {
        if (list.size() > 0) {
            int n = 0;
            Statement statement = null;
            Statement statement2 = null;
            PreparedStatement preparedStatement = WriteManager.prepareRegisterStatement(this.getConnection(), false);
            try {
                Object e = list.get(0);
                Connection connection = this.getConnection();
                String string = this.getTableName(e);
                String string2 = "update " + string + " set name = ?, changed_by = user, date_changed = sysdate, xml_content = ? " + " where ovid = ?";
                String string3 = "insert into " + string + " ( name, OID, OVID,source,target, created_by,date_created,v_sequence,xml_content) values (?,?,?,?,?, user, sysdate,1,? )";
                statement = (OraclePreparedStatement)connection.prepareStatement(string3);
                for (Object e2 : list) {
                    String string4;
                    if (!(e instanceof XtdMapping)) continue;
                    XtdMapping xtdMapping = (XtdMapping)e2;
                    String string5 = xtdMapping.getRepositoryOID();
                    boolean bl = false;
                    if (string5 == null) {
                        string5 = new GUID().toString();
                        bl = true;
                    }
                    if ((string4 = xtdMapping.getRepositoryOVID()) == null) {
                        string4 = new GUID().toString();
                    }
                    String string6 = xtdMapping.getOwnerRepOID();
                    String string7 = xtdMapping.getTargetRepOID();
                    String string8 = this.repositoryManager.getXML(xtdMapping);
                    BLOB bLOB = DB_XMappingWriter.getBLOB(string8, connection);
                    if (bl) {
                        statement.setString(1, xtdMapping.getName());
                        statement.setString(2, string5);
                        statement.setString(3, string4);
                        statement.setString(4, string6);
                        statement.setString(5, string7);
                        statement.setObject(6, bLOB);
                        n = statement.executeUpdate();
                        if (n != 1) continue;
                        this.assignRepositoryIDs(xtdMapping, string5, string4);
                        WriteManager.registerObject(string5, string4, preparedStatement);
                        this.clearDirtyFlag(xtdMapping);
                        continue;
                    }
                    if (statement2 == null) {
                        statement2 = connection.prepareStatement(string2);
                    }
                    statement2.setString(1, xtdMapping.getName());
                    statement2.setObject(2, bLOB);
                    statement2.setString(3, string4);
                    n = statement2.executeUpdate();
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (statement2 != null) {
                    statement2.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }
}

