/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.db.oracle.RepositoryFactory;
import oracle.dbtools.crest.util.JDBCUtils;

public abstract class AbstractRepositoryManager {
    protected Connection connection = null;
    protected String connectionURL;
    protected String user;
    protected String password;
    private float repositoryVersion = -1.0f;
    private float softwareVersion = -1.0f;
    private String repositoryName = "Null";
    private String repositoryOID = "";
    private String repositoryOwner = "";
    private Design design;
    public static boolean INITIAL_WRITE_TODB = false;

    public AbstractRepositoryManager(Design design) {
        this.design = design;
    }

    public AbstractRepositoryManager(String string, String string2, String string3, Design design) {
        this.design = design;
        this.connectionURL = string;
        this.user = string2;
        this.password = string3;
        this.connect();
        if (this.isConnected()) {
            this.readRepositoryDetails();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public abstract void connect();

    public abstract RepositoryFactory getRepositoryFactory();

    public void connect(String string, String string2, String string3) {
        this.connectionURL = string;
        this.user = string2;
        this.password = string3;
        this.connect();
        if (this.isConnected()) {
            this.readRepositoryDetails();
        } else {
            this.repositoryVersion = -1.0f;
            this.softwareVersion = -1.0f;
            this.repositoryName = "Null";
            this.repositoryOID = "";
            this.repositoryOwner = "";
        }
    }

    public boolean isConnected() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readRepositoryDetails() {
        ResultSet resultSet;
        Statement statement;
        block8: {
            statement = null;
            resultSet = null;
            String string = "select name, oid, version, software_version, owner from repository";
            try {
                try {
                    statement = this.connection.createStatement();
                    resultSet = statement.executeQuery(string);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (resultSet != null) {
                    try {
                        if (resultSet.next()) {
                            this.repositoryName = resultSet.getString(1);
                            this.repositoryOID = resultSet.getString(2);
                            this.repositoryVersion = resultSet.getFloat(3);
                            this.softwareVersion = resultSet.getFloat(4);
                            this.repositoryOwner = resultSet.getString(5);
                        }
                        break block8;
                    }
                    catch (SQLException sQLException) {}
                    break block8;
                }
                this.repositoryVersion = -1.0f;
                this.softwareVersion = -1.0f;
                this.repositoryName = "Null";
                this.repositoryOID = "";
                this.repositoryOwner = "";
            }
            catch (Throwable throwable) {
                JDBCUtils.close(resultSet, statement);
                throw throwable;
            }
        }
        JDBCUtils.close(resultSet, statement);
    }

    public boolean isRepositoryOwner(String string) {
        return this.repositoryOwner.equalsIgnoreCase(string);
    }

    public boolean isRepositoryExists() {
        return (double)this.repositoryVersion > 0.0;
    }

    public boolean isRepositoryExists(String string) {
        return (double)this.repositoryVersion > 0.0 && this.repositoryName.equalsIgnoreCase(string);
    }

    public float getRepositoryVersion() {
        return this.repositoryVersion;
    }

    public float getSoftwareVersion() {
        return this.softwareVersion;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRepositoryOID() {
        return this.repositoryOID;
    }

    public abstract void dropRepository();

    public abstract void upgradeRepository();

    public abstract boolean canUpgradeRepository();

    public Design getDesign() {
        return this.design;
    }

    public abstract void writeDesign(Design var1);

    public abstract void writeObject(RepositoryObject var1);

    public abstract void writeObjects(List var1, String var2) throws SQLException;

    public abstract void writeDesignPart(DesignPart var1);

    public abstract void readDesign(Design var1, String var2, String var3);

    public abstract List getDesigns(boolean var1);

    public abstract void readPhysicalModel(StorageDesign var1);

    public abstract boolean checkOutObject(RepositoryObject var1);

    public abstract boolean checkInObject(RepositoryObject var1);

    public abstract String getCheckoutByUser(RepositoryObject var1) throws SQLException;

    public abstract void writeDesignLevelSettings(Design var1);

    public String getUser() {
        return this.user;
    }

    public class DesignDescriptor {
        public String name;
        public String oid;
        public String ovid;
        public String created_by;
        public String date_created;
        public String changed_by;
        public String date_changed;
        public String short_description;
        public int v_sequence;
        public String checkout_version;
        public String checkout_by;
    }
}

