/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.zip.InflaterInputStream;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.persistence.AbstractFileManager;
import oracle.dbtools.crest.model.persistence.PersistenceManager;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.BLOB;

public class FileManager
extends AbstractFileManager {
    private File defaultPath;
    private String designPath = "";
    private FilenameFilter extensionFilter;
    private static final Logger LOGGER;
    public static int DB_REPOSITORY;
    public static int FILE_REPOSITORY;
    public static int REPOSITORY_TYPE;
    Connection conn = null;
    OraclePreparedStatement stmt = null;

    public FileManager() {
        String string = MDConfiguration.getDefaultInstance().get("defaultFilePath");
        this.setBasePath(string);
    }

    @Override
    public boolean setBasePath(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.defaultPath = file;
        return true;
    }

    public File getBasePath() {
        return this.defaultPath;
    }

    protected FilenameFilter getExtensionFilter() {
        if (this.extensionFilter == null) {
            this.extensionFilter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(FileManager.this.getFileExtension());
                }
            };
        }
        return this.extensionFilter;
    }

    @Override
    public boolean store(PersistenceManager persistenceManager, String string, String string2, String string3) {
        try {
            File file = this.getAbsolutePath(persistenceManager, string, string2, true);
            File file2 = new File(file, this.toFileName(string2));
            if (!file.exists()) {
                file.mkdirs();
            }
            file2.createNewFile();
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
            bufferedWriter.write(string3);
            ((Writer)bufferedWriter).close();
            return true;
        }
        catch (IOException iOException) {
            LOGGER.error("Can not write data! Location: " + string + " - Name: " + string2, iOException);
            persistenceManager.setSaveFailed(true);
            return false;
        }
    }

    @Override
    public boolean store(PersistenceManager persistenceManager, String string, String string2, InputStream inputStream) {
        return this.store(persistenceManager, string, string2, inputStream, this.getStartWriterThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean store(PersistenceManager persistenceManager, String string, String string2, InputStream inputStream, boolean bl) {
        try {
            File file = this.getAbsolutePath(persistenceManager, string, string2, true);
            if (string2.endsWith("_Domains")) {
                File file2 = new File("c:/lock.pid");
                file2.createNewFile();
                try {
                    File file3 = new File(file, this.toFileName(string2));
                    file3.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    if (bl) {
                        Thread thread = new Thread(new StreamCopier(inputStream, fileOutputStream));
                        thread.start();
                    }
                    new StreamCopier(inputStream, fileOutputStream).run();
                }
                finally {
                    file2.delete();
                }
            } else {
                File file4 = new File(file, this.toFileName(string2));
                file4.createNewFile();
                FileOutputStream fileOutputStream = new FileOutputStream(file4);
                if (bl) {
                    Thread thread = new Thread(new StreamCopier(inputStream, fileOutputStream));
                    thread.start();
                } else {
                    new StreamCopier(inputStream, fileOutputStream).run();
                }
            }
            return true;
        }
        catch (IOException iOException) {
            LOGGER.error("Can not write data! Location: " + string + " - Name: " + string2, iOException);
            persistenceManager.setSaveFailed(true);
            return false;
        }
    }

    @Override
    public String readData(PersistenceManager persistenceManager, String string, String string2) {
        try {
            InputStream inputStream = this.getDataInputStreamWithoutExtension(persistenceManager, string, string2);
            if (inputStream == null) {
                LOGGER.error("Stream for: " + string + " " + string2 + " was null.");
                return "";
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            while (bufferedReader.ready()) {
                stringBuffer.append(bufferedReader.readLine());
            }
            bufferedReader.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            LOGGER.error("Can not read data: ", iOException);
            return null;
        }
    }

    protected File[] listFiles(String string) {
        File file = this.getAbsolutePath(string, false);
        return file.listFiles(this.getExtensionFilter());
    }

    @Override
    public boolean exists(PersistenceManager persistenceManager, String string, String string2) {
        File file = null;
        file = string2 == null ? this.getAbsolutePath(persistenceManager, string, string2, false) : new File(this.getAbsolutePath(persistenceManager, string, string2, false), this.toFileName(string2));
        return file.exists();
    }

    @Override
    public boolean deleteDesign(PersistenceManager persistenceManager, String string, String string2, String string3) {
        File file = null;
        boolean bl = true;
        if (string2 != null) {
            file = new File(this.getAbsolutePath(persistenceManager, string, string2, false), this.toFileName(string2));
            if (file.exists()) {
                bl = file.delete();
            }
            if ((file = new File(this.getAbsolutePath(persistenceManager, string, string2, false), string2)).exists() && file.isDirectory()) {
                bl = this.deleteDirectory(file, string3);
            }
        }
        return bl;
    }

    private boolean deleteDirectory(File file, String string) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.deleteDirectory(fileArray[i], string);
                continue;
            }
            fileArray[i].delete();
        }
        return file.delete();
    }

    @Override
    public boolean unlockDesign(String string, String string2, String string3) {
        return true;
    }

    @Override
    public Object[] listNames(String string) {
        File file = this.getAbsolutePath(string, true);
        return file.list(this.getExtensionFilter());
    }

    @Override
    public InputStream getDataInputStreamWithoutExtension(PersistenceManager persistenceManager, String string, String string2) {
        return this.getDataInputStream(persistenceManager, string, this.toFileName(string2));
    }

    @Override
    public InputStream getDataInputStream(PersistenceManager persistenceManager, String string, Object object) {
        try {
            String string2;
            String string3 = this.toFileName((String)object);
            File file = this.getAbsolutePath(persistenceManager, string, string3, false);
            File file2 = new File(file, string3);
            if (REPOSITORY_TYPE == DB_REPOSITORY && this.isDBPath(string2 = file2.getAbsolutePath())) {
                try {
                    return this.getStreamFromDB(string2);
                }
                catch (Exception exception) {
                    LOGGER.error("getStreamFromDB: Can not read data", exception);
                    return null;
                }
            }
            return new FileInputStream(file2);
        }
        catch (IOException iOException) {
            String string4;
            boolean bl = true;
            if (object != null && object instanceof String && (string4 = (String)object).indexOf("defaultdomains.") > -1) {
                bl = false;
            }
            if (bl) {
                LOGGER.error("getDataInputStream: Can not read data", iOException);
            }
            return null;
        }
    }

    private boolean isDBPath(String string) {
        String string2 = string.toUpperCase();
        return string2.indexOf("\\MTC2.XML") <= -1 && string2.indexOf("\\logtypes\\types.xml".toUpperCase()) <= -1 && string2.indexOf("\\domains\\defaultdomains.xml".toUpperCase()) <= -1 && string2.indexOf("RDBMSSites.xml".toUpperCase()) <= -1 && string2.indexOf("\\mtc2_Domains.xml".toUpperCase()) <= -1 && string2.indexOf("\\businessinfo\\".toUpperCase()) <= -1 && string2.indexOf("\\mtc2\\datatypes\\".toUpperCase()) <= -1 && string2.indexOf("mtc2\\processmodel\\".toUpperCase()) <= -1 && string2.indexOf("mtc2\\owbmetadata\\".toUpperCase()) <= -1;
    }

    private InputStream getStreamFromDB(String string) throws SQLException, IOException {
        BLOB bLOB;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (this.conn == null) {
            DriverManager.registerDriver((Driver)new OracleDriver());
            this.conn = DriverManager.getConnection(string2, string4, string3);
            this.conn.setAutoCommit(false);
            this.stmt = (OraclePreparedStatement)this.conn.prepareStatement("select xml_content from jr.tables_4 where file_name = ?");
        }
        this.stmt.setString(1, string);
        ResultSet resultSet = this.stmt.executeQuery();
        if (resultSet.next() && (bLOB = (BLOB)resultSet.getBlob(1)) != null) {
            int n;
            int n2 = bLOB.getBufferSize();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(bLOB.getBinaryStream());
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while ((n = inflaterInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n3 += n;
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            inflaterInputStream.close();
            byteArrayOutputStream.close();
            return new ByteArrayInputStream(byArray2);
        }
        return null;
    }

    @Override
    public String[] listNamesNoFileExtension(String string) {
        int n = this.getFileExtension().length() + 1;
        String[] stringArray = (String[])this.listNames(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - n);
            }
            return stringArray;
        }
        return null;
    }

    @Override
    public File getAbsolutePath(PersistenceManager persistenceManager, String string, String string2, boolean bl) {
        if (this.isSystemName(this.removeExt(string2))) {
            String string3 = persistenceManager.getAppView().getSettings().getDefaultSystemTypesPath();
            File file = new File(string3);
            if (string3.length() == 0 || !file.exists()) {
                return this.getAbsolutePath(string, bl);
            }
            return file;
        }
        File file = this.designPath == null || "".equalsIgnoreCase(this.designPath) ? new File(string) : new File(this.designPath, string);
        if (bl) {
            file.mkdirs();
        }
        return file;
    }

    public File getAbsolutePath(String string, boolean bl) {
        File file = this.defaultPath == null ? new File(string) : new File(this.defaultPath, string);
        if (bl) {
            file.mkdirs();
        }
        return file;
    }

    private boolean isSystemName(String string) {
        String[] stringArray = new String[]{"defaultRDBMSSites", "defaultdomains", "types"};
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        return hashSet.contains(string);
    }

    @Override
    public String getDataPath() {
        return this.designPath;
    }

    @Override
    public boolean isWriteFinished() {
        File file = new File("c:/lock.pid");
        return !file.exists();
    }

    @Override
    public void setDesignPath(String string) {
        this.designPath = string;
    }

    @Override
    public boolean deleteFiles(List list) {
        boolean bl = false;
        System.gc();
        for (int i = 0; i < list.size(); ++i) {
            File file;
            String string = (String)list.get(i);
            if (string == null || !(file = new File(this.fixFilePath(string))).exists()) continue;
            if (file.isDirectory()) {
                bl = this.deleteDirectory(file, "");
                continue;
            }
            bl = file.delete();
            if (bl) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bl = file.delete();
        }
        return bl;
    }

    static {
        DB_REPOSITORY = 2;
        REPOSITORY_TYPE = FILE_REPOSITORY = 1;
        LOGGER = new Logger(FileManager.class);
    }

    private class StreamCopier
    implements Runnable {
        InputStream in;
        OutputStream out;

        private StreamCopier(InputStream inputStream, OutputStream outputStream) {
            this.in = inputStream;
            this.out = outputStream;
        }

        @Override
        public void run() {
            try {
                int n;
                while (-1 != (n = this.in.read())) {
                    this.out.write(n);
                }
                this.out.flush();
                this.out.close();
            }
            catch (IOException iOException) {
                LOGGER.error("Error in StreamCopier.run", iOException);
            }
        }
    }
}

