/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata.compare;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.GeneralPropertiesComparator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.compare.MetaPropertyHolder;

public class MetaPropertiesComparator
implements GeneralPropertiesComparator,
MDXMLConstants {
    public static boolean considerChangeTime = false;
    protected List propertiesList = new ArrayList();
    protected boolean isDroped = false;
    protected boolean caseSensitive = false;
    protected boolean useSchema = true;
    protected boolean useDataTypeKind = false;
    private CompareObjectSelection selectionObject;
    private Map leftMap;
    private Map rightMap;
    private ClassDescription cd;
    private Design design;
    boolean plainMap = false;
    private static final String CREATED_BY = "createdBy";
    private static final String CREATED_TIME = "createdTime";
    private static final String CHANGED_BY = "changedBy";
    private static final String CHANGED_TIME = "changedTime";
    private StorageDesign storageDesign;

    public MetaPropertiesComparator() {
        this(null, null, null, null, null);
    }

    public MetaPropertiesComparator(Map map, Map map2, ClassDescription classDescription, Design design, StorageDesign storageDesign) {
        this.leftMap = map;
        this.rightMap = map2;
        this.cd = classDescription;
        this.design = design;
        this.storageDesign = storageDesign;
        this.initPropertiesList();
    }

    public MetaPropertiesComparator(Map map, Map map2, boolean bl, Design design, StorageDesign storageDesign) {
        this.leftMap = map;
        this.rightMap = map2;
        this.cd = null;
        this.plainMap = true;
        this.design = design;
        this.storageDesign = storageDesign;
        this.initPropertiesList();
    }

    protected void initPropertiesList() {
        if (this.cd != null) {
            ArrayList<ClassDescription.PropertyDescription> arrayList = new ArrayList<ClassDescription.PropertyDescription>();
            for (ClassDescription.PropertyDescription propertyDescription : this.cd.getPropertiesList()) {
                if (!propertyDescription.isReferred() && !propertyDescription.isSimpleClass() && !propertyDescription.isStringClass() && !propertyDescription.isRectangle) continue;
                if (this.isLoggingProperty(propertyDescription)) {
                    arrayList.add(propertyDescription);
                    continue;
                }
                this.processProperty(propertyDescription);
            }
            this.processPoints(this.cd);
            for (ClassDescription.PropertyDescription propertyDescription : arrayList) {
                this.processProperty(propertyDescription);
            }
        }
        if (this.plainMap) {
            this.processPropertiesMap(this.leftMap, this.rightMap);
        }
    }

    public ClassDescription getClassDescription() {
        return this.cd;
    }

    private void processProperty(ClassDescription.PropertyDescription propertyDescription) {
        if (propertyDescription.isRectangle) {
            this.processRectangle(propertyDescription);
            return;
        }
        if (propertyDescription.isPropertyMap || propertyDescription.isMap) {
            Map map = null;
            if (this.leftMap != null) {
                map = (Map)this.leftMap.get(propertyDescription.xmlName);
            }
            Map map2 = null;
            if (this.rightMap != null) {
                map2 = (Map)this.rightMap.get(propertyDescription.xmlName);
            }
            if (map != null || map2 != null) {
                this.processPropertiesMap(map, map2);
            }
            return;
        }
        if (propertyDescription.isSimpleClass() || propertyDescription.isStringClass() || propertyDescription.isReferred()) {
            String string = null;
            if (this.leftMap != null) {
                string = (String)this.leftMap.get(propertyDescription.xmlName);
            }
            String string2 = null;
            if (this.rightMap != null) {
                string2 = (String)this.rightMap.get(propertyDescription.xmlName);
            }
            if (string != null || string2 != null) {
                Object object;
                MetaPropertyHolder metaPropertyHolder = new MetaPropertyHolder(propertyDescription, this.leftMap, this.rightMap);
                if (string != null) {
                    if (!string.equals(string2)) {
                        metaPropertyHolder.setModified(true);
                        metaPropertyHolder.setSelected(true);
                    }
                    if (propertyDescription.isReferred() && !propertyDescription.isSimpleClass() && !propertyDescription.isStringClass()) {
                        object = this.getObject(string);
                        if (object != null) {
                            metaPropertyHolder.setLeftValuePresentation(((ModelObject)object).getName() + " / " + string);
                        }
                    } else if (propertyDescription.hasCodedEnum()) {
                        object = (String)propertyDescription.getCoddedEnumMap().get(string);
                        if (object != null) {
                            metaPropertyHolder.setLeftValuePresentation((String)object);
                        }
                    } else if (propertyDescription.isListOfRefs) {
                        metaPropertyHolder.setLeftValuePresentation(this.getListOfRefsPresentation(string));
                    }
                    metaPropertyHolder.setLeftValue(string);
                    if (string2 == null) {
                        metaPropertyHolder.setRightValuePresentation(propertyDescription.defaultValue);
                    }
                }
                if (string2 != null) {
                    if (!string2.equals(string)) {
                        metaPropertyHolder.setModified(true);
                        metaPropertyHolder.setSelected(true);
                    }
                    if (propertyDescription.isReferred() && !propertyDescription.isSimpleClass() && !propertyDescription.isStringClass()) {
                        object = this.getObject(string2);
                        if (object != null) {
                            metaPropertyHolder.setRightValuePresentation(((ModelObject)object).getName() + " / " + string2);
                        }
                    } else if (propertyDescription.hasCodedEnum()) {
                        object = (String)propertyDescription.getCoddedEnumMap().get(string2);
                        if (object != null) {
                            metaPropertyHolder.setRightValuePresentation((String)object);
                        }
                    } else if (propertyDescription.isListOfRefs) {
                        metaPropertyHolder.setRightValuePresentation(this.getListOfRefsPresentation(string2));
                    }
                    metaPropertyHolder.setRightValue(string2);
                    if (string == null) {
                        metaPropertyHolder.setLeftValuePresentation(propertyDescription.defaultValue);
                    }
                }
                this.propertiesList.add(metaPropertyHolder);
            }
        } else if (!propertyDescription.isReferred()) {
            // empty if block
        }
    }

    private String getListOfRefsPresentation(String string) {
        String string2 = null;
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            DesignObject designObject = null;
            if (this.design != null) {
                designObject = this.design.getDesignObject(stringArray[i]);
            }
            if (string2 == null) {
                if (designObject != null) {
                    string2 = ((ModelObject)designObject).getName() + " / " + stringArray[i];
                    continue;
                }
                string2 = stringArray[i];
                continue;
            }
            string2 = designObject != null ? string2 + "\n" + ((ModelObject)designObject).getName() + " / " + stringArray[i] : string2 + "\n" + stringArray[i];
        }
        return string2;
    }

    private void processPropertiesMap(Map map, Map map2) {
        if (map != null || map2 != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (map != null) {
                arrayList.addAll(map.keySet());
            }
            if (map2 != null) {
                if (map == null) {
                    arrayList.addAll(map2.keySet());
                } else {
                    for (String string : map2.keySet()) {
                        if (arrayList.contains(string)) continue;
                        arrayList.add(string);
                    }
                }
            }
            Collections.sort(arrayList, ModelObjectSet.TOSTRING_COMPARATOR);
            for (String string : arrayList) {
                ModelIDObject modelIDObject;
                String string2 = null;
                if (map != null) {
                    string2 = (String)map.get(string);
                }
                String string3 = null;
                if (map2 != null) {
                    string3 = (String)map2.get(string);
                }
                if (string2 == null && string3 == null) continue;
                MetaPropertyHolder metaPropertyHolder = new MetaPropertyHolder(string);
                if (string2 != null) {
                    if (!string2.equals(string3)) {
                        metaPropertyHolder.setModified(true);
                        metaPropertyHolder.setSelected(true);
                    }
                    if ((modelIDObject = this.getObject(string2)) != null) {
                        metaPropertyHolder.setLeftValuePresentation(modelIDObject.getName() + " / " + string2);
                    }
                    metaPropertyHolder.setLeftValue(string2);
                }
                if (string3 != null) {
                    if (!string3.equals(string2)) {
                        metaPropertyHolder.setModified(true);
                        metaPropertyHolder.setSelected(true);
                    }
                    if ((modelIDObject = this.getObject(string3)) != null) {
                        metaPropertyHolder.setRightValuePresentation(modelIDObject.getName() + " / " + string3);
                    }
                    metaPropertyHolder.setRightValue(string3);
                }
                this.propertiesList.add(metaPropertyHolder);
            }
        }
    }

    @Override
    public List getPropertiesList() {
        return this.propertiesList;
    }

    @Override
    public void copySelectedProperties() {
        for (MetaPropertyHolder metaPropertyHolder : this.getPropertiesList()) {
            if (!metaPropertyHolder.isModified() || !metaPropertyHolder.isSelected() || metaPropertyHolder.isFiltered()) continue;
            ClassDescription.PropertyDescription propertyDescription = metaPropertyHolder.getPropertyDescription();
            if (propertyDescription != null) {
                if (this.rightMap == null) continue;
                if (propertyDescription.isRectangle) {
                    if (metaPropertyHolder.getLeftMap() == null || metaPropertyHolder.getRightMap() == null) continue;
                    metaPropertyHolder.getRightMap().clear();
                    metaPropertyHolder.getRightMap().putAll(metaPropertyHolder.getLeftMap());
                    continue;
                }
                if (propertyDescription.isMergeCompare && metaPropertyHolder.isMerged()) {
                    this.rightMap.put(propertyDescription.xmlName, metaPropertyHolder.getRightValue());
                    continue;
                }
                this.rightMap.put(propertyDescription.xmlName, metaPropertyHolder.getLeftValue());
                continue;
            }
            if (this.rightMap == null) continue;
            if ("points".equalsIgnoreCase(metaPropertyHolder.getName())) {
                this.rightMap.put(metaPropertyHolder.getName(), this.leftMap.get("points"));
                continue;
            }
            this.rightMap.put(metaPropertyHolder.getName(), metaPropertyHolder.getLeftValue());
        }
    }

    @Override
    public String getLeftName() {
        if (this.leftMap != null) {
            String string = (String)this.leftMap.get("xmlName");
            if (string == null) {
                string = (String)this.leftMap.get("oldXmlName");
            }
            if (string != null) {
                return string;
            }
        }
        return "";
    }

    @Override
    public String getRightName() {
        if (this.rightMap != null) {
            String string = (String)this.rightMap.get("xmlName");
            if (string == null) {
                string = (String)this.rightMap.get("oldXmlName");
            }
            if (string != null) {
                return string;
            }
        }
        return "";
    }

    protected void copyPropertiesFromLeftToRight() {
    }

    @Override
    public boolean isModified() {
        for (EngPropertyHolder engPropertyHolder : this.getPropertiesList()) {
            if (!engPropertyHolder.isModified() || engPropertyHolder.isFiltered() || CHANGED_TIME.equals(engPropertyHolder.getName()) && !considerChangeTime) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getID() {
        if (this.leftMap != null && this.rightMap != null) {
            String string = (String)this.leftMap.get("id");
            String string2 = (String)this.rightMap.get("id");
            if (string != null && string2 != null) {
                return string + string2;
            }
        }
        return "null";
    }

    protected boolean hasToBeRename() {
        return false;
    }

    protected boolean hasToBeDrop() {
        return false;
    }

    protected boolean isDirty() {
        for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
            if (!engPropertyHolder.isModified() || !engPropertyHolder.isSelected()) continue;
            return true;
        }
        return false;
    }

    public CompareObjectSelection getLeftSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareObjectSelection compareObjectSelection) {
        this.selectionObject = compareObjectSelection;
    }

    public String getChoosedPropertyValue(String string) {
        for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
            if (!engPropertyHolder.getName().equals(string)) continue;
            if (engPropertyHolder.isSelected()) {
                return engPropertyHolder.getLeftValue();
            }
            return engPropertyHolder.getRightValue();
        }
        return "";
    }

    public EngPropertyHolder getPropertyHolderByName(String string) {
        for (EngPropertyHolder engPropertyHolder : this.getPropertiesList()) {
            if (!engPropertyHolder.getName().equals(string)) continue;
            return engPropertyHolder;
        }
        return null;
    }

    public boolean isDDLModified() {
        for (EngPropertyHolder engPropertyHolder : this.getPropertiesList()) {
            if (!engPropertyHolder.isSelected() || !engPropertyHolder.isDDLHolder()) continue;
            return true;
        }
        return false;
    }

    private ModelIDObject getObject(String string) {
        ModelIDObject modelIDObject;
        if (this.design != null && (modelIDObject = this.design.getDesignObject(string)) != null) {
            return modelIDObject;
        }
        if (this.storageDesign != null) {
            modelIDObject = this.storageDesign.getStorageObject(string);
            return modelIDObject;
        }
        return null;
    }

    private void processRectangle(ClassDescription.PropertyDescription propertyDescription) {
        Integer n;
        Integer n2;
        Object object;
        Object object2;
        Map map = null;
        if (this.leftMap != null) {
            map = (Map)this.leftMap.get(propertyDescription.xmlName);
        }
        Map map2 = null;
        if (this.rightMap != null) {
            map2 = (Map)this.rightMap.get(propertyDescription.xmlName);
        }
        String string = null;
        if (map != null) {
            object2 = (Integer)map.get("x");
            object = (Integer)map.get("y");
            n2 = (Integer)map.get("width");
            n = (Integer)map.get("height");
            if (object2 != null) {
                string = String.valueOf(object2) + "," + String.valueOf(object) + "," + String.valueOf(n2) + "," + String.valueOf(n);
            }
        }
        object2 = null;
        if (map2 != null) {
            object = (Integer)map2.get("x");
            n2 = (Integer)map2.get("y");
            n = (Integer)map2.get("width");
            Integer n3 = (Integer)map2.get("height");
            if (object != null) {
                object2 = String.valueOf(object) + "," + String.valueOf(n2) + "," + String.valueOf(n) + "," + String.valueOf(n3);
            }
        }
        if (string != null || object2 != null) {
            object = new MetaPropertyHolder(propertyDescription, map, map2);
            if (string != null) {
                if (!string.equals(object2)) {
                    ((EngPropertyHolder)object).setModified(true);
                    ((EngPropertyHolder)object).setSelected(true);
                }
                ((EngPropertyHolder)object).setLeftValue(string);
            }
            if (object2 != null) {
                if (!((String)object2).equals(string)) {
                    ((EngPropertyHolder)object).setModified(true);
                    ((EngPropertyHolder)object).setSelected(true);
                }
                ((EngPropertyHolder)object).setRightValue((String)object2);
            }
            this.propertiesList.add(object);
        }
    }

    private void processPoints(ClassDescription classDescription) {
        List list = (List)this.leftMap.get("points");
        if (list != null) {
            Object object2;
            List list2 = null;
            if (this.rightMap != null) {
                list2 = (List)this.rightMap.get("points");
            }
            String string = null;
            String string2 = null;
            for (Object object2 : list) {
                if (string == null) {
                    string = String.valueOf((int)((Point2D)object2).getX()) + "/" + String.valueOf((int)((Point2D)object2).getY());
                    continue;
                }
                string = string + "  \n" + String.valueOf((int)((Point2D)object2).getX()) + "/" + String.valueOf((int)((Point2D)object2).getY());
            }
            if (list2 != null) {
                for (Object object2 : list2) {
                    if (string2 == null) {
                        string2 = String.valueOf((int)((Point2D)object2).getX()) + "/" + String.valueOf((int)((Point2D)object2).getY());
                        continue;
                    }
                    string2 = string2 + "  \n" + String.valueOf((int)((Point2D)object2).getX()) + "/" + String.valueOf((int)((Point2D)object2).getY());
                }
            }
            object2 = new MetaPropertyHolder("points");
            ((MetaPropertyHolder)object2).setPresentationName("points ( x/y  ...)");
            if (string != null) {
                if (!string.equals(string2)) {
                    ((EngPropertyHolder)object2).setModified(true);
                    ((EngPropertyHolder)object2).setSelected(true);
                }
                ((EngPropertyHolder)object2).setLeftValue(string);
                ((MetaPropertyHolder)object2).setLeftValuePresentation(string);
            }
            if (string2 != null) {
                if (!string2.equals(string)) {
                    ((EngPropertyHolder)object2).setModified(true);
                    ((EngPropertyHolder)object2).setSelected(true);
                }
                ((EngPropertyHolder)object2).setRightValue(string2);
                ((MetaPropertyHolder)object2).setRightValuePresentation(string2);
            }
            this.propertiesList.add(object2);
        }
    }

    private boolean isLoggingProperty(ClassDescription.PropertyDescription propertyDescription) {
        return CREATED_BY.equals(propertyDescription.name) || CREATED_TIME.equals(propertyDescription.name) || CHANGED_BY.equals(propertyDescription.name) || CHANGED_TIME.equals(propertyDescription.name);
    }
}

