/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata.compare;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.engineering.EngFilter;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.compare.MetaPropertiesComparator;
import oracle.dbtools.crest.swingui.ApplicationView;

public class MetaMapSelection
extends ModelIdObjectSelection {
    static final String NONAME = "NONAME";
    public static MetaPropertiesComparator EMPTY_COMPARATOR = new MetaPropertiesComparator();
    static final String NO_ID = "NO_ID";
    private Map map;
    private MetaPropertiesComparator propertiesComparator;
    private MetaMapSelection correspondentNode;
    private EngFilter filter;
    private List filterChilds = new ArrayList();
    private static Integer NO_FILTER_STATUS = new Integer(-1);
    private boolean editable = true;
    private Class childClass;
    private int itemPosition = -1;
    private boolean itemPositionImportant = true;
    private ClassDescription.CollectionDescription collectionDescription;
    private List listFromMap;
    private String referenceID;
    private boolean complexPropertiesList = false;
    private String complexPropertyXMLName;
    Class oclass = null;

    public MetaMapSelection(Map map) {
        super("");
        this.setName(this.getName(map));
        this.setCollection(false);
        this.map = map;
    }

    public MetaMapSelection(ModelIDObject modelIDObject) {
        super(modelIDObject);
    }

    public MetaMapSelection(ModelIDObject modelIDObject, boolean bl) {
        super(modelIDObject, bl);
    }

    public MetaMapSelection(String string) {
        super(string);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Map getMap() {
        return this.map;
    }

    public MetaPropertiesComparator getPropertiesComparator() {
        return this.propertiesComparator;
    }

    public void setPropertiesComparator(MetaPropertiesComparator metaPropertiesComparator) {
        this.propertiesComparator = metaPropertiesComparator;
    }

    public MetaMapSelection getCorrespondentNode() {
        return this.correspondentNode;
    }

    public void setCorrespondentNode(MetaMapSelection metaMapSelection) {
        this.correspondentNode = metaMapSelection;
    }

    public String getName(Map map) {
        String string = null;
        if (map != null) {
            string = (String)map.get("name");
        }
        if (string == null) {
            string = NONAME;
        }
        return string;
    }

    public static String getID(Map map) {
        String string = null;
        if (map != null) {
            string = (String)map.get("id");
            if (string != null) {
                return string;
            }
            string = (String)map.get("objectID");
            if (string == null) {
                string = (String)map.get("oid");
            }
            if (string == null) {
                string = (String)map.get("vid");
            }
            if (string == null) {
                string = (String)map.get("columnID");
            }
            if (string == null) {
                string = (String)map.get("fkAssociation");
            }
            if (string == null) {
                string = (String)map.get("referredColumn");
            }
        }
        if (string == null) {
            string = NO_ID;
        }
        return string;
    }

    public String getObjectClassName(Map map) {
        if (map == null) {
            return null;
        }
        return (String)map.get("class");
    }

    public ClassDescription getClassDecription(Map map) {
        String string = this.getObjectClassName(map);
        if (string != null && !"".equals(string)) {
            return ApplicationView.getInstance().getXMLTransformationManager().getMetaDataManager().getClassDescription(string);
        }
        return null;
    }

    public String getObjectClassName() {
        if (this.map != null) {
            return this.getObjectClassName(this.map);
        }
        return "";
    }

    public Class getObjectClass(Map map) {
        String string = this.getObjectClassName(map);
        Class<?> clazz = null;
        if (string != null && !"".equals(string)) {
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    public Class getObjectClass() {
        if (this.oclass == null && this.map != null) {
            this.oclass = this.getObjectClass(this.map);
        }
        if (this.oclass == null) {
            return this.getChildClass();
        }
        return this.oclass;
    }

    public void setObjectClass(Class clazz) {
        this.oclass = clazz;
    }

    public void setEmptyComparator() {
        this.propertiesComparator = EMPTY_COMPARATOR;
    }

    @Override
    public int getNumberOfChildren() {
        if (this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) {
            return this.childs.size();
        }
        return this.filterChilds.size();
    }

    @Override
    public ModelObject getChild(int n) {
        if ((this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) && this.childs.size() > 0) {
            return (ModelObject)this.childs.get(n);
        }
        if (this.filterChilds.size() > 0) {
            return (ModelObject)this.filterChilds.get(n);
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if ((this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) && this.childs.size() > 0) {
            return this.childs.indexOf(modelObject);
        }
        if (this.filterChilds.size() > 0) {
            return this.filterChilds.indexOf(modelObject);
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if ((this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) && this.childs.size() > 0) {
            return this.childs.indexOf(object);
        }
        if (this.filterChilds.size() > 0) {
            return this.filterChilds.indexOf(object);
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return this.getNumberOfChildren() == 0;
    }

    public void setFilter(EngFilter engFilter) {
        this.filterChilds = new ArrayList();
        this.filter = engFilter;
        if (engFilter != null) {
            for (int i = 0; i < this.childs.size(); ++i) {
                MetaMapSelection metaMapSelection = (MetaMapSelection)this.childs.get(i);
                metaMapSelection.setFilter(engFilter);
                if (!metaMapSelection.isFiltered(engFilter.getFilterList()) && !metaMapSelection.hasFilteredChilds(engFilter.getFilterList())) continue;
                this.filterChilds.add(metaMapSelection);
            }
        }
    }

    public void setStatus(int n) {
        if (n == STATE_MODIFIED) {
            if (this.status != STATE_NEW && this.status != STATE_DELETED) {
                this.status = n;
            }
        } else {
            this.status = n;
        }
    }

    public boolean isModified() {
        boolean bl = false;
        if (this.propertiesComparator != null) {
            bl = this.propertiesComparator.isModified();
        }
        return bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean hasChildsWithChangeStatus() {
        for (MetaMapSelection metaMapSelection : this.childs) {
            if (metaMapSelection.getStatus() == STATE_UNCHANGED) continue;
            return true;
        }
        for (MetaMapSelection metaMapSelection : this.childs) {
            if (!metaMapSelection.hasChildsWithChangeStatus()) continue;
            return true;
        }
        return false;
    }

    public void resetModifiedStatus() {
        boolean bl;
        for (MetaMapSelection metaMapSelection : this.childs) {
            metaMapSelection.resetModifiedStatus();
        }
        boolean bl2 = bl = this.isModified() || this.hasChildsWithChangeStatus() || this.isItemPositionImportant() && this.hasChildsWithChangedPosition();
        if (bl && this.getStatus() == STATE_UNCHANGED) {
            this.setStatus(STATE_MODIFIED);
        } else if (!bl && this.getStatus() == STATE_MODIFIED) {
            this.setStatus(STATE_UNCHANGED);
        }
    }

    public Class getChildClass() {
        return this.childClass;
    }

    public void setChildClass(Class clazz) {
        this.childClass = clazz;
    }

    public int getItemPosition() {
        return this.itemPosition;
    }

    public void setItemPosition(int n) {
        this.itemPosition = n;
    }

    public boolean isItemPositionModified() {
        return this.itemPosition > -1 && this.getCorrespondentNode() != null && this.getCorrespondentNode().getItemPosition() != this.itemPosition;
    }

    public boolean hasItemPosition() {
        return this.itemPosition > -1;
    }

    public boolean hasChildsWithChangedPosition() {
        for (MetaMapSelection metaMapSelection : this.childs) {
            if (!metaMapSelection.isItemPositionModified()) continue;
            return true;
        }
        return false;
    }

    public ClassDescription.CollectionDescription getCollectionDescription() {
        return this.collectionDescription;
    }

    public void setCollectionDescription(ClassDescription.CollectionDescription collectionDescription) {
        this.collectionDescription = collectionDescription;
    }

    public boolean isMetaCollection() {
        return this.collectionDescription != null;
    }

    public List getListFromMap() {
        return this.listFromMap;
    }

    public void setListFromMap(List list) {
        this.listFromMap = list;
    }

    public String getReferenceID() {
        return this.referenceID;
    }

    public void setReferenceID(String string) {
        this.referenceID = string;
    }

    public boolean isRefID() {
        return this.referenceID != null && !"".equals(this.referenceID);
    }

    public boolean isComplexPropertiesList() {
        return this.complexPropertiesList;
    }

    public void setComplexPropertiesList(boolean bl) {
        this.complexPropertiesList = bl;
    }

    public String getComplexPropertyXMLName() {
        return this.complexPropertyXMLName;
    }

    public void setComplexPropertyXMLName(String string) {
        this.complexPropertyXMLName = string;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public boolean isItemPositionImportant() {
        return this.itemPositionImportant;
    }

    public void setItemPositionImportant(boolean bl) {
        this.itemPositionImportant = bl;
    }
}

