/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata.compare;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.XMLToMapTransformer;
import oracle.dbtools.crest.model.metadata.compare.MetaMapSelection;
import oracle.dbtools.crest.model.metadata.compare.MetaPropertiesComparator;
import oracle.dbtools.crest.swingui.TopView;

public class MapCompareBuilder
extends MetaMapSelection
implements MDXMLConstants {
    private Map leftMap = new HashMap();
    private Map rightMap = new HashMap();
    private ClassDescription leftCD;
    private ClassDescription rightCD;
    private MetaMapSelection leftRoot;
    private MetaMapSelection rightRoot;
    private Design design;
    private static String COMPLEX_PRPERTIES = "Complex Properties";
    private static String TO_DELETE = "TO DELETE";
    private static String NEW = "NEW";
    private StorageDesign storageDesign;

    public MapCompareBuilder(Design design, StorageDesign storageDesign, InputStream inputStream, String string, InputStream inputStream2, String string2) throws UnsupportedEncodingException {
        super("");
        this.design = design;
        this.storageDesign = storageDesign;
        boolean bl = design.isCompressedDesign();
        XMLToMapTransformer.transformToMap(this.leftMap, inputStream, bl);
        XMLToMapTransformer.transformToMap(this.rightMap, inputStream2, bl);
        this.build(string, string2);
        this.leftRoot.resetModifiedStatus();
        this.rightRoot.resetModifiedStatus();
    }

    public MetaMapSelection getLeftRoot() {
        return this.leftRoot;
    }

    public MetaMapSelection getRightRoot() {
        return this.rightRoot;
    }

    private void build(String string, String string2) {
        this.leftCD = this.getClassDecription(this.leftMap);
        this.rightCD = this.getClassDecription(this.rightMap);
        if (this.leftCD != null && this.rightCD != null && this.leftCD == this.rightCD) {
            ClassDescription classDescription = this.leftCD;
            MetaPropertiesComparator metaPropertiesComparator = new MetaPropertiesComparator(this.leftMap, this.rightMap, classDescription, this.design, this.storageDesign);
            this.leftRoot = new MetaMapSelection(this.leftMap);
            this.leftRoot.setPropertiesComparator(metaPropertiesComparator);
            this.rightRoot = new MetaMapSelection(this.rightMap);
            this.rightRoot.setPropertiesComparator(metaPropertiesComparator);
            this.leftRoot.setCorrespondentNode(this.rightRoot);
            this.rightRoot.setCorrespondentNode(this.leftRoot);
            this.leftRoot.setName(this.leftRoot.getName() + " (" + string + ")");
            this.rightRoot.setName(this.rightRoot.getName() + " (" + string2 + ")");
            this.addStructure(this.leftRoot, this.rightRoot, classDescription, this.leftMap, this.rightMap);
        }
    }

    private void addStructure(MetaMapSelection metaMapSelection, MetaMapSelection metaMapSelection2, ClassDescription classDescription, Map map, Map map2) {
        this.processComplexPeoperties(metaMapSelection, metaMapSelection2, classDescription, map, map2);
        for (ClassDescription.CollectionDescription collectionDescription : classDescription.getOrderedCollectionsList("compare/v")) {
            List list = null;
            boolean bl = true;
            if (map == null) {
                bl = false;
            }
            if (map != null) {
                list = (List)map.get(collectionDescription.xmlName);
            }
            if (list == null) {
                list = Collections.EMPTY_LIST;
                bl = false;
            }
            ArrayList arrayList = null;
            if (map2 != null) {
                arrayList = (ArrayList)map2.get(collectionDescription.xmlName);
            }
            if (arrayList == null) {
                if (bl && map2 != null) {
                    arrayList = new ArrayList();
                    map2.put(collectionDescription.xmlName, arrayList);
                } else {
                    arrayList = Collections.EMPTY_LIST;
                }
            }
            if (list.size() <= 0 && arrayList.size() <= 0) continue;
            MetaMapSelection metaMapSelection3 = new MetaMapSelection(collectionDescription.xmlName);
            MetaMapSelection metaMapSelection4 = new MetaMapSelection(collectionDescription.xmlName);
            metaMapSelection3.setCorrespondentNode(metaMapSelection4);
            metaMapSelection4.setCorrespondentNode(metaMapSelection3);
            metaMapSelection3.setEmptyComparator();
            metaMapSelection4.setEmptyComparator();
            metaMapSelection3.setCollectionDescription(collectionDescription);
            metaMapSelection4.setCollectionDescription(collectionDescription);
            metaMapSelection3.setListFromMap(list);
            metaMapSelection4.setListFromMap(arrayList);
            metaMapSelection.addChild(metaMapSelection3);
            metaMapSelection2.addChild(metaMapSelection4);
            this.processCollection(metaMapSelection3, metaMapSelection4, list, arrayList, collectionDescription);
        }
    }

    private Map createMap(Map map, ClassDescription classDescription) {
        Map<String, String> map2 = null;
        String string = null;
        if (map != null) {
            try {
                Class<?> clazz = Class.forName(map.getClass().getName());
                if (clazz instanceof Map) {
                    map2 = (Map)((Object)clazz);
                }
                string = (String)map2.get("class");
            }
            catch (ClassNotFoundException classNotFoundException) {
                map2 = new TreeMap();
            }
        } else {
            map2 = new TreeMap<String, String>();
        }
        if (string != null) {
            map2.put("class", string);
        } else if (classDescription != null) {
            map2.put("class", classDescription.getClassName());
        }
        return map2;
    }

    private void processComplexPeoperties(MetaMapSelection metaMapSelection, MetaMapSelection metaMapSelection2, ClassDescription classDescription, Map map, Map map2) {
        if (classDescription != null) {
            Object object;
            ArrayList<ClassDescription.PropertyDescription> arrayList = new ArrayList<ClassDescription.PropertyDescription>();
            for (ClassDescription.PropertyDescription propertyDescription : classDescription.getPropertiesList()) {
                if (propertyDescription.isReferred() && !propertyDescription.isPropertyMap && !propertyDescription.isMap || propertyDescription.isSimpleClass() || propertyDescription.isStringClass() || propertyDescription.isRectangle) continue;
                object = map.get(propertyDescription.xmlName);
                if (object == null) {
                    object = map2.get(propertyDescription.xmlName);
                }
                if (object == null) continue;
                arrayList.add(propertyDescription);
            }
            boolean bl = false;
            if (classDescription.isPropertyMap) {
                object = map.get("propertyMap");
                if (object == null) {
                    object = map2.get("propertyMap");
                }
                if (object != null) {
                    bl = true;
                }
            }
            if (arrayList.size() > 0 || bl) {
                object = new MetaMapSelection(COMPLEX_PRPERTIES);
                MetaMapSelection metaMapSelection3 = new MetaMapSelection(COMPLEX_PRPERTIES);
                ((MetaMapSelection)object).setComplexPropertiesList(true);
                metaMapSelection3.setComplexPropertiesList(true);
                ((MetaMapSelection)object).setMap(map);
                metaMapSelection3.setMap(map2);
                ((MetaMapSelection)object).setCorrespondentNode(metaMapSelection3);
                metaMapSelection3.setCorrespondentNode((MetaMapSelection)object);
                ((MetaMapSelection)object).setEmptyComparator();
                metaMapSelection3.setEmptyComparator();
                metaMapSelection.addChild((ModelIdObjectSelection)object);
                metaMapSelection2.addChild(metaMapSelection3);
                for (ClassDescription.PropertyDescription propertyDescription : arrayList) {
                    this.processComplexProp((MetaMapSelection)object, metaMapSelection3, map, map2, propertyDescription.xmlName);
                }
                if (bl) {
                    this.processComplexProp((MetaMapSelection)object, metaMapSelection3, map, map2, "propertyMap");
                }
            }
        }
    }

    private void processComplexProp(MetaMapSelection metaMapSelection, MetaMapSelection metaMapSelection2, Map map, Map map2, String string) {
        Object object;
        Object object2;
        Map map3 = (Map)map.get(string);
        Map map4 = (Map)map2.get(string);
        MetaMapSelection metaMapSelection3 = null;
        MetaPropertiesComparator metaPropertiesComparator = null;
        ClassDescription classDescription = null;
        if (map3 == null) {
            metaMapSelection3 = new MetaMapSelection(TO_DELETE);
            metaMapSelection3.setStatus(STATE_DELETED);
        } else {
            classDescription = this.getClassDecription(map3);
            metaMapSelection3 = new MetaMapSelection(map3);
            if ("NONAME".equals(metaMapSelection3.getName())) {
                object2 = this.getObjectName(map3);
                if (object2 != null) {
                    metaMapSelection3.setName((String)object2);
                } else {
                    metaMapSelection3.setName(string);
                }
            }
        }
        if (map4 != null) {
            if (classDescription == null) {
                classDescription = this.getClassDecription(map3);
            }
            if ("NONAME".equals(((MetaMapSelection)(object2 = new MetaMapSelection(map4))).getName())) {
                object = this.getObjectName(map4);
                if (object != null) {
                    ((ModelObject)object2).setName((String)object);
                } else {
                    ((ModelObject)object2).setName(string);
                }
            }
        } else {
            object2 = new MetaMapSelection(NEW);
            metaMapSelection3.setStatus(STATE_NEW);
            ((MetaMapSelection)object2).setStatus(STATE_NEW);
        }
        metaPropertiesComparator = classDescription == null ? new MetaPropertiesComparator(map3, map4, true, this.design, this.storageDesign) : new MetaPropertiesComparator(map3, map4, classDescription, this.design, this.storageDesign);
        object = metaMapSelection3.getObjectClass();
        if (object == null) {
            object = this.getClassByObject(map3);
            if (object == null) {
                object = this.getClassByObject(map4);
            }
            if (object != null) {
                metaMapSelection3.setChildClass((Class)object);
                ((MetaMapSelection)object2).setChildClass((Class)object);
            }
        }
        if (object != null && TopView.class.isAssignableFrom((Class<?>)object)) {
            metaMapSelection3.setObjectClass((Class)object);
            ((MetaMapSelection)object2).setObjectClass((Class)object);
        }
        if (metaMapSelection3.getStatus() == STATE_DELETED) {
            ((MetaMapSelection)object2).setStatus(STATE_DELETED);
        }
        metaMapSelection3.setCorrespondentNode((MetaMapSelection)object2);
        ((MetaMapSelection)object2).setCorrespondentNode(metaMapSelection3);
        metaMapSelection3.setPropertiesComparator(metaPropertiesComparator);
        ((MetaMapSelection)object2).setPropertiesComparator(metaPropertiesComparator);
        metaMapSelection3.setComplexPropertyXMLName(string);
        ((MetaMapSelection)object2).setComplexPropertyXMLName(string);
        metaMapSelection.addChild(metaMapSelection3);
        metaMapSelection2.addChild((ModelIdObjectSelection)object2);
        if (classDescription != null) {
            this.addStructure(metaMapSelection3, (MetaMapSelection)object2, classDescription, map3, map4);
        }
    }

    private void processCollection(MetaMapSelection metaMapSelection, MetaMapSelection metaMapSelection2, List list, List list2, ClassDescription.CollectionDescription collectionDescription) {
        boolean bl = this.hasID(list, collectionDescription) || this.hasID(list2, collectionDescription);
        ArrayList arrayList = new ArrayList();
        if (list != null) {
            if (collectionDescription.itemIsRef) {
                this.addExistingRefsToLeft(metaMapSelection, metaMapSelection2, list, list2, collectionDescription, bl, arrayList);
                this.addDeletedRefsToRight(metaMapSelection, metaMapSelection2, list, list2, collectionDescription, bl, arrayList);
            } else {
                this.addExistingToLeft(metaMapSelection, metaMapSelection2, list, list2, collectionDescription, bl, arrayList);
                this.addDeletedToRight(metaMapSelection, metaMapSelection2, list, list2, collectionDescription, bl, arrayList);
            }
        }
    }

    private void addExistingToLeft(MetaMapSelection metaMapSelection, MetaMapSelection metaMapSelection2, List list, List list2, ClassDescription.CollectionDescription collectionDescription, boolean bl, List list3) {
        for (int i = 0; i < list.size(); ++i) {
            String string;
            Object object;
            Object object2;
            int n = -1;
            int n2 = -1;
            Map map = (Map)list.get(i);
            String string2 = MapCompareBuilder.getID(map);
            Map map2 = null;
            if (bl) {
                n2 = i;
                map2 = this.getByID(list2, string2);
                if (map2 != null) {
                    n = list2.indexOf(map2);
                }
            } else {
                map2 = this.getByPosition(list2, i);
            }
            if (map2 != null) {
                list3.add(map2);
            }
            ClassDescription classDescription = this.getClassDecription(map);
            MetaPropertiesComparator metaPropertiesComparator = null;
            metaPropertiesComparator = collectionDescription.isMapItem ? new MetaPropertiesComparator(map, map2, true, this.design, this.storageDesign) : new MetaPropertiesComparator(map, map2, classDescription, this.design, this.storageDesign);
            MetaMapSelection metaMapSelection3 = new MetaMapSelection(map);
            metaMapSelection3.setItemPosition(n2);
            metaMapSelection3.setItemPositionImportant(this.isItemPositionImportant(collectionDescription));
            if ("NONAME".equals(metaMapSelection3.getName())) {
                object2 = this.getObjectName(map);
                if (object2 != null) {
                    metaMapSelection3.setName((String)object2);
                } else {
                    metaMapSelection3.setName(collectionDescription.itemXmlName);
                }
            }
            if ((object2 = metaMapSelection3.getObjectClass()) == null || RelationalObjectProxy.class.isAssignableFrom((Class<?>)object2)) {
                object = this.getClassByObject(map);
                if (object != null) {
                    object2 = object;
                    metaMapSelection3.setObjectClass((Class)object);
                } else if (metaMapSelection.getObjectClass() != null) {
                    object2 = metaMapSelection.getObjectClass();
                    metaMapSelection3.setObjectClass((Class)object2);
                }
            }
            if (object2 != null) {
                metaMapSelection3.setChildClass((Class)object2);
                if (TopView.class.isAssignableFrom((Class<?>)object2)) {
                    object = this.getClassByObject(map);
                    if (object != null) {
                        object2 = object;
                        metaMapSelection3.setObjectClass((Class)object);
                    } else if (metaMapSelection.getObjectClass() != null) {
                        object2 = metaMapSelection.getObjectClass();
                        metaMapSelection3.setObjectClass((Class)object2);
                    }
                    metaMapSelection3.setObjectClass((Class)object2);
                }
            }
            if (map2 != null) {
                object = new MetaMapSelection(map2);
                ((MetaMapSelection)object).setItemPosition(n);
                ((MetaMapSelection)object).setItemPositionImportant(this.isItemPositionImportant(collectionDescription));
                if ("NONAME".equals(((MetaMapSelection)object).getName())) {
                    string = this.getObjectName(map2);
                    if (string != null) {
                        ((ModelObject)object).setName(string);
                    } else {
                        ((ModelObject)object).setName(collectionDescription.itemXmlName);
                    }
                }
            } else {
                string = null;
                if (map != null) {
                    string = (String)map.get("name");
                }
                if (string == null) {
                    string = NEW;
                }
                object = new MetaMapSelection(string);
                metaMapSelection3.setStatus(STATE_NEW);
                ((MetaMapSelection)object).setStatus(STATE_NEW);
                if (n2 > -1) {
                    ((MetaMapSelection)object).setItemPosition(n2);
                    ((MetaMapSelection)object).setItemPositionImportant(this.isItemPositionImportant(collectionDescription));
                }
            }
            if (object2 == null) {
                object2 = this.getClassByObject(map2);
            }
            if (object2 != null) {
                ((MetaMapSelection)object).setObjectClass((Class)object2);
                ((MetaMapSelection)object).setChildClass((Class)object2);
                metaMapSelection3.setChildClass((Class)object2);
                if (TopView.class.isAssignableFrom((Class<?>)object2)) {
                    ((MetaMapSelection)object).setObjectClass((Class)object2);
                    metaMapSelection3.setObjectClass((Class)object2);
                }
            }
            metaMapSelection3.setCorrespondentNode((MetaMapSelection)object);
            ((MetaMapSelection)object).setCorrespondentNode(metaMapSelection3);
            metaMapSelection3.setPropertiesComparator(metaPropertiesComparator);
            ((MetaMapSelection)object).setPropertiesComparator(metaPropertiesComparator);
            metaMapSelection.addChild(metaMapSelection3);
            metaMapSelection2.addChild((ModelIdObjectSelection)object);
            if (metaMapSelection.getObjectClass() == null) {
                metaMapSelection.setChildClass(metaMapSelection3.getObjectClass());
                metaMapSelection2.setChildClass(((MetaMapSelection)object).getObjectClass());
            }
            if (classDescription == null || map2 == null) continue;
            this.addStructure(metaMapSelection3, (MetaMapSelection)object, classDescription, map, map2);
        }
    }

    private void addDeletedToRight(MetaMapSelection metaMapSelection, MetaMapSelection metaMapSelection2, List list, List list2, ClassDescription.CollectionDescription collectionDescription, boolean bl, List list3) {
        for (int i = 0; i < list2.size(); ++i) {
            Map map = (Map)list2.get(i);
            if (list3.contains(map)) continue;
            Map map2 = Collections.EMPTY_MAP;
            ClassDescription classDescription = this.getClassDecription(map);
            MetaPropertiesComparator metaPropertiesComparator = null;
            metaPropertiesComparator = collectionDescription.isMapItem ? new MetaPropertiesComparator(map2, map, true, this.design, this.storageDesign) : new MetaPropertiesComparator(map2, map, classDescription, this.design, this.storageDesign);
            MetaMapSelection metaMapSelection3 = new MetaMapSelection(TO_DELETE);
            MetaMapSelection metaMapSelection4 = null;
            if (map != null && "NONAME".equals((metaMapSelection4 = new MetaMapSelection(map)).getName())) {
                String string = this.getObjectName(map);
                if (string != null) {
                    metaMapSelection4.setName(string);
                } else {
                    metaMapSelection4.setName(collectionDescription.itemXmlName);
                }
            }
            metaMapSelection3.setStatus(STATE_DELETED);
            metaMapSelection3.setCorrespondentNode(metaMapSelection4);
            metaMapSelection3.setPropertiesComparator(metaPropertiesComparator);
            metaMapSelection.addChild(metaMapSelection3);
            metaMapSelection2.addChild(metaMapSelection4);
            if (metaMapSelection4 == null) continue;
            metaMapSelection4.setStatus(STATE_DELETED);
            metaMapSelection3.setChildClass(metaMapSelection4.getObjectClass());
            metaMapSelection4.setCorrespondentNode(metaMapSelection3);
            metaMapSelection4.setPropertiesComparator(metaPropertiesComparator);
            if (metaMapSelection4.getObjectClass() != null) continue;
            metaMapSelection4.setChildClass(metaMapSelection.getObjectClass());
            metaMapSelection3.setChildClass(metaMapSelection.getObjectClass());
        }
    }

    private void addExistingRefsToLeft(MetaMapSelection metaMapSelection, MetaMapSelection metaMapSelection2, List list, List list2, ClassDescription.CollectionDescription collectionDescription, boolean bl, List list3) {
        for (int i = 0; i < list.size(); ++i) {
            MetaMapSelection metaMapSelection3;
            String string = (String)list.get(i);
            list3.add(string);
            String string2 = this.getObjectName(string);
            if (string2 == null) {
                string2 = collectionDescription.itemXmlName;
            }
            int n = this.getRefPosByID(list2, string);
            Class clazz = this.getClassByObject(string);
            MetaMapSelection metaMapSelection4 = new MetaMapSelection(string2);
            metaMapSelection4.setChildClass(clazz);
            metaMapSelection4.setReferenceID(string);
            if (n > -1) {
                metaMapSelection3 = new MetaMapSelection(string2);
            } else {
                metaMapSelection3 = new MetaMapSelection(NEW);
                metaMapSelection4.setStatus(STATE_NEW);
                metaMapSelection3.setStatus(STATE_NEW);
            }
            metaMapSelection3.setChildClass(clazz);
            metaMapSelection4.setCorrespondentNode(metaMapSelection3);
            metaMapSelection3.setCorrespondentNode(metaMapSelection4);
            metaMapSelection4.setPropertiesComparator(EMPTY_COMPARATOR);
            metaMapSelection3.setPropertiesComparator(EMPTY_COMPARATOR);
            metaMapSelection.addChild(metaMapSelection4);
            metaMapSelection2.addChild(metaMapSelection3);
            if (metaMapSelection.getObjectClass() != null) continue;
            metaMapSelection.setChildClass(metaMapSelection4.getObjectClass());
            metaMapSelection2.setChildClass(metaMapSelection3.getObjectClass());
        }
    }

    private void addDeletedRefsToRight(MetaMapSelection metaMapSelection, MetaMapSelection metaMapSelection2, List list, List list2, ClassDescription.CollectionDescription collectionDescription, boolean bl, List list3) {
        for (int i = 0; i < list2.size(); ++i) {
            String string = (String)list2.get(i);
            if (list3.contains(string)) continue;
            String string2 = this.getObjectName(string);
            if (string2 == null) {
                string2 = collectionDescription.itemXmlName;
            }
            MetaPropertiesComparator metaPropertiesComparator = EMPTY_COMPARATOR;
            Class clazz = this.getClassByObject(string);
            MetaMapSelection metaMapSelection3 = new MetaMapSelection(TO_DELETE);
            MetaMapSelection metaMapSelection4 = new MetaMapSelection(string2);
            metaMapSelection3.setStatus(STATE_DELETED);
            metaMapSelection4.setStatus(STATE_DELETED);
            metaMapSelection4.setChildClass(clazz);
            metaMapSelection3.setChildClass(clazz);
            metaMapSelection3.setCorrespondentNode(metaMapSelection4);
            metaMapSelection4.setCorrespondentNode(metaMapSelection3);
            metaMapSelection3.setPropertiesComparator(metaPropertiesComparator);
            metaMapSelection4.setPropertiesComparator(metaPropertiesComparator);
            metaMapSelection3.setReferenceID(string);
            metaMapSelection4.setReferenceID(string);
            metaMapSelection.addChild(metaMapSelection3);
            metaMapSelection2.addChild(metaMapSelection4);
            if (metaMapSelection4.getObjectClass() != null) continue;
            metaMapSelection4.setChildClass(metaMapSelection.getObjectClass());
            metaMapSelection3.setChildClass(metaMapSelection.getObjectClass());
        }
    }

    private boolean hasID(List list, ClassDescription.CollectionDescription collectionDescription) {
        if (list != null && list.size() > 0) {
            Map map;
            String string;
            if (collectionDescription.itemIsRef) {
                return true;
            }
            Object e = list.get(0);
            if (e instanceof Map && (string = MapCompareBuilder.getID(map = (Map)e)) != null && !"NO_ID".equals(string)) {
                return true;
            }
        }
        return false;
    }

    private Map getByID(List list, String string) {
        for (Map map : list) {
            String string2 = MapCompareBuilder.getID(map);
            if (string2 == null || !string2.equals(string)) continue;
            return map;
        }
        return null;
    }

    private int getRefPosByID(List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            if (string2 == null || !string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    private Map getByPosition(List list, int n) {
        if (n < list.size()) {
            return (Map)list.get(n);
        }
        return null;
    }

    private String getObjectName(Map map) {
        DesignObject designObject;
        if (map == null) {
            return null;
        }
        String string = MetaMapSelection.getID(map);
        if (this.design != null && (designObject = this.design.getDesignObject(string)) != null) {
            return ((ModelObject)designObject).getName();
        }
        return (String)map.get("foType");
    }

    private Class getClassByObject(Map map) {
        ModelIDObject modelIDObject;
        String string = MetaMapSelection.getID(map);
        if (this.design != null && (modelIDObject = this.design.getDesignObject(string)) != null) {
            Index index;
            if (modelIDObject instanceof Index && (index = (Index)modelIDObject).isFK()) {
                return FKIndexAssociation.class;
            }
            return modelIDObject.getClass();
        }
        if (this.storageDesign != null && (modelIDObject = this.storageDesign.getStorageObject(string)) != null) {
            return modelIDObject.getClass();
        }
        return null;
    }

    private String getObjectName(String string) {
        ModelIDObject modelIDObject;
        if (this.design != null && (modelIDObject = this.design.getDesignObject(string)) != null) {
            return modelIDObject.getName();
        }
        if (this.storageDesign != null && (modelIDObject = this.storageDesign.getStorageObject(string)) != null) {
            return modelIDObject.getName();
        }
        return null;
    }

    private Class getClassByObject(String string) {
        DesignObject designObject;
        if (this.design != null && (designObject = this.design.getDesignObject(string)) != null) {
            return designObject.getClass();
        }
        return null;
    }

    public void mergeToRightMap() {
        this.copyProperties(this.leftRoot);
        this.mergeStructure(this.leftRoot);
    }

    public Map getRightMap() {
        return this.rightMap;
    }

    public Map getLefttMap() {
        return this.leftMap;
    }

    private void copyProperties(MetaMapSelection metaMapSelection) {
        if (metaMapSelection.getStatus() != ModelIdObjectSelection.STATE_DELETED && metaMapSelection.getStatus() != ModelIdObjectSelection.STATE_NEW) {
            Object object;
            if (metaMapSelection.isSelected() && metaMapSelection.isModified() && (object = metaMapSelection.getPropertiesComparator()) != null) {
                ((MetaPropertiesComparator)object).copySelectedProperties();
            }
            for (MetaMapSelection metaMapSelection2 : metaMapSelection.getChilds()) {
                this.copyProperties(metaMapSelection2);
            }
        }
    }

    private void mergeStructure(MetaMapSelection metaMapSelection) {
        if (metaMapSelection.getStatus() != ModelIdObjectSelection.STATE_DELETED && metaMapSelection.getStatus() != ModelIdObjectSelection.STATE_NEW) {
            if (metaMapSelection.isMetaCollection()) {
                this.mergeCollections(metaMapSelection, metaMapSelection.getCorrespondentNode());
            }
            if (metaMapSelection.isComplexPropertiesList()) {
                this.mergeComplexProperties(metaMapSelection);
            } else {
                for (MetaMapSelection metaMapSelection2 : metaMapSelection.getChilds()) {
                    this.mergeStructure(metaMapSelection2);
                }
            }
        }
    }

    private void mergeComplexProperties(MetaMapSelection metaMapSelection) {
        MetaMapSelection metaMapSelection2 = metaMapSelection.getCorrespondentNode();
        Map map = metaMapSelection2.getMap();
        if (map != null) {
            for (MetaMapSelection metaMapSelection3 : metaMapSelection.getChilds()) {
                if (!metaMapSelection3.isSelected()) continue;
                String string = metaMapSelection3.getComplexPropertyXMLName();
                if (metaMapSelection3.getStatus() == ModelIdObjectSelection.STATE_DELETED) {
                    if (string == null) continue;
                    map.remove(string);
                    continue;
                }
                if (metaMapSelection3.getStatus() == ModelIdObjectSelection.STATE_NEW) {
                    Map map2;
                    if (string == null || (map2 = metaMapSelection3.getMap()) == null) continue;
                    map.put(string, map2);
                    continue;
                }
                this.mergeStructure(metaMapSelection3);
            }
        }
    }

    private void mergeCollections(MetaMapSelection metaMapSelection, MetaMapSelection metaMapSelection2) {
        ClassDescription.CollectionDescription collectionDescription = metaMapSelection.getCollectionDescription();
        List list = metaMapSelection2.getListFromMap();
        if (list != null) {
            for (MetaMapSelection metaMapSelection3 : metaMapSelection.getChilds()) {
                Object object;
                if (metaMapSelection3.getStatus() != ModelIdObjectSelection.STATE_DELETED || !metaMapSelection3.isSelected()) continue;
                if (collectionDescription.itemIsRef) {
                    object = metaMapSelection3.getCorrespondentNode().getReferenceID();
                    if (object == null) continue;
                    list.remove(object);
                    continue;
                }
                object = metaMapSelection3.getCorrespondentNode().getMap();
                if (object == null) continue;
                list.remove(object);
            }
            int n = 0;
            for (Object object : metaMapSelection.getChilds()) {
                if (((ModelIdObjectSelection)object).isSelected()) {
                    int n2;
                    Object object2;
                    if (collectionDescription.itemIsRef) {
                        object2 = null;
                        if (((ModelIdObjectSelection)object).getStatus() == ModelIdObjectSelection.STATE_NEW) {
                            object2 = ((MetaMapSelection)object).getReferenceID();
                            if (object2 != null) {
                                if (n > list.size()) {
                                    list.add(object2);
                                } else {
                                    list.add(n, object2);
                                }
                            }
                        } else if (((ModelIdObjectSelection)object).getStatus() != ModelIdObjectSelection.STATE_DELETED && (object2 = ((MetaMapSelection)object).getCorrespondentNode().getReferenceID()) != null && (n2 = list.indexOf(object2)) != n && list.remove(object2)) {
                            if (n > list.size()) {
                                list.add(object2);
                            } else {
                                list.add(n, object2);
                            }
                        }
                    } else {
                        object2 = null;
                        if (((ModelIdObjectSelection)object).getStatus() == ModelIdObjectSelection.STATE_NEW) {
                            object2 = ((MetaMapSelection)object).getMap();
                            if (object2 != null) {
                                if (n > list.size()) {
                                    list.add(object2);
                                } else {
                                    list.add(n, object2);
                                }
                            }
                        } else if (((ModelIdObjectSelection)object).getStatus() != ModelIdObjectSelection.STATE_DELETED) {
                            object2 = ((MetaMapSelection)object).getCorrespondentNode().getMap();
                            this.mergeStructure((MetaMapSelection)object);
                            if (object2 != null && (n2 = list.indexOf(object2)) != n && list.remove(object2)) {
                                if (n > list.size()) {
                                    list.add(object2);
                                } else {
                                    list.add(n, object2);
                                }
                            }
                        }
                    }
                }
                ++n;
            }
        }
    }

    public void updateBothModifiedStatus() {
        this.leftRoot.resetModifiedStatus();
        this.rightRoot.resetModifiedStatus();
    }

    private boolean isItemPositionImportant(ClassDescription.CollectionDescription collectionDescription) {
        if (collectionDescription.isProxyitem || collectionDescription.isObjectViewItem || collectionDescription.isTVDiagramItem || collectionDescription.isTVConnectorItem) {
            return false;
        }
        return collectionDescription.isOrderImportant;
    }
}

