/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.XMLFromObjTransformer;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLToObjectTransformer
extends MDTransformer
implements MDXMLConstants {
    public static boolean processCreatedTime = true;
    public static boolean checkForChanges = false;
    private static final Logger LOGGER = new Logger(XMLToObjectTransformer.class);
    public static DocumentBuilder DOCUMENT_BUILDER = null;
    static DOMParser parser = null;
    static XMLDOMImplementation domimpl;

    @Override
    public String transformFromObjectToString(Object object) {
        MDTransformationManager.TrObjects trObjects = this.getTransformationManager().getTransformersFor(object.getClass());
        XMLToObjectTransformer xMLToObjectTransformer = (XMLToObjectTransformer)trObjects.getFromObjectTransformer();
        if (xMLToObjectTransformer != null) {
            return xMLToObjectTransformer.transformFromObjectToString(object);
        }
        return null;
    }

    public void transformToObject(Object object, String string) {
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        this.transformToObject(object, inputSource);
        stringReader.close();
    }

    public void transformToObject(Object object, File file) throws FileNotFoundException, UnsupportedEncodingException {
        this.transformToObject(object, file, false);
    }

    public void transformToObject(Object object, File file, boolean bl) throws FileNotFoundException, UnsupportedEncodingException {
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        if (inputStreamReader != null) {
            InputSource inputSource = new InputSource(inputStreamReader);
            this.transformToObject(object, inputSource, bl);
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void transformToObject(Object object, InputSource inputSource) {
        this.transformToObject(object, inputSource, false);
    }

    public void transformToObject(Object object, InputSource inputSource, boolean bl) {
        Document document;
        block5: {
            document = null;
            try {
                document = DOCUMENT_BUILDER.parse(inputSource);
            }
            catch (Exception exception) {
                Design.openFailed();
                if (object instanceof StorableObject) {
                    StorableObject storableObject = (StorableObject)object;
                    LOGGER.error("Can not parse file for " + storableObject.getName() + " in file " + storableObject.getStorageName() + "\n", exception);
                } else {
                    LOGGER.error("Can not parse file:", exception);
                }
                if (!(object instanceof ModelIDObject)) break block5;
                System.out.println(((ModelIDObject)object).getObjectID() + "  " + ((ModelIDObject)object).getName());
            }
        }
        if (document != null) {
            this.transformToObject(object, document, bl);
        }
    }

    public void transformToObject(Object object, Document document) {
        this.transformToObject(object, document, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformToObject(Object object, Document document, boolean bl) {
        Element element = document.getDocumentElement();
        if (element != null) {
            ModelIDObject modelIDObject = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            if (!bl && checkForChanges && object instanceof ModelIDObject && !(modelIDObject = (ModelIDObject)object).isDirty()) {
                try {
                    MDTransformer.includeLoggingProps = false;
                    MDTransformer.includeID = false;
                    string = this.transformFromObjectToString(object);
                    string3 = modelIDObject.getChangedTime();
                }
                finally {
                    MDTransformer.includeLoggingProps = true;
                    MDTransformer.includeID = true;
                }
            }
            this.transformToObject(object, element, bl);
            if (string != null && modelIDObject != null && string3 != null) {
                try {
                    MDTransformer.includeLoggingProps = false;
                    MDTransformer.includeID = false;
                    string2 = this.transformFromObjectToString(object);
                    string3 = modelIDObject.getChangedTime();
                }
                finally {
                    MDTransformer.includeLoggingProps = true;
                    MDTransformer.includeID = true;
                }
                if (string.equals(string2)) {
                    modelIDObject.setChangedTime(string3);
                }
            }
        }
    }

    public void transformToObject(Object object, Element element, boolean bl) {
        ClassDescription classDescription = this.getClassDescription();
        Map map = this.loadElements(element);
        ArrayList<ClassDescription.PropertyDescription> arrayList = new ArrayList<ClassDescription.PropertyDescription>();
        ArrayList<ClassDescription.PropertyDescription> arrayList2 = new ArrayList<ClassDescription.PropertyDescription>();
        ArrayList<ClassDescription.PropertyDescription> arrayList3 = new ArrayList<ClassDescription.PropertyDescription>();
        for (ClassDescription.PropertyDescription object2 : classDescription.getPropertiesList()) {
            if (object2.isExternalProperty && !bl) continue;
            if (object2.isLoggingProp) {
                arrayList.add(object2);
                continue;
            }
            if (object2.isAfterCollectionProcessing) {
                arrayList2.add(object2);
                continue;
            }
            if (object2.beforeCollection != null && !"".equals(object2.beforeCollection) || object2.afterCollection != null && !"".equals(object2.afterCollection)) {
                arrayList3.add(object2);
                continue;
            }
            this.processProperty(object, map, element, object2, bl);
        }
        this.processClassPropertyMap(object, map, classDescription);
        if (bl && classDescription.isCreateAllExtItemsFirst) {
            this.createAllExtItemsFirst(object, map, element, classDescription, bl);
        }
        for (ClassDescription.CollectionDescription collectionDescription : classDescription.getCollectionsList()) {
            if (collectionDescription.isExternalCollection && !bl) continue;
            if (collectionDescription.preProcess != null) {
                this.invokeMethod(object, collectionDescription.preProcess);
            }
            this.processBeforeCollection(object, map, element, collectionDescription, arrayList3, bl);
            if (collectionDescription.createAllItemsFirst) {
                this.createAllItemsFirst(object, map, element, collectionDescription, bl);
            }
            this.processCollection(object, map, element, collectionDescription, bl);
            this.processAfterCollection(object, map, element, collectionDescription, arrayList3, bl);
        }
        for (ClassDescription.PropertyDescription propertyDescription : arrayList2) {
            if (propertyDescription.isExternalProperty && !bl) continue;
            this.processProperty(object, map, element, propertyDescription, bl);
        }
        for (ClassDescription.PropertyDescription propertyDescription : arrayList) {
            this.processProperty(object, map, element, propertyDescription, bl);
        }
        this.invokeMethod(object, classDescription.afterInit);
        if (bl) {
            this.invokeMethod(object, classDescription.afterInitExt);
        }
    }

    private void processBeforeCollection(Object object, Map map, Element element, ClassDescription.CollectionDescription collectionDescription, List list, boolean bl) {
        for (ClassDescription.PropertyDescription propertyDescription : list) {
            if (propertyDescription.beforeCollection == null || collectionDescription.name == null || collectionDescription.name.equals(propertyDescription.beforeCollection)) continue;
            this.processProperty(object, map, element, propertyDescription, bl);
        }
    }

    private void processAfterCollection(Object object, Map map, Element element, ClassDescription.CollectionDescription collectionDescription, List list, boolean bl) {
        for (ClassDescription.PropertyDescription propertyDescription : list) {
            if (propertyDescription.afterCollection == null || collectionDescription.name == null || !collectionDescription.name.equals(propertyDescription.afterCollection)) continue;
            this.processProperty(object, map, element, propertyDescription, bl);
        }
    }

    private void processClassPropertyMap(Object object, Map map, ClassDescription classDescription) {
        if (classDescription.isPropertyMap && object instanceof PropertyMap) {
            NodeList nodeList;
            int n;
            PropertyMap propertyMap = (PropertyMap)object;
            Element element = (Element)map.get("propertyMap");
            propertyMap.clearProperties();
            if (element != null && (n = (nodeList = element.getElementsByTagName("property")).getLength()) > 0) {
                for (int i = 0; i < n; ++i) {
                    Element element2 = (Element)nodeList.item(i);
                    String string = element2.getAttribute("name");
                    if (string == null || "".equals(string)) continue;
                    String string2 = element2.getAttribute("value");
                    propertyMap.setProperty(StringUtilities.decodeAttributeValue(string), StringUtilities.decodeAttributeValue(string2));
                }
            }
        }
    }

    private void processProperty(Object object, Map map, Element element, ClassDescription.PropertyDescription propertyDescription, boolean bl) {
        if (propertyDescription.isCreatedTimeProp && !processCreatedTime) {
            return;
        }
        String string = null;
        boolean bl2 = false;
        Object v = map.get(propertyDescription.xmlName);
        if (v == null && propertyDescription.oldXmlName != null) {
            v = map.get(propertyDescription.oldXmlName);
        }
        if (v != null) {
            if (v instanceof Node && !(v instanceof Element)) {
                string = ((Node)v).getNodeValue();
            } else if (v instanceof Element) {
                Element element2 = (Element)v;
                if (propertyDescription.isRectangle) {
                    this.processRectangle(element2, object, propertyDescription);
                    return;
                }
                if (propertyDescription.isPropertyMap) {
                    this.processPropertyAsPropertyMap(object, element2, propertyDescription);
                    return;
                }
                if (propertyDescription.isMap) {
                    this.processMapProperty(object, element2, propertyDescription);
                    return;
                }
                if (propertyDescription.isSimpleClass() || propertyDescription.isStringClass() || propertyDescription.isReferred()) {
                    Node node = element2.getFirstChild();
                    if (node != null) {
                        string = node.getNodeValue();
                    }
                } else if (!propertyDescription.isReferred()) {
                    XMLToObjectTransformer xMLToObjectTransformer;
                    MDTransformationManager.TrObjects trObjects;
                    Object object2 = XMLToObjectTransformer.getObjectForProperty(object, propertyDescription);
                    if (object2 == null && propertyDescription.createProperty != null) {
                        object2 = this.createObject(object, propertyDescription.createProperty);
                    }
                    if (object2 != null && (trObjects = this.getTransformationManager().getTransformersFor(object2.getClass())) != null && trObjects.getFromObjectTransformer() != null && trObjects.getFromObjectTransformer() instanceof XMLFromObjTransformer && (xMLToObjectTransformer = (XMLToObjectTransformer)trObjects.getToObjectTransformer()) != null) {
                        xMLToObjectTransformer.transformToObject(object2, element2, bl);
                        if (propertyDescription.setter != null) {
                            this.setObjectForProperty(object, propertyDescription, object2);
                        }
                    }
                    return;
                }
            }
        } else {
            bl2 = true;
        }
        if (bl2) {
            this.setDefaultProperty(object, propertyDescription);
        } else {
            if (string == null) {
                string = "";
            } else {
                string = StringUtilities.decodeAttributeValue(string);
                if ((propertyDescription.isID || propertyDescription.isListOfRefs) && object instanceof ModelIDObject) {
                    string = ((ModelIDObject)object).replaceIDsInValue(string);
                }
            }
            this.setProperty(object, string, propertyDescription);
        }
    }

    private void processPropertyAsPropertyMap(Object object, Element element, ClassDescription.PropertyDescription propertyDescription) {
        Object object2 = XMLToObjectTransformer.getObjectForProperty(object, propertyDescription);
        boolean bl = false;
        if (object2 == null) {
            object2 = this.createObject(object, propertyDescription.createPMap);
            bl = true;
        }
        if (object2 instanceof PropertyMap) {
            NodeList nodeList = element.getElementsByTagName(propertyDescription.pmItemName);
            int n = nodeList.getLength();
            PropertyMap propertyMap = (PropertyMap)object2;
            if (!bl) {
                propertyMap.clearProperties();
            }
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = element2.getAttribute(propertyDescription.pmKeyName);
                String string2 = element2.getAttribute(propertyDescription.pmValueName);
                if (string == null || string2 == null || "".equals(string)) continue;
                propertyMap.setProperty(StringUtilities.decodeAttributeValue(string), StringUtilities.decodeAttributeValue(string2));
            }
            if (bl) {
                this.setObjectForProperty(object, propertyDescription, object2);
            }
        }
    }

    private void processMapProperty(Object object, Element element, ClassDescription.PropertyDescription propertyDescription) {
        Object object2 = XMLToObjectTransformer.getObjectForProperty(object, propertyDescription);
        if (object2 != null && object2 instanceof Map) {
            NodeList nodeList = element.getElementsByTagName(propertyDescription.pmItemName);
            int n = nodeList.getLength();
            Map map = (Map)object2;
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = element2.getAttribute("key");
                String string2 = element2.getAttribute("value");
                if (string == null || string2 == null || "".equals(string)) continue;
                map.put(StringUtilities.decodeAttributeValue(string), StringUtilities.decodeAttributeValue(string2));
            }
        }
    }

    private List getListWithElements(Object object, ClassDescription.CollectionDescription collectionDescription) {
        Object object2 = XMLToObjectTransformer.getCollection(object, collectionDescription);
        if (object2 != null) {
            ElementSet elementSet;
            if (object2 instanceof Collection) {
                Collection collection = (Collection)object2;
                if (collection.size() > 0) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(collection);
                    return arrayList;
                }
            } else if (object2 instanceof ElementSet && (elementSet = (ElementSet)object2).size() > 0) {
                ArrayList arrayList = new ArrayList();
                elementSet.addAllElementsTo(arrayList);
                return arrayList;
            }
        }
        return Collections.EMPTY_LIST;
    }

    private void processCollection(Object object, Map map, Element element, ClassDescription.CollectionDescription collectionDescription, boolean bl) {
        Element element2 = (Element)map.get(collectionDescription.xmlName);
        if (element2 != null) {
            NodeList nodeList;
            int n;
            if (this.canProcessCollectionItem(collectionDescription)) {
                List list = this.getListWithElements(object, collectionDescription);
                ArrayList arrayList = new ArrayList();
                if (!collectionDescription.itemIsRef) {
                    this.processCollectionWithContained(object, element2, collectionDescription, arrayList, list, bl);
                } else {
                    this.processCollectionWithRefs(object, element2, collectionDescription, arrayList);
                }
                if (collectionDescription.applyList == null) {
                    this.orderAndClearList(object, collectionDescription, list, arrayList);
                } else {
                    this.applyList(object, collectionDescription.applyList, arrayList);
                }
            } else if (collectionDescription.isMapItem && collectionDescription.applyList != null && (n = (nodeList = element2.getElementsByTagName(collectionDescription.itemXmlName)).getLength()) > 0) {
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < n; ++i) {
                    Element element3 = (Element)nodeList.item(i);
                    NamedNodeMap namedNodeMap = element3.getAttributes();
                    int n2 = namedNodeMap.getLength();
                    if (n2 <= 0) continue;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (int j = 0; j < n2; ++j) {
                        Node node = namedNodeMap.item(j);
                        String string = node.getNodeName();
                        String string2 = node.getNodeValue();
                        hashMap.put(StringUtilities.decodeAttributeValue(string), StringUtilities.decodeAttributeValue(string2));
                    }
                    arrayList.add(hashMap);
                }
                this.applyList(object, collectionDescription.applyList, arrayList);
            }
        } else if (this.canProcessCollectionItem(collectionDescription)) {
            List list = this.getListWithElements(object, collectionDescription);
            this.orderAndClearList(object, collectionDescription, list, Collections.EMPTY_LIST);
        } else if (collectionDescription.isMapItem && collectionDescription.applyList != null) {
            this.applyList(object, collectionDescription.applyList, Collections.EMPTY_LIST);
        }
    }

    private void createAllItemsFirst(Object object, Map map, Element element, ClassDescription.CollectionDescription collectionDescription, boolean bl) {
        Element element2 = (Element)map.get(collectionDescription.xmlName);
        if (element2 != null && this.canProcessCollectionItem(collectionDescription)) {
            List list = this.getListWithElements(object, collectionDescription);
            ArrayList arrayList = new ArrayList();
            if (!collectionDescription.itemIsRef) {
                this.createAllContained(object, element2, collectionDescription, arrayList, list, bl);
            }
            if (collectionDescription.applyList == null) {
                this.orderAndClearList(object, collectionDescription, list, arrayList);
            } else {
                this.applyList(object, collectionDescription.applyList, arrayList);
            }
        }
    }

    private void createAllExtItemsFirst(Object object, Map map, Element element, ClassDescription classDescription, boolean bl) {
        for (ClassDescription.CollectionDescription collectionDescription : classDescription.getCollectionsList()) {
            Element element2;
            if (!collectionDescription.isExternalCollection || !bl || (element2 = (Element)map.get(collectionDescription.xmlName)) == null || !this.canProcessCollectionItem(collectionDescription)) continue;
            List list = this.getListWithElements(object, collectionDescription);
            ArrayList arrayList = new ArrayList();
            if (!collectionDescription.itemIsRef) {
                this.createAllContained(object, element2, collectionDescription, arrayList, list, bl);
            }
            if (collectionDescription.applyList == null) {
                this.orderAndClearList(object, collectionDescription, list, arrayList);
                continue;
            }
            this.applyList(object, collectionDescription.applyList, arrayList);
        }
    }

    private void createAllContained(Object object, Element element, ClassDescription.CollectionDescription collectionDescription, List list, List list2, boolean bl) {
        NodeList nodeList = element.getElementsByTagName(collectionDescription.itemXmlName);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            Object object2 = this.getOrCreateObject(object, element2, collectionDescription, list2);
            if (object2 == null) continue;
            if (collectionDescription.addItem != null) {
                this.addItem(object, collectionDescription.addItem, object2);
            }
            list.add(object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCollectionWithContained(Object object, Element element, ClassDescription.CollectionDescription collectionDescription, List list, List list2, boolean bl) {
        XMLToObjectTransformer xMLToObjectTransformer = null;
        NodeList nodeList = element.getElementsByTagName(collectionDescription.itemXmlName);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            Object object2 = this.getOrCreateObject(object, element2, collectionDescription, list2);
            if (object2 == null) continue;
            try {
                if (object2 instanceof StorageDesign) {
                    ((StorageDesign)object2).setLoading(true);
                }
                if (xMLToObjectTransformer == null) {
                    MDTransformationManager.TrObjects trObjects = this.getTransformationManager().getTransformersFor(object2.getClass());
                    xMLToObjectTransformer = (XMLToObjectTransformer)trObjects.getToObjectTransformer();
                }
                if (xMLToObjectTransformer != null) {
                    xMLToObjectTransformer.transformToObject(object2, element2, bl);
                }
                this.processTopView(object2, element2);
                if (collectionDescription.addItem != null) {
                    this.addItem(object, collectionDescription.addItem, object2);
                }
                list.add(object2);
                continue;
            }
            finally {
                if (object2 instanceof StorageDesign) {
                    ((StorageDesign)object2).setLoading(false);
                    ((StorageDesign)object2).setOpen(true);
                }
            }
        }
    }

    private void processTopView(Object object, Element element) {
        if (object instanceof TopView) {
            // empty if block
        }
        if (object instanceof TVConnector) {
            this.processPointsCollection(element, object);
        } else if (object instanceof ContainerView) {
            // empty if block
        }
    }

    private void processRectangle(Element element, Object object, ClassDescription.PropertyDescription propertyDescription) {
        String string = element.getAttribute("x");
        String string2 = element.getAttribute("y");
        String string3 = element.getAttribute("width");
        String string4 = element.getAttribute("height");
        int n = 0;
        int n2 = 0;
        int n3 = 20;
        int n4 = 20;
        try {
            n = Integer.valueOf(string);
            n2 = Integer.valueOf(string2);
            n3 = Integer.valueOf(string3);
            n4 = Integer.valueOf(string4);
        }
        catch (Exception exception) {
            LOGGER.warn(exception.getMessage(), exception);
        }
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.setObjectForProperty(object, propertyDescription, rectangle);
    }

    private void processPointsCollection(Element element, Object object) {
        if (object instanceof TVConnector) {
            TVConnector tVConnector = (TVConnector)object;
            Element element2 = XMLToObjectTransformer.getFirstChildByTagName(element, "points");
            if (element2 != null) {
                NodeList nodeList = element2.getElementsByTagName("point");
                List list = tVConnector.getEdgePoints();
                list.clear();
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Element element3 = (Element)nodeList.item(i);
                    String string = element3.getAttribute("x");
                    String string2 = element3.getAttribute("y");
                    int n2 = 0;
                    int n3 = 0;
                    try {
                        n2 = Integer.valueOf(string);
                        n3 = Integer.valueOf(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Point point = new Point(n2, n3);
                    list.add(DiagramConstants.createPoint(point));
                }
                tVConnector.applyEdgePointsToCellView();
            }
        }
    }

    public static Element getFirstChildByTagName(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getTagName().equals(string)) continue;
            return (Element)node;
        }
        return null;
    }

    private Object getOrCreateObject(Object object, Element element, ClassDescription.CollectionDescription collectionDescription, List list) {
        if (collectionDescription.isObjectViewItem && object instanceof DesignPartView) {
            return this.getOrCreateTopView((DesignPartView)object, element, collectionDescription);
        }
        if (collectionDescription.isTVConnectorItem && object instanceof DesignPartView) {
            return this.getOrCreateTVConnector((DesignPartView)object, element, collectionDescription);
        }
        if (collectionDescription.isTVDiagramItem && object instanceof DesignPartView) {
            return this.getOrCreateTVDiagram((DesignPartView)object, element, collectionDescription);
        }
        if (collectionDescription.isPhysicalModelItem && object instanceof RelationalDesign) {
            return this.getOrCreateStorageDesign((RelationalDesign)object, element, collectionDescription);
        }
        String string = this.getID(element);
        Object object2 = null;
        if (string != null) {
            object2 = collectionDescription.getItemByID != null ? this.getItemByID(object, collectionDescription.getItemByID, string) : (object instanceof DesignObject || object instanceof DesignPart ? ((ModelIDObject)object).getDesign().getDesignObject(string) : (object instanceof StorageObject ? ((StorageObject)object).getStorageDesign().getStorageObject(string) : (object instanceof StorageDesign ? ((StorageDesign)object).getStorageObject(string) : this.getItemByID(list, string, collectionDescription))));
        }
        if (object2 == null) {
            if (collectionDescription.isProxyitem) {
                if (object instanceof ID_ObjectPropertyTranslator) {
                    object2 = ((ID_ObjectPropertyTranslator)object).translateIdToObject(null, string);
                }
            } else {
                if (collectionDescription.getItemByID == null && object instanceof ID_ObjectPropertyTranslator) {
                    object2 = ((ID_ObjectPropertyTranslator)object).translateIdToObject(collectionDescription.itemXmlName, string);
                }
                if (object2 == null) {
                    object2 = this.createItem(object, collectionDescription.createItem);
                }
            }
        }
        if (object2 instanceof ModelIDObject) {
            ((ModelIDObject)object2).setObjectID(string);
        }
        return object2;
    }

    Object getItemByID(List list, String string, ClassDescription.CollectionDescription collectionDescription) {
        for (Object e : list) {
            if (e instanceof ModelIDObject) {
                if (!((ModelIDObject)e).getObjectID().equals(string)) continue;
                return e;
            }
            return null;
        }
        return null;
    }

    private Object getOrCreateTopView(DesignPartView designPartView, Element element, ClassDescription.CollectionDescription collectionDescription) {
        if (collectionDescription.isObjectViewItem) {
            String string;
            String string2 = StringUtilities.decodeAttributeValue(element.getAttribute("oid"));
            DesignObject designObject = designPartView.getDesignPart().getDesign().getDesignObject(string2);
            if (designObject == null && designPartView.getDesignPart() instanceof TransformationTask) {
                string = StringUtilities.decodeAttributeValue(element.getAttribute("otype"));
                if ("InOutParams".equalsIgnoreCase(string)) {
                    designObject = ((TransformationTask)designPartView.getDesignPart()).getInOutParamsObjectById(string2);
                } else if ("InfoStore".equalsIgnoreCase(string)) {
                    designObject = ((TransformationTask)designPartView.getDesignPart()).getInfoStoreSet().getObjectByID(string2);
                }
            }
            if (designObject != null) {
                string = StringUtilities.decodeAttributeValue(element.getAttribute("vid"));
                String string3 = StringUtilities.decodeAttributeValue(element.getAttribute("vnum"));
                int n = 0;
                try {
                    n = Integer.valueOf(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                TopView topView = designObject.getTopViewByID(designPartView, string, n);
                if (topView == null) {
                    topView = designPartView.createTopViewForGlobal(designObject);
                }
                if (!designPartView.getTopviewsList().contains(topView)) {
                    designPartView.add(topView);
                }
                topView.setViewID(string);
                return topView;
            }
        }
        return null;
    }

    private Object getOrCreateTVDiagram(DesignPartView designPartView, Element element, ClassDescription.CollectionDescription collectionDescription) {
        if (collectionDescription.isTVDiagramItem) {
            String string = StringUtilities.decodeAttributeValue(element.getAttribute("oid"));
            DesignPart designPart = designPartView.getDesignPart();
            DiagramView diagramView = designPart.recreateDiagramView(string);
            if (diagramView != null) {
                TopView topView;
                if (!designPartView.isMainDiagram()) {
                    designPartView.getDesignPart().getMainView().removeViewFor(diagramView);
                }
                if ((topView = diagramView.getFirstViewForDPV(designPartView)) == null) {
                    topView = designPartView.createTopViewFor(diagramView);
                }
                return topView;
            }
        }
        return null;
    }

    private Object getOrCreateStorageDesign(RelationalDesign relationalDesign, Element element, ClassDescription.CollectionDescription collectionDescription) {
        Object object;
        Element element2;
        Element element3 = this.getFirstElementByTagName("siteID", element);
        String string = element3.getTextContent();
        RDBMSSite rDBMSSite = relationalDesign.getDesign().getRDBMSSiteSet().getByObjectID(string);
        if (rDBMSSite == null && (element2 = this.getFirstElementByTagName("siteType", element)) != null) {
            object = element2.getTextContent();
            Element element4 = this.getFirstElementByTagName("siteID", element);
            String string2 = element4.getTextContent();
            Element element5 = this.getFirstElementByTagName("siteName", element);
            String string3 = element5.getTextContent();
            rDBMSSite = relationalDesign.getDesign().getRDBMSSiteSet().createSite(string3, relationalDesign.getDesign());
            int n = 9;
            try {
                n = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RDBMSType rDBMSType = relationalDesign.getDesign().getRDBMSTypeSet().get(n);
            rDBMSSite.setType(rDBMSType);
            rDBMSSite.setObjectID(string2);
            rDBMSSite.setPathID(relationalDesign.getDesign().getRDBMSSiteSet().nextIndex());
        }
        if (rDBMSSite != null) {
            boolean bl = relationalDesign.getStorageDesignFactory().existStorageDesign(rDBMSSite);
            object = relationalDesign.getStorageDesign(rDBMSSite);
            if (object != null) {
                ((StorageDesign)object).setTempModel(false);
                if (bl && !relationalDesign.getDesign().isNewDesign()) {
                    ((StorageDesign)object).openStorageDesign();
                }
            }
            return object;
        }
        return null;
    }

    private Object getOrCreateTVConnector(DesignPartView designPartView, Element element, ClassDescription.CollectionDescription collectionDescription) {
        if (collectionDescription.isTVConnectorItem) {
            String string = StringUtilities.decodeAttributeValue(element.getAttribute("oid"));
            DesignObject designObject = designPartView.getDesignPart().getDesign().getDesignObject(string);
            if (designObject != null && designObject instanceof ConnectionInterface) {
                ConnectionInterface connectionInterface = (ConnectionInterface)((Object)designObject);
                String string2 = StringUtilities.decodeAttributeValue(element.getAttribute("vid_source"));
                String string3 = StringUtilities.decodeAttributeValue(element.getAttribute("vid_target"));
                if (connectionInterface.getSourceObject() != null && connectionInterface.getTargetObject() != null) {
                    TopView topView;
                    if (!string2.equals("") && (topView = connectionInterface.getSourceObject().getTopViewByID(designPartView, string2)) != null) {
                        connectionInterface.setSourceTopView(topView);
                    }
                    if (!string3.equals("") && (topView = connectionInterface.getTargetObject().getTopViewByID(designPartView, string3)) != null) {
                        connectionInterface.setTargetTopView(topView);
                    }
                    if ((topView = connectionInterface.getViewFor(designPartView)) != null && !designPartView.getTopviewsList().contains(topView)) {
                        designPartView.add(topView);
                    }
                    return topView;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void processCollectionWithRefs(Object object, Element element, ClassDescription.CollectionDescription collectionDescription, List list) {
        Object object2;
        Object object3;
        Object object4;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (collectionDescription.listOfRefs) {
            object4 = element.getAttribute(collectionDescription.refsXMLName);
            if (object4 != null && !"".equals(object4)) {
                void string;
                object3 = ((String)object4).split(" ");
                boolean n = false;
                while (string < ((Object)object3).length) {
                    arrayList.add(object3[string]);
                    ++string;
                }
            }
        } else {
            void var8_12;
            object4 = element.getElementsByTagName(collectionDescription.itemXmlName);
            int n2 = object4.getLength();
            boolean bl = false;
            while (var8_12 < n2) {
                object2 = (Element)object4.item((int)var8_12);
                Node node = object2.getFirstChild();
                if (node != null) {
                    String string = node.getNodeValue();
                    arrayList.add(string);
                }
                ++var8_12;
            }
        }
        object4 = null;
        if (collectionDescription.nativeList && collectionDescription.addItem == null && (object3 = XMLToObjectTransformer.getCollection(object, collectionDescription)) instanceof List) {
            object4 = (List)object3;
        }
        for (String string : arrayList) {
            object2 = this.getItemByID(object, collectionDescription.getItemByID, string);
            if (object2 == null && object instanceof ID_ObjectPropertyTranslator && (object2 = ((ID_ObjectPropertyTranslator)object).translateIdToObject(collectionDescription.xmlName, string)) != null) {
                if (collectionDescription.addItem != null) {
                    this.addItem(object, collectionDescription.addItem, object2);
                } else if (collectionDescription.nativeList && object4 != null) {
                    object4.add(object2);
                }
            }
            if (object2 == null) continue;
            list.add(object2);
        }
    }

    private void orderAndClearList(Object object, ClassDescription.CollectionDescription collectionDescription, List list, List list2) {
        if (collectionDescription.isProxyitem) {
            return;
        }
        for (Object object2 : list) {
            if (list2.contains(object2)) continue;
            if (collectionDescription.removeItem != null) {
                this.removeItem(object, collectionDescription.removeItem, object2);
                continue;
            }
            if (object2 instanceof ModelIDObject && !collectionDescription.itemIsRef) {
                ((ModelIDObject)object2).remove();
                continue;
            }
            if (!(object2 instanceof ContainerView)) continue;
            ((ContainerView)object2).remove(false);
        }
        if (collectionDescription.applyList != null) {
            this.applyList(object, collectionDescription.applyList, list2);
        } else if (collectionDescription.moveMethod != null) {
            for (int i = 0; i < list2.size(); ++i) {
                Object e = list2.get(i);
                this.moveContained(object, collectionDescription.moveMethod, e, i);
            }
        } else if (collectionDescription.nativeList && collectionDescription.orderTheList) {
            Object object2;
            object2 = XMLToObjectTransformer.getCollection(object, collectionDescription);
            if (object2 instanceof List) {
                List list3 = (List)object2;
                list3.clear();
                list3.addAll(list2);
            }
        } else if (collectionDescription.isIDObjectSet) {
            // empty if block
        }
    }

    private String getID(Element element) {
        String string = element.getAttribute("id");
        if ((string == null || "".equals(string)) && (string = element.getAttribute("objectID")) != null && "".equals(string) && (string = element.getAttribute("IDREF")) != null && "".equals(string)) {
            return null;
        }
        return string;
    }

    private Map loadElements(Element element) {
        HashMap<String, Node> hashMap = new HashMap<String, Node>();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            hashMap.put(element2.getTagName(), element2);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                Node node = namedNodeMap.item(i);
                String string = node.getNodeName();
                hashMap.put(string, node);
            }
        }
        return hashMap;
    }

    static {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DOCUMENT_BUILDER = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }
}

