/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.net.InflaterInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLToMapTransformer
extends MDTransformer
implements MDXMLConstants {
    public static DocumentBuilder DOCUMENT_BUILDER = null;

    @Override
    public String transformFromObjectToString(Object object) {
        return null;
    }

    public static void transformToMap(Map map, String string) {
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        XMLToMapTransformer.transformToMap(map, inputSource);
        stringReader.close();
    }

    public static void transformToMap(Map map, File file) throws FileNotFoundException, UnsupportedEncodingException {
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        if (inputStreamReader != null) {
            InputSource inputSource = new InputSource(inputStreamReader);
            XMLToMapTransformer.transformToMap(map, inputSource);
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void transformToMap(Map map, InputStream inputStream, boolean bl) throws UnsupportedEncodingException {
        if (bl) {
            try {
                int n;
                InflaterInputStream inflaterInputStream = new InflaterInputStream(inputStream);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n2 = 1024;
                byte[] byArray = new byte[n2];
                while ((n = inflaterInputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(byteArrayInputStream);
                byteArrayOutputStream.close();
                ((InputStream)byteArrayInputStream).close();
                XMLToMapTransformer.transformToMap(map, document);
            }
            catch (Exception exception) {}
        } else {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            if (inputStreamReader != null) {
                InputSource inputSource = new InputSource(inputStreamReader);
                XMLToMapTransformer.transformToMap(map, inputSource);
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static void transformToMap(Map map, InputSource inputSource) {
        Document document = null;
        try {
            document = DOCUMENT_BUILDER.parse(inputSource);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (document != null) {
            XMLToMapTransformer.transformToMap(map, document);
        }
    }

    public static void transformToMap(Map map, Document document) {
        MDTransformationManager mDTransformationManager;
        XMLToMapTransformer xMLToMapTransformer;
        Element element = document.getDocumentElement();
        String string = element.getAttribute("class");
        if (string != null && !"".equals(string) && (xMLToMapTransformer = (XMLToMapTransformer)(mDTransformationManager = ApplicationView.getInstance().getXMLTransformationManager().getXMLMapTransformationManager()).getToObjectTransformerFor(string)) != null) {
            xMLToMapTransformer.transformToMap(map, element);
        }
    }

    public void transformToMap(Map map, Element element) {
        String string;
        ClassDescription classDescription = this.getClassDescription();
        Map map2 = this.loadElementsAndAttributes(element);
        for (ClassDescription.PropertyDescription object2 : classDescription.getPropertiesList()) {
            this.processProperty(map, map2, element, object2);
        }
        String string2 = (String)map.get("class");
        if (string2 == null && (string = element.getAttribute("class")) != null && !"".equals(string)) {
            map.put("class", string);
        }
        this.processClassPropertyMap(map, map2, classDescription);
        for (ClassDescription.CollectionDescription collectionDescription : classDescription.getCollectionsList()) {
            this.processCollection(map, map2, element, collectionDescription);
        }
    }

    private void processClassPropertyMap(Map map, Map map2, ClassDescription classDescription) {
        NodeList nodeList;
        int n;
        Element element;
        if (classDescription.isPropertyMap && (element = (Element)map2.get("propertyMap")) != null && (n = (nodeList = element.getElementsByTagName("property")).getLength()) > 0) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = element2.getAttribute("name");
                if (string == null || "".equals(string)) continue;
                String string2 = element2.getAttribute("value");
                treeMap.put(StringUtilities.decodeAttributeValue(string), StringUtilities.decodeAttributeValue(string2));
            }
            map.put("propertyMap", treeMap);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processProperty(Map map, Map map2, Element element, ClassDescription.PropertyDescription propertyDescription) {
        String string;
        block12: {
            boolean bl;
            block13: {
                Element element2;
                Object v;
                block14: {
                    string = null;
                    bl = false;
                    v = map2.get(propertyDescription.xmlName);
                    if (v == null && propertyDescription.oldXmlName != null) {
                        v = map2.get(propertyDescription.oldXmlName);
                    }
                    if (v == null) break block13;
                    if (!(v instanceof Node) || v instanceof Element) break block14;
                    string = ((Node)v).getNodeValue();
                    break block12;
                }
                if (v instanceof Element && (element2 = (Element)v) != null) {
                    if (propertyDescription.isRectangle) {
                        this.processRectangle(element2, map, propertyDescription);
                        return;
                    }
                    if (propertyDescription.isPropertyMap) {
                        this.processPropertyAsPropertyMap(map, element2, propertyDescription);
                        return;
                    }
                    if (propertyDescription.isMap) {
                        this.processMapProperty(map, element2, propertyDescription);
                        return;
                    }
                    if (propertyDescription.isSimpleClass() || propertyDescription.isStringClass() || propertyDescription.isReferred()) {
                        Node node = element2.getFirstChild();
                        if (node != null) {
                            string = node.getNodeValue();
                            if (!propertyDescription.isReferred()) {
                                // empty if block
                            }
                        }
                        break block12;
                    } else if (!propertyDescription.isReferred()) {
                        XMLToMapTransformer xMLToMapTransformer;
                        HashMap hashMap = new HashMap();
                        map.put(propertyDescription.xmlName, hashMap);
                        String string2 = element2.getAttribute("class");
                        if (string2 != null && !"".equals(string2) && (xMLToMapTransformer = (XMLToMapTransformer)this.getTransformationManager().getToObjectTransformerFor(string2)) != null) {
                            xMLToMapTransformer.transformToMap(hashMap, element2);
                        }
                        return;
                    }
                }
                break block12;
            }
            bl = true;
        }
        if (string != null) {
            string = StringUtilities.decodeAttributeValue(string);
            map.put(propertyDescription.xmlName, string);
        }
    }

    private void processPropertyAsPropertyMap(Map map, Element element, ClassDescription.PropertyDescription propertyDescription) {
        NodeList nodeList = element.getElementsByTagName(propertyDescription.pmItemName);
        int n = nodeList.getLength();
        if (n > 0) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = element2.getAttribute(propertyDescription.pmKeyName);
                String string2 = element2.getAttribute(propertyDescription.pmValueName);
                if (string == null || string2 == null || "".equals(string)) continue;
                treeMap.put(StringUtilities.decodeAttributeValue(string), StringUtilities.decodeAttributeValue(string2));
            }
            map.put(propertyDescription.xmlName, treeMap);
        }
    }

    private void processMapProperty(Map map, Element element, ClassDescription.PropertyDescription propertyDescription) {
        NodeList nodeList = element.getElementsByTagName(propertyDescription.pmItemName);
        int n = nodeList.getLength();
        if (n > 0) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = element2.getAttribute("key");
                String string2 = element2.getAttribute("value");
                if (string == null || string2 == null || "".equals(string)) continue;
                treeMap.put(StringUtilities.decodeAttributeValue(string), StringUtilities.decodeAttributeValue(string2));
            }
            map.put(propertyDescription.xmlName, treeMap);
        }
    }

    private void processCollection(Map map, Map map2, Element element, ClassDescription.CollectionDescription collectionDescription) {
        Element element2 = (Element)map2.get(collectionDescription.xmlName);
        if (element2 != null) {
            NodeList nodeList;
            int n;
            if (this.canProcessCollectionItem(collectionDescription)) {
                ArrayList arrayList = new ArrayList();
                if (!collectionDescription.itemIsRef) {
                    this.processCollectionWithContained(map, element2, collectionDescription, arrayList);
                } else {
                    this.processCollectionWithRefs(map, element2, collectionDescription, arrayList);
                }
                map.put(collectionDescription.xmlName, arrayList);
            } else if (collectionDescription.isMapItem && (n = (nodeList = element2.getElementsByTagName(collectionDescription.itemXmlName)).getLength()) > 0) {
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < n; ++i) {
                    Element element3 = (Element)nodeList.item(i);
                    NamedNodeMap namedNodeMap = element3.getAttributes();
                    int n2 = namedNodeMap.getLength();
                    if (n2 <= 0) continue;
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    for (int j = 0; j < n2; ++j) {
                        Node node = namedNodeMap.item(j);
                        String string = node.getNodeName();
                        String string2 = node.getNodeValue();
                        treeMap.put(StringUtilities.decodeAttributeValue(string), StringUtilities.decodeAttributeValue(string2));
                    }
                    arrayList.add(treeMap);
                }
                map.put(collectionDescription.xmlName, arrayList);
            }
        }
    }

    private void processCollectionWithContained(Map map, Element element, ClassDescription.CollectionDescription collectionDescription, List list) {
        String string = null;
        if (collectionDescription.itemClassName != null && !"".equals(collectionDescription.itemClassName)) {
            string = element.getAttribute("itemClass");
        }
        XMLToMapTransformer xMLToMapTransformer = null;
        NodeList nodeList = element.getElementsByTagName(collectionDescription.itemXmlName);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (hashMap == null) continue;
            String string2 = null;
            string2 = string != null && !"".equals(string) ? string : element2.getAttribute("class");
            hashMap.put("class", string2);
            xMLToMapTransformer = (XMLToMapTransformer)this.getTransformationManager().getToObjectTransformerFor(string2);
            if (xMLToMapTransformer != null) {
                xMLToMapTransformer.transformToMap(hashMap, element2);
            }
            this.processTopView(hashMap, element2, collectionDescription);
            list.add(hashMap);
        }
    }

    private void processTopView(Map map, Element element, ClassDescription.CollectionDescription collectionDescription) {
        String string = StringUtilities.decodeAttributeValue(element.getAttribute("oid"));
        String string2 = StringUtilities.decodeAttributeValue(element.getAttribute("otype"));
        String string3 = StringUtilities.decodeAttributeValue(element.getAttribute("vid"));
        String string4 = StringUtilities.decodeAttributeValue(element.getAttribute("dpv_id"));
        String string5 = StringUtilities.decodeAttributeValue(element.getAttribute("vnum"));
        String string6 = StringUtilities.decodeAttributeValue(element.getAttribute("vid_source"));
        String string7 = StringUtilities.decodeAttributeValue(element.getAttribute("vid_target"));
        boolean bl = false;
        if (string != null && !"".equals(string)) {
            map.put("oid", string);
        }
        if (string2 != null && !"".equals(string2)) {
            map.put("otype", string2);
        }
        if (string3 != null && !"".equals(string3)) {
            map.put("vid", string3);
        }
        if (string4 != null && !"".equals(string4)) {
            map.put("vid", string4);
        }
        if (string5 != null && !"".equals(string5)) {
            map.put("vnum", string5);
        }
        if (string6 != null && !"".equals(string6)) {
            map.put("vid_source", string6);
            bl = true;
        }
        if (string7 != null && !"".equals(string7)) {
            map.put("vid_target", string7);
            bl = true;
        }
        if (collectionDescription.isTVConnectorItem || bl) {
            this.processPointsCollection(element, map);
        } else if (map instanceof ContainerView) {
            // empty if block
        }
    }

    private void processRectangle(Element element, Map map, ClassDescription.PropertyDescription propertyDescription) {
        String string = element.getAttribute("x");
        String string2 = element.getAttribute("y");
        String string3 = element.getAttribute("width");
        String string4 = element.getAttribute("height");
        Integer n = 0;
        Integer n2 = 0;
        Integer n3 = 20;
        Integer n4 = 20;
        try {
            n = Integer.valueOf(string);
            n2 = Integer.valueOf(string2);
            n3 = Integer.valueOf(string3);
            n4 = Integer.valueOf(string4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("x", n);
        hashMap.put("y", n2);
        hashMap.put("width", n3);
        hashMap.put("height", n4);
        map.put(propertyDescription.xmlName, hashMap);
    }

    private void processPointsCollection(Element element, Map map) {
        NodeList nodeList;
        int n;
        Element element2 = XMLToMapTransformer.getFirstChildByTagName(element, "points");
        if (element2 != null && (n = (nodeList = element2.getElementsByTagName("point")).getLength()) > 0) {
            ArrayList<Point> arrayList = new ArrayList<Point>();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string = element3.getAttribute("x");
                String string2 = element3.getAttribute("y");
                int n2 = 0;
                int n3 = 0;
                try {
                    n2 = Integer.valueOf(string);
                    n3 = Integer.valueOf(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Point point = new Point(n2, n3);
                arrayList.add(point);
            }
            map.put("points", arrayList);
        }
    }

    public static Element getFirstChildByTagName(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getTagName().equals(string)) continue;
            return (Element)node;
        }
        return null;
    }

    private Object getOrCreateTopView(DesignPartView designPartView, Element element, ClassDescription.CollectionDescription collectionDescription) {
        if (collectionDescription.isObjectViewItem) {
            String string;
            String string2 = StringUtilities.decodeAttributeValue(element.getAttribute("oid"));
            DesignObject designObject = designPartView.getDesignPart().getDesign().getDesignObject(string2);
            if (designObject == null && designPartView.getDesignPart() instanceof TransformationTask) {
                string = StringUtilities.decodeAttributeValue(element.getAttribute("otype"));
                if ("InOutParams".equalsIgnoreCase(string)) {
                    designObject = ((TransformationTask)designPartView.getDesignPart()).getInOutParamsObjectById(string2);
                } else if ("InfoStore".equalsIgnoreCase(string)) {
                    designObject = ((TransformationTask)designPartView.getDesignPart()).getInfoStoreSet().getObjectByID(string2);
                }
            }
            if (designObject != null) {
                string = StringUtilities.decodeAttributeValue(element.getAttribute("vid"));
                String string3 = StringUtilities.decodeAttributeValue(element.getAttribute("vnum"));
                int n = 0;
                try {
                    n = Integer.valueOf(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                TopView topView = designObject.getTopViewByID(designPartView, string, n);
                if (topView == null) {
                    topView = designPartView.createTopViewForGlobal(designObject);
                }
                topView.setViewID(string);
                return topView;
            }
        }
        return null;
    }

    private void processCollectionWithRefs(Map map, Element element, ClassDescription.CollectionDescription collectionDescription, List list) {
        block4: {
            block3: {
                if (!collectionDescription.listOfRefs) break block3;
                String string = element.getAttribute(collectionDescription.refsXMLName);
                if (string == null || "".equals(string)) break block4;
                String[] stringArray = string.split(" ");
                for (int i = 0; i < stringArray.length; ++i) {
                    list.add(stringArray[i]);
                }
                break block4;
            }
            NodeList nodeList = element.getElementsByTagName(collectionDescription.itemXmlName);
            int n = nodeList.getLength();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    Element element2 = (Element)nodeList.item(i);
                    Node node = element2.getFirstChild();
                    if (node == null) continue;
                    String string = node.getNodeValue();
                    list.add(string);
                }
            }
        }
    }

    private Map loadElementsAndAttributes(Element element) {
        HashMap<String, Node> hashMap = new HashMap<String, Node>();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            hashMap.put(element2.getTagName(), element2);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                Node node = namedNodeMap.item(i);
                String string = node.getNodeName();
                hashMap.put(string, node);
            }
        }
        return hashMap;
    }

    static {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DOCUMENT_BUILDER = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }
}

