/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.util.propertymap.PropertyTranslator;

public class ClassDescription
implements Cloneable,
MDXMLConstants {
    public static final int PROP_TYPE_ATTRIBUTE = 1;
    public static final int PROP_TYPE_ELEMENT = 2;
    private List<PropertyDescription> propertiesList = new ArrayList<PropertyDescription>();
    private List<PropertyDescription> attributePropertiesList;
    private List<CollectionDescription> collectionsList = new ArrayList<CollectionDescription>();
    private String className;
    private String xmlName;
    public List propertiesDependency = new ArrayList();
    public boolean isPropertyMap = false;
    public boolean isCreateAllExtItemsFirst = false;
    private static final String ITEM_NAME = "item";
    private static final String KEY_NAME = "key";
    private static final String VALUE_NAME = "value";
    private Map contextMap = new HashMap();
    private List contexts = new ArrayList();
    public String beforeTransformName;
    public String beforeTransformExtName;
    public String afterInitName;
    public String afterInitExtName;
    public Method beforeTransform;
    public Method beforeTransformExt;
    public Method afterInit;
    public Method afterInitExt;
    private boolean hasElementsOrCollections = true;

    public static void main(String[] stringArray) {
    }

    protected Object clone() throws CloneNotSupportedException {
        ArrayList arrayList;
        ClassDescription classDescription = (ClassDescription)super.clone();
        ArrayList<PropertyDescription> arrayList2 = new ArrayList<PropertyDescription>(this.propertiesList);
        classDescription.propertiesList = arrayList2;
        ArrayList<CollectionDescription> arrayList3 = new ArrayList<CollectionDescription>(this.collectionsList);
        classDescription.collectionsList = arrayList3;
        classDescription.propertiesDependency = arrayList = new ArrayList(this.propertiesDependency);
        classDescription.contextMap = new HashMap(this.contextMap);
        classDescription.contexts = new ArrayList(this.contexts);
        classDescription.beforeTransformExtName = this.beforeTransformExtName;
        classDescription.beforeTransformName = this.beforeTransformName;
        classDescription.beforeTransformExt = this.beforeTransform;
        classDescription.beforeTransform = this.beforeTransformExt;
        classDescription.afterInitName = this.afterInitName;
        classDescription.afterInit = this.afterInit;
        classDescription.afterInitExtName = this.afterInitExtName;
        classDescription.afterInitExt = this.afterInitExt;
        return classDescription;
    }

    public List<PropertyDescription> getPropertiesList() {
        return this.propertiesList;
    }

    public List<PropertyDescription> getAttributePropertiesList() {
        if (this.attributePropertiesList == null) {
            this.attributePropertiesList = new ArrayList<PropertyDescription>();
            for (PropertyDescription propertyDescription : this.propertiesList) {
                if (!propertyDescription.isAttribute()) continue;
                this.attributePropertiesList.add(propertyDescription);
            }
        }
        return this.attributePropertiesList;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String toString() {
        return this.getClassName();
    }

    public String getXmlName() {
        if (this.xmlName == null) {
            int n = this.className.lastIndexOf(46) + 1;
            this.xmlName = this.className.substring(n);
        }
        return this.xmlName;
    }

    public void setXmlName(String string) {
        this.xmlName = string;
    }

    public List<CollectionDescription> getCollectionsList() {
        return this.collectionsList;
    }

    public List<CollectionDescription> getOrderedCollectionsList(String string) {
        List list;
        if (string != null && !"".equals(string) && (list = (List)this.contextMap.get(string + "collectionOrder")) != null) {
            return list;
        }
        return this.collectionsList;
    }

    public PropertyDescription getPropertyDescriptionByName(String string) {
        for (PropertyDescription propertyDescription : this.propertiesList) {
            if (!propertyDescription.name.equalsIgnoreCase(string)) continue;
            return propertyDescription;
        }
        return null;
    }

    public Map getContextMap() {
        return this.contextMap;
    }

    public CollectionDescription getCollectionDescriptionByName(String string) {
        if (string != null) {
            for (CollectionDescription collectionDescription : this.getCollectionsList()) {
                if (!string.equals(collectionDescription.name)) continue;
                return collectionDescription;
            }
        }
        return null;
    }

    public List getContexts() {
        return this.contexts;
    }

    public void removePropertyDescription(PropertyDescription propertyDescription) {
        this.propertiesList.remove(propertyDescription);
    }

    public void removeCollectionDescription(CollectionDescription collectionDescription) {
        this.collectionsList.remove(collectionDescription);
    }

    public boolean isHasElementsOrCollections() {
        return this.hasElementsOrCollections;
    }

    public void resetElementsAndCollectionsFlag() {
        if (this.isPropertyMap) {
            this.hasElementsOrCollections = true;
            return;
        }
        for (PropertyDescription propertyDescription : this.propertiesList) {
            if (!propertyDescription.isElement()) continue;
            this.hasElementsOrCollections = true;
            return;
        }
        this.hasElementsOrCollections = this.collectionsList.size() > 0;
    }

    public static class CollectionDescription {
        public String name;
        public String className;
        public String itemClassName;
        public String xmlName;
        public String itemXmlName;
        public String itemContainment;
        public String getterName;
        public String setterName;
        public String createItemName;
        public String removeItemName;
        public String addItemName;
        public String applyListName;
        public String getItemByIDName;
        public String moveMethodName;
        public boolean keepOrder = false;
        public boolean isMapItem = false;
        public boolean isEngPropertyHolderItem;
        public boolean isObjectViewItem = false;
        public boolean isTVConnectorItem = false;
        public boolean isTVDiagramItem = false;
        public Method getter;
        public Method setter;
        public Method createItem;
        public Method removeItem;
        public Method applyList;
        public Method getItemByID;
        public Method moveMethod;
        public Method addItem;
        public boolean itemIsRef = false;
        public boolean listOfRefs = false;
        public boolean nativeList = false;
        public boolean orderTheList = false;
        public String idName = "IDREF";
        public String refsXMLName = "IDREFS";
        public boolean isIDObjectSet = false;
        public boolean isProxyitem = false;
        public boolean isOrderImportant = true;
        public boolean isExternalCollection = false;
        public boolean createAllItemsFirst = false;
        public String preProcessName;
        public Method preProcess;
        public boolean isPhysicalModelItem = false;
    }

    public static class PropertyDescription {
        public String name;
        public String className;
        public String xmlName;
        public String oldXmlName;
        public String defaultValue;
        public String getterName;
        public String setterName;
        public String createPropertyName;
        public int propType = 2;
        public Method getter;
        public Method setter;
        public Method createPMap;
        public Method createProperty;
        public Method removeProperty;
        public boolean referred = false;
        public boolean ddlRelated = false;
        public boolean idObjecttranslator = false;
        public boolean simpleClass;
        public boolean stringClass = true;
        public boolean isPropertyMap = false;
        public boolean isMap = false;
        public boolean isRectangle = false;
        public boolean isLoggingProp = false;
        public boolean isCreatedTimeProp = false;
        public boolean isColorProperty = false;
        public boolean isListOfRefs = false;
        public boolean isMergeCompare = false;
        public String pmItemName = "item";
        public String pmKeyName = "key";
        public String pmValueName = "value";
        public String createPMapName;
        public PropertyTranslator propertyTranslator;
        public String presentationName;
        public String removePropertyName;
        public boolean isID = false;
        public boolean isAfterCollectionProcessing = false;
        public boolean isExternalProperty = false;
        public String beforeCollection;
        public String afterCollection;
        private Map encodedEnumMap;

        public String toString() {
            return "name=" + this.name + "/n className(datatype)=" + this.className;
        }

        public boolean isAttribute() {
            return this.propType == 1;
        }

        public boolean isElement() {
            return this.propType == 2;
        }

        public boolean isDdlRelated() {
            return this.ddlRelated;
        }

        public boolean isSimpleClass() {
            return this.simpleClass;
        }

        public boolean isStringClass() {
            return this.stringClass;
        }

        public boolean isReferred() {
            return this.referred;
        }

        public boolean isContainedClass() {
            return !this.isReferred() && !this.isSimpleClass() && !this.isStringClass() && !this.isReferred();
        }

        public boolean isIdObjecttranslator() {
            return this.idObjecttranslator;
        }

        public Map getCoddedEnumMap() {
            if (this.encodedEnumMap == null) {
                this.encodedEnumMap = new HashMap();
            }
            return this.encodedEnumMap;
        }

        public boolean hasCodedEnum() {
            return this.encodedEnumMap != null && !this.encodedEnumMap.isEmpty();
        }
    }
}

