/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.udb;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.NodeGroupSetUDBv71;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableSpaceNodeGroup
extends AbstractDRStorageDesign {
    private final String RULE_ID = "79A61EB9-E014-BFF8-2430-4D07B2B0C168";

    public DRTableSpaceNodeGroup(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableSpaceNodeGroup.CheckNodegroup"));
        this.setDescription(Messages.getString("DRTableSpaceNodeGroup.NodegroupMustBeIBMTEMPGROUP"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableSpaceUDB tableSpaceUDB = (TableSpaceUDB)object;
        if (tableSpaceUDB.getNodeGroup() != null && tableSpaceUDB.getDataType().equalsIgnoreCase("SYSTEM TEMPORARY") && !tableSpaceUDB.getNodeGroup().equals(NodeGroupSetUDBv71.getTempNodeGroup())) {
            return CheckResult.createFailed(tableSpaceUDB, this, MessageFormat.format(Messages.getString("DRTableSpaceNodeGroup.SystemTempTablespaceMustHave"), NodeGroupSetUDBv71.getTempNodeGroup().getName()));
        }
        if (tableSpaceUDB.getNodeGroup() != null && !tableSpaceUDB.getDataType().equalsIgnoreCase("SYSTEM TEMPORARY") && tableSpaceUDB.getNodeGroup().equals(NodeGroupSetUDBv71.getTempNodeGroup())) {
            return CheckResult.createFailed(tableSpaceUDB, this, MessageFormat.format(Messages.getString("DRTableSpaceNodeGroup.TablespaceMayNotHave"), NodeGroupSetUDBv71.getTempNodeGroup().getName()));
        }
        return CheckResult.createOk(tableSpaceUDB, this, Messages.getString("DRTableSpaceNodeGroup.NodegroupIsOK"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "79A61EB9-E014-BFF8-2430-4D07B2B0C168";
    }
}

