/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.udb;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableSpaceManagedBy
extends AbstractDRStorageDesign {
    private final String RULE_ID = "209C9FA9-BF3E-38DA-F8B6-CBCCEA31790B";

    public DRTableSpaceManagedBy(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableSpaceManagedBy.MustBeDMSTablespace"));
        this.setDescription(Messages.getString("DRTableSpaceManagedBy.TablespaceMustBeManagedByDatabase"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableSpaceUDB tableSpaceUDB = (TableSpaceUDB)object;
        if (tableSpaceUDB.getDataType().equalsIgnoreCase("LONG")) {
            if (tableSpaceUDB.getManagedBy().equalsIgnoreCase("DATABASE")) {
                return CheckResult.createFailed(tableSpaceUDB, this, Messages.getString("DRTableSpaceManagedBy.LongTablespaceMustBeManagedByDatabase"));
            }
            return CheckResult.createOk(tableSpaceUDB, this, Messages.getString("DRTableSpaceManagedBy.LongTablespaceIsManagedByDatabase"));
        }
        return CheckResult.createOk(tableSpaceUDB, this, Messages.getString("DRTableSpaceManagedBy.TablespaceMayBeManagedByTheDatabaseOrSystem"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "209C9FA9-BF3E-38DA-F8B6-CBCCEA31790B";
    }
}

