/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.udb;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRIndexProxyMaxColumns
extends AbstractDRStorageDesign {
    private final String RULE_ID = "E4F22893-3DBD-FE24-48FD-85AD73E6DA5C";
    public static final int MAX_COLUMN_NUMBER = 16;

    public DRIndexProxyMaxColumns(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRIndexProxyMaxColumns.CheckNumberOfColumnsForIndex"));
        this.setDescription(Messages.getString("DRIndexProxyMaxColumns.IndexMayNotContainMoreThan16Columns"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        IndexProxyUDB indexProxyUDB = (IndexProxyUDB)object;
        if (indexProxyUDB.getColumnProxies() != null && indexProxyUDB.getColumnProxies().length > 16) {
            return CheckResult.createFailed(indexProxyUDB, this, new StringBuffer(MessageFormat.format(Messages.getString("DRIndexProxyMaxColumns.IndexHasMoreThan"), 16)).toString());
        }
        return CheckResult.createOk(indexProxyUDB, this, new StringBuffer(MessageFormat.format(Messages.getString("DRIndexProxyMaxColumns.IndexDoesNotContainMoreThan"), 16)).toString());
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "E4F22893-3DBD-FE24-48FD-85AD73E6DA5C";
    }
}

